/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.FscOrderCreateBo;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscMerchantNewMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscMerchantNewPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscMerchantNewMapper fscMerchantNewMapper;
    private static final Integer UPSTREAM_ECOMMERCE = 0;
    private static final Integer DOWNSTREAM_ECOMMERCE = 1;
    private static final Integer TRIPARTITE_TRANSACTION = 2;
    public static final String BUSI_NAME = "\u91c7\u8d2d\u65b9\u5bf9\u8d26\u5f85\u786e\u8ba4";
    public static final String BUSI_CODE = "1015";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        HashMap<String, Long> messageMap = new HashMap<String, Long>(reqBO.getSplitOrderList().size() + 1);
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        HashMap accountPeriodMap = new HashMap(reqBO.getSplitOrderList().size() + 1);
        Map<Long, String> purMap = reqBO.getSplitOrderList().stream().collect(Collectors.toMap(SplitOrderBO::getPurchaserId, SplitOrderBO::getPurchaserName, (v1, v2) -> v1));
        FscMerchantNewPO fscMerchantNewPo = new FscMerchantNewPO();
        fscMerchantNewPo.setOrgIds(new ArrayList<Long>(purMap.keySet()));
        fscMerchantNewPo.setIsDel(FscConstants.MerchantDeleteFlag.NO);
        List fscMerchantNewPoS = this.fscMerchantNewMapper.getList(fscMerchantNewPo);
        fscMerchantNewPoS.forEach(fscMerchantNewPoModel -> accountPeriodMap.put(fscMerchantNewPoModel.getOrgId(), fscMerchantNewPoModel.getExtend2()));
        ArrayList<FscOrderCreateBo> fscOrderCreateBoS = new ArrayList<FscOrderCreateBo>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            if (Integer.valueOf("2").equals(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getUserType()) && (DOWNSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream()) || TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream()))) {
                messageMap.put(reqBO.getOrderNos().get(num), ((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserId());
            }
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            if (reqBO.getIsOrderBill() != null && reqBO.getIsOrderBill() == 1) {
                fscOrderPo.setOrderConfirmTime(new Date());
                fscOrderPo.setOrderConfirmId(reqBO.getUserId().toString());
                fscOrderPo.setOrderConfirmName(reqBO.getName());
            }
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, RoundingMode.HALF_UP));
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setPayType(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPayType());
            fscOrderPo.setContractId(splitOrderBO.getContractId());
            fscOrderPo.setContractNo(splitOrderBO.getContractNo());
            fscOrderPo.setUserType(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getUserType());
            FscOrderCreateBo fscOrderCreateBo = new FscOrderCreateBo();
            fscOrderCreateBo.setFscOrderNo(fscOrderPo.getOrderNo());
            fscOrderCreateBo.setPurchaserName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserName());
            fscOrderCreateBoS.add(fscOrderCreateBo);
            if (UPSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                fscOrderPo.setSupplierId(Long.valueOf(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierCode()));
                fscOrderPo.setSupplierName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierName());
                fscOrderPo.setBuyName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getInvoiceName());
                fscOrderPo.setPayeeId(Long.valueOf(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierCode()));
                fscOrderPo.setPayeeName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierName());
            } else if (DOWNSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                fscOrderPo.setPurchaserId(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserId());
                fscOrderPo.setPurchaserName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserName());
                fscOrderPo.setProjectCode(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getProjectCode());
                fscOrderPo.setProjectName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getProjectName());
                fscOrderPo.setDepartmentCode(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getDepartmentCode());
                fscOrderPo.setDepartmentName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getDepartmentName());
                fscOrderPo.setPayerId(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserId());
                fscOrderPo.setPayerName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserName());
            } else if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
                fscOrderPo.setPurchaserId(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserId());
                fscOrderPo.setPurchaserName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserName());
                fscOrderPo.setProjectCode(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getProjectCode());
                fscOrderPo.setProjectName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getProjectName());
                fscOrderPo.setDepartmentCode(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getDepartmentCode());
                fscOrderPo.setDepartmentName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getDepartmentName());
                fscOrderPo.setPayerId(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserId());
                fscOrderPo.setPayerName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPurchaserName());
                fscOrderPo.setSupplierId(Long.valueOf(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierCode()));
                fscOrderPo.setSupplierName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierName());
                fscOrderPo.setBuyName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getInvoiceName());
                fscOrderPo.setPayeeId(Long.valueOf(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierCode()));
                fscOrderPo.setPayeeName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getSupplierName());
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getPayType())) {
                String time;
                if (!StringUtils.isEmpty(accountPeriodMap.get(splitOrderBO.getPurchaserId()))) {
                    time = (String)accountPeriodMap.get(splitOrderBO.getPurchaserId());
                } else {
                    FscMerchantNewPO fscMerchantNewPoDetail = new FscMerchantNewPO();
                    fscMerchantNewPoDetail.setIsDefault(FscConstants.MerchantDefalutFlag.YES);
                    fscMerchantNewPoDetail.setIsDel(FscConstants.MerchantDeleteFlag.NO);
                    FscMerchantNewPO modelBy = this.fscMerchantNewMapper.getModelBy(fscMerchantNewPoDetail);
                    time = modelBy.getExtend2();
                }
                if (!StringUtils.isEmpty((Object)time)) {
                    fscOrderPo.setBillCycle(Integer.valueOf(time));
                    Calendar date = Calendar.getInstance();
                    date.setTime(new Date());
                    date.add(5, Integer.parseInt(time));
                    fscOrderPo.setPredictPaymentTime(date.getTime());
                }
            }
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            fscOrderPo.setFscTransOrderType(FscConstants.FscTransOrderType.ORDER);
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                if (UPSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                    fscOrderRelationPO.setUpDown(UPSTREAM_ECOMMERCE);
                } else if (DOWNSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                    fscOrderRelationPO.setUpDown(DOWNSTREAM_ECOMMERCE);
                } else if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
                    fscOrderRelationPO.setUpDown(TRIPARTITE_TRANSACTION);
                }
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderInfoBO.getFscOrderItemBOS().forEach(fscOrderItemBO -> fscOrderItemBO.setFscOrderId(fscOrderPo.getFscOrderId()));
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
            }
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePo.setBuyCode(reqBO.getBuyCode());
            fscOrderInvoicePo.setMemo(reqBO.getInvoiceMemo());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            if (DOWNSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                fscOrderInvoicePo.setBuyCode(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getInvoiceCode());
                fscOrderInvoicePo.setBuyName(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getInvoiceName());
            } else if (UPSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream()) || TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
                fscOrderInvoicePo.setBuyCode(reqBO.getBuyCode());
                fscOrderInvoicePo.setBuyName(reqBO.getBuyName());
            }
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPo -> fscOrderItemPo.setId(Long.valueOf(Sequence.getInstance().nextId())));
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        if (reqBO.getIsOrderBill() != null && reqBO.getIsOrderBill() == 1) {
            for (Long fscOrderId : fscOrderIds) {
                this.flowAtom(fscOrderId);
            }
        }
        this.syncOrderStatus(fscOrderIds);
        FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO = new FscBillOrderCreateBusiRspBO();
        fscBillOrderCreateBusiRspBO.setFscOrderIds(fscOrderIds);
        fscBillOrderCreateBusiRspBO.setFscOrderCreateBos(fscOrderCreateBoS);
        fscBillOrderCreateBusiRspBO.setMessageMap(messageMap);
        return fscBillOrderCreateBusiRspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    public static void main(String[] args) {
        List<Integer> integers = Arrays.asList(1, 2, 3);
        Iterator<Integer> iterator = integers.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().hashCode());
        }
    }

    private void flowAtom(Long fscOrderId) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(fscOrderId);
        flowAtomReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("redoFlagNext", "1");
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193012", flowAtomRspBO.getRespDesc());
        }
    }
}

