/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.bill.busi.api.FscBillPurCheckConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPurCheckConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPurCheckConfirmBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTransfeeItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillPurCheckConfirmBusiServiceImpl
implements FscBillPurCheckConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPurCheckConfirmBusiServiceImpl.class);
    public static final String BUSI_NAME = "\u91c7\u8d2d\u65b9\u5bf9\u8d26\u5f85\u786e\u8ba4";
    public static final String BUSI_CODE = "1015";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscTransfeeItemMapper fscTransfeeItemMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public FscBillPurCheckConfirmBusiRspBO dealPurOrderConfirm(FscBillPurCheckConfirmBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPoResult = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPoResult == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7ed3\u7b97\u5355\u6570\u636e");
        }
        if (!FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPoResult.getOrderState())) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u884c\u5bf9\u8d26\u786e\u8ba4");
        }
        FscOrderPO set = new FscOrderPO();
        set.setOrderConfirmId(reqBO.getUserId().toString());
        set.setOrderConfirmName(reqBO.getName());
        set.setOrderConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
        if (!FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPoResult.getMakeType())) {
            FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscOrderInvoicePO);
            this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePO);
            if (reqBO.getInvoiceCategory() != null) {
                Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
                if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
                    elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
                }
                FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
                fscInvoiceRulePO.setFscOrderId(reqBO.getFscOrderId());
                fscInvoiceRulePO.setElecFlag(elecFlag);
                this.fscInvoiceRuleMapper.updateById(fscInvoiceRulePO);
            }
        }
        this.updateFscOrder(reqBO);
        this.flowAtom(reqBO);
        this.cacheService.delete("Confirm" + reqBO.getFscOrderId());
        return new FscBillPurCheckConfirmBusiRspBO();
    }

    private void updateFscOrder(FscBillPurCheckConfirmBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy.getContractId() != null) {
            log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5f00\u59cb");
            FscOrderPO fscOrderPoSet = new FscOrderPO();
            fscOrderPoSet.setPayMoney(BigDecimal.ZERO);
            fscOrderPoSet.setCostPayState(FscConstants.CostPayState.TO_PAY);
            FscOrderPO fscOrderPoWhere = new FscOrderPO();
            fscOrderPoWhere.setFscOrderId(reqBO.getFscOrderId());
            log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503cSet{}", (Object)fscOrderPoSet);
            log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5f00\u59cbWhere{}", (Object)fscOrderPoWhere);
            int update = this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
            if (update < 1) {
                log.debug("\u6210\u672c\u7cfb\u7edf\u63a8\u9001\u7ed9\u72b6\u6001\u53ca\u91d1\u989d\u9ed8\u8ba4\u503c\u5931\u8d25");
                throw new FscBusinessException("190000", "\u6210\u672c\u7cfb\u7edf\u66f4\u65b0\u5931\u8d25");
            }
        }
    }

    private void flowAtom(FscBillPurCheckConfirmBusiReqBO reqBO) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("redoFlagNext", "1");
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193012", flowAtomRspBO.getRespDesc());
        }
    }
}

