/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.dyc.umc.service.weekdayConfig.UmcGetWorkingDayService;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataRspBo;
import com.tydic.fsc.bill.busi.api.FscLianDongNeedPayUpdatePayTimeBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayUpdatePayTimeBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayUpdatePayTimeBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractPayMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscNeedPayPO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscLianDongNeedPayUpdatePayTimeBusiServiceImpl
implements FscLianDongNeedPayUpdatePayTimeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongNeedPayUpdatePayTimeBusiServiceImpl.class);
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscContractPayMapper fscContractPayMapper;
    @Autowired
    private UmcGetWorkingDayService umcGetWorkingDayService;

    @Override
    public FscLianDongNeedPayUpdatePayTimeBusiRspBo updatePayTime(FscLianDongNeedPayUpdatePayTimeBusiReqBo busiReqBo) {
        log.debug("\u5e94\u4ed8\u66f4\u65b0\u65f6\u95f4\u5165\u53c2{}", (Object)busiReqBo);
        FscNeedPayPO fscNeedPayPo = this.checkNeedPay(busiReqBo);
        String dateString = this.updateNeedPay(busiReqBo, fscNeedPayPo);
        this.updateContractPay(busiReqBo, dateString);
        FscLianDongNeedPayUpdatePayTimeBusiRspBo fscLianDongNeedPayUpdatePayTimeBusiRspBo = new FscLianDongNeedPayUpdatePayTimeBusiRspBo();
        fscLianDongNeedPayUpdatePayTimeBusiRspBo.setRespCode("0000");
        fscLianDongNeedPayUpdatePayTimeBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongNeedPayUpdatePayTimeBusiRspBo;
    }

    private void updateContractPay(FscLianDongNeedPayUpdatePayTimeBusiReqBo busiReqBo, String dateString) {
        if (FscConstants.FscNeedPayType.ORDER.equals(busiReqBo.getNeedPayType())) {
            log.debug("\u66f4\u65b0\u5408\u540c\u4ed8\u6b3e\u8868");
            FscContractPayPO fscContractPayPo = new FscContractPayPO();
            fscContractPayPo.setExtend2(busiReqBo.getPayOrderType().toString());
            fscContractPayPo.setPurchaseOrderId(busiReqBo.getSaleOrderId());
            fscContractPayPo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
            FscContractPayPO fscContractPayMapperModelBy = this.fscContractPayMapper.getModelBy(fscContractPayPo);
            if (fscContractPayMapperModelBy == null) {
                throw new FscBusinessException("190000", "\u8be2\u76d8\u5408\u540c\u8ba2\u5355\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            FscContractPayPO fscContractPayPoSet = new FscContractPayPO();
            fscContractPayPoSet.setContractPayPlanTime(dateString);
            fscContractPayPoSet.setUpdateOperId(busiReqBo.getUserId());
            fscContractPayPoSet.setUpdateTime(new Date());
            int updateBy = this.fscContractPayMapper.updateBy(fscContractPayPoSet, fscContractPayPo);
            if (updateBy < 1) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u8be2\u76d8\u5408\u540c\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
    }

    private String updateNeedPay(FscLianDongNeedPayUpdatePayTimeBusiReqBo busiReqBo, FscNeedPayPO fscNeedPayPo) {
        Date needPayTime = busiReqBo.getNeedPayTime();
        if (busiReqBo.getNeedPayDate() != null) {
            UmcGetWorkingDayByDataReqBo umcGetWorkingDayByDataReqBo = new UmcGetWorkingDayByDataReqBo();
            umcGetWorkingDayByDataReqBo.setDate(busiReqBo.getNeedPayTime());
            umcGetWorkingDayByDataReqBo.setWorkingDayNum(busiReqBo.getNeedPayDate().intValue());
            UmcGetWorkingDayByDataRspBo workingDayByData = this.umcGetWorkingDayService.getWorkingDayByData(umcGetWorkingDayByDataReqBo);
            if (!"0000".equals(workingDayByData.getRespCode())) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u4f1a\u5458\u5de5\u4f5c\u65e5\u5931\u8d25");
            }
            needPayTime = workingDayByData.getDate();
        }
        FscNeedPayPO fscNeedPayPoSet = new FscNeedPayPO();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = dateFormat.format(needPayTime);
        fscNeedPayPoSet.setNeedPayDate(dateString);
        fscNeedPayPoSet.setUpdateOperId(busiReqBo.getUserId());
        fscNeedPayPoSet.setUpdateTime(new Date());
        int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoSet, fscNeedPayPo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return dateString;
    }

    private FscNeedPayPO checkNeedPay(FscLianDongNeedPayUpdatePayTimeBusiReqBo busiReqBo) {
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setPurchaseOrderId(busiReqBo.getSaleOrderId());
        fscNeedPayPo.setNeedPayType(busiReqBo.getNeedPayType());
        fscNeedPayPo.setPayOrderType(busiReqBo.getPayOrderType());
        FscNeedPayPO modelBy = this.fscNeedPayMapper.getModelBy(fscNeedPayPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
        return fscNeedPayPo;
    }
}

