/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceApplyAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceApplyBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceApplyAbilityService"})
public class FscBillInvoiceApplyAbilityServiceImpl
implements FscBillInvoiceApplyAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillInvoiceApplyBusiService fscBillInvoiceApplyBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Value(value="${FSC_INVOICE_APLLY_TOPIC:FSC_INVOICE_APLLY_TOPIC}")
    private String FSC_INVOICE_APLLY_TOPIC;
    @Value(value="${FSC_INVOICE_APPLY_TAG:*}")
    private String FSC_INVOICE_APPLY_TAG;
    @Resource(name="fscInvoiceApplyProvider")
    private ProxyMessageProducer fscInvoiceApplyProvider;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @BigDecimalConvert(value=2)
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealInvoiceApply"})
    public FscBillInvoiceApplyAbilityRspBO dealInvoiceApply(@RequestBody FscBillInvoiceApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        for (Long orderId : reqBO.getOrderIds()) {
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(orderId);
            FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
            if (null == modelBy) {
                throw new FscBusinessException("191008", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            }
            if (modelBy.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
                throw new FscBusinessException("191008", "\u5f00\u7968\u65b9\u4e0d\u80fd\u4e3a\u4f9b\u5e94\u5546");
            }
            if (!modelBy.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                throw new FscBusinessException("191008", "\u5f53\u524d\u72b6\u6001[" + FscBillStatus.getInstance((Integer)modelBy.getOrderState()).getDescr() + "]\u4e0d\u80fd\u5904\u7406\u5f00\u7968\u7533\u8bf7");
            }
            FscBillInvoiceApplyBusiReqBO fscBillInvoiceApplyBusiReqBO = new FscBillInvoiceApplyBusiReqBO();
            fscBillInvoiceApplyBusiReqBO.setOrderId(orderId);
            fscBillInvoiceApplyBusiReqBO.setOrderState(modelBy.getOrderState());
            fscBillInvoiceApplyBusiReqBO.setUserId(reqBO.getUserId());
            fscBillInvoiceApplyBusiReqBO.setUserName(reqBO.getUserName());
            FscBillInvoiceApplyBusiRspBO fscBillInvoiceApplyBusiRspBO = this.fscBillInvoiceApplyBusiService.dealInvoiceApply(fscBillInvoiceApplyBusiReqBO);
            if (!"0000".equals(fscBillInvoiceApplyBusiRspBO.getRespCode())) {
                throw new FscBusinessException("191008", fscBillInvoiceApplyBusiRspBO.getRespDesc());
            }
            this.sendMq(orderId);
        }
        return new FscBillInvoiceApplyAbilityRspBO();
    }

    private void val(FscBillInvoiceApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderIds()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderIds]\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long orderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

