/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscReceiveUValleyCompareInfosToExpenseAbilityService;
import com.tydic.fsc.bill.ability.bo.FscReceiveUValleyCompareInfosToExpenseAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscReceiveUValleyCompareInfosToExpenseAbilityRspBO;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscReceiveUValleyCompareInfosToExpenseAbilityService"})
public class FscReceiveUValleyCompareInfosToExpenseAbilityServiceImpl
implements FscReceiveUValleyCompareInfosToExpenseAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReceiveUValleyCompareInfosToExpenseAbilityServiceImpl.class);
    @Value(value="${RECEIVE_U_VALLEY_COMPARE_INFOS_TO_EXPENSE_URL:http://apim-gateway.test.liando.cn/env-201/por-201/testcost/uValley/receiveUValleyCompareInfosToExpense}")
    private String RECEIVE_U_VALLEY_COMPARE_INFOS_TO_EXPENSE_URL;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;

    @PostMapping(value={"receiveUValleyCompareInfosToExpense"})
    public FscReceiveUValleyCompareInfosToExpenseAbilityRspBO receiveUValleyCompareInfosToExpense(@RequestBody FscReceiveUValleyCompareInfosToExpenseAbilityReqBO reqBO) {
        this.validate(reqBO);
        FscReceiveUValleyCompareInfosToExpenseAbilityRspBO rspBO = new FscReceiveUValleyCompareInfosToExpenseAbilityRspBO();
        String body = JSON.toJSONString((Object)reqBO);
        Long logId = this.logAdd(body, reqBO.getFscOrderId().toString());
        log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5bf9\u8d26\u5355\u63a5\u6536\u63a5\u53e3URL-{}", (Object)this.RECEIVE_U_VALLEY_COMPARE_INFOS_TO_EXPENSE_URL);
        log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5bf9\u8d26\u5355\u63a5\u6536\u63a5\u53e3BODY-{}", (Object)body);
        try {
            String result = HttpUtil.post((String)this.RECEIVE_U_VALLEY_COMPARE_INFOS_TO_EXPENSE_URL, (String)body);
            log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5bf9\u8d26\u5355\u63a5\u6536\u63a5\u53e3\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                this.logUpdate(logId, result, FscConstants.CostIsError.NO);
            } else {
                this.logUpdate(logId, result, FscConstants.CostIsError.YES);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logUpdate(logId, e.getMessage(), FscConstants.CostIsError.NO);
            throw new FscBusinessException("190000", "\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5bf9\u8d26\u5355\u63a5\u6536\u63a5\u53e3\u5f02\u5e38-" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validate(FscReceiveUValleyCompareInfosToExpenseAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderId\u3011 \u4e0d\u80fd\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderNo())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderNo\u3011 \u4e0d\u80fd\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderSupplierName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderSupplierName\u3011 \u4e0d\u80fd\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getTotalPay())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010totalPay\u3011 \u4e0d\u80fd\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderItem())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem\u3011 \u4e0d\u80fd\u7a7a");
        }
        for (FscReceiveUValleyCompareInfosToExpenseAbilityReqBO.FscOrderItemOutBO bo : reqBO.getFscOrderItem()) {
            if (ObjectUtil.isEmpty((Object)bo.getOrderNo())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->orderNo\u3011 \u4e0d\u80fd\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getReceivingReportNo())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->receivingReportNo\u3011 \u4e0d\u80fd\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getReceivingReportAmount())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->receivingReportAmount\u3011 \u4e0d\u80fd\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getSkuCode())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->skuCode\u3011 \u4e0d\u80fd\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getOrderNum())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->orderNum\u3011 \u4e0d\u80fd\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)bo.getSalePrice())) continue;
            throw new FscBusinessException("190000", "\u5165\u53c2 \u3010fscOrderItem->salePrice\u3011 \u4e0d\u80fd\u7a7a");
        }
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.NO, FscConstants.CostObjType.RECEIPT_OF_STATEMENT, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }
}

