/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.busi.api.FscBillOrderSplitComputeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscMerchantNewMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscMerchantNewPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderSplitComputeBusiServiceImpl
implements FscBillOrderSplitComputeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSplitComputeBusiServiceImpl.class);
    private static final Integer GROUPWAY_NOSPLIT = 0;
    private static final Integer GROUPWAY_PURUNIT = 1;
    private static final Integer GROUPWAY_ORDER = 2;
    private static final Integer UPSTREAM_ECOMMERCE = 0;
    private static final Integer DOWNSTREAM_ECOMMERCE = 1;
    private static final Integer TRIPARTITE_TRANSACTION = 2;
    private static final Integer OUT_USER = 2;
    private static final Integer INNER_USER = 4;
    private static final String POSITIVE = "-0";
    private static final String NEGATIVE = "-1";
    @Autowired
    private FscMerchantNewMapper fscMerchantNewMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;

    @Override
    public FscBillOrderSplitComputeBusiRspBO getSplitCompute(FscBillOrderSplitComputeBusiReqBO reqBO) {
        reqBO.getRelOrderList().forEach(relOrderBo -> {
            if (!FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP.equals(relOrderBo.getPayType())) {
                relOrderBo.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            }
        });
        List collect = reqBO.getRelOrderList().stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
        fscCheckResultPo.setAcceptOrderIds(collect);
        fscCheckResultPo.setStatus(FscConstants.BillCheck.EQUALS);
        List list = this.fscCheckResultMapper.getList(fscCheckResultPo);
        log.debug("\u62c6\u5206\u67e5\u8be2\u5bf9\u8d26\u8868\u51fa\u53c2{}", (Object)list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            reqBO.setRelOrderList(reqBO.getRelOrderList());
        } else {
            Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, relOrderBO -> relOrderBO, (v1, v2) -> v1));
            log.debug("\u62c6\u5206\u8ba2\u5355\u5173\u8054\u4fe1\u606fmap{}", relOrderBoMap);
            ArrayList<RelOrderBO> relOrderBoS = new ArrayList<RelOrderBO>();
            list.forEach(fscCheckResultPoModel -> {
                if (collect.contains(fscCheckResultPoModel.getAcceptOrderId())) {
                    relOrderBoS.add((RelOrderBO)relOrderBoMap.get(fscCheckResultPoModel.getAcceptOrderId()));
                }
            });
            log.debug("\u62c6\u5206\u8ba2\u5355\u5173\u8054\u4fe1\u606f\u96c6\u5408{}", relOrderBoS);
            reqBO.setRelOrderList(relOrderBoS);
        }
        if (!CollectionUtils.isEmpty(reqBO.getRelOrderList())) {
            reqBO.getRelOrderList().forEach(relOrderBo -> {
                if (relOrderBo.getAmount() == null || relOrderBo.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                    throw new FscBusinessException("190000", "\u9a8c\u6536\u91d1\u989d\u4e3a\u7a7a\u6216\u9a8c\u6536\u91d1\u989d\u4e3a0\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (relOrderBo.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                    relOrderBo.setPositiveOrNegative(POSITIVE);
                }
                if (relOrderBo.getAmount().compareTo(BigDecimal.ZERO) < 0) {
                    relOrderBo.setPositiveOrNegative(NEGATIVE);
                }
            });
        }
        List<Object> splitOrderList = new LinkedList();
        Integer ruleType = reqBO.getRuleType();
        if (GROUPWAY_NOSPLIT.equals(ruleType)) {
            splitOrderList = this.noSplit(reqBO);
        } else if (GROUPWAY_PURUNIT.equals(ruleType)) {
            splitOrderList = this.groupByPur(reqBO);
        } else if (GROUPWAY_ORDER.equals(ruleType)) {
            splitOrderList = this.groupByOrder(reqBO);
        }
        HashMap accountPeriodMap = new HashMap(reqBO.getRelOrderList().size() + 1);
        Map<Long, String> purMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getPurchaserId, RelOrderBO::getPurchaserName, (v1, v2) -> v1));
        FscMerchantNewPO fscMerchantNewPo = new FscMerchantNewPO();
        fscMerchantNewPo.setOrgIds(new ArrayList<Long>(purMap.keySet()));
        fscMerchantNewPo.setIsDel(FscConstants.MerchantDeleteFlag.NO);
        if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
            fscMerchantNewPo.setConfigurationType(FscConstants.ConfigurationType.SUPPLIER);
        } else {
            fscMerchantNewPo.setConfigurationType(FscConstants.ConfigurationType.OPER);
        }
        List fscMerchantNewPoS = this.fscMerchantNewMapper.getList(fscMerchantNewPo);
        FscMerchantNewPO fscMerchantNewPoDefault = new FscMerchantNewPO();
        fscMerchantNewPoDefault.setIsNotDefault(FscConstants.MerchantDefalutFlag.NO);
        fscMerchantNewPoDefault.setIsDel(FscConstants.MerchantDeleteFlag.NO);
        if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
            fscMerchantNewPoDefault.setConfigurationType(FscConstants.ConfigurationType.SUPPLIER);
        } else {
            fscMerchantNewPoDefault.setConfigurationType(FscConstants.ConfigurationType.OPER);
        }
        List isDefault = this.fscMerchantNewMapper.getList(fscMerchantNewPoDefault);
        if (!CollectionUtils.isEmpty((Collection)fscMerchantNewPoS)) {
            fscMerchantNewPoS.forEach(fscMerchantNewPoModel -> {
                if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
                    accountPeriodMap.put(fscMerchantNewPoModel.getOrgId() + fscMerchantNewPoModel.getSupplierId(), fscMerchantNewPoModel.getExtend2());
                } else {
                    accountPeriodMap.put(fscMerchantNewPoModel.getOrgId(), fscMerchantNewPoModel.getExtend2());
                }
            });
        } else {
            isDefault.forEach(isDefaultModel -> accountPeriodMap.put(Long.valueOf(isDefaultModel.getIsDefault().intValue()), isDefaultModel.getExtend2()));
        }
        LinkedList<SplitOrderBO> splitOrderBOList = new LinkedList<SplitOrderBO>();
        for (List list2 : splitOrderList) {
            SplitOrderBO splitOrderBO = new SplitOrderBO();
            long purNum = list2.stream().map(RelOrderBO::getPurchaserId).distinct().count();
            BigDecimal amt = list2.stream().map(RelOrderBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            long supNum = list2.stream().map(RelOrderBO::getSupplierCode).distinct().count();
            splitOrderBO.setPurchaserNum(Integer.valueOf(new Long(purNum).intValue()));
            splitOrderBO.setAmount(amt);
            splitOrderBO.setOrderNum(Integer.valueOf(list2.size()));
            splitOrderBO.setSupplierNum(Integer.valueOf(new Long(supNum).intValue()));
            splitOrderBO.setSupplierId(Long.valueOf(((RelOrderBO)list2.get(0)).getSupplierCode()));
            splitOrderBO.setSupplierName(((RelOrderBO)list2.get(0)).getSupplierName());
            splitOrderBO.setPurchaserId(((RelOrderBO)list2.get(0)).getPurchaserId());
            splitOrderBO.setPurchaserName(((RelOrderBO)list2.get(0)).getPurchaserName());
            splitOrderBO.setContractId(((RelOrderBO)list2.get(0)).getContractId());
            splitOrderBO.setContractNo(((RelOrderBO)list2.get(0)).getContractNo());
            splitOrderBO.setAgreementId(((RelOrderBO)list2.get(0)).getAgreementId());
            splitOrderBO.setAgreementLdType(((RelOrderBO)list2.get(0)).getAgreementLdType());
            splitOrderBO.setAgreementCode(((RelOrderBO)list2.get(0)).getAgreementCode());
            if (StringUtils.isEmpty((Object)((RelOrderBO)list2.get(0)).getProjectCode()) || !StringUtils.isEmpty((Object)((RelOrderBO)list2.get(0)).getProjectCode()) && !((RelOrderBO)list2.get(0)).getProjectCode().equals(((RelOrderBO)list2.get(0)).getDepartmentCode())) {
                splitOrderBO.setProjectCode(((RelOrderBO)list2.get(0)).getProjectCode());
                splitOrderBO.setProjectName(((RelOrderBO)list2.get(0)).getProjectName());
            } else {
                splitOrderBO.setProjectCode("");
                splitOrderBO.setProjectName("");
            }
            if (((RelOrderBO)list2.get(0)).getPayType().equals(2)) {
                if (TRIPARTITE_TRANSACTION.equals(reqBO.getUpstreamOrDownstream())) {
                    if (StringUtils.isEmpty(accountPeriodMap.get(((RelOrderBO)list2.get(0)).getPurchaserId() + Long.parseLong(((RelOrderBO)list2.get(0)).getSupplierCode())))) {
                        if ("4".equals(((RelOrderBO)list2.get(0)).getUserType().toString())) {
                            splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(FscConstants.MerchantDefalutFlag.YES));
                        } else {
                            splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(FscConstants.MerchantDefalutFlag.YES_OUT));
                        }
                    } else {
                        splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(((RelOrderBO)list2.get(0)).getPurchaserId() + Long.parseLong(((RelOrderBO)list2.get(0)).getSupplierCode())));
                    }
                } else if (DOWNSTREAM_ECOMMERCE.equals(reqBO.getUpstreamOrDownstream())) {
                    if (StringUtils.isEmpty(accountPeriodMap.get(((RelOrderBO)list2.get(0)).getPurchaserId()))) {
                        if ("4".equals(((RelOrderBO)list2.get(0)).getUserType().toString())) {
                            splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(FscConstants.MerchantDefalutFlag.YES));
                        } else {
                            splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(FscConstants.MerchantDefalutFlag.YES_OUT));
                        }
                    } else {
                        splitOrderBO.setAccountPeriod((String)accountPeriodMap.get(((RelOrderBO)list2.get(0)).getPurchaserId()));
                    }
                }
            }
            splitOrderBO.setDepartmentCode(((RelOrderBO)list2.get(0)).getDepartmentCode());
            splitOrderBO.setDepartmentName(((RelOrderBO)list2.get(0)).getDepartmentName());
            splitOrderBO.setRelOrderList(list2);
            splitOrderBOList.add(splitOrderBO);
        }
        FscBillOrderSplitComputeBusiRspBO busiRspBO = new FscBillOrderSplitComputeBusiRspBO();
        busiRspBO.setRows(splitOrderBOList);
        if (log.isDebugEnabled()) {
            log.debug("\u5206\u7ec4\u65b9\u5f0f\uff1a{}\uff0c\u5bf9\u5e94\u7684\u62c6\u5206\u7ed3\u679c\u4e3a\uff1a{}", (Object)ruleType, (Object)JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        return busiRspBO;
    }

    private List<List<RelOrderBO>> groupByOrder(FscBillOrderSplitComputeBusiReqBO reqBO) {
        LinkedList<List<RelOrderBO>> orderInfosList = new LinkedList<List<RelOrderBO>>();
        for (RelOrderBO orderInfoVO : reqBO.getRelOrderList()) {
            LinkedList<RelOrderBO> orderInfoForSingleInvoice = new LinkedList<RelOrderBO>();
            orderInfoForSingleInvoice.add(orderInfoVO);
            orderInfosList.add(orderInfoForSingleInvoice);
        }
        return orderInfosList;
    }

    private List<List<RelOrderBO>> groupByPur(FscBillOrderSplitComputeBusiReqBO reqBO) {
        List<List<RelOrderBO>> orderInfosList = this.baseSplit(reqBO.getRelOrderList(), reqBO.getUpstreamOrDownstream());
        orderInfosList = this.splitByPurchaseUnit(orderInfosList);
        if (reqBO.getMaxCharge() != null && reqBO.getMaxOrderCount() != null && !reqBO.getMaxCharge().equals(BigDecimal.ZERO) && reqBO.getMaxOrderCount() != 0) {
            orderInfosList = this.splitByMaxOrderCount(orderInfosList, reqBO.getMaxOrderCount(), reqBO.getMaxCharge());
        }
        return orderInfosList;
    }

    private List<List<RelOrderBO>> noSplit(FscBillOrderSplitComputeBusiReqBO reqBO) {
        List<List<RelOrderBO>> orderInfosList = this.baseSplit(reqBO.getRelOrderList(), reqBO.getUpstreamOrDownstream());
        log.debug("\u62c6\u5206\u8ba2\u5355\u5173\u8054\u4fe1\u606f\u57fa\u7840\u62c6\u5206\u51fa\u53c2{}", orderInfosList);
        if (reqBO.getMaxCharge() != null && reqBO.getMaxOrderCount() != null && reqBO.getMaxOrderCount() != 0 && !reqBO.getMaxCharge().equals(BigDecimal.ZERO)) {
            orderInfosList = this.splitByMaxOrderCount(orderInfosList, reqBO.getMaxOrderCount(), reqBO.getMaxCharge());
        }
        log.debug("\u51fa\u5165\u62c6\u5206\u4e86-------------------------------" + orderInfosList);
        return orderInfosList;
    }

    private List<List<RelOrderBO>> splitByPurchaseUnit(List<List<RelOrderBO>> orderInfosList) {
        LinkedList<List<RelOrderBO>> orderInfosSplitList = new LinkedList<List<RelOrderBO>>();
        LinkedList valList = new LinkedList();
        for (List<RelOrderBO> list : orderInfosList) {
            HashMap purUnitMap = new HashMap(list.size() + 1);
            for (RelOrderBO orderInfoVO : list) {
                if (purUnitMap.containsKey(orderInfoVO.getPurchaserId())) {
                    ((List)purUnitMap.get(orderInfoVO.getPurchaserId())).add(orderInfoVO);
                    continue;
                }
                LinkedList<RelOrderBO> newOrderInfoVOList = new LinkedList<RelOrderBO>();
                newOrderInfoVOList.add(orderInfoVO);
                purUnitMap.put(orderInfoVO.getPurchaserId(), newOrderInfoVOList);
            }
            valList.add(purUnitMap);
        }
        for (Map map : valList) {
            for (Map.Entry entry : map.entrySet()) {
                orderInfosSplitList.add((List<RelOrderBO>)entry.getValue());
            }
        }
        return orderInfosSplitList;
    }

    private List<List<RelOrderBO>> splitByMaxOrderCount(List<List<RelOrderBO>> orderInfosList, Integer maxOrderCount, BigDecimal maxCharge) {
        LinkedList<List<RelOrderBO>> orderInfosSplitList = new LinkedList<List<RelOrderBO>>();
        for (List<RelOrderBO> orderInfoVoList : orderInfosList) {
            LinkedList<RelOrderBO> minOrderInfoForSingle = new LinkedList<RelOrderBO>();
            BigDecimal amt = BigDecimal.ZERO;
            for (RelOrderBO orderInfoVO : orderInfoVoList) {
                amt = amt.add(orderInfoVO.getAmount());
                if (orderInfoVO.getPositiveOrNegative().equals(POSITIVE) && (amt.compareTo(maxCharge) > 0 || minOrderInfoForSingle.size() >= maxOrderCount)) {
                    if (!CollectionUtils.isEmpty(minOrderInfoForSingle)) {
                        orderInfosSplitList.add(minOrderInfoForSingle);
                    }
                    minOrderInfoForSingle = new LinkedList();
                    amt = orderInfoVO.getAmount();
                }
                if (orderInfoVO.getPositiveOrNegative().equals(NEGATIVE) && minOrderInfoForSingle.size() >= maxOrderCount) {
                    if (!CollectionUtils.isEmpty(minOrderInfoForSingle)) {
                        orderInfosSplitList.add(minOrderInfoForSingle);
                    }
                    minOrderInfoForSingle = new LinkedList();
                }
                minOrderInfoForSingle.add(orderInfoVO);
            }
            orderInfosSplitList.add(minOrderInfoForSingle);
        }
        return orderInfosSplitList;
    }

    private List<List<RelOrderBO>> baseSplit(List<RelOrderBO> relOrderList, Integer upstreamOrDownstream) {
        LinkedList<List<RelOrderBO>> orderInfosList;
        block14: {
            HashMap orderInfosListMap;
            block15: {
                block13: {
                    orderInfosList = new LinkedList<List<RelOrderBO>>();
                    orderInfosListMap = new HashMap(relOrderList.size() + 1);
                    if (!UPSTREAM_ECOMMERCE.equals(upstreamOrDownstream)) break block13;
                    for (RelOrderBO relOrderBo : relOrderList) {
                        if (orderInfosListMap.containsKey(relOrderBo.getSupplierCode() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())) {
                            ((List)orderInfosListMap.get(relOrderBo.getSupplierCode() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())).add(relOrderBo);
                            continue;
                        }
                        LinkedList<RelOrderBO> relOrderBoS = new LinkedList<RelOrderBO>();
                        relOrderBoS.add(relOrderBo);
                        orderInfosListMap.put(relOrderBo.getSupplierCode() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId(), relOrderBoS);
                    }
                    for (String key : orderInfosListMap.keySet()) {
                        orderInfosList.add((List<RelOrderBO>)orderInfosListMap.get(key));
                    }
                    break block14;
                }
                if (!DOWNSTREAM_ECOMMERCE.equals(upstreamOrDownstream)) break block15;
                for (RelOrderBO relOrderBo : relOrderList) {
                    LinkedList<RelOrderBO> relOrderBoS;
                    if (INNER_USER.equals(relOrderBo.getUserType())) {
                        if (orderInfosListMap.containsKey(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())) {
                            ((List)orderInfosListMap.get(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())).add(relOrderBo);
                            continue;
                        }
                        relOrderBoS = new LinkedList<RelOrderBO>();
                        relOrderBoS.add(relOrderBo);
                        orderInfosListMap.put(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId(), relOrderBoS);
                        continue;
                    }
                    if (!OUT_USER.equals(relOrderBo.getUserType())) continue;
                    if (orderInfosListMap.containsKey(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())) {
                        ((List)orderInfosListMap.get(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())).add(relOrderBo);
                        continue;
                    }
                    relOrderBoS = new LinkedList();
                    relOrderBoS.add(relOrderBo);
                    orderInfosListMap.put(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId(), relOrderBoS);
                }
                for (String key : orderInfosListMap.keySet()) {
                    orderInfosList.add((List<RelOrderBO>)orderInfosListMap.get(key));
                }
                break block14;
            }
            if (!TRIPARTITE_TRANSACTION.equals(upstreamOrDownstream)) break block14;
            for (RelOrderBO relOrderBo : relOrderList) {
                LinkedList<RelOrderBO> relOrderBoS;
                if (INNER_USER.equals(relOrderBo.getUserType())) {
                    if (orderInfosListMap.containsKey(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())) {
                        ((List)orderInfosListMap.get(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())).add(relOrderBo);
                        continue;
                    }
                    relOrderBoS = new LinkedList<RelOrderBO>();
                    relOrderBoS.add(relOrderBo);
                    orderInfosListMap.put(relOrderBo.getDepartmentCode() + relOrderBo.getInvoiceCode() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId(), relOrderBoS);
                    continue;
                }
                if (!OUT_USER.equals(relOrderBo.getUserType())) continue;
                if (orderInfosListMap.containsKey(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())) {
                    ((List)orderInfosListMap.get(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId())).add(relOrderBo);
                    continue;
                }
                relOrderBoS = new LinkedList();
                relOrderBoS.add(relOrderBo);
                orderInfosListMap.put(relOrderBo.getPurchaserId().toString() + relOrderBo.getPayType() + relOrderBo.getSupplierCode() + relOrderBo.getContractId() + relOrderBo.getPositiveOrNegative() + relOrderBo.getAgreementLdType() + relOrderBo.getAgreementId(), relOrderBoS);
            }
            for (String key : orderInfosListMap.keySet()) {
                orderInfosList.add((List<RelOrderBO>)orderInfosListMap.get(key));
            }
        }
        return orderInfosList;
    }
}

