/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.FscTransFeeOrderBO;
import com.tydic.fsc.bill.busi.api.FscLianDongCreateTransFeeBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateTransFeeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateTransFeeBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTransfeeItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTransfeeItemPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongCreateTransFeeBusiServiceImpl
implements FscLianDongCreateTransFeeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongCreateTransFeeBusiServiceImpl.class);
    @Autowired
    private FscTransfeeItemMapper fscTransfeeItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Value(value="${QRY_TRANS_FEE_ORDER_URL:http://test-lsugu.liando.cn/dyc/saas/self/noauth/order/qrySaleOrderTranFee}")
    private String qryTransFeeOrderUrl;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    private static final Integer TRANS_FEE = 3;
    private static final Integer TRANS_FEE_UP = 4;

    @Override
    public FscLianDongCreateTransFeeBusiRspBO createTransFee(FscLianDongCreateTransFeeBusiReqBO busiReqBO) {
        FscLianDongCreateTransFeeBusiRspBO fscLianDongCreateTransFeeBusiRspBo = new FscLianDongCreateTransFeeBusiRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        FscOrderPO fscOrderMapperModelBy = this.getFscOrderPo(busiReqBO);
        List<FscOrderItemPO> fscOrderItemPoList = this.getFscOrderItemList(busiReqBO.getFscOrderId());
        List<Long> acceptOrderIds = fscOrderItemPoList.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
        List<FscTransFeeOrderBO> orderTransFeeList = this.getOrderTransFeeList(acceptOrderIds);
        Map<Long, Long> saleAndInspMap = orderTransFeeList.stream().collect(Collectors.toMap(FscTransFeeOrderBO::getSaleOrderId, FscTransFeeOrderBO::getInspOrderId));
        Map<Long, FscTransFeeOrderBO> fscTransFeeOrderBoMap = orderTransFeeList.stream().collect(Collectors.toMap(FscTransFeeOrderBO::getSaleOrderId, o -> o));
        log.debug("\u521d\u59cb\u5316\u8ba2\u5355\u6709\u8fd0\u8d39\u4fe1\u606f\u7684map{}", fscTransFeeOrderBoMap);
        if (!CollectionUtils.isEmpty(orderTransFeeList)) {
            log.debug("\u521d\u59cb\u5316\u8ba2\u5355\u6709\u8fd0\u8d39\u4fe1\u606f\u7684map\u6709\u503c{}", fscTransFeeOrderBoMap);
            List<Long> transFeeList = this.getTransFeeList(fscOrderMapperModelBy, orderTransFeeList);
            if (!CollectionUtils.isEmpty(transFeeList)) {
                log.debug("\u53d6\u51fa\u9700\u8981\u751f\u6210\u5bf9\u8d26\u5355\u7684\u9500\u552e\u5355id\u96c6\u5408\u6709\u503c{}", transFeeList);
                BigDecimal totalCharge = BigDecimal.ZERO;
                BigDecimal totalChargeAfter = this.getTotalCharge(fscOrderMapperModelBy, fscTransFeeOrderBoMap, transFeeList, totalCharge);
                log.debug("\u5bf9\u8d26\u5355\u603b\u91d1\u989d\u7d2f\u52a0\u540e\u5916\u5c42\u51fa\u53c2{}", (Object)totalChargeAfter);
                StringBuilder keySb = this.getStringBuilder(fscOrderMapperModelBy);
                String serial = this.getSerial(keySb.toString());
                this.insertFscOrder(fscOrderMapperModelBy, totalChargeAfter, fscOrderId, serial);
                this.insertFscTransFeeItem(fscOrderMapperModelBy, fscTransFeeOrderBoMap, transFeeList, fscOrderId);
                this.insertOrderInvoice(busiReqBO, fscOrderId);
                this.insertFscInvoiceRule(busiReqBO, fscOrderId);
                this.insertFscOrderRelation(busiReqBO, saleAndInspMap, transFeeList, fscOrderId);
                this.startFlow(fscOrderMapperModelBy, fscOrderId);
                fscLianDongCreateTransFeeBusiRspBo.setFscOrderId(fscOrderId);
            }
        }
        fscLianDongCreateTransFeeBusiRspBo.setRespCode("0000");
        fscLianDongCreateTransFeeBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongCreateTransFeeBusiRspBo;
    }

    private void insertFscInvoiceRule(FscLianDongCreateTransFeeBusiReqBO busiReqBO, Long fscOrderId) {
        FscInvoiceRulePO fscInvoiceRulePo = new FscInvoiceRulePO();
        fscInvoiceRulePo.setFscOrderId(busiReqBO.getFscOrderId());
        FscInvoiceRulePO modelBy = this.fscInvoiceRuleMapper.getModelBy(fscInvoiceRulePo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u539f\u59cb\u53d1\u7968\u89c4\u5219\u4e3a\u7a7a");
        }
        modelBy.setFscOrderId(fscOrderId);
        int insert = this.fscInvoiceRuleMapper.insert(modelBy);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u8fd0\u8d39\u53d1\u7968\u89c4\u5219\u5931\u8d25");
        }
    }

    private void startFlow(FscOrderPO fscOrderMapperModelBy, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBo = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBo.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBo.setOrderFlow(fscOrderMapperModelBy.getOrderFlow());
        fscOrderStatusStartAtomReqBo.setOperId("1");
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        if (!FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderMapperModelBy.getMakeType()) || !FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType())) {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.NOT_CHECK);
        } else {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.ELECTRONIC);
        }
        fscOrderStatusStartAtomReqBo.setParamMap(paramMap);
        log.debug("\u5f00\u542f\u72b6\u6001\u673a\u5165\u53c2{}", (Object)fscOrderStatusStartAtomReqBo);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBo);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertFscOrderRelation(FscLianDongCreateTransFeeBusiReqBO busiReqBO, Map<Long, Long> saleAndInspMap, List<Long> transFeeList, Long fscOrderId) {
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(busiReqBO.getFscOrderId());
        fscOrderRelationPo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        List fscOrderRelationList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        log.debug("\u539f\u59cb\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u8868\u67e5\u8be2\u51fa\u53c2{}", (Object)fscOrderRelationList);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationList)) {
            throw new FscBusinessException("190000", "\u539f\u59cb\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u8868\u67e5\u8be2\u4e3a\u7a7a");
        }
        Map<Long, FscOrderRelationPO> fscOrderRelationPoMap = fscOrderRelationList.stream().collect(Collectors.toMap(FscOrderRelationPO::getAcceptOrderId, o -> o));
        log.debug("\u83b7\u53d6\u9a8c\u6536\u5355\u5bf9\u5e94\u5173\u8054\u8868map{}", fscOrderRelationPoMap);
        ArrayList fscOrderRelationPoList = new ArrayList();
        transFeeList.forEach(saleOrderId -> {
            FscOrderRelationPO fscOrderRelationPoModel = (FscOrderRelationPO)fscOrderRelationPoMap.get(saleAndInspMap.get(saleOrderId));
            log.debug("\u83b7\u53d6\u5230\u9700\u8981\u8fd0\u8d39\u7684\u9500\u552e\u5355\u7684\u5173\u8054\u8868\u6570\u636e{}", (Object)fscOrderRelationPoModel);
            if (fscOrderRelationPoModel != null) {
                fscOrderRelationPoModel.setFscOrderId(fscOrderId);
                if (busiReqBO.getUpOrDown() != null) {
                    fscOrderRelationPoModel.setUpDown(TRANS_FEE_UP);
                } else {
                    fscOrderRelationPoModel.setUpDown(TRANS_FEE);
                }
                fscOrderRelationPoModel.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPoModel.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
                fscOrderRelationPoList.add(fscOrderRelationPoModel);
            }
        });
        log.debug("\u83b7\u53d6\u5230\u9700\u8981\u8fd0\u8d39\u7684\u9500\u552e\u5355\u7684\u5173\u8054\u8868\u6570\u636e\u6700\u7ec8\u503c{}", fscOrderRelationPoList);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPoList);
    }

    private void insertOrderInvoice(FscLianDongCreateTransFeeBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(busiReqBO.getFscOrderId());
        log.debug("\u67e5\u8be2\u539f\u59cb\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f\u5165\u53c2{}", (Object)fscOrderInvoicePo);
        FscOrderInvoicePO fscOrderInvoiceMapperModelBy = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        log.debug("\u67e5\u8be2\u539f\u59cb\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f\u51fa\u53c2{}", (Object)fscOrderInvoiceMapperModelBy);
        if (fscOrderInvoiceMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u539f\u59cb\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f\u8868\u4e3a\u7a7a");
        }
        fscOrderInvoiceMapperModelBy.setFscOrderId(fscOrderId);
        int insert = this.fscOrderInvoiceMapper.insert(fscOrderInvoiceMapperModelBy);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u8fd0\u8d39\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }

    private void insertFscTransFeeItem(FscOrderPO fscOrderMapperModelBy, Map<Long, FscTransFeeOrderBO> fscTransFeeOrderBoMap, List<Long> transFeeList, Long fscOrderId) {
        ArrayList fscTransfeeItemList = new ArrayList();
        transFeeList.forEach(saleOrderId -> {
            Long fscTransFeeItemId = Sequence.getInstance().nextId();
            FscTransfeeItemPO fscTransfeeItemPo = new FscTransfeeItemPO();
            FscTransFeeOrderBO fscTransFeeOrderBo = (FscTransFeeOrderBO)fscTransFeeOrderBoMap.get(saleOrderId);
            BeanUtils.copyProperties((Object)fscTransFeeOrderBo, (Object)fscTransfeeItemPo);
            fscTransfeeItemPo.setReceiveType(fscOrderMapperModelBy.getReceiveType());
            fscTransfeeItemPo.setMakeType(fscOrderMapperModelBy.getMakeType());
            fscTransfeeItemPo.setFscOrderId(fscOrderId);
            fscTransfeeItemPo.setCreateTime(new Date());
            fscTransfeeItemPo.setFscTransfeeItemId(fscTransFeeItemId);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderMapperModelBy.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType()) || FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderMapperModelBy.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType())) {
                fscTransfeeItemPo.setTransFee(fscTransFeeOrderBo.getTransFeeUp());
            } else {
                fscTransfeeItemPo.setTransFee(fscTransFeeOrderBo.getTransFeeDown());
            }
            fscTransfeeItemPo.setPurchaseId(fscOrderMapperModelBy.getPurchaserId());
            fscTransfeeItemPo.setSupplierId(fscOrderMapperModelBy.getSupplierId());
            fscTransfeeItemPo.setPurchaseName(fscOrderMapperModelBy.getPurchaserName());
            fscTransfeeItemPo.setSupplierName(fscOrderMapperModelBy.getSupplierName());
            fscTransfeeItemList.add(fscTransfeeItemPo);
        });
        this.fscTransfeeItemMapper.insertBatch(fscTransfeeItemList);
    }

    private void insertFscOrder(FscOrderPO fscOrderMapperModelBy, BigDecimal totalCharge, Long fscOrderId, String serial) {
        FscOrderPO fscOrderTransFeePo = new FscOrderPO();
        BeanUtils.copyProperties((Object)fscOrderMapperModelBy, (Object)fscOrderTransFeePo);
        fscOrderTransFeePo.setFscOrderId(fscOrderId);
        fscOrderTransFeePo.setOrderNo(serial);
        fscOrderTransFeePo.setTotalCharge(BigDecimal.ZERO);
        fscOrderTransFeePo.setInspTotalTransMoney(totalCharge);
        fscOrderTransFeePo.setInspTotalBillMoney(totalCharge);
        fscOrderTransFeePo.setTaskId(null);
        fscOrderTransFeePo.setOrderState(null);
        fscOrderTransFeePo.setCreateTime(new Date());
        fscOrderTransFeePo.setBuildAction(FscConstants.FscOrderBuildAction.AUTO);
        fscOrderTransFeePo.setProcInstId(null);
        fscOrderTransFeePo.setFscTransOrderType(FscConstants.FscTransOrderType.TRANSFEE);
        log.debug("\u65b0\u589e\u8fd0\u8d39\u5bf9\u8d26\u5355\u5165\u53c2{}", (Object)fscOrderTransFeePo);
        int insert = this.fscOrderMapper.insert(fscOrderTransFeePo);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u8fd0\u8d39\u5bf9\u8d26\u5355\u5931\u8d25");
        }
    }

    private BigDecimal getTotalCharge(FscOrderPO fscOrderMapperModelBy, Map<Long, FscTransFeeOrderBO> fscTransFeeOrderBoMap, List<Long> transFeeList, BigDecimal totalCharge) {
        for (Long saleOrderId : transFeeList) {
            FscTransFeeOrderBO fscTransFeeOrderBo = fscTransFeeOrderBoMap.get(saleOrderId);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderMapperModelBy.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType()) || FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderMapperModelBy.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType())) {
                log.debug("\u4e0a\u6e38\u5bf9\u8d26\u5355\u91d1\u989d\u7d2f\u52a0");
                totalCharge = totalCharge.add(fscTransFeeOrderBo.getTransFeeUp());
                log.debug("\u4e0a\u6e38\u5bf9\u8d26\u5355\u91d1\u989d\u7d2f\u52a0\u540e\u503c{}", (Object)totalCharge);
                continue;
            }
            log.debug("\u4e0b\u6e38\u5bf9\u8d26\u5355\u91d1\u989d\u7d2f\u52a0");
            totalCharge = totalCharge.add(fscTransFeeOrderBo.getTransFeeDown());
            log.debug("\u4e0b\u6e38\u5bf9\u8d26\u5355\u91d1\u989d\u7d2f\u52a0\u540e\u503c{}", (Object)totalCharge);
        }
        log.debug("\u5bf9\u8d26\u5355\u91d1\u989d\u7d2f\u52a0\u6700\u7ec8\u503c{}", (Object)totalCharge);
        return totalCharge;
    }

    private StringBuilder getStringBuilder(FscOrderPO fscOrderMapperModelBy) {
        StringBuilder keySb = new StringBuilder();
        keySb.append(fscOrderMapperModelBy.getReceiveType());
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderMapperModelBy.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderMapperModelBy.getReceiveType())) {
            keySb.append(FscConstants.FscBusiModel.TRADE);
        } else {
            keySb.append(FscConstants.FscBusiModel.MATCHING);
        }
        keySb.append(fscOrderMapperModelBy.getOrderSource());
        return keySb;
    }

    private String getSerial(String key) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(Objects.requireNonNull(FscBillInvoiceSerial.getInstance((String)key)).getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private FscOrderPO getFscOrderPo(FscLianDongCreateTransFeeBusiReqBO busiReqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(busiReqBO.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u539f\u59cb\u5bf9\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderMapperModelBy;
    }

    private List<Long> getTransFeeList(FscOrderPO fscOrderPo, List<FscTransFeeOrderBO> orderTransFeeList) {
        List<Long> saleOrderIds = orderTransFeeList.stream().map(FscTransFeeOrderBO::getSaleOrderId).collect(Collectors.toList());
        log.debug("\u8ba2\u5355\u8fd4\u56de\u7684\u8fd0\u8d39\u5bf9\u8d26\u5355\u7684\u9500\u552e\u5355id\u96c6\u5408{}", saleOrderIds);
        FscTransfeeItemPO fscTransfeeItemPo = new FscTransfeeItemPO();
        fscTransfeeItemPo.setSaleOrderIds(saleOrderIds);
        fscTransfeeItemPo.setMakeType(fscOrderPo.getMakeType());
        fscTransfeeItemPo.setReceiveType(fscOrderPo.getReceiveType());
        log.debug("\u67e5\u8be2\u5df2\u7ecf\u751f\u6210\u7684\u9500\u552e\u5355\u8fd0\u8d39\u96c6\u5408\u5165\u53c2{}", (Object)fscTransfeeItemPo);
        List fscTransfeeItemList = this.fscTransfeeItemMapper.getList(fscTransfeeItemPo);
        log.debug("\u67e5\u8be2\u5df2\u7ecf\u751f\u6210\u7684\u9500\u552e\u5355\u8fd0\u8d39\u96c6\u5408\u51fa\u53c2{}", (Object)fscTransfeeItemList);
        if (!CollectionUtils.isEmpty((Collection)fscTransfeeItemList)) {
            List removeSaleOrderIds = fscTransfeeItemList.stream().map(FscTransfeeItemPO::getSaleOrderId).collect(Collectors.toList());
            log.debug("\u9700\u8981\u79fb\u9664\u7684\u8fd0\u8d39\u5bf9\u8d26\u5355\u7684\u9500\u552e\u5355id\u96c6\u5408{}", removeSaleOrderIds);
            saleOrderIds.removeAll(removeSaleOrderIds);
        }
        return this.returnTrueSaleOrderIds(fscOrderPo, orderTransFeeList, saleOrderIds);
    }

    private List<Long> returnTrueSaleOrderIds(FscOrderPO fscOrderPo, List<FscTransFeeOrderBO> orderTransFeeList, List<Long> saleOrderIds) {
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType())) {
            List collect = orderTransFeeList.stream().filter(fscTransFeeOrderBo -> fscTransFeeOrderBo.getTransFeeDown() == null || fscTransFeeOrderBo.getTransFeeDown().compareTo(BigDecimal.ZERO) == 0).map(FscTransFeeOrderBO::getSaleOrderId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                saleOrderIds.removeAll(collect);
            }
            log.debug("\u9700\u8981\u751f\u6210\u8fd0\u8d39\u5bf9\u8d26\u5355\u7684\u9500\u552e\u5355id\u96c6\u5408{}", saleOrderIds);
            return saleOrderIds;
        }
        List collect = orderTransFeeList.stream().filter(fscTransFeeOrderBo -> fscTransFeeOrderBo.getTransFeeUp() == null || fscTransFeeOrderBo.getTransFeeUp().compareTo(BigDecimal.ZERO) == 0).map(FscTransFeeOrderBO::getSaleOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            saleOrderIds.removeAll(collect);
        }
        log.debug("\u9700\u8981\u751f\u6210\u8fd0\u8d39\u5bf9\u8d26\u5355\u7684\u9500\u552e\u5355id\u96c6\u5408{}", saleOrderIds);
        return saleOrderIds;
    }

    private List<FscOrderItemPO> getFscOrderItemList(Long fscOrderId) {
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(fscOrderId);
        List fscOrderItemPoList = this.fscOrderItemMapper.getList(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPoList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u539f\u59cb\u5bf9\u8d26\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return fscOrderItemPoList;
    }

    private List<FscTransFeeOrderBO> getOrderTransFeeList(List<Long> acceptOrderIds) {
        log.debug("http\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u662f\u5426\u6709\u8fd0\u8d39\u4fe1\u606f\uff08\u533a\u5206\u4e0a\u4e0b\u6e38\uff09\u5f00\u59cb{}", acceptOrderIds);
        HashMap<String, List<Long>> content = new HashMap<String, List<Long>>(2);
        content.put("acceptOrderIds", acceptOrderIds);
        log.debug("http\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u662f\u5426\u6709\u8fd0\u8d39\u4fe1\u606f\u5165\u53c2{}", (Object)(this.qryTransFeeOrderUrl + JSONObject.toJSONString(content)));
        String resultData = HttpUtil.post((String)this.qryTransFeeOrderUrl, (String)JSONObject.toJSONString(content));
        log.debug("http\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u662f\u5426\u6709\u8fd0\u8d39\u4fe1\u606f\u51fa\u53c2{}", (Object)resultData);
        if (!StringUtils.isEmpty((CharSequence)resultData)) {
            JSONObject jsonObject = JSONObject.parseObject((String)resultData);
            Object code = jsonObject.get((Object)"code");
            if (!"0".equals(code)) {
                throw new FscBusinessException("190000", jsonObject.get((Object)"message").toString());
            }
            JSONObject data = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"data")), JSONObject.class);
            String saleOrderTransFeeBoList = JSONObject.toJSONString((Object)data.get((Object)"saleOrderTransFeeBoList"));
            log.debug("\u8ba2\u5355\u8fd0\u8d39\u4fe1\u606f\u51fa\u53c2{}", (Object)saleOrderTransFeeBoList);
            List saleOrderTransFeeBoListJson = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data.get((Object)"saleOrderTransFeeBoList")), FscTransFeeOrderBO.class);
            if (CollectionUtils.isEmpty((Collection)saleOrderTransFeeBoListJson)) {
                return new ArrayList<FscTransFeeOrderBO>();
            }
            log.debug("\u8ba2\u5355\u8fd0\u8d39\u4fe1\u606f\u51fa\u53c2\u6709\u503c{}", (Object)saleOrderTransFeeBoListJson);
            return saleOrderTransFeeBoListJson;
        }
        throw new FscBusinessException("190000", "http\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u662f\u5426\u6709\u8fd0\u8d39\u4fe1\u606f\u5931\u8d25\uff01");
    }
}

