/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscLianDongAddContractAbilityService;
import com.tydic.fsc.bill.ability.bo.FscContractAddBO;
import com.tydic.fsc.bill.ability.bo.FscContractAddPayBO;
import com.tydic.fsc.bill.ability.bo.FscContractAddSkuBO;
import com.tydic.fsc.bill.ability.bo.FscLianDongAddContractAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscLianDongAddContractAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscLianDongAddContractBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddContractBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddContractBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongAddContractAbilityService"})
public class FscLianDongAddContractAbilityServiceImpl
implements FscLianDongAddContractAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongAddContractAbilityServiceImpl.class);
    @Autowired
    private FscLianDongAddContractBusiService fscLianDongAddContractBusiService;

    @PostMapping(value={"ledgerContractGeneration"})
    public FscLianDongAddContractAbilityRspBO ledgerContractGeneration(@RequestBody FscLianDongAddContractAbilityReqBO reqBO) {
        FscLianDongAddContractAbilityRspBO abilityRspBO = new FscLianDongAddContractAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        this.validate(reqBO);
        this.dealAddContractInfo(reqBO);
        return abilityRspBO;
    }

    private void dealAddContractInfo(FscLianDongAddContractAbilityReqBO reqBO) {
        reqBO.getFscContractBOList().forEach(fscContractAddBo -> {
            FscLianDongAddContractBusiReqBO contractBusiReqBO = (FscLianDongAddContractBusiReqBO)((Object)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscLianDongAddContractBusiReqBO.class)));
            contractBusiReqBO.setFscContractBOList(Collections.singletonList(fscContractAddBo));
            FscLianDongAddContractBusiRspBO busiRspBO = this.fscLianDongAddContractBusiService.dealContractAdd(contractBusiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new FscBusinessException("190000", busiRspBO.getRespDesc());
            }
        });
    }

    private void validate(FscLianDongAddContractAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getUserId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 [\u7528\u6237\u4fe1\u606f] \u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscContractBOList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList] \u4e3a\u7a7a");
        }
        for (FscContractAddBO contract : reqBO.getFscContractBOList()) {
            if (ObjectUtil.isEmpty((Object)contract.getPurchaseOrderId())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->purchaseOrderId] \u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)contract.getCtrctKsdaCode())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->ctrctKsdaCode] \u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)contract.getCtrctKsdaId())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->ctrctKsdaId] \u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)contract.getCtrctType())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->ctrctType] \u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)contract.getContractAddSkuBOList())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList] \u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)contract.getContractAddPayBOList())) {
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddPayBOList] \u4e3a\u7a7a");
            }
            for (FscContractAddSkuBO skuBO : contract.getContractAddSkuBOList()) {
                if (ObjectUtil.isEmpty((Object)skuBO.getSkuNo())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->skuNo] \u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)skuBO.getSkuName())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->skuName] \u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)skuBO.getUnit())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->unit] \u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)skuBO.getSkuPrice())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->skuPrice] \u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)skuBO.getNum())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->num] \u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)skuBO.getAmount())) continue;
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddSkuBOList->amount] \u4e3a\u7a7a");
            }
            for (FscContractAddPayBO payBO : contract.getContractAddPayBOList()) {
                if (ObjectUtil.isEmpty((Object)payBO.getContractPayType())) {
                    throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddPayBOList->contractPayType] \u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)payBO.getContractPayTypeStr())) continue;
                throw new FscBusinessException("190000", "\u5165\u53c2 [fscContractBOList->contractAddPayBOList->contractPayTypeStr] \u4e3a\u7a7a");
            }
        }
    }
}

