/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscLianDongCallFscNotContractUpAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongCallFscNotContractUpAbilityReqBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongCallFscNotContractUpAbilityRspBo;
import com.tydic.fsc.bill.busi.api.FscLianDongCallFscNotContractUpBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongCallFscNotContractUpBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongCallFscNotContractUpBusiRspBo;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongCallFscNotContractUpAbilityService"})
public class FscLianDongCallFscNotContractUpAbilityServiceImpl
implements FscLianDongCallFscNotContractUpAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongCallFscNotContractUpAbilityServiceImpl.class);
    @Autowired
    private FscLianDongCallFscNotContractUpBusiService fscLianDongCallFscNotContractUpBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Value(value="${settlementDay:7}")
    private int settlementDay;

    @PostMapping(value={"dealCallFscNotContractUp"})
    public FscLianDongCallFscNotContractUpAbilityRspBo dealCallFscNotContractUp(@RequestBody FscLianDongCallFscNotContractUpAbilityReqBo abilityReqBo) {
        this.getFscOrderPo(abilityReqBo);
        FscLianDongCallFscNotContractUpBusiReqBo fscLianDongCallFscNotContractUpBusiReqBo = (FscLianDongCallFscNotContractUpBusiReqBo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBo), FscLianDongCallFscNotContractUpBusiReqBo.class));
        fscLianDongCallFscNotContractUpBusiReqBo.setIsDeal(true);
        FscLianDongCallFscNotContractUpBusiRspBo fscLianDongCallFscNotContractUpBusiRspBo = this.fscLianDongCallFscNotContractUpBusiService.dealCallFscNotContractUp(fscLianDongCallFscNotContractUpBusiReqBo);
        if (!"0000".equals(fscLianDongCallFscNotContractUpBusiRspBo.getRespCode())) {
            throw new FscBusinessException(fscLianDongCallFscNotContractUpBusiRspBo.getRespCode(), fscLianDongCallFscNotContractUpBusiRspBo.getRespDesc());
        }
        return (FscLianDongCallFscNotContractUpAbilityRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)fscLianDongCallFscNotContractUpBusiRspBo)), FscLianDongCallFscNotContractUpAbilityRspBo.class);
    }

    @PostMapping(value={"dealAutoTimeCallFscNotContractUp"})
    public FscLianDongCallFscNotContractUpAbilityRspBo dealAutoTimeCallFscNotContractUp(@RequestBody FscLianDongCallFscNotContractUpAbilityReqBo abilityReqBo) {
        List<FscOrderPO> fscOrderPoList = this.getFscOrderPoList();
        if (CollectionUtils.isEmpty(fscOrderPoList)) {
            return new FscLianDongCallFscNotContractUpAbilityRspBo();
        }
        fscOrderPoList.forEach(fscOrderPoModel -> {
            FscLianDongCallFscNotContractUpBusiReqBo fscLianDongCallFscNotContractUpBusiReqBo = new FscLianDongCallFscNotContractUpBusiReqBo();
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(6, this.settlementDay);
            Date resultDate = calendar.getTime();
            if (fscOrderPoModel.getPlanPayTime() != null && fscOrderPoModel.getPlanPayTime().compareTo(resultDate) <= 0) {
                this.setInfo(fscLianDongCallFscNotContractUpBusiReqBo, (FscOrderPO)fscOrderPoModel);
                log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u5f00\u59cb{}", (Object)fscLianDongCallFscNotContractUpBusiReqBo);
                Long logId = null;
                try {
                    logId = this.logAdd(fscOrderPoModel.getFscOrderId() + "", fscOrderPoModel.getFscOrderId() + "");
                }
                catch (Exception e) {
                    log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
                    e.printStackTrace();
                }
                fscLianDongCallFscNotContractUpBusiReqBo.setLogId(logId);
                try {
                    log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u5165\u53c2{}", (Object)fscLianDongCallFscNotContractUpBusiReqBo);
                    FscLianDongCallFscNotContractUpBusiRspBo fscLianDongCallFscNotContractUpBusiRspBo = this.fscLianDongCallFscNotContractUpBusiService.dealCallFscNotContractUp(fscLianDongCallFscNotContractUpBusiReqBo);
                    log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u51fa\u53c2{}", (Object)fscLianDongCallFscNotContractUpBusiReqBo);
                }
                catch (Exception e) {
                    log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u5931\u8d25");
                    try {
                        if (logId != null) {
                            this.logUpdate(logId, e.getMessage(), FscConstants.CostIsError.NO);
                        }
                    }
                    catch (Exception es) {
                        log.debug("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
                        es.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
        return new FscLianDongCallFscNotContractUpAbilityRspBo();
    }

    @PostMapping(value={"dealBySelfCallFscNotContractUp"})
    public FscLianDongCallFscNotContractUpAbilityRspBo dealBySelfCallFscNotContractUp(@RequestBody FscLianDongCallFscNotContractUpAbilityReqBo abilityReqBo) {
        FscOrderPO fscOrderPoModel = this.getFscOrderPo(abilityReqBo);
        if (!FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION.equals(fscOrderPoModel.getAgreementLdType())) {
            throw new FscBusinessException("190000", "\u975e\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0d\u5141\u8bb8\u624b\u52a8\u63a8\u9001");
        }
        FscLianDongCallFscNotContractUpBusiReqBo fscLianDongCallFscNotContractUpBusiReqBo = (FscLianDongCallFscNotContractUpBusiReqBo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBo), FscLianDongCallFscNotContractUpBusiReqBo.class));
        this.setInfo(fscLianDongCallFscNotContractUpBusiReqBo, fscOrderPoModel);
        fscLianDongCallFscNotContractUpBusiReqBo.setIsDeal(true);
        log.debug("\u624b\u52a8\u63a8\u9001\u81ea\u91c7\u96c6\u91c7\u7c7b\u8d26\u5355\u4e0a\u6e38\u5f00\u59cb{}", (Object)fscLianDongCallFscNotContractUpBusiReqBo);
        FscLianDongCallFscNotContractUpBusiRspBo fscLianDongCallFscNotContractUpBusiRspBo = this.fscLianDongCallFscNotContractUpBusiService.dealCallFscNotContractUp(fscLianDongCallFscNotContractUpBusiReqBo);
        if (!"0000".equals(fscLianDongCallFscNotContractUpBusiRspBo.getRespCode())) {
            throw new FscBusinessException(fscLianDongCallFscNotContractUpBusiRspBo.getRespCode(), fscLianDongCallFscNotContractUpBusiRspBo.getRespDesc());
        }
        return (FscLianDongCallFscNotContractUpAbilityRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)fscLianDongCallFscNotContractUpBusiRspBo)), FscLianDongCallFscNotContractUpAbilityRspBo.class);
    }

    private FscOrderPO getFscOrderPo(FscLianDongCallFscNotContractUpAbilityReqBo abilityReqBo) {
        if (abilityReqBo == null) {
            throw new FscBusinessException("190000", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBo.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(abilityReqBo.getFscOrderId());
        fscOrderPo.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        FscOrderPO fscOrderPoModel = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPoModel == null) {
            throw new FscBusinessException("190000", "\u5bf9\u8d26\u5355\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!FscConstants.IsCallCost.NO.equals(fscOrderPo.getIsCallCost())) {
            throw new FscBusinessException("190000", "\u5df2\u7ecf\u63a8\u9001\u7684\u8d26\u5355\u4e0d\u5141\u8bb8\u518d\u6b21\u63a8\u9001");
        }
        return fscOrderPoModel;
    }

    private void setInfo(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo, FscOrderPO fscOrderPoModel) {
        busiReqBo.setFscOrderId(fscOrderPoModel.getFscOrderId());
        busiReqBo.setFscOrderNo(fscOrderPoModel.getOrderNo());
        busiReqBo.setFscTransOrderType(fscOrderPoModel.getFscTransOrderType());
        busiReqBo.setTotalAmount(fscOrderPoModel.getInspTotalBillMoney());
        busiReqBo.setSupplierName(fscOrderPoModel.getSupplierName());
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.YES, FscConstants.CostObjType.ORDER_NEED_PAY_FSC_CALL, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }

    private List<FscOrderPO> getFscOrderPoList() {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setIsCallCost(FscConstants.IsCallCost.NO);
        fscOrderPo.setAgreementLdType(FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION);
        fscOrderPo.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        return this.fscOrderMapper.getListNotChannl(fscOrderPo);
    }
}

