/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscLianDongQryFscNeedPayListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongNeedPayBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongQryFscNeedPayListAbilityReqBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongQryFscNeedPayListAbilityRspBo;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscNeedPayPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongQryFscNeedPayListAbilityService"})
public class FscLianDongQryFscNeedPayListAbilityServiceImpl
implements FscLianDongQryFscNeedPayListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongQryFscNeedPayListAbilityServiceImpl.class);
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;

    @PostMapping(value={"qryFscNeedPayList"})
    public FscLianDongQryFscNeedPayListAbilityRspBo qryFscNeedPayList(@RequestBody FscLianDongQryFscNeedPayListAbilityReqBo abilityReqBo) {
        Date date;
        FscLianDongQryFscNeedPayListAbilityRspBo abilityRspBo = new FscLianDongQryFscNeedPayListAbilityRspBo();
        abilityRspBo.setRespCode("0000");
        abilityRspBo.setRespDesc("\u6210\u529f");
        FscNeedPayPO qryFscNeedPayPo = (FscNeedPayPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBo), FscNeedPayPO.class);
        Page page = new Page(abilityReqBo.getPageNo().intValue(), abilityReqBo.getPageSize().intValue());
        if (abilityReqBo.getNeedPayDateEnd() != null) {
            date = FscLianDongQryFscNeedPayListAbilityServiceImpl.timeProcessing(abilityReqBo.getNeedPayDateEnd());
            qryFscNeedPayPo.setNeedPayDateEnd(date);
        }
        if (abilityReqBo.getNeedPayDateStart() != null) {
            date = FscLianDongQryFscNeedPayListAbilityServiceImpl.timeProcessing(abilityReqBo.getNeedPayDateStart());
            qryFscNeedPayPo.setNeedPayDateStart(date);
        }
        qryFscNeedPayPo.setOrderBy("create_time DESC");
        List fscNeedPayPos = this.fscNeedPayMapper.getListPage(qryFscNeedPayPo, page);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayPos)) {
            abilityRspBo.setRows(new ArrayList());
            abilityRspBo.setPageNo(Integer.valueOf(0));
            abilityRspBo.setTotal(Integer.valueOf(0));
            abilityRspBo.setRecordsTotal(Integer.valueOf(0));
            return abilityRspBo;
        }
        ArrayList rows = new ArrayList(fscNeedPayPos.size());
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        fscNeedPayPos.forEach(e -> {
            FscLianDongNeedPayBo fscNeedPayBo = (FscLianDongNeedPayBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)e), FscLianDongNeedPayBo.class);
            Map fscNeedPayStateMap = (Map)dicMap.get("FSC_NEED_PAY_STATE");
            if (!MapUtils.isEmpty((Map)fscNeedPayStateMap) && fscNeedPayBo.getNeedPayState() != null) {
                fscNeedPayBo.setNeedPayStateStr((String)fscNeedPayStateMap.get(fscNeedPayBo.getNeedPayState().toString()));
            }
            fscNeedPayBo.setNeedPayMoney(FscLianDongQryFscNeedPayListAbilityServiceImpl.dealBigDecimal(fscNeedPayBo.getNeedPayMoney()));
            rows.add(fscNeedPayBo);
        });
        abilityRspBo.setRows(rows);
        abilityRspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        abilityRspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        abilityRspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        return abilityRspBo;
    }

    private static BigDecimal dealBigDecimal(BigDecimal bigDecimal) {
        int scale = 2;
        if (bigDecimal != null) {
            bigDecimal = "0E-8".equals(bigDecimal.toString()) ? new BigDecimal(0).setScale(scale, 4) : bigDecimal.setScale(scale, 4);
        }
        return bigDecimal;
    }

    private static Date timeProcessing(Date date) {
        SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = longSdf.parse(shortSdf.format(date) + " 00:00:00");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("FSC_NEED_PAY_STATE");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, FscDicDictionaryPO::getTitle));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

