/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscLianDongNeedPayUpdatePayTimeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongNeedPayInvoiceBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongNeedPayUpdatePayTimeAbilityReqBo;
import com.tydic.fsc.bill.busi.api.FscLianDongAddFscNeedPayInvoiceListBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddFscNeedPayInvoiceListBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddFscNeedPayInvoiceListBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractPayMapper;
import com.tydic.fsc.dao.FscNeedPayInvoiceMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscNeedPayInvoicePO;
import com.tydic.fsc.po.FscNeedPayPO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscLianDongAddFscNeedPayInvoiceListBusiServiceImpl
implements FscLianDongAddFscNeedPayInvoiceListBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongAddFscNeedPayInvoiceListBusiServiceImpl.class);
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscNeedPayInvoiceMapper fscNeedPayInvoiceMapper;
    @Autowired
    private FscContractPayMapper fscContractPayMapper;
    @Value(value="${PAY_TYPE_ITEM_CONTRACT:\u7968\u5230}")
    private String payTypeItemContract;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTORUPDATENEEDPAYTIMESERVICE = new ThreadPoolExecutor(CPU, 2 * CPU, 200L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("\u65b0\u589e\u53d1\u7968\u4fee\u6539\u5bf9\u8d26\u5355\u4fee\u6539\u5e94\u4ed8\u65f6\u95f4\u7ebf\u7a0b\u6c60").build(), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private FscLianDongNeedPayUpdatePayTimeAbilityService fscLianDongNeedPayUpdatePayTimeAbilityService;

    @Override
    public FscLianDongAddFscNeedPayInvoiceListBusiRspBo addFscNeedPayInvoiceList(FscLianDongAddFscNeedPayInvoiceListBusiReqBo abilityReqBo) {
        FscNeedPayPO fscNeedPayPo = this.checkFscNeedPay(abilityReqBo);
        Map<String, List<FscNeedPayInvoicePO>> fscNeedPayInvoiceMap = this.getFscNeedPayInvoiceMap(abilityReqBo);
        ArrayList<FscNeedPayInvoicePO> addFscNeedPayInvoicePos = new ArrayList<FscNeedPayInvoicePO>();
        for (FscLianDongNeedPayInvoiceBo fscNeedPayInvoiceBo : abilityReqBo.getFscNeedPayInvoiceBos()) {
            FscNeedPayInvoicePO fscNeedPayInvoicePo = (FscNeedPayInvoicePO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscNeedPayInvoiceBo), FscNeedPayInvoicePO.class);
            if (MapUtils.isNotEmpty(fscNeedPayInvoiceMap) && fscNeedPayInvoiceMap.containsKey(fscNeedPayInvoiceBo.getInvoiceNo())) {
                FscNeedPayInvoicePO fscNeedPayInvoiceOld = fscNeedPayInvoiceMap.get(fscNeedPayInvoiceBo.getInvoiceNo()).get(0);
                FscNeedPayInvoicePO fscNeedPayInvoiceWherePo = new FscNeedPayInvoicePO();
                fscNeedPayInvoiceWherePo.setNeedPayInvoiceId(fscNeedPayInvoiceOld.getNeedPayInvoiceId());
                fscNeedPayInvoicePo.setUpdateOperId(abilityReqBo.getUserId());
                fscNeedPayInvoicePo.setNeedPayId(abilityReqBo.getNeedPayId());
                fscNeedPayInvoicePo.setUpdateTime(new Date());
                try {
                    this.fscNeedPayInvoiceMapper.updateBy(fscNeedPayInvoicePo, fscNeedPayInvoiceWherePo);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u5df2\u7ecf\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u5931\u8d25{}", (Object)e.getMessage());
                    throw new FscBusinessException("190000", "\u6dfb\u52a0\u53d1\u7968\u5931\u8d25");
                }
            }
            fscNeedPayInvoicePo.setNeedPayInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscNeedPayInvoicePo.setNeedPayId(abilityReqBo.getNeedPayId());
            fscNeedPayInvoicePo.setCreateTime(new Date());
            fscNeedPayInvoicePo.setCreateOperId(abilityReqBo.getUserId());
            fscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
            addFscNeedPayInvoicePos.add(fscNeedPayInvoicePo);
        }
        if (!CollectionUtils.isEmpty(addFscNeedPayInvoicePos)) {
            try {
                this.fscNeedPayInvoiceMapper.insertBatch(addFscNeedPayInvoicePos);
                this.updatePayNeedState(fscNeedPayPo);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u53d1\u7968\u4fe1\u606f\u5931\u8d25{}", (Object)e.getMessage());
                throw new FscBusinessException("190000", "\u6dfb\u52a0\u53d1\u7968\u5931\u8d25");
            }
        }
        this.updateNeedPayTime(fscNeedPayPo);
        FscLianDongAddFscNeedPayInvoiceListBusiRspBo busiRspBo = new FscLianDongAddFscNeedPayInvoiceListBusiRspBo();
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u6210\u529f");
        return busiRspBo;
    }

    private void updatePayNeedState(FscNeedPayPO fscNeedPayPoModel) {
        FscNeedPayPO fscNeedPayPoSet = new FscNeedPayPO();
        if (fscNeedPayPoModel.getWaitPayMoney().compareTo(BigDecimal.ZERO) < 0 || fscNeedPayPoModel.getWaitPayMoney().compareTo(fscNeedPayPoModel.getNeedPayMoney()) > 0) {
            throw new FscBusinessException("190000", "\u5e94\u4ed8\u5355\u6709\u8bef");
        }
        if (fscNeedPayPoModel.getWaitPayMoney().compareTo(BigDecimal.ZERO) > 0 && fscNeedPayPoModel.getWaitPayMoney().compareTo(fscNeedPayPoModel.getNeedPayMoney()) < 0) {
            fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PART_NEED_PAY);
        }
        if (fscNeedPayPoModel.getWaitPayMoney().compareTo(BigDecimal.ZERO) > 0 && fscNeedPayPoModel.getWaitPayMoney().compareTo(fscNeedPayPoModel.getNeedPayMoney()) == 0) {
            fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY);
        }
        if (fscNeedPayPoModel.getWaitPayMoney().compareTo(BigDecimal.ZERO) == 0) {
            fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_INVOICE);
        }
        FscNeedPayPO fscNeedPayPoWhere = new FscNeedPayPO();
        fscNeedPayPoWhere.setNeedPayId(fscNeedPayPoModel.getNeedPayId());
        int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoSet, fscNeedPayPoWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u53d1\u7968\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updateNeedPayTime(FscNeedPayPO fscNeedPayPo) {
        EXECUTORUPDATENEEDPAYTIMESERVICE.execute(() -> {
            if (StringUtils.isEmpty((Object)fscNeedPayPo.getNeedPayDate()) && FscConstants.FscNeedPayType.ORDER.equals(fscNeedPayPo.getNeedPayType())) {
                FscContractPayPO fscContractPayPo = new FscContractPayPO();
                fscContractPayPo.setPurchaseOrderId(fscNeedPayPo.getPurchaseOrderId());
                fscContractPayPo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
                List fscContractPayMapperList = this.fscContractPayMapper.getList(fscContractPayPo);
                if (CollectionUtils.isEmpty((Collection)fscContractPayMapperList)) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4ed8\u6b3e\u4fe1\u606f\u4e3a\u7a7a");
                }
                fscContractPayMapperList.forEach(fscContractPayPoModel -> {
                    if (fscContractPayPoModel.getContractPayTypeStr().contains(this.payTypeItemContract)) {
                        LocalDate today = LocalDate.now();
                        LocalDate needPayTime = today.plusDays(Long.parseLong(fscContractPayPoModel.getExtend1()));
                        Date date = Date.from(needPayTime.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        FscLianDongNeedPayUpdatePayTimeAbilityReqBo fscLianDongNeedPayUpdatePayTimeAbilityReqBo = new FscLianDongNeedPayUpdatePayTimeAbilityReqBo();
                        fscLianDongNeedPayUpdatePayTimeAbilityReqBo.setNeedPayTime(date);
                        fscLianDongNeedPayUpdatePayTimeAbilityReqBo.setNeedPayType(FscConstants.FscNeedPayType.ORDER);
                        fscLianDongNeedPayUpdatePayTimeAbilityReqBo.setPayOrderType(Integer.valueOf(fscContractPayPoModel.getExtend2()));
                        fscLianDongNeedPayUpdatePayTimeAbilityReqBo.setSaleOrderId(fscNeedPayPo.getPurchaseOrderId());
                        this.fscLianDongNeedPayUpdatePayTimeAbilityService.updatePayTime(fscLianDongNeedPayUpdatePayTimeAbilityReqBo);
                    }
                });
            }
        });
    }

    private Map<String, List<FscNeedPayInvoicePO>> getFscNeedPayInvoiceMap(FscLianDongAddFscNeedPayInvoiceListBusiReqBo abilityReqBo) {
        List invoiceNos = abilityReqBo.getFscNeedPayInvoiceBos().stream().map(FscLianDongNeedPayInvoiceBo::getInvoiceNo).collect(Collectors.toList());
        FscNeedPayInvoicePO qryFscNeedPayInvoicePo = new FscNeedPayInvoicePO();
        qryFscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        qryFscNeedPayInvoicePo.setInvoiceNos(invoiceNos);
        qryFscNeedPayInvoicePo.setNeedPayId(abilityReqBo.getNeedPayId());
        List fscNeedPayInvoicePos = this.fscNeedPayInvoiceMapper.getList(qryFscNeedPayInvoicePo);
        Map<String, List<FscNeedPayInvoicePO>> fscNeedPayInvoiceMap = new HashMap<String, List<FscNeedPayInvoicePO>>(16);
        if (!CollectionUtils.isEmpty((Collection)fscNeedPayInvoicePos)) {
            fscNeedPayInvoiceMap = fscNeedPayInvoicePos.stream().collect(Collectors.groupingBy(FscNeedPayInvoicePO::getInvoiceNo));
            log.debug("\u6dfb\u52a0\u53d1\u7968\u4fe1\u606f\u83b7\u53d6\u5230\u7684\u65e7\u6570\u636emap{}", (Object)JSONObject.toJSONString(fscNeedPayInvoiceMap));
        }
        return fscNeedPayInvoiceMap;
    }

    private FscNeedPayPO checkFscNeedPay(FscLianDongAddFscNeedPayInvoiceListBusiReqBo abilityReqBo) {
        FscNeedPayPO qryFscNeedPayPo = new FscNeedPayPO();
        qryFscNeedPayPo.setNeedPayId(abilityReqBo.getNeedPayId());
        FscNeedPayPO fscNeedPayResult = this.fscNeedPayMapper.getModelBy(qryFscNeedPayPo);
        if (fscNeedPayResult == null) {
            throw new FscBusinessException("190000", "\u6ca1\u6709\u67e5\u8be2\u5230\u8be6\u60c5\u4fe1\u606f");
        }
        return fscNeedPayResult;
    }
}

