/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckApplyAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillEcomCheckApplyAbilityService"})
public class FscBillEcomCheckApplyAbilityServiceImpl
implements FscBillEcomCheckApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckApplyAbilityServiceImpl.class);
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Resource(name="fscInvoiceEcomCheck")
    private ProxyMessageProducer fscInvoiceEcomCheckProvider;
    @Value(value="${FSC_BILL_ECOM_CHECK_TOPIC:FSC_BILL_ECOM_CHECK_TOPIC}")
    private String FSC_BILL_ECOM_CHECK_TOPIC;
    @Value(value="${FSC_BILL_ECOM_CHECK_TAG:*}")
    private String FSC_BILL_ECOM_CHECK_TAG;
    private static final Integer ISNEGATIVE = 1;
    private static final Integer ISPOSITIVE = 0;

    @BigDecimalConvert(value=2)
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealEcomCheckApply"})
    public FscBillEcomCheckApplyAbilityRspBO dealEcomCheckApply(@RequestBody FscBillEcomCheckApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscBillEcomCheckApplyBusiReqBO busiReqBO = (FscBillEcomCheckApplyBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscBillEcomCheckApplyBusiReqBO.class));
        FscBillEcomCheckApplyBusiRspBO busiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191005", busiRspBO.getRespDesc());
        }
        Map<Long, List<RelOrderBO>> collect = reqBO.getRelOrderList().stream().collect(Collectors.groupingBy(RelOrderBO::getSupplierId));
        for (Long key : collect.keySet()) {
            List<RelOrderBO> relOrderList = collect.get(key);
            log.debug("\u5bf9\u8d26\u5bf9\u8d26\u5355\u96c6\u5408{}", relOrderList);
            List positiveList = relOrderList.stream().filter(relOrderBo -> relOrderBo.getSaleAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            log.debug("\u5bf9\u8d26\u6b63\u6570\u5bf9\u8d26\u5355\u96c6\u5408{}", positiveList);
            List negativeList = relOrderList.stream().filter(relOrderBo -> relOrderBo.getSaleAmount().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
            log.debug("\u5bf9\u8d26\u8d1f\u6570\u5bf9\u8d26\u5355\u96c6\u5408{}", negativeList);
            if (!CollectionUtils.isEmpty(negativeList)) {
                reqBO.setRelOrderList(negativeList);
                reqBO.setPositiveOrNegative(ISNEGATIVE);
                this.fscInvoiceEcomCheckProvider.send(new ProxyMessage(this.FSC_BILL_ECOM_CHECK_TOPIC, this.FSC_BILL_ECOM_CHECK_TAG, JSON.toJSONString((Object)reqBO)));
            }
            if (CollectionUtils.isEmpty(positiveList)) continue;
            reqBO.setRelOrderList(positiveList);
            reqBO.setPositiveOrNegative(ISPOSITIVE);
            this.fscInvoiceEcomCheckProvider.send(new ProxyMessage(this.FSC_BILL_ECOM_CHECK_TOPIC, this.FSC_BILL_ECOM_CHECK_TAG, JSON.toJSONString((Object)reqBO)));
        }
        return new FscBillEcomCheckApplyAbilityRspBO();
    }

    private void val(FscBillEcomCheckApplyAbilityReqBO reqBO) {
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        if (reqBO.getRelOrderList().size() != 0) {
            List relOrderList = reqBO.getRelOrderList();
            for (RelOrderBO relOrderBO : relOrderList) {
                if (null == relOrderBO.getAcceptOrderId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[acceptOrderId]\u4e3a\u7a7a");
                }
                if (null == relOrderBO.getOrderId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)relOrderBO.getOtherNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[otherNo]\u4e3a\u7a7a");
                }
                if (null == relOrderBO.getMyAmount()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[myAmount]\u4e3a\u7a7a");
                }
                if (null != relOrderBO.getSupplierId()) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
            }
        }
    }
}

