/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillOrderTimingTasksConfirmedAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderTimingTasksConfirmedAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderTimingTasksConfirmedAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderTimingTasksConfirmedBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderTimingTasksConfirmedBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderTimingTasksConfirmedBusiRspBO;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderTimingTasksConfirmedAbilityService"})
public class FscBillOrderTimingTasksConfirmedAbilityServiceImpl
implements FscBillOrderTimingTasksConfirmedAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderTimingTasksConfirmedAbilityServiceImpl.class);
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Value(value="${timingTasksConfirmedDate:7}")
    private Integer TIMING_TASKS_CONFIRMED_DATE;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateCombService fscUocOrderRelUpdateCombService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillOrderTimingTasksConfirmedBusiService fscBillOrderTimingTasksConfirmedBusiService;

    @PostMapping(value={"dealTimingTasksConfirmed"})
    public FscBillOrderTimingTasksConfirmedAbilityRspBO dealTimingTasksConfirmed(@RequestBody FscBillOrderTimingTasksConfirmedAbilityReqBO reqBO) {
        FscOrderPO qryFscOrderPo = new FscOrderPO();
        qryFscOrderPo.setOrderState(FscBillStatus.TO_BE_RECONCILED.getCode());
        qryFscOrderPo.setOrderSource(FscConstants.FscOrderSource.ELECTRONIC_INT);
        qryFscOrderPo.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        qryFscOrderPo.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        qryFscOrderPo.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        Date now = this.getDate();
        qryFscOrderPo.setCreateTimeEnd(now);
        List fscOrderPOS = this.fscOrderMapper.getList(qryFscOrderPo);
        log.debug("\u5b9a\u65f6\u4efb\u52a1\u9700\u8981\u5904\u7406\u7684\u6570\u636e{}", (Object)fscOrderPOS);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            ArrayList<Long> fscOrderIds = new ArrayList<Long>(fscOrderPOS.size());
            for (FscOrderPO each : fscOrderPOS) {
                FscBillOrderTimingTasksConfirmedBusiReqBO fscBillOrderTimingTasksConfirmedBusiReqBO = (FscBillOrderTimingTasksConfirmedBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)each), FscBillOrderTimingTasksConfirmedBusiReqBO.class);
                FscBillOrderTimingTasksConfirmedBusiRspBO fscBillOrderTimingTasksConfirmedBusiRspBO = this.fscBillOrderTimingTasksConfirmedBusiService.dealTimingTasksConfirmed(fscBillOrderTimingTasksConfirmedBusiReqBO);
                if ("0000".equals(fscBillOrderTimingTasksConfirmedBusiRspBO.getRespCode())) {
                    this.sendMq(each.getFscOrderId());
                    fscOrderIds.add(each.getFscOrderId());
                    continue;
                }
                log.error("\u5b9a\u65f6\u4efb\u52a1\u6709\u95ee\u9898\u7684\u6570\u636e{}", (Object)each);
            }
        }
        FscBillOrderTimingTasksConfirmedAbilityRspBO rspBO = new FscBillOrderTimingTasksConfirmedAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscUocOrderRelUpdateCombReqBO fscUocOrderRelUpdateCombReqBO = new FscUocOrderRelUpdateCombReqBO();
        fscUocOrderRelUpdateCombReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateCombReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateCombReqBO.setUpdateOrder(Integer.valueOf(1));
        this.fscUocOrderRelUpdateCombService.dealRelUpdate(fscUocOrderRelUpdateCombReqBO);
    }

    private Date getDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -this.TIMING_TASKS_CONFIRMED_DATE.intValue());
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }
}

