/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bill.ability.api.FscLianDongAddContractRePushAbilityService;
import com.tydic.fsc.bill.ability.bo.FscCostAddContractOutBO;
import com.tydic.fsc.bill.ability.bo.FscLianDongAddContractRePushAbilityReqBO;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractPO;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscContractSkuPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongAddContractRePushAbilityService"})
public class FscLianDongAddContractRePushAbilityServiceImpl
implements FscLianDongAddContractRePushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongAddContractRePushAbilityServiceImpl.class);
    @Value(value="${COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL:http://apim-gateway.test.liando.cn/env-201/por-201/testcost/uValley/receiveUValleyPurchaseOrders}")
    private String COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscContractMapper fscContractMapper;

    @PostMapping(value={"addContractRePush"})
    public FscRspBaseBO addContractRePush(@RequestBody FscLianDongAddContractRePushAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getPurchaseOrderId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscContractPO po = this.fscContractMapper.getJoin(reqBO.getPurchaseOrderId());
        if (ObjectUtil.isEmpty((Object)po)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f");
        }
        this.pushCostHttp(po);
        FscRspBaseBO rspBaseBO = new FscRspBaseBO();
        rspBaseBO.setRespCode("0000");
        return rspBaseBO;
    }

    private void pushCostHttp(FscContractPO item) {
        FscCostAddContractOutBO contractOutBO = new FscCostAddContractOutBO();
        FscCostAddContractOutBO.FscCostAddContractOutInnerBO fscCostAddContractOutBO = new FscCostAddContractOutBO.FscCostAddContractOutInnerBO();
        fscCostAddContractOutBO.setPurchaseOrderId(item.getPurchaseOrderId().toString());
        fscCostAddContractOutBO.setF_FRGSID(item.getCtrctFrgsCode());
        fscCostAddContractOutBO.setErp_Pk_Corp(item.getCtrctFrgsCode());
        fscCostAddContractOutBO.setF_KSDAMC(item.getCtrctKsdaCode());
        fscCostAddContractOutBO.setOriginatorType(item.getCtrctType());
        if (!CollectionUtils.isEmpty((Collection)item.getContractSkuPOList())) {
            ArrayList<FscCostAddContractOutBO.FscCostGoodsDetailBO> detailBOS = new ArrayList<FscCostAddContractOutBO.FscCostGoodsDetailBO>();
            for (FscContractSkuPO skuBO : item.getContractSkuPOList()) {
                FscCostAddContractOutBO.FscCostGoodsDetailBO goodsDetailBO = new FscCostAddContractOutBO.FscCostGoodsDetailBO();
                goodsDetailBO.setGoodsName(skuBO.getSkuName());
                goodsDetailBO.setGoodsNo(skuBO.getSkuCode());
                goodsDetailBO.setGoodsNumber(skuBO.getNum().stripTrailingZeros().toString());
                goodsDetailBO.setGoodsPrice(skuBO.getSkuPrice().stripTrailingZeros().toString());
                goodsDetailBO.setGoodsSKU(skuBO.getSkuNo());
                goodsDetailBO.setGoodsUnit(skuBO.getUnit());
                goodsDetailBO.setGoodsSpecification(skuBO.getExtend3());
                goodsDetailBO.setGoodsDeliveryAddress(skuBO.getExtend2());
                goodsDetailBO.setGoodsDeliveryTime(skuBO.getExtend1());
                goodsDetailBO.setTotalAmt(skuBO.getAmount().stripTrailingZeros().toString());
                detailBOS.add(goodsDetailBO);
            }
            fscCostAddContractOutBO.setGoodsDetails(detailBOS);
        }
        if (!CollectionUtils.isEmpty((Collection)item.getContractPayPOList())) {
            ArrayList<FscCostAddContractOutBO.FscCostPaymentTermDetailBO> termDetailBOS = new ArrayList<FscCostAddContractOutBO.FscCostPaymentTermDetailBO>();
            for (FscContractPayPO payBO : item.getContractPayPOList()) {
                FscCostAddContractOutBO.FscCostPaymentTermDetailBO paymentTermDetailBO = new FscCostAddContractOutBO.FscCostPaymentTermDetailBO();
                paymentTermDetailBO.setPaymentAmt(payBO.getContractPayAmount().stripTrailingZeros().toString());
                paymentTermDetailBO.setPaymentDate(payBO.getContractPayTime());
                paymentTermDetailBO.setPaymentNode(payBO.getContractPayTypeStr());
                paymentTermDetailBO.setPaymentTermId(payBO.getContractPayId().toString());
                paymentTermDetailBO.setTermPercent(payBO.getContractPayProportion().stripTrailingZeros().toString());
                paymentTermDetailBO.setTermType(payBO.getContractPayType());
                termDetailBOS.add(paymentTermDetailBO);
            }
            fscCostAddContractOutBO.setPaymentTermDetails(termDetailBOS);
        }
        contractOutBO.setBusiness_data(Collections.singletonList(fscCostAddContractOutBO));
        String body = JSON.toJSONString((Object)contractOutBO);
        Long logId = this.logAdd(body, fscCostAddContractOutBO.getPurchaseOrderId());
        try {
            HashMap map = new HashMap();
            String formData = "business_data=" + JSON.toJSONString((Object)contractOutBO.getBusiness_data());
            formData = formData.replace("%", "%25");
            log.debug("-\u91cd\u65b0\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3URL-{}", (Object)this.COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL);
            log.debug("-\u91cd\u65b0\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3BODY-{}", (Object)formData);
            HttpRequest request = ((HttpRequest)HttpRequest.post((String)this.COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL).header("Content-Type", "application/x-www-form-urlencoded")).body(formData);
            String result = request.execute().body();
            log.debug("-\u91cd\u65b0\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                this.logUpdate(logId, result, FscConstants.CostIsError.NO);
                throw new FscBusinessException("190000", "\u91cd\u65b0\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3\u5931\u8d25-" + result);
            }
            this.logUpdate(logId, result, FscConstants.CostIsError.YES);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logUpdate(logId, e.getMessage(), FscConstants.CostIsError.NO);
            throw new FscBusinessException("190000", "\u91cd\u65b0\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3\u5f02\u5e38-" + e.getMessage());
        }
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.NO, FscConstants.CostObjType.PURCHASE_ORDER_RECEIPT, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }
}

