/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscLianDongContCtrctDeleteAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongContCtrctDeleteAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscLianDongContCtrctDeleteAbilityRspBo;
import com.tydic.fsc.bill.busi.api.FscLianDongContCtrctDeleteBusiService;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongContCtrctDeleteAbilityService"})
public class FscLianDongContCtrctDeleteAbilityServiceImpl
implements FscLianDongContCtrctDeleteAbilityService {
    @Autowired
    private FscLianDongContCtrctDeleteBusiService fscLianDongContCtrctDeleteBusiService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;

    @PostMapping(value={"contCtrctDelete"})
    public FscLianDongContCtrctDeleteAbilityRspBo contCtrctDelete(@RequestBody FscLianDongContCtrctDeleteAbilityReqBO reqBO) {
        Long logId = this.logAdd(JSON.toJSONString((Object)reqBO), reqBO.getPurchaseOrderId());
        String validate = this.validate(reqBO);
        if (!StringUtils.isEmpty((CharSequence)validate)) {
            this.logUpdate(logId, validate, FscConstants.CostIsError.NO);
            throw new FscBusinessException("8888", validate);
        }
        try {
            FscLianDongContCtrctDeleteAbilityRspBo rspBO = this.fscLianDongContCtrctDeleteBusiService.dealContCtrctDelete(reqBO);
            this.logUpdate(logId, JSON.toJSONString((Object)rspBO), FscConstants.CostIsError.YES);
            return rspBO;
        }
        catch (Exception e) {
            this.logUpdate(logId, e.getMessage(), FscConstants.CostIsError.NO);
            throw new FscBusinessException("8888", e.getMessage());
        }
    }

    private String validate(FscLianDongContCtrctDeleteAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseOrderId())) {
            return "\u5165\u53c2\u3010purchaseOrderId\u3011\u4e3a\u7a7a";
        }
        return null;
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.NO, FscConstants.CostObjType.CONTRACT_DELETION_CALLBACK, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }
}

