/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderContractExtUrlService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderContractBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderContractExtUrlReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderContractExtUrlRspBO;
import com.tydic.fsc.bill.ability.api.FscLianDongContCtrctExaPassAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongContCtrctExaPassAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscLianDongContCtrctExaPassAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscLianDongContCtrctExaPassBusiService;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongContCtrctExaPassAbilityService"})
public class FscLianDongContCtrctExaPassAbilityServiceImpl
implements FscLianDongContCtrctExaPassAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongContCtrctExaPassAbilityServiceImpl.class);
    @Autowired
    private FscLianDongContCtrctExaPassBusiService fscLianDongContCtrctExaPassBusiService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private UocUpdateSaleOrderContractExtUrlService uocUpdateSaleOrderContractExtUrlService;

    @PostMapping(value={"contCtrctExaPassCallBack"})
    public FscLianDongContCtrctExaPassAbilityRspBO contCtrctExaPassCallBack(@RequestBody FscLianDongContCtrctExaPassAbilityReqBO reqBO) {
        Long logId = this.logAdd(JSON.toJSONString((Object)reqBO), reqBO.getPurchaseOrderId());
        String validate = this.validate(reqBO);
        if (!StringUtils.isEmpty((CharSequence)validate)) {
            this.logUpdate(logId, validate, FscConstants.CostIsError.NO);
            throw new FscBusinessException("8888", validate);
        }
        return this.fscLianDongContCtrctExaPassBusiService.dealContCtrctExaPass(reqBO);
    }

    private void syncUoc(FscLianDongContCtrctExaPassAbilityReqBO reqBO) {
        UocUpdateSaleOrderContractExtUrlReqBO extUrlReqBO = new UocUpdateSaleOrderContractExtUrlReqBO();
        ArrayList contractBoList = new ArrayList();
        UocSaleOrderContractBo orderContractBo = new UocSaleOrderContractBo();
        orderContractBo.setSaleOrderId(Long.valueOf(reqBO.getPurchaseOrderId()));
        orderContractBo.setContractUrl(reqBO.getCtrctPdfUrl());
        extUrlReqBO.setContractBoList(contractBoList);
        log.debug("-\u66f4\u65b0\u8ba2\u5355\u5408\u540curl\u5165\u53c2-{}", (Object)JSON.toJSONString((Object)extUrlReqBO));
        UocUpdateSaleOrderContractExtUrlRspBO extUrlRspBO = this.uocUpdateSaleOrderContractExtUrlService.updateSaleOrderContractExtUrl(extUrlReqBO);
        log.debug("-\u66f4\u65b0\u8ba2\u5355\u5408\u540curl\u51fa\u53c2-{}", (Object)JSON.toJSONString((Object)extUrlRspBO));
        if (!"0000".equals(extUrlRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u66f4\u65b0\u8ba2\u5355url\u5931\u8d25\uff0c\u62a5\u9519\u4fe1\u606f:" + extUrlRspBO.getRespDesc());
        }
    }

    private String validate(FscLianDongContCtrctExaPassAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctCode())) {
            return "\u5165\u53c2\u3010ctrctCode\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseOrderId())) {
            return "\u5165\u53c2\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctName())) {
            return "\u5165\u53c2\u3010ctrctName\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctFrgsCode())) {
            return "\u5165\u53c2\u3010ctrctFrgsCode\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctKsdaCode())) {
            return "\u5165\u53c2\u3010ctrctKsdaCode\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctFrgsName())) {
            return "\u5165\u53c2\u3010ctrctFrgsName\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCtrctKsdaName())) {
            return "\u5165\u53c2\u3010ctrctKsdaName\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCtrctCreateTime())) {
            return "\u5165\u53c2\u3010ctrctCreateTime\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCtrctEndTime())) {
            return "\u5165\u53c2\u3010ctrctEndTime\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCtrctStartTime())) {
            return "\u5165\u53c2\u3010ctrctStartTime\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.NO, FscConstants.CostObjType.CALLBACK_OF_CONTRACT_APPROVAL_RESULTS, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }
}

