/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscLianDongQryExtSystemsInvoiceListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscLianDongExtSystemsInvoiceInfoBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongQryExtSystemsInvoiceListAbilityReqBo;
import com.tydic.fsc.bill.ability.bo.FscLianDongQryExtSystemsInvoiceListAbilityRspBo;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.exception.FscBusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscLianDongQryExtSystemsInvoiceListAbilityService"})
public class FscLianDongQryExtSystemsInvoiceListAbilityServiceImpl
implements FscLianDongQryExtSystemsInvoiceListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongQryExtSystemsInvoiceListAbilityServiceImpl.class);
    public static final String CODE = "0";
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Value(value="${QRY_EXT_SYSTEMS_INVOICE_LIST_URL:http://10.0.11.60:8001/OSN/api/queryFpInfo/v1}")
    private String uri;

    @PostMapping(value={"qryExtSystemsInvoiceList"})
    public FscLianDongQryExtSystemsInvoiceListAbilityRspBo qryExtSystemsInvoiceList(@RequestBody FscLianDongQryExtSystemsInvoiceListAbilityReqBo abilityReqBo) {
        this.validate(abilityReqBo);
        String jsonParam = JSON.toJSONString((Object)abilityReqBo);
        log.debug("\u5e94\u4ed8\u53f0\u8d26\u5904-\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u63a5\u53e3URL\uff1a{}", (Object)this.uri);
        log.debug("\u5e94\u4ed8\u53f0\u8d26\u5904-\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u63a5\u53e3\u5165\u53c2:{}", (Object)jsonParam);
        String result = HttpUtil.post((String)this.uri, (String)jsonParam);
        log.debug("\u5e94\u4ed8\u53f0\u8d26\u5904-\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)result);
        FscLianDongQryExtSystemsInvoiceListAbilityRspBo rspBo = (FscLianDongQryExtSystemsInvoiceListAbilityRspBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FscLianDongQryExtSystemsInvoiceListAbilityRspBo.class);
        if (!CODE.equals(rspBo.getF_CODE())) {
            log.error("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5931\u8d25:{}", (Object)rspBo.getF_MESSAGE());
            throw new FscBusinessException("190000", "\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
        this.dealExtSystemsInvoice(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealExtSystemsInvoice(FscLianDongQryExtSystemsInvoiceListAbilityRspBo rspBo) {
        Map itemType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_NEED_PAY_INVOICE_TYPE");
        if (!CollectionUtils.isEmpty((Collection)rspBo.getF_BODY())) {
            for (FscLianDongExtSystemsInvoiceInfoBo each : rspBo.getF_BODY()) {
                if (StringUtils.isNotBlank((CharSequence)each.getF_FPLX())) {
                    each.setF_FPLX_STR((String)itemType.get(each.getF_FPLX()));
                }
                if (!StringUtils.isNotBlank((CharSequence)each.getF_FPRQ())) continue;
                SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date date = inputFormat.parse(each.getF_FPRQ());
                    String outputDate = outputFormat.format(date);
                    each.setF_FPRQ(outputDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void validate(FscLianDongQryExtSystemsInvoiceListAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getF_LRR())) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u5bf9\u8c61[\u5f55\u5165\u4eba]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

