/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.service.enterprise.UmcGetEnterpriseBankListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseBankBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcGetEnterpriseBankListReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcGetEnterpriseBankListRspBo;
import com.tydic.fsc.bill.ability.bo.FscContractAddBO;
import com.tydic.fsc.bill.ability.bo.FscContractAddPayBO;
import com.tydic.fsc.bill.ability.bo.FscContractAddSkuBO;
import com.tydic.fsc.bill.ability.bo.FscContractBankBO;
import com.tydic.fsc.bill.ability.bo.FscCostAddContractOutBO;
import com.tydic.fsc.bill.busi.api.FscLianDongAddContractBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddContractBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscLianDongAddContractBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractBankMapper;
import com.tydic.fsc.dao.FscContractMapper;
import com.tydic.fsc.dao.FscContractPayMapper;
import com.tydic.fsc.dao.FscContractSkuMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractBankPO;
import com.tydic.fsc.po.FscContractPO;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscContractSkuPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscLianDongAddContractBusiServiceImpl
implements FscLianDongAddContractBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongAddContractBusiServiceImpl.class);
    @Value(value="${COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL:http://apim-gateway.test.liando.cn/env-201/por-201/testcost/uValley/receiveUValleyPurchaseOrders}")
    private String COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL;
    @Value(value="${COST_PAY_A_ADDRESS:\u5317\u4eac\u5e02\u901a\u5dde\u533a\u9a6c\u9a79\u6865\u9547\u4e5d\u5468\u8def\u4e3429\u53f7-19}")
    private String COST_PAY_A_ADDRESS;
    @Value(value="${COST_PAY_A_OPEN_BANK:\u62db\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5317\u4eac\u81ea\u8d38\u8bd5\u9a8c\u533a\u7965\u4e91\u5c0f\u9547\u652f\u884c}")
    private String COST_PAY_A_OPEN_BANK;
    @Value(value="${COST_PAY_A_BUNK_ACCOUNT:110949926110601}")
    private String COST_PAY_A_BUNK_ACCOUNT;
    @Value(value="${COST_PAY_A_TAX_NO:91110113MABNBT3N4K}")
    private String COST_PAY_A_TAX_NO;
    @Value(value="${COST_A_NC_CODE:2060}")
    private String COST_A_NC_CODE;
    @Value(value="${COST_A_NAME:\u5317\u4eac\u94fe\u4e0a\u4f18\u8c37\u79d1\u6280\u6709\u9650\u516c\u53f8}")
    private String COST_A_NAME;
    @Value(value="${COST_A_ID:305775845729763336}")
    private String COST_A_ID;
    @Autowired
    private UmcGetEnterpriseBankListService umcGetEnterpriseBankListService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscContractMapper fscContractMapper;
    @Autowired
    private FscContractPayMapper fscContractPayMapper;
    @Autowired
    private FscContractSkuMapper fscContractSkuMapper;
    @Autowired
    private FscContractBankMapper fscContractBankMapper;
    private final Sequence sequence = Sequence.getInstance();
    @Value(value="${isSend:true}")
    private boolean isSend;

    @Override
    public FscLianDongAddContractBusiRspBO dealContractAdd(FscLianDongAddContractBusiReqBO reqBO) {
        String failMsg;
        boolean result;
        ArrayList<FscContractPO> contractPOS = new ArrayList<FscContractPO>();
        ArrayList<FscContractPayPO> contractPayPOS = new ArrayList<FscContractPayPO>();
        ArrayList<FscContractSkuPO> contractSkuPOS = new ArrayList<FscContractSkuPO>();
        ArrayList<FscContractBankPO> bankPOS = new ArrayList<FscContractBankPO>();
        this.componentData(reqBO, contractPOS, contractPayPOS, contractSkuPOS, bankPOS);
        this.dealAdd(contractPOS, contractPayPOS, contractSkuPOS, bankPOS);
        if (this.isSend && !(result = this.pushCostHttp(reqBO, failMsg = ""))) {
            throw new FscBusinessException("190000", "\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6d88\u606f\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u63a8\u9001\u65e5\u5fd7");
        }
        FscLianDongAddContractBusiRspBO busiRspBO = new FscLianDongAddContractBusiRspBO();
        busiRspBO.setRespCode("0000");
        return busiRspBO;
    }

    private void dealAdd(List<FscContractPO> fscContractPOS, List<FscContractPayPO> fscContractPayPOS, List<FscContractSkuPO> fscContractSkuPOS, List<FscContractBankPO> bankPOS) {
        try {
            this.fscContractMapper.insertBatch(fscContractPOS);
            this.fscContractPayMapper.insertBatch(fscContractPayPOS);
            this.fscContractSkuMapper.insertBatch(fscContractSkuPOS);
            this.fscContractBankMapper.insertBatch(bankPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("190000", "\u65b0\u589e\u5408\u540c\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }

    private void componentData(FscLianDongAddContractBusiReqBO reqBO, List<FscContractPO> fscContractPOS, List<FscContractPayPO> fscContractPayPOS, List<FscContractSkuPO> fscContractSkuPOS, List<FscContractBankPO> bankPos) {
        Date time = new Date();
        for (FscContractAddBO fscContractAddBO : reqBO.getFscContractBOList()) {
            FscContractPO contractPO = new FscContractPO();
            BeanUtils.copyProperties((Object)fscContractAddBO, (Object)contractPO);
            contractPO.setCtrctFrgsCode(this.COST_A_NC_CODE);
            contractPO.setCreateOperId(reqBO.getUserId());
            contractPO.setCreateTime(time);
            contractPO.setIsDel(FscConstants.FscContractDelStatus.EFFECTIVE);
            contractPO.setId(Long.valueOf(this.sequence.nextId()));
            contractPO.setCtrctFrgsName(this.COST_A_NAME);
            contractPO.setCtrctFrgsId(this.COST_A_ID);
            contractPO.setExtend4(fscContractAddBO.getSubmitId());
            contractPO.setCtrctPdfUrl(fscContractAddBO.getCtrctPdfUrl());
            contractPO.setCtrctName(fscContractAddBO.getCtrctName());
            fscContractAddBO.setCtrctFrgsId(this.COST_A_ID);
            fscContractAddBO.setCtrctFrgsCode(this.COST_A_NC_CODE);
            fscContractAddBO.setCtrctFrgsName(this.COST_A_NAME);
            fscContractAddBO.setCtrctName(contractPO.getCtrctName());
            fscContractPOS.add(contractPO);
            FscContractBankPO bankPO = new FscContractBankPO();
            bankPO.setPurchaseOrderId(fscContractAddBO.getPurchaseOrderId());
            bankPO.setFscContractBankId(Long.valueOf(this.sequence.nextId()));
            bankPO.setAAdress(this.COST_PAY_A_ADDRESS);
            bankPO.setABunkAccount(this.COST_PAY_A_BUNK_ACCOUNT);
            bankPO.setAPenBank(this.COST_PAY_A_OPEN_BANK);
            bankPO.setATaxNo(this.COST_PAY_A_TAX_NO);
            if (ObjectUtil.isEmpty((Object)fscContractAddBO.getBBunkAccount())) {
                this.getSupplierInfo(fscContractAddBO.getCtrctKsdaId(), bankPO);
            } else {
                bankPO.setBAdress(fscContractAddBO.getBAdress());
                bankPO.setBBunkAccount(fscContractAddBO.getBBunkAccount());
                bankPO.setBOpenBank(fscContractAddBO.getBOpenBank());
                bankPO.setBTaxNo(fscContractAddBO.getBTaxNo());
            }
            bankPO.setCreateOperId(reqBO.getUserId().toString());
            bankPO.setCreateOperName(reqBO.getName());
            bankPO.setCreateTime(time);
            bankPos.add(bankPO);
            fscContractAddBO.setBankBO((FscContractBankBO)JSONObject.parseObject((String)JSON.toJSONString((Object)bankPO), FscContractBankBO.class));
            if (!CollectionUtils.isEmpty((Collection)fscContractAddBO.getContractAddPayBOList())) {
                for (FscContractAddPayBO addPayBO : fscContractAddBO.getContractAddPayBOList()) {
                    FscContractPayPO fscContractPayPO = new FscContractPayPO();
                    BeanUtils.copyProperties((Object)addPayBO, (Object)fscContractPayPO);
                    fscContractPayPO.setContractPayId(Long.valueOf(this.sequence.nextId()));
                    addPayBO.setContractPayId(fscContractPayPO.getContractPayId());
                    fscContractPayPO.setCreateOperId(reqBO.getUserId());
                    fscContractPayPO.setCreateTime(time);
                    fscContractPayPO.setIsDel(FscConstants.FscContractDelStatus.EFFECTIVE);
                    fscContractPayPO.setPurchaseOrderId(fscContractAddBO.getPurchaseOrderId());
                    fscContractPayPO.setCtrctCode(fscContractAddBO.getCtrctCode());
                    fscContractPayPO.setExtend1(addPayBO.getPayDay());
                    fscContractPayPO.setExtend2(addPayBO.getPayOrderType().toString());
                    fscContractPayPOS.add(fscContractPayPO);
                }
            }
            if (CollectionUtils.isEmpty((Collection)fscContractAddBO.getContractAddSkuBOList())) continue;
            for (FscContractAddSkuBO skuBO : fscContractAddBO.getContractAddSkuBOList()) {
                FscContractSkuPO fscContractSkuPO = new FscContractSkuPO();
                BeanUtils.copyProperties((Object)skuBO, (Object)fscContractSkuPO);
                fscContractSkuPO.setContractSkuId(Long.valueOf(this.sequence.nextId()));
                fscContractSkuPO.setPurchaseOrderId(fscContractAddBO.getPurchaseOrderId());
                fscContractSkuPO.setCtrctCode(fscContractAddBO.getCtrctCode());
                fscContractSkuPO.setIsDel(FscConstants.FscContractDelStatus.EFFECTIVE);
                fscContractSkuPO.setExtend1(skuBO.getDelivery());
                fscContractSkuPO.setExtend2(skuBO.getDeliverAddress());
                fscContractSkuPO.setExtend3(skuBO.getSpec());
                fscContractSkuPO.setBrand(skuBO.getBrand());
                fscContractSkuPO.setTrueSalePrice(skuBO.getTrueSalePrice());
                fscContractSkuPO.setGrossProfit(skuBO.getGrossProfit());
                fscContractSkuPOS.add(fscContractSkuPO);
            }
        }
    }

    private void getSupplierInfo(String ctrctFrgsId, FscContractBankPO bankPO) {
        UmcGetEnterpriseBankListReqBo bankListReqBo = new UmcGetEnterpriseBankListReqBo();
        bankListReqBo.setOrgId(Long.valueOf(Long.parseLong(ctrctFrgsId)));
        log.debug("-\u4f1a\u5458\u4e59\u65b9\u94f6\u884c\u4fe1\u606f\u67e5\u8be2\u5165\u53c2-{}", (Object)JSON.toJSONString((Object)bankListReqBo));
        UmcGetEnterpriseBankListRspBo enterpriseBankListRspBo = this.umcGetEnterpriseBankListService.getEnterpriseBankList(bankListReqBo);
        log.debug("-\u4f1a\u5458\u4e59\u65b9\u94f6\u884c\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2-{}", (Object)JSON.toJSONString((Object)enterpriseBankListRspBo));
        if (!"0000".equals(enterpriseBankListRspBo.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u4e59\u65b9\u4fe1\u606f\u5931\u8d25" + enterpriseBankListRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)enterpriseBankListRspBo.getEnterpriseBankBoList())) {
            throw new FscBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4e59\u65b9\u94f6\u884c\u7b49\u4fe1\u606f");
        }
        UmcEnterpriseBankBo umcEnterpriseBankBo = (UmcEnterpriseBankBo)enterpriseBankListRspBo.getEnterpriseBankBoList().get(0);
        if (ObjectUtils.isEmpty((Object)umcEnterpriseBankBo.getBankAddr()) || ObjectUtil.isEmpty((Object)umcEnterpriseBankBo.getBankAccount()) || ObjectUtil.isEmpty((Object)umcEnterpriseBankBo.getBankName()) || ObjectUtil.isEmpty((Object)enterpriseBankListRspBo.getCreditNo())) {
            throw new FscBusinessException("8888", "\u4f1a\u5458\u8fd4\u56de \u94f6\u884c\u4fe1\u606f\u4e0d\u5b8c\u6574 ");
        }
        bankPO.setBAdress(umcEnterpriseBankBo.getBankAddr());
        bankPO.setBBunkAccount(umcEnterpriseBankBo.getBankAccount());
        bankPO.setBOpenBank(umcEnterpriseBankBo.getBankName());
        bankPO.setBTaxNo(enterpriseBankListRspBo.getCreditNo());
    }

    private boolean pushCostHttp(FscLianDongAddContractBusiReqBO reqBO, String failMsg) {
        boolean success = true;
        for (FscContractAddBO item : reqBO.getFscContractBOList()) {
            FscCostAddContractOutBO contractOutBO = new FscCostAddContractOutBO();
            FscCostAddContractOutBO.FscCostAddContractOutInnerBO fscCostAddContractOutBO = new FscCostAddContractOutBO.FscCostAddContractOutInnerBO();
            fscCostAddContractOutBO.setPurchaseOrderId(item.getPurchaseOrderId().toString());
            fscCostAddContractOutBO.setF_FRGSID(item.getCtrctFrgsCode());
            fscCostAddContractOutBO.setErp_Pk_Corp(item.getCtrctFrgsCode());
            fscCostAddContractOutBO.setF_KSDAMC(item.getCtrctKsdaName());
            fscCostAddContractOutBO.setOriginatorType(item.getCtrctType());
            fscCostAddContractOutBO.setAAddress(this.COST_PAY_A_ADDRESS);
            fscCostAddContractOutBO.setABunkAccount(this.COST_PAY_A_BUNK_ACCOUNT);
            fscCostAddContractOutBO.setAOpenBank(this.COST_PAY_A_OPEN_BANK);
            fscCostAddContractOutBO.setATaxNo(this.COST_PAY_A_TAX_NO);
            fscCostAddContractOutBO.setContractName(item.getCtrctName());
            fscCostAddContractOutBO.setInChargeIdmId(item.getSubmitId());
            fscCostAddContractOutBO.setBAddress(item.getBankBO().getBAdress());
            fscCostAddContractOutBO.setBBunkAccount(item.getBankBO().getBBunkAccount());
            fscCostAddContractOutBO.setBOpenBank(item.getBankBO().getBOpenBank());
            fscCostAddContractOutBO.setBTaxNo(item.getBankBO().getBTaxNo());
            fscCostAddContractOutBO.setUValleyFileUrl(item.getCtrctPdfUrl());
            fscCostAddContractOutBO.setUValleyFileName(item.getCtrctName() + ".pdf");
            if (!CollectionUtils.isEmpty((Collection)item.getContractAddSkuBOList())) {
                ArrayList<FscCostAddContractOutBO.FscCostGoodsDetailBO> detailBOS = new ArrayList<FscCostAddContractOutBO.FscCostGoodsDetailBO>();
                for (FscContractAddSkuBO skuBO : item.getContractAddSkuBOList()) {
                    FscCostAddContractOutBO.FscCostGoodsDetailBO goodsDetailBO = new FscCostAddContractOutBO.FscCostGoodsDetailBO();
                    goodsDetailBO.setGoodsName(skuBO.getSkuName());
                    goodsDetailBO.setGoodsNo(skuBO.getSkuCode());
                    goodsDetailBO.setGoodsNumber(skuBO.getNum().stripTrailingZeros().toPlainString());
                    goodsDetailBO.setGoodsPrice(skuBO.getSkuPrice().stripTrailingZeros().toPlainString());
                    goodsDetailBO.setGoodsSKU(skuBO.getSkuNo());
                    goodsDetailBO.setGoodsUnit(skuBO.getUnit());
                    goodsDetailBO.setGoodsDeliveryAddress(skuBO.getDeliverAddress());
                    goodsDetailBO.setGoodsDeliveryTime(skuBO.getDelivery());
                    goodsDetailBO.setGoodsSpecification(skuBO.getSpec());
                    goodsDetailBO.setTotalAmt(skuBO.getAmount().stripTrailingZeros().toPlainString());
                    if (skuBO.getTrueSalePrice() == null) {
                        goodsDetailBO.setGoodsActualPrice("0.00");
                    } else {
                        goodsDetailBO.setGoodsActualPrice(skuBO.getTrueSalePrice().stripTrailingZeros().toPlainString());
                    }
                    if (StringUtils.isEmpty((Object)skuBO.getGrossProfit())) {
                        goodsDetailBO.setGoodsProfit("0.00");
                    } else {
                        goodsDetailBO.setGoodsProfit(skuBO.getGrossProfit());
                    }
                    goodsDetailBO.setGoodsBrand(skuBO.getBrand());
                    detailBOS.add(goodsDetailBO);
                }
                fscCostAddContractOutBO.setGoodsDetails(detailBOS);
            }
            if (!CollectionUtils.isEmpty((Collection)item.getContractAddPayBOList())) {
                ArrayList<FscCostAddContractOutBO.FscCostPaymentTermDetailBO> termDetailBOS = new ArrayList<FscCostAddContractOutBO.FscCostPaymentTermDetailBO>();
                for (FscContractAddPayBO payBO : item.getContractAddPayBOList()) {
                    FscCostAddContractOutBO.FscCostPaymentTermDetailBO paymentTermDetailBO = new FscCostAddContractOutBO.FscCostPaymentTermDetailBO();
                    paymentTermDetailBO.setPaymentAmt(payBO.getContractPayPlanAmount().stripTrailingZeros().toPlainString());
                    paymentTermDetailBO.setPaymentDate(payBO.getContractPayPlanTime());
                    paymentTermDetailBO.setPaymentNode(payBO.getContractPayTypeStr());
                    paymentTermDetailBO.setPaymentTermId(payBO.getContractPayId().toString());
                    paymentTermDetailBO.setTermPercent(payBO.getContractPayProportion().stripTrailingZeros().toPlainString());
                    paymentTermDetailBO.setTermType(payBO.getContractPayType());
                    termDetailBOS.add(paymentTermDetailBO);
                }
                fscCostAddContractOutBO.setPaymentTermDetails(termDetailBOS);
            }
            contractOutBO.setBusiness_data(Collections.singletonList(fscCostAddContractOutBO));
            String body = "business_data=" + JSON.toJSONString((Object)contractOutBO.getBusiness_data());
            body = body.replace("%", "%25");
            body = body.replace(" ", "%20");
            Long logId = this.logAdd(body, fscCostAddContractOutBO.getPurchaseOrderId());
            try {
                log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3URL-{}", (Object)this.COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL);
                log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3BODY-{}", (Object)body);
                HttpRequest request = ((HttpRequest)HttpRequest.post((String)this.COST_RECEIVE_U_VALLEY_PURCHASE_ORDERS_URL).header("Content-Type", "application/x-www-form-urlencoded")).body(body);
                String result = request.execute().body();
                log.debug("-\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3\u51fa\u53c2-{}", (Object)result);
                JSONObject resultObj = JSONObject.parseObject((String)result);
                if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                    this.logUpdate(logId, result, FscConstants.CostIsError.NO);
                    failMsg = result;
                    success = false;
                    continue;
                }
                this.logUpdate(logId, result, FscConstants.CostIsError.YES);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logUpdate(logId, e.getMessage(), FscConstants.CostIsError.NO);
                log.error("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u91c7\u8d2d\u8ba2\u5355\u63a5\u6536\u63a5\u53e3\u5f02\u5e38{}", (Object)e.getMessage());
                success = false;
            }
        }
        if (failMsg.contains("\u5408\u540c\u4e59\u65b9\u4e0d\u5b58\u5728")) {
            throw new FscBusinessException("191046", "\u5f53\u524d\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u6210\u672c\u7cfb\u7edf\u7ef4\u62a4\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        return success;
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.NO, FscConstants.CostObjType.PURCHASE_ORDER_RECEIPT, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr, Integer isError) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, isError);
    }
}

