/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.umc.service.ldOrganization.UmcQryLdOrgInfoDetailService;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailRspBO;
import com.tydic.fsc.bill.busi.api.FscLianDongDealProjectMasterDataBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealProjectMasterDataBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealProjectMasterDataBusiRspBo;
import com.tydic.fsc.bill.busi.bo.LianDongFscReceiptQueryReqBo;
import com.tydic.fsc.bill.busi.bo.LianDongFscReceiptQueryRspBo;
import com.tydic.fsc.bill.busi.bo.ThirdQueryPaymentVo;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscReceivableInfoMapper;
import com.tydic.fsc.dao.FscReceivablePayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscReceivableInfoPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongDealProjectMasterDataBusiServiceImpl
implements FscLianDongDealProjectMasterDataBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongDealProjectMasterDataBusiServiceImpl.class);
    @Autowired
    private FscReceivableInfoMapper fscReceivableInfoMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscReceivablePayMapper fscReceivablePayMapper;
    @Autowired
    private UmcQryLdOrgInfoDetailService umcQryLdOrgInfoDetailService;
    @Value(value="${receivableOrgIdWeb:1106732607002918912}")
    private Long receivableOrgIdWeb;
    @Value(value="${RECEIPT_QUERY:http://test1-lsugu.liando.cn}")
    private String RECEIPT_QUERY;

    @Override
    public FscLianDongDealProjectMasterDataBusiRspBo dealProjectMasterData(FscLianDongDealProjectMasterDataBusiReqBo busiReqBo) {
        List<FscReceivableInfoPO> fscReceivableInfoMapperList = this.getFscReceivableInfoPoList();
        if (CollectionUtils.isEmpty(fscReceivableInfoMapperList)) {
            return new FscLianDongDealProjectMasterDataBusiRspBo();
        }
        List<String> receiveId = fscReceivableInfoMapperList.stream().map(FscReceivableInfoPO::getFscReceivableId).map(Object::toString).collect(Collectors.toList());
        Map<Long, FscReceivableInfoPO> fscReceivableInfoPoMap = fscReceivableInfoMapperList.stream().collect(Collectors.toMap(FscReceivableInfoPO::getFscReceivableId, o -> o));
        UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo = this.getUmcQryLdOrgInfoDetailRspBo();
        List<ThirdQueryPaymentVo> thirdQueryPaymentVoList = this.getReceipt(umcQryLdOrgInfoDetailRspBo, receiveId);
        thirdQueryPaymentVoList.forEach(thirdQueryPaymentVo -> {
            if (fscReceivableInfoPoMap.get(Long.valueOf(thirdQueryPaymentVo.getChargeDetailId())) != null) {
                log.debug("\u5b9e\u4ed8\u4fee\u6539");
            } else {
                log.debug("\u5b9e\u4ed8\u65b0\u589e");
            }
        });
        return null;
    }

    private List<FscReceivableInfoPO> getFscReceivableInfoPoList() {
        FscReceivableInfoPO fscReceivableInfoPo = new FscReceivableInfoPO();
        ArrayList<Integer> payStateList = new ArrayList<Integer>();
        payStateList.add(FscConstants.ReceivablePayState.WAIT_PAY);
        payStateList.add(FscConstants.ReceivablePayState.PART_PAY);
        fscReceivableInfoPo.setPayStateList(payStateList);
        fscReceivableInfoPo.setReceivablePushState(FscConstants.ReceivablePushState.PUSHED);
        return this.fscReceivableInfoMapper.getList(fscReceivableInfoPo);
    }

    private UmcQryLdOrgInfoDetailRspBO getUmcQryLdOrgInfoDetailRspBo() {
        UmcQryLdOrgInfoDetailReqBO umcQryLdOrgInfoDetailReqBo = new UmcQryLdOrgInfoDetailReqBO();
        umcQryLdOrgInfoDetailReqBo.setOrgIdWeb(this.receivableOrgIdWeb);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u5165\u53c2{}", (Object)umcQryLdOrgInfoDetailReqBo);
        UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo = this.umcQryLdOrgInfoDetailService.qryLdOrgInfoDetail(umcQryLdOrgInfoDetailReqBo);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u51fa\u53c2{}", (Object)umcQryLdOrgInfoDetailRspBo);
        if (!"0000".equals(umcQryLdOrgInfoDetailRspBo.getRespCode()) || umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO() == null || StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum()) || StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbPkCorp()) || StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbCorpName())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u5931\u8d25\u6216\u6570\u636e\u4e3a\u7a7a");
        }
        return umcQryLdOrgInfoDetailRspBo;
    }

    private List<ThirdQueryPaymentVo> getReceipt(UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, List<String> receiveId) {
        LianDongFscReceiptQueryReqBo lianDongFscReceiptQueryReqBo = new LianDongFscReceiptQueryReqBo();
        lianDongFscReceiptQueryReqBo.setPrecinctId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        lianDongFscReceiptQueryReqBo.setChargeDetailIDs(receiveId);
        try {
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606fURL{}", (Object)this.RECEIPT_QUERY);
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606fBODY{}", (Object)lianDongFscReceiptQueryReqBo);
            String result = HttpUtil.post((String)this.RECEIPT_QUERY, (String)JSONObject.toJSONString((Object)lianDongFscReceiptQueryReqBo));
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObj.get((Object)"resultCode"))) {
                log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u7cfb\u7edf\u5f02\u5e38");
                throw new FscBusinessException("190000", (String)resultObj.get((Object)"resultMsg"));
            }
            LianDongFscReceiptQueryRspBo lianDongFscReceiptQueryRspBo = (LianDongFscReceiptQueryRspBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), LianDongFscReceiptQueryRspBo.class);
            if (CollectionUtils.isEmpty(lianDongFscReceiptQueryRspBo.getResultData())) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5b9e\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
            }
            List<ThirdQueryPaymentVo> thirdQueryPaymentVoList = lianDongFscReceiptQueryRspBo.getResultData().stream().filter(thirdQueryOrderVo -> thirdQueryOrderVo.getIsDelete() == 0).flatMap(thirdQueryOrderVo -> thirdQueryOrderVo.getPaymentList().stream()).filter(paymentVo -> paymentVo.getIsDelete() == 0).filter(paymentVo -> !"998".equals(paymentVo.getSquareTypeID())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(thirdQueryPaymentVoList)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5b9e\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
            }
            return thirdQueryPaymentVoList;
        }
        catch (Exception e) {
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u7cfb\u7edf\u5f02\u5e38");
            throw new FscBusinessException("190000", e.getMessage());
        }
    }
}

