/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.dao.FscTaskInfoMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscTaskInfoPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscEsBillCheckServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEsBillCheckServiceConsumer.class);
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscTaskInfoMapper fscTaskInfoMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        FscBillEcomCheckAbilityReqBO applyAbilityReqBO = (FscBillEcomCheckAbilityReqBO)JSON.parseObject((String)proxyMessage.getContent(), FscBillEcomCheckAbilityReqBO.class);
        try {
            FscBillEcomCheckAbilityRspBO abilityRspBO;
            if (log.isDebugEnabled()) {
                log.debug("mq\u7535\u5546\u5bf9\u8d26\u6d88\u8d39\u8005\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)applyAbilityReqBO));
            }
            if (!"0000".equals((abilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(applyAbilityReqBO)).getRespCode())) {
                throw new FscBusinessException("190000", abilityRspBO.getRespDesc());
            }
            if ("0000".equals(abilityRspBO.getRespCode())) {
                this.updateTaskForSucess(applyAbilityReqBO);
            }
        }
        catch (Exception e) {
            this.updateTaskForFail(applyAbilityReqBO);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void updateTaskForFail(FscBillEcomCheckAbilityReqBO applyAbilityReqBO) {
        log.debug("\u5bf9\u8d26\u5931\u8d25\u4fee\u6539\u4efb\u52a1\u4e3a\u5bf9\u8d26\u5931\u8d25");
        FscTaskInfoPO fscTaskInfoPoWhere = new FscTaskInfoPO();
        fscTaskInfoPoWhere.setTaskId(applyAbilityReqBO.getTaskId());
        FscTaskInfoPO fscTaskInfoPoSet = new FscTaskInfoPO();
        fscTaskInfoPoSet.setTaskState(Integer.valueOf(4));
        this.fscTaskInfoMapper.updateBy(fscTaskInfoPoSet, fscTaskInfoPoWhere);
    }

    private void updateTaskForSucess(FscBillEcomCheckAbilityReqBO applyAbilityReqBO) {
        log.debug("\u5bf9\u8d26\u5931\u8d25\u4fee\u6539\u4efb\u52a1\u4e3a\u5bf9\u8d26\u6210\u529f");
        FscTaskInfoPO fscTaskInfoPoWhere = new FscTaskInfoPO();
        fscTaskInfoPoWhere.setTaskId(applyAbilityReqBO.getTaskId());
        FscTaskInfoPO fscTaskInfoPoSet = new FscTaskInfoPO();
        fscTaskInfoPoSet.setTaskState(Integer.valueOf(3));
        this.fscTaskInfoMapper.updateBy(fscTaskInfoPoSet, fscTaskInfoPoWhere);
    }
}

