/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.bill.ability.api.FscBillPurCheckConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPurCheckConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPurCheckConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPurCheckConfirmBusiService;
import com.tydic.fsc.bill.busi.api.FscLianDongCallFscNotContractUpBusiService;
import com.tydic.fsc.bill.busi.api.FscLianDongCreateTransFeeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPurCheckConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPurCheckConfirmBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateTransFeeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateTransFeeBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscOrderAbilityReqBO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPurCheckConfirmAbilityService"})
public class FscBillPurCheckConfirmAbilityServiceImpl
implements FscBillPurCheckConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPurCheckConfirmAbilityServiceImpl.class);
    @Autowired
    private FscBillPurCheckConfirmBusiService fscBillPurCheckConfirmBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateCombService fscUocOrderRelUpdateCombService;
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderAbilityService fscOrderAbilityService;
    @Value(value="${agreeOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/agrTradeStatementDetails?fscOrderId=}")
    private String agreeOrderDownDetailUrl;
    @Value(value="${eleOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/ecTradeStatementDetails?fscOrderId=}")
    private String eleOrderDownDetailUrl;
    @Value(value="${tradOrderDownDetailUrl:http://test1-lsugu.liando.cn:9191/#/index/agrTradeStatementDetails?fscOrderId=}")
    private String tradOrderDownDetailUrl;
    @Autowired
    private FscLianDongCreateTransFeeBusiService fscLianDongCreateTransFeeBusiService;
    @Autowired
    private FscLianDongCallFscNotContractUpBusiService fscLianDongCallFscNotContractUpBusiService;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTORSERVICEPAYCOMFIRE = new ThreadPoolExecutor(CPU, 2 * CPU, 200L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("\u4e0b\u6e38\u786e\u8ba4\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u6d88\u606f").build(), new ThreadPoolExecutor.AbortPolicy());
    private static final ExecutorService EXECUTORSERVICE = new ThreadPoolExecutor(2, 5, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(3), new ThreadFactoryBuilder().setNameFormat("\u751f\u6210\u8fd0\u8d39\u5bf9\u8d26\u5355").build(), new ThreadPoolExecutor.AbortPolicy());
    @Value(value="${settlementDay:7}")
    private int settlementDay;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;

    @PostMapping(value={"dealPurOrderConfirm"})
    public FscBillPurCheckConfirmAbilityRspBO dealPurOrderConfirm(@RequestBody FscBillPurCheckConfirmAbilityReqBO reqBO) {
        Long fscOrderId = (Long)this.cacheService.get("Confirm" + reqBO.getFscOrderId());
        if (fscOrderId != null) {
            return new FscBillPurCheckConfirmAbilityRspBO();
        }
        this.cacheService.set("Confirm" + reqBO.getFscOrderId(), (Object)reqBO.getFscOrderId());
        this.val(reqBO);
        FscBillPurCheckConfirmBusiReqBO fscBillPurCheckConfirmBusiReqBO = new FscBillPurCheckConfirmBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)fscBillPurCheckConfirmBusiReqBO));
        FscBillPurCheckConfirmBusiRspBO fscBillPurCheckConfirmBusiRspBO = this.fscBillPurCheckConfirmBusiService.dealPurOrderConfirm(fscBillPurCheckConfirmBusiReqBO);
        if (!"0000".equals(fscBillPurCheckConfirmBusiRspBO.getRespCode())) {
            this.cacheService.delete("Confirm" + reqBO.getFscOrderId());
            throw new FscBusinessException(fscBillPurCheckConfirmBusiRspBO.getRespCode(), fscBillPurCheckConfirmBusiRspBO.getRespDesc());
        }
        this.cacheService.delete("Confirm" + reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.getFscOrderPO(reqBO);
        this.sendMq(reqBO.getFscOrderId(), fscOrderPo.getFscTransOrderType());
        this.callMoney(Collections.singletonList(reqBO.getFscOrderId()));
        return new FscBillPurCheckConfirmAbilityRspBO();
    }

    private FscOrderPO getFscOrderPO(FscBillPurCheckConfirmAbilityReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u8be6\u60c5\u4e3a\u7a7a");
        }
        return fscOrderMapperModelBy;
    }

    private void createTransFeeFscOrder(Long fscOrderId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderMapperModelBy.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderMapperModelBy.getReceiveType()) && FscConstants.FscTransOrderType.ORDER.equals(fscOrderMapperModelBy.getFscTransOrderType())) {
            EXECUTORSERVICE.execute(() -> {
                FscLianDongCreateTransFeeBusiReqBO fscLianDongCreateTransFeeBusiReqBo = new FscLianDongCreateTransFeeBusiReqBO();
                fscLianDongCreateTransFeeBusiReqBo.setFscOrderId(fscOrderId);
                FscLianDongCreateTransFeeBusiRspBO fscLianDongCreateTransFeeBusiRspBo = this.fscLianDongCreateTransFeeBusiService.createTransFee(fscLianDongCreateTransFeeBusiReqBo);
                if (!"0000".equals(fscLianDongCreateTransFeeBusiRspBo.getRespCode())) {
                    log.debug("\u5bf9\u8d26\u5355\u786e\u8ba4\u751f\u6210\u8fd0\u8d39\u5bf9\u8d26\u5355\u5931\u8d25");
                }
                if (fscLianDongCreateTransFeeBusiRspBo.getFscOrderId() != null) {
                    this.sendEsMq(fscLianDongCreateTransFeeBusiRspBo.getFscOrderId());
                }
            });
        }
    }

    private void val(FscBillPurCheckConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long fscOrderId, Integer fscTransOrderType) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        if (FscConstants.FscTransOrderType.ORDER.equals(fscTransOrderType)) {
            FscUocOrderRelUpdateCombReqBO fscUocOrderRelUpdateCombReqBO = new FscUocOrderRelUpdateCombReqBO();
            fscUocOrderRelUpdateCombReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateCombReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            fscUocOrderRelUpdateCombReqBO.setUpdateOrder(Integer.valueOf(1));
            this.fscUocOrderRelUpdateCombService.dealRelUpdate(fscUocOrderRelUpdateCombReqBO);
        }
    }

    private void sendEsMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void callMoney(List<Long> fscOrderIds) {
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
        EXECUTORSERVICEPAYCOMFIRE.execute(() -> {
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderIds(fscOrderIds);
            log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u5165\u53c2{}", (Object)fscOrderPo);
            List fscOrderPoS = this.fscOrderMapper.getList(fscOrderPo);
            log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u51fa\u53c2{}", (Object)fscOrderPoS);
            if (CollectionUtils.isEmpty((Collection)fscOrderPoS) || fscOrderIds.size() != fscOrderPoS.size()) {
                throw new FscBusinessException("190000", "\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u51fa\u53c2\u4e3a\u7a7a\u6216\u63a8\u9001\u6570\u91cf\u4e0d\u540c");
            }
            fscOrderPoS.forEach(fscOrderPoModel -> {
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPoModel.getReceiveType()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0 && "4".equals(fscOrderPoModel.getUserType().toString())) {
                    Date date = new Date();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(6, this.settlementDay);
                    Date resultDate = calendar.getTime();
                    if (FscConstants.AgreementLdType.NORMAL.equals(fscOrderPoModel.getAgreementLdType()) || FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION.equals(fscOrderPoModel.getAgreementLdType()) && fscOrderPoModel.getPlanPayTime() != null && fscOrderPoModel.getPlanPayTime().compareTo(resultDate) <= 0) {
                        FscOrderAbilityReqBO fscOrderAbilityReqBo = new FscOrderAbilityReqBO();
                        if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                            log.debug("\u8d38\u6613\u534f\u8bae\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                            fscOrderAbilityReqBo.setUrl(this.agreeOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                        } else if ("3".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                            log.debug("\u4e09\u65b9\u4ea4\u6613\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                            fscOrderAbilityReqBo.setUrl(this.tradOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                        } else if ("2".equals(fscOrderPoModel.getOrderSource().toString()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPoModel.getMakeType()) && "4".equals(fscOrderPoModel.getUserType().toString()) && fscOrderPoModel.getTotalCombinedPaymentCredit().compareTo(BigDecimal.ZERO) > 0) {
                            log.debug("\u7535\u5546\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5f00\u59cb");
                            fscOrderAbilityReqBo.setUrl(this.tradOrderDownDetailUrl + fscOrderPoModel.getFscOrderId());
                        }
                        fscOrderAbilityReqBo.setFscOrderId(fscOrderPoModel.getFscOrderId());
                        Long logId = null;
                        try {
                            logId = this.logAddCallMoney(fscOrderAbilityReqBo + "", fscOrderPoModel.getFscOrderId() + "");
                        }
                        catch (Exception e) {
                            log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
                            e.printStackTrace();
                        }
                        try {
                            fscOrderAbilityReqBo.setLogId(logId);
                            log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u5165\u53c2{}", (Object)fscOrderAbilityReqBo);
                            this.fscOrderAbilityService.dealFscOrder(fscOrderAbilityReqBo);
                            log.debug("\u4e0b\u6e38\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u51fa\u53c2{}", (Object)fscOrderAbilityReqBo);
                        }
                        catch (Exception e) {
                            try {
                                if (logId != null) {
                                    this.logUpdate(logId, e.getMessage());
                                }
                            }
                            catch (Exception ek) {
                                log.debug("\u4e0b\u6e38\u6210\u672c\u7cfb\u7edf\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25");
                                ek.printStackTrace();
                            }
                            e.printStackTrace();
                        }
                    }
                }
            });
        });
    }

    private Long logAddCallMoney(String reqStr, String fscOrderId) {
        return this.fscCostLogAtomService.logInsert(fscOrderId, reqStr, null, FscConstants.CostIsError.YES, FscConstants.CostObjType.FSC_DOWN_CALL_MONEY, this.getClass().toString());
    }

    private Long logAdd(String reqStr, String purchaseOrderId) {
        return this.fscCostLogAtomService.logInsert(purchaseOrderId, reqStr, null, FscConstants.CostIsError.YES, FscConstants.CostObjType.ORDER_NEED_PAY_FSC_CALL, this.getClass().toString());
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }
}

