/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.dyc.umc.service.purchaselimit.UmcGetIsExtCustomerOrderService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetIsExtCustomerOrderReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetIsExtCustomerOrderRspBo;
import com.tydic.fsc.bill.ability.api.FscQrySaleOrderPayTypeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscQrySaleOrderPayTypeAbilityReqBo;
import com.tydic.fsc.bill.ability.bo.FscQrySaleOrderPayTypeAbilityRspBo;
import com.tydic.fsc.bill.ability.bo.SkuInfoBo;
import com.tydic.fsc.bill.ability.bo.payListBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscMerchantNewMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantNewPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscQrySaleOrderPayTypeAbilityService"})
public class FscQrySaleOrderPayTypeAbilityServiceImpl
implements FscQrySaleOrderPayTypeAbilityService {
    @Autowired
    private FscMerchantNewMapper fscMerchantNewMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private UmcGetIsExtCustomerOrderService umcGetIsExtCustomerOrderService;

    @PostMapping(value={"qrySaleOrderPayType"})
    public FscQrySaleOrderPayTypeAbilityRspBo qrySaleOrderPayType(@RequestBody FscQrySaleOrderPayTypeAbilityReqBo abilityReqBo) {
        FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo = new FscQrySaleOrderPayTypeAbilityRspBo();
        fscQrySaleOrderPayTypeAbilityRspBo.setRespCode("0000");
        fscQrySaleOrderPayTypeAbilityRspBo.setRespDesc("\u6210\u529f");
        this.check(abilityReqBo);
        List<SkuInfoBo> operList = abilityReqBo.getSkuInfoBoList().stream().filter(skuInfoBo -> FscConstants.ConfigurationType.OPER.equals(skuInfoBo.getConfigurationType())).collect(Collectors.toList());
        List<SkuInfoBo> supList = abilityReqBo.getSkuInfoBoList().stream().filter(skuInfoBo -> FscConstants.ConfigurationType.SUPPLIER.equals(skuInfoBo.getConfigurationType())).collect(Collectors.toList());
        Integer operPayType = this.getOperPayType(abilityReqBo, operList);
        List<Integer> supPayTypeList = this.getSupPayType(abilityReqBo, supList);
        ArrayList<payListBo> payListBoList = new ArrayList<payListBo>();
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        this.rsprPut(fscQrySaleOrderPayTypeAbilityRspBo, operPayType, supPayTypeList, dicMap, payListBoList, abilityReqBo);
        return fscQrySaleOrderPayTypeAbilityRspBo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rsprPut(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Integer operPayType, List<Integer> supPayTypeList, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList, FscQrySaleOrderPayTypeAbilityReqBo abilityReqBo) {
        if (operPayType == null && CollectionUtils.isEmpty(supPayTypeList)) {
            throw new FscBusinessException("190000", "\u652f\u4ed8\u65b9\u5f0f\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (operPayType == null && !CollectionUtils.isEmpty(supPayTypeList)) {
            fscQrySaleOrderPayTypeAbilityRspBo.setPayType(supPayTypeList.get(0));
        } else if (operPayType != null && CollectionUtils.isEmpty(supPayTypeList)) {
            fscQrySaleOrderPayTypeAbilityRspBo.setPayType(operPayType);
        } else if (operPayType != null && !CollectionUtils.isEmpty(supPayTypeList)) {
            if ("4".equals(abilityReqBo.getMemUserType())) {
                if (!operPayType.equals(supPayTypeList.get(0))) throw new FscBusinessException("190000", "\u6240\u9009\u5546\u54c1\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u7edf\u4e00\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
                fscQrySaleOrderPayTypeAbilityRspBo.setPayType(operPayType);
            } else if (operPayType.equals(supPayTypeList.get(0))) {
                fscQrySaleOrderPayTypeAbilityRspBo.setPayType(operPayType);
            } else if (FscConstants.PayOrderType.FIXED_LIMIT.equals(operPayType) && FscConstants.PayOrderType.FIXED_LIMIT.equals(supPayTypeList.get(0))) {
                fscQrySaleOrderPayTypeAbilityRspBo.setPayType(FscConstants.PayOrderType.FIXED_LIMIT);
            } else {
                fscQrySaleOrderPayTypeAbilityRspBo.setPayType(FscConstants.PayOrderType.PAY_FIRST);
            }
        }
        if (!abilityReqBo.getIsPayGroup().booleanValue()) {
            if ("4".equals(abilityReqBo.getMemUserType())) {
                this.putInner(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
                return;
            } else if (FscConstants.PayOrderType.PAY_FIRST.equals(fscQrySaleOrderPayTypeAbilityRspBo.getPayType())) {
                this.putOutFirst(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
                return;
            } else {
                this.putOutFixed(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
            }
            return;
        } else if ("4".equals(abilityReqBo.getMemUserType())) {
            this.putInnerGroup(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
            return;
        } else if (FscConstants.PayOrderType.PAY_FIRST.equals(fscQrySaleOrderPayTypeAbilityRspBo.getPayType())) {
            this.putOutFirstGroup(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
            return;
        } else {
            this.putOutFixedGroup(fscQrySaleOrderPayTypeAbilityRspBo, dicMap, payListBoList);
        }
    }

    private void putInner(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBo2 = new payListBo();
        payListBo2.setPayType(fscQrySaleOrderPayTypeAbilityRspBo.getPayType());
        payListBo2.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(payListBo2.getPayType().toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(2);
        if (FscConstants.PayOrderType.PAY_FIRST.equals(payListBo2.getPayType())) {
            payChannelMap.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
            payChannelMap.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        } else {
            payChannelMap.put(FscConstants.payOrderChannel.FIXED_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.FIXED_LIMIT.toString()));
        }
        payListBo2.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBo2);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private void putOutFirst(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBo2 = new payListBo();
        payListBo2.setPayType(FscConstants.PayOrderType.PAY_FIRST);
        payListBo2.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(2);
        payChannelMap.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
        payChannelMap.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        payListBo2.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBo2);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private void putOutFixed(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBoFixed = new payListBo();
        payListBoFixed.setPayType(FscConstants.PayOrderType.FIXED_LIMIT);
        payListBoFixed.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.FIXED_LIMIT.toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(1);
        payChannelMap.put(FscConstants.payOrderChannel.FIXED_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.FIXED_LIMIT.toString()));
        payListBoFixed.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBoFixed);
        payListBo payListBoPayUp = new payListBo();
        payListBoPayUp.setPayType(FscConstants.PayOrderType.PAY_FIRST);
        payListBoPayUp.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelMapUp = new HashMap<Integer, String>(2);
        payChannelMapUp.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
        payChannelMapUp.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        payListBoPayUp.setPayChannelMap(payChannelMapUp);
        payListBoList.add(payListBoPayUp);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private void putInnerGroup(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBo2 = new payListBo();
        payListBo2.setPayType(fscQrySaleOrderPayTypeAbilityRspBo.getPayType());
        payListBo2.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(payListBo2.getPayType().toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(2);
        if (FscConstants.PayOrderType.PAY_FIRST.equals(payListBo2.getPayType())) {
            payChannelMap.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
            payChannelMap.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        } else {
            payChannelMap.put(FscConstants.payOrderChannel.FIXED_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.FIXED_LIMIT.toString()));
        }
        payListBo2.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBo2);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private void putOutFirstGroup(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBo2 = new payListBo();
        payListBo2.setPayType(FscConstants.PayOrderType.PAY_FIRST);
        payListBo2.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(2);
        payChannelMap.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
        payChannelMap.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        payListBo2.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBo2);
        payListBo payListBoTemporary = new payListBo();
        payListBoTemporary.setPayType(FscConstants.PayOrderType.TEMPORARY_LIMIT);
        payListBoTemporary.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.TEMPORARY_LIMIT.toString()));
        HashMap<Integer, String> payChannelTemporaryMap = new HashMap<Integer, String>(2);
        payChannelTemporaryMap.put(FscConstants.payOrderChannel.TEMPORARY_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.TEMPORARY_LIMIT.toString()));
        payListBoTemporary.setPayChannelMap(payChannelTemporaryMap);
        payListBoList.add(payListBoTemporary);
        payListBo payListBoFirstAndTemporary = new payListBo();
        payListBoFirstAndTemporary.setPayType(FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST);
        payListBoFirstAndTemporary.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelAndTemporaryMap = new HashMap<Integer, String>(2);
        payChannelAndTemporaryMap.put(FscConstants.payOrderChannel.TEMPORARY_LIMIT_ADD_PAY_FIRST, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.TEMPORARY_LIMIT_ADD_PAY_FIRST.toString()));
        payListBoFirstAndTemporary.setPayChannelMap(payChannelAndTemporaryMap);
        payListBoList.add(payListBoFirstAndTemporary);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private void putOutFixedGroup(FscQrySaleOrderPayTypeAbilityRspBo fscQrySaleOrderPayTypeAbilityRspBo, Map<String, Map<String, String>> dicMap, List<payListBo> payListBoList) {
        payListBo payListBoFixed = new payListBo();
        payListBoFixed.setPayType(FscConstants.PayOrderType.FIXED_LIMIT);
        payListBoFixed.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.FIXED_LIMIT.toString()));
        HashMap<Integer, String> payChannelMap = new HashMap<Integer, String>(1);
        payChannelMap.put(FscConstants.payOrderChannel.FIXED_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.FIXED_LIMIT.toString()));
        payListBoFixed.setPayChannelMap(payChannelMap);
        payListBoList.add(payListBoFixed);
        payListBo payListBoPayUp = new payListBo();
        payListBoPayUp.setPayType(FscConstants.PayOrderType.PAY_FIRST);
        payListBoPayUp.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelMapUp = new HashMap<Integer, String>(2);
        payChannelMapUp.put(FscConstants.payOrderChannel.PAY_UP, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_UP.toString()));
        payChannelMapUp.put(FscConstants.payOrderChannel.PAY_DOWN, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.PAY_DOWN.toString()));
        payListBoPayUp.setPayChannelMap(payChannelMapUp);
        payListBoList.add(payListBoPayUp);
        payListBo payListBoTemporary = new payListBo();
        payListBoTemporary.setPayType(FscConstants.PayOrderType.TEMPORARY_LIMIT);
        payListBoTemporary.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.TEMPORARY_LIMIT.toString()));
        HashMap<Integer, String> payChannelTemporaryMap = new HashMap<Integer, String>(2);
        payChannelTemporaryMap.put(FscConstants.payOrderChannel.TEMPORARY_LIMIT, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.TEMPORARY_LIMIT.toString()));
        payListBoTemporary.setPayChannelMap(payChannelTemporaryMap);
        payListBoList.add(payListBoTemporary);
        payListBo payListBoFirstAndTemporary = new payListBo();
        payListBoFirstAndTemporary.setPayType(FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST);
        payListBoFirstAndTemporary.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelAndTemporaryMap = new HashMap<Integer, String>(2);
        payChannelAndTemporaryMap.put(FscConstants.payOrderChannel.TEMPORARY_LIMIT_ADD_PAY_FIRST, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.TEMPORARY_LIMIT_ADD_PAY_FIRST.toString()));
        payListBoFirstAndTemporary.setPayChannelMap(payChannelAndTemporaryMap);
        payListBoList.add(payListBoFirstAndTemporary);
        payListBo payListBoFirstAndFixed = new payListBo();
        payListBoFirstAndFixed.setPayType(FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST);
        payListBoFirstAndFixed.setPayTypeStr(dicMap.get("PAY_ORDER_TYPE").get(FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.toString()));
        HashMap<Integer, String> payChannelAndFixedMap = new HashMap<Integer, String>(2);
        payChannelAndFixedMap.put(FscConstants.payOrderChannel.FIXED_LIMIT_ADD_PAY_FIRST, dicMap.get("PAY_ORDER_CHANNEL").get(FscConstants.payOrderChannel.FIXED_LIMIT_ADD_PAY_FIRST.toString()));
        payListBoFirstAndFixed.setPayChannelMap(payChannelAndFixedMap);
        payListBoList.add(payListBoFirstAndFixed);
        fscQrySaleOrderPayTypeAbilityRspBo.setPayList(payListBoList);
    }

    private List<Integer> getSupPayType(FscQrySaleOrderPayTypeAbilityReqBo abilityReqBo, List<SkuInfoBo> supList) {
        ArrayList<Integer> supPayTypeList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(supList)) {
            supList.forEach(skuInfoBo -> {
                FscMerchantNewPO fscMerchantNewPo = new FscMerchantNewPO();
                fscMerchantNewPo.setConfigurationType(FscConstants.ConfigurationType.SUPPLIER);
                fscMerchantNewPo.setSupplierId(skuInfoBo.getSupId());
                fscMerchantNewPo.setAgreementNo(skuInfoBo.getAgreementNo());
                fscMerchantNewPo.setOrgId(abilityReqBo.getPurId());
                fscMerchantNewPo.setIsDel(FscConstants.DicDelFlag.NO);
                FscMerchantNewPO modelBySupOrg = this.fscMerchantNewMapper.getModelBy(fscMerchantNewPo);
                if (modelBySupOrg != null) {
                    supPayTypeList.add(modelBySupOrg.getPayType());
                } else {
                    fscMerchantNewPo.setOrgId(null);
                    fscMerchantNewPo.setSupplierId(null);
                    fscMerchantNewPo.setAgreementNo(null);
                    if ("4".equals(abilityReqBo.getMemUserType())) {
                        fscMerchantNewPo.setIsDefault(FscConstants.MerchantDefalutFlag.YES);
                    } else {
                        fscMerchantNewPo.setIsDefault(FscConstants.MerchantDefalutFlag.YES_OUT);
                    }
                    FscMerchantNewPO modelBySupDefault = this.fscMerchantNewMapper.getModelBy(fscMerchantNewPo);
                    supPayTypeList.add(modelBySupDefault.getPayType());
                }
            });
            if (CollectionUtils.isEmpty(supPayTypeList)) {
                throw new FscBusinessException("190000", "\u4e09\u65b9\u4ea4\u6613\u652f\u4ed8\u65b9\u5f0f\u67e5\u8be2\u4e3a\u7a7a");
            }
            HashSet<Integer> set = new HashSet<Integer>(supPayTypeList);
            if (set.size() > 1) {
                throw new FscBusinessException("190000", "\u6240\u9009\u5546\u54c1\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u7edf\u4e00\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
            }
        }
        return supPayTypeList;
    }

    private Integer getOperPayType(FscQrySaleOrderPayTypeAbilityReqBo abilityReqBo, List<SkuInfoBo> operList) {
        Integer operPayType = null;
        if (!CollectionUtils.isEmpty(operList)) {
            if ("4".equals(abilityReqBo.getMemUserType())) {
                FscMerchantNewPO fscMerchantNewPo = new FscMerchantNewPO();
                fscMerchantNewPo.setConfigurationType(FscConstants.ConfigurationType.OPER);
                fscMerchantNewPo.setOrgId(abilityReqBo.getPurId());
                fscMerchantNewPo.setIsDel(FscConstants.DicDelFlag.NO);
                FscMerchantNewPO modelByOperOrg = this.fscMerchantNewMapper.getModelBy(fscMerchantNewPo);
                if (modelByOperOrg != null) {
                    operPayType = modelByOperOrg.getPayType();
                } else {
                    fscMerchantNewPo.setOrgId(null);
                    if ("4".equals(abilityReqBo.getMemUserType())) {
                        fscMerchantNewPo.setIsDefault(FscConstants.MerchantDefalutFlag.YES);
                    } else {
                        fscMerchantNewPo.setIsDefault(FscConstants.MerchantDefalutFlag.YES_OUT);
                    }
                    FscMerchantNewPO modelByOperDefault = this.fscMerchantNewMapper.getModelBy(fscMerchantNewPo);
                    if (modelByOperDefault == null) {
                        throw new FscBusinessException("190000", "\u8d38\u6613\u6a21\u5f0f\u652f\u4ed8\u65b9\u5f0f\u67e5\u8be2\u4e3a\u7a7a");
                    }
                    operPayType = modelByOperDefault.getPayType();
                }
            } else {
                UmcGetIsExtCustomerOrderReqBo umcGetIsExtCustomerOrderReqBo = new UmcGetIsExtCustomerOrderReqBo();
                umcGetIsExtCustomerOrderReqBo.setCompanyId(abilityReqBo.getPurId());
                UmcGetIsExtCustomerOrderRspBo isExtCustomerOrder = this.umcGetIsExtCustomerOrderService.getIsExtCustomerOrder(umcGetIsExtCustomerOrderReqBo);
                if (!"0000".equals(isExtCustomerOrder.getRespCode())) {
                    throw new FscBusinessException("190000", "\u5916\u90e8\u7528\u6237\u67e5\u8be2\u8d38\u6613\u6a21\u5f0f\u652f\u4ed8\u65b9\u5f0f\u67e5\u8be2\u5931\u8d25");
                }
                operPayType = isExtCustomerOrder.getIsExtCustomerOrder() != false ? FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD : FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP;
            }
        }
        return operPayType;
    }

    private void check(FscQrySaleOrderPayTypeAbilityReqBo abilityReqBo) {
        if (StringUtils.isEmpty((Object)abilityReqBo.getMemUserType())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBo.getPurId() == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u91c7\u8d2d\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBo.getSkuInfoBoList())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getMemUserType())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBo.getSkuInfoBoList().forEach(skuInfoBo -> {
            if (skuInfoBo.getConfigurationType() == null) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\u96c6\u5408\u4e2d\u914d\u7f6e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (FscConstants.ConfigurationType.SUPPLIER.equals(skuInfoBo.getConfigurationType())) {
                if (skuInfoBo.getSupId() == null) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\u96c6\u5408\u4e2d\u4e3a\u4e09\u65b9\u4ea4\u6613\u65f6\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (skuInfoBo.getAgreementNo() == null) {
                    throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u65f6\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f\u96c6\u5408\u4e2d\u4e3a\u4e09\u65b9\u4ea4\u6613\u65f6\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        });
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("PAY_ORDER_TYPE");
        dicPCodes.add("PAY_ORDER_CHANNEL");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

