/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.ability.bo.AcceptOrderItemBO;
import com.tydic.fsc.bill.busi.api.FscBillAbnormalChangeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAbnormalChangeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillAbnormalChangeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultItemPO;
import com.tydic.fsc.po.FscCheckResultPO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillAbnormalChangeBusiServiceImpl
implements FscBillAbnormalChangeBusiService {
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;

    @Override
    public FscBillAbnormalChangeBusiRspBO dealAbnormalChange(FscBillAbnormalChangeBusiReqBO busiReqBO) {
        FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
        fscCheckResultPo.setAcceptOrderId(busiReqBO.getAcceptOrderId());
        FscCheckResultPO modelBy = this.fscCheckResultMapper.getModelBy(fscCheckResultPo);
        if (modelBy == null) {
            return new FscBillAbnormalChangeBusiRspBO();
        }
        FscCheckResultPO fscCheckResultSetPo = new FscCheckResultPO();
        fscCheckResultSetPo.setAmount(busiReqBO.getAcceptPurAmount());
        fscCheckResultSetPo.setSaleAmount(busiReqBO.getAcceptSaleAmount());
        fscCheckResultSetPo.setStatus(FscConstants.BillCheck.NOT_CHECK);
        FscCheckResultPO fscCheckResultWherePo = new FscCheckResultPO();
        fscCheckResultWherePo.setAcceptOrderId(busiReqBO.getAcceptOrderId());
        int update = this.fscCheckResultMapper.updateBy(fscCheckResultSetPo, fscCheckResultWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u901a\u77e5\u7ed3\u7b97\u4fee\u6539\u5bf9\u8d26\u8868\u5931\u8d25");
        }
        List skuIds = busiReqBO.getAcceptOrderItemList().stream().map(AcceptOrderItemBO::getSkuId).collect(Collectors.toList());
        int byAcceptOrderIdAndSkuIds = this.fscCheckResultItemMapper.getByAcceptOrderIdAndSkuIds(skuIds, busiReqBO.getAcceptOrderId());
        if (busiReqBO.getAcceptOrderItemList().size() != byAcceptOrderIdAndSkuIds) {
            throw new FscBusinessException("190000", "\u5176\u4e2d\u6709\u9a8c\u6536\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
        }
        busiReqBO.getAcceptOrderItemList().forEach(acceptOrderItemBO -> {
            FscCheckResultItemPO fscCheckResultItemSetPo = new FscCheckResultItemPO();
            fscCheckResultItemSetPo.setAmount(acceptOrderItemBO.getAmount());
            fscCheckResultItemSetPo.setNum(acceptOrderItemBO.getNum());
            FscCheckResultItemPO fscCheckResultItemWherePo = new FscCheckResultItemPO();
            fscCheckResultItemWherePo.setAcceptOrderId(busiReqBO.getAcceptOrderId());
            fscCheckResultItemWherePo.setSkuId(acceptOrderItemBO.getSkuId());
            fscCheckResultItemWherePo.setAcceptOrderItemId(acceptOrderItemBO.getAcceptOrderItemId());
            int updateItem = this.fscCheckResultItemMapper.updateBy(fscCheckResultItemSetPo, fscCheckResultItemWherePo);
            if (updateItem < 1) {
                throw new FscBusinessException("190000", "\u9a8c\u6536\u5355\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff0c\u9a8c\u6536\u5355ID\u4e3a" + busiReqBO.getAcceptOrderId() + "\u9a8c\u6536\u5355\u5355\u54c1ID\u4e3a" + acceptOrderItemBO.getSkuId());
            }
        });
        FscBillAbnormalChangeBusiRspBO fscBillAbnormalChangeBusiRspBo = new FscBillAbnormalChangeBusiRspBO();
        fscBillAbnormalChangeBusiRspBo.setRespCode("0000");
        fscBillAbnormalChangeBusiRspBo.setRespDesc("\u6210\u529f");
        return fscBillAbnormalChangeBusiRspBo;
    }
}

