/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscLianDongCallFscNotContractUpBusiService;
import com.tydic.fsc.bill.busi.bo.FscCallFscNotContractUpBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongCallFscNotContractUpBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongCallFscNotContractUpBusiRspBo;
import com.tydic.fsc.bill.busi.bo.FscOrderItemCallBo;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTransfeeItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTransfeeItemPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongCallFscNotContractUpBusiServiceImpl
implements FscLianDongCallFscNotContractUpBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongCallFscNotContractUpBusiServiceImpl.class);
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscTransfeeItemMapper fscTransfeeItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${CALL_FSC_NOT_CONTRACT_UP_URL:www.baidu.com}")
    private String callFscNotContractUpUrl;
    @Value(value="${IS_CALL_FSC:true}")
    private boolean isCallFscFlag;

    @Override
    public FscLianDongCallFscNotContractUpBusiRspBo dealCallFscNotContractUp(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8{}", (Object)busiReqBo);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(busiReqBo.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (FscConstants.IsNeedPayOrder.NO.equals(fscOrderPo.getIsNeedPayOrder())) {
            log.debug("\u9a8c\u6536\u5355\u7ef4\u5ea6\u63a8\u9001\u6570\u636e");
            List<FscOrderRelationPO> fscOrderRelationMapperList = this.getFscOrderRelationPoList(busiReqBo);
            Map<Long, List<FscOrderItemPO>> fscItemMap = this.getLongListMap(busiReqBo);
            FscCallFscNotContractUpBo fscCallFscNotContractUpBo = new FscCallFscNotContractUpBo();
            ArrayList<FscOrderItemCallBo> fscOrderItemCallBoList = new ArrayList<FscOrderItemCallBo>();
            this.setCallBo(busiReqBo, fscOrderRelationMapperList, fscItemMap, fscCallFscNotContractUpBo, fscOrderItemCallBoList);
            if (this.isCallFscFlag) {
                this.doPost(busiReqBo, fscCallFscNotContractUpBo);
            }
        } else {
            log.debug("\u5e94\u4ed8\u7ef4\u5ea6\u63a8\u9001\u6570\u636e");
        }
        FscLianDongCallFscNotContractUpBusiRspBo fscLianDongCallFscNotContractUpBusiRspBo = new FscLianDongCallFscNotContractUpBusiRspBo();
        fscLianDongCallFscNotContractUpBusiRspBo.setRespCode("0000");
        fscLianDongCallFscNotContractUpBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongCallFscNotContractUpBusiRspBo;
    }

    private void doPost(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo, FscCallFscNotContractUpBo fscCallFscNotContractUpBo) {
        block6: {
            if (!busiReqBo.getIsDeal().booleanValue()) {
                try {
                    log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8body{}", (Object)fscCallFscNotContractUpBo);
                    log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8url{}", (Object)this.callFscNotContractUpUrl);
                    String result = HttpUtil.post((String)this.callFscNotContractUpUrl, (String)JSONObject.toJSONString((Object)fscCallFscNotContractUpBo));
                    log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8\u51fa\u53c2-{}", (Object)result);
                    JSONObject resultObj = JSONObject.parseObject((String)result);
                    if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                        log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8\u8fd4\u56de\u5f02\u5e38");
                        this.logUpdate(busiReqBo.getLogId(), result);
                        break block6;
                    }
                    this.setSucessPost(busiReqBo);
                }
                catch (Exception e) {
                    log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8\u5f02\u5e38");
                    this.logUpdate(busiReqBo.getLogId(), e.getMessage());
                    e.printStackTrace();
                }
            } else {
                log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8body{}", (Object)fscCallFscNotContractUpBo);
                log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8url{}", (Object)this.callFscNotContractUpUrl);
                String result = HttpUtil.post((String)this.callFscNotContractUpUrl, (String)JSONObject.toJSONString((Object)fscCallFscNotContractUpBo));
                log.debug("\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8\u51fa\u53c2-{}", (Object)result);
                JSONObject resultObj = JSONObject.parseObject((String)result);
                if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                    throw new FscBusinessException("190000", "\u63a8\u9001\u6210\u672c\u7cfb\u7edf\u4e0a\u6e38\u5bf9\u8d26\u5355\u5e94\u4ed8\u5f02\u5e38");
                }
                this.setSucessPost(busiReqBo);
            }
        }
    }

    private void setSucessPost(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        FscOrderPO fscOrderPoWhere = new FscOrderPO();
        fscOrderPoWhere.setFscOrderId(busiReqBo.getFscOrderId());
        FscOrderPO fscOrderPoSet = new FscOrderPO();
        fscOrderPoSet.setIsCallCost(FscConstants.IsCallCost.YES);
        this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
    }

    private void setCallBo(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo, List<FscOrderRelationPO> fscOrderRelationMapperList, Map<Long, List<FscOrderItemPO>> fscItemMap, FscCallFscNotContractUpBo fscCallFscNotContractUpBo, List<FscOrderItemCallBo> fscOrderItemCallBoList) {
        fscOrderRelationMapperList.forEach(fscOrderRelationPoModel -> {
            List fscOrderItemPoList = (List)fscItemMap.get(fscOrderRelationPoModel.getAcceptOrderId());
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPoList)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderItemPoList.forEach(fscOrderItemPoModel -> {
                FscOrderItemCallBo fscOrderItemCallBo = new FscOrderItemCallBo();
                fscOrderItemCallBo.setOrderNo(fscOrderRelationPoModel.getOrderNo());
                fscOrderItemCallBo.setReceivingReportNo(fscOrderRelationPoModel.getAcceptOrderNo());
                fscOrderItemCallBo.setEceivingReportAmount(fscOrderItemPoModel.getAmt());
                fscOrderItemCallBo.setSkuCode(fscOrderItemPoModel.getSkuId() + "");
                fscOrderItemCallBo.setOrderNum(fscOrderItemPoModel.getNum());
                fscOrderItemCallBo.setSalePrice(fscOrderItemPoModel.getPrice());
                fscOrderItemCallBoList.add(fscOrderItemCallBo);
            });
        });
        fscCallFscNotContractUpBo.setFscOrderId(busiReqBo.getFscOrderId());
        fscCallFscNotContractUpBo.setFscOrderNo(busiReqBo.getFscOrderNo());
        fscCallFscNotContractUpBo.setFscOrderSupplierName(busiReqBo.getSupplierName());
        fscCallFscNotContractUpBo.setUrl(null);
        fscCallFscNotContractUpBo.setTotalPay(busiReqBo.getTotalAmount());
        fscCallFscNotContractUpBo.setFscOrderItem(fscOrderItemCallBoList);
        FscOrderPO fscOrderMapperModelBy = this.getFscOrderPo(busiReqBo);
        if (fscOrderMapperModelBy.getAgreementLdType() != null && FscConstants.AgreementLdType.INTERNAL_DATA_COLLECTION.equals(fscOrderMapperModelBy.getAgreementLdType()) && fscOrderMapperModelBy.getPlanPayTime() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = dateFormat.format(fscOrderMapperModelBy.getPlanPayTime());
            fscCallFscNotContractUpBo.setExpectedPayDate(format);
        }
    }

    private FscOrderPO getFscOrderPo(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(busiReqBo.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderMapperModelBy;
    }

    private Map<Long, List<FscOrderItemPO>> getLongListMap(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        if (FscConstants.FscTransOrderType.ORDER.equals(busiReqBo.getFscTransOrderType())) {
            List<FscOrderItemPO> fscOrderItemMapperList = this.getFscOrderItemPoList(busiReqBo);
            return fscOrderItemMapperList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAcceptOrderId));
        }
        ArrayList<FscOrderItemPO> fscOrderItemPoList = this.getFscOrderTransItemPoList(busiReqBo);
        return fscOrderItemPoList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAcceptOrderId));
    }

    private ArrayList<FscOrderItemPO> getFscOrderTransItemPoList(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        FscTransfeeItemPO fscTransfeeItemPo = new FscTransfeeItemPO();
        fscTransfeeItemPo.setFscOrderId(busiReqBo.getFscOrderId());
        log.debug("\u83b7\u53d6\u8fd0\u8d39\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscTransfeeItemPo);
        List fscTransfeeItemMapperList = this.fscTransfeeItemMapper.getList(fscTransfeeItemPo);
        log.debug("\u83b7\u53d6\u8fd0\u8d39\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscTransfeeItemMapperList);
        if (CollectionUtils.isEmpty((Collection)fscTransfeeItemMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u8fd0\u8d39\u660e\u7ec6\u4e3a\u7a7a");
        }
        ArrayList<FscOrderItemPO> fscOrderItemPoList = new ArrayList<FscOrderItemPO>();
        fscTransfeeItemMapperList.forEach(transfeeItemPo -> {
            FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
            fscOrderItemPo.setAcceptOrderId(transfeeItemPo.getInspOrderId());
            fscOrderItemPo.setPrice(transfeeItemPo.getTransFee());
            fscOrderItemPo.setSkuId(Long.valueOf(99L));
            fscOrderItemPo.setNum(new BigDecimal(1));
            fscOrderItemPo.setAmt(transfeeItemPo.getTransFee());
            fscOrderItemPoList.add(fscOrderItemPo);
        });
        return fscOrderItemPoList;
    }

    private List<FscOrderItemPO> getFscOrderItemPoList(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(busiReqBo.getFscOrderId());
        log.debug("\u83b7\u53d6\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u5165\u53c2{}", (Object)fscOrderItemPo);
        List fscOrderItemMapperList = this.fscOrderItemMapper.getList(fscOrderItemPo);
        log.debug("\u83b7\u53d6\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscOrderItemMapperList);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderItemMapperList;
    }

    private List<FscOrderRelationPO> getFscOrderRelationPoList(FscLianDongCallFscNotContractUpBusiReqBo busiReqBo) {
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(busiReqBo.getFscOrderId());
        log.debug("\u83b7\u53d6\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u5165\u53c2{}", (Object)fscOrderRelationPo);
        List fscOrderRelationMapperList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        log.debug("\u83b7\u53d6\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u51fa\u53c2{}", (Object)fscOrderRelationMapperList);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderRelationMapperList;
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }
}

