/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import com.tydic.fsc.bill.busi.api.FscLianDongCreateReceivableBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateReceivableBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongCreateReceivableBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscReceivableInfoMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscReceivableInfoPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscLianDongCreateReceivableBusiServiceImpl
implements FscLianDongCreateReceivableBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongCreateReceivableBusiServiceImpl.class);
    @Autowired
    private FscReceivableInfoMapper fscReceivableInfoMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private UmcQryEnterpriseInfoDetailService umcQryEnterpriseInfoDetailService;

    @Override
    public FscLianDongCreateReceivableBusiRspBo createReceivable(FscLianDongCreateReceivableBusiReqBo busiReqBo) {
        log.debug("\u521b\u5efa\u5e94\u6536API\u5b9e\u73b0\u7c7b\u5165\u53c2{}", (Object)busiReqBo);
        this.check(busiReqBo);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBo = this.getCfcEncodedSerialGetServiceRspBo(busiReqBo);
        UmcQryEnterpriseInfoDetailRspBo umcQryEnterpriseInfoDetailRspBo = this.getUmcQryEnterpriseInfoDetailRspBo(busiReqBo);
        this.insertInfo(busiReqBo, encodedSerialGetServicePayRspBo, umcQryEnterpriseInfoDetailRspBo);
        FscLianDongCreateReceivableBusiRspBo fscLianDongCreateReceivableBusiRspBo = new FscLianDongCreateReceivableBusiRspBo();
        fscLianDongCreateReceivableBusiRspBo.setRespCode("0000");
        fscLianDongCreateReceivableBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongCreateReceivableBusiRspBo;
    }

    private void insertInfo(FscLianDongCreateReceivableBusiReqBo busiReqBo, CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBo, UmcQryEnterpriseInfoDetailRspBo umcQryEnterpriseInfoDetailRspBo) {
        FscReceivableInfoPO fscReceivableInfoPoInsert = new FscReceivableInfoPO();
        fscReceivableInfoPoInsert.setFscReceivableId(Long.valueOf(Sequence.getInstance().nextId()));
        fscReceivableInfoPoInsert.setFscReceivableNo((String)encodedSerialGetServicePayRspBo.getSerialNoList().get(0));
        fscReceivableInfoPoInsert.setParentSaleOrderId(busiReqBo.getSaleOrderId());
        fscReceivableInfoPoInsert.setParentSaleOrderNo(busiReqBo.getSaleOrderNo());
        fscReceivableInfoPoInsert.setOrderId(busiReqBo.getOrderId());
        fscReceivableInfoPoInsert.setOrderCreateTime(busiReqBo.getOrderCreateTime());
        fscReceivableInfoPoInsert.setParentSaleOrderState(busiReqBo.getSaleOrderState());
        fscReceivableInfoPoInsert.setInspTime(null);
        fscReceivableInfoPoInsert.setOrderMoney(busiReqBo.getOrderMoney());
        fscReceivableInfoPoInsert.setReceivableMoney(busiReqBo.getReceivableMoney());
        fscReceivableInfoPoInsert.setPurchaserId(busiReqBo.getPurchaserId());
        fscReceivableInfoPoInsert.setPurchaserName(busiReqBo.getPurchaserName());
        fscReceivableInfoPoInsert.setPurchaserUserType(Integer.valueOf(umcQryEnterpriseInfoDetailRspBo.getExtField2()));
        fscReceivableInfoPoInsert.setPayType(busiReqBo.getPayType());
        fscReceivableInfoPoInsert.setPayState(FscConstants.ReceivablePayState.WAIT_PAY);
        fscReceivableInfoPoInsert.setReceivableUserId(null);
        fscReceivableInfoPoInsert.setReceivableUserName("");
        fscReceivableInfoPoInsert.setPayedMoney(BigDecimal.ZERO);
        fscReceivableInfoPoInsert.setWaitPayMoney(busiReqBo.getReceivableMoney());
        fscReceivableInfoPoInsert.setReceivableType(busiReqBo.getReceivableType());
        fscReceivableInfoPoInsert.setReceivablePushState(FscConstants.ReceivablePushState.NOT_PUSH);
        fscReceivableInfoPoInsert.setRemark(busiReqBo.getRemark());
        fscReceivableInfoPoInsert.setCreateTime(new Date());
        fscReceivableInfoPoInsert.setPayOrderType(busiReqBo.getPayOrderType());
        fscReceivableInfoPoInsert.setCreateOperId(busiReqBo.getUserId());
        fscReceivableInfoPoInsert.setExtends6(umcQryEnterpriseInfoDetailRspBo.getExtField9());
        fscReceivableInfoPoInsert.setExtends1(busiReqBo.getOrderShouldPayId().toString());
        if (busiReqBo.getReceivableTime() != null) {
            fscReceivableInfoPoInsert.setExtends2(busiReqBo.getReceivableTime().toString());
        } else {
            fscReceivableInfoPoInsert.setExtends2("");
        }
        if (busiReqBo.getReceivableDate() != null) {
            fscReceivableInfoPoInsert.setExtends3(busiReqBo.getReceivableDate().toString());
        } else {
            fscReceivableInfoPoInsert.setExtends3("");
        }
        fscReceivableInfoPoInsert.setExtends4("1");
        int insert = this.fscReceivableInfoMapper.insert(fscReceivableInfoPoInsert);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u751f\u6210\u5e94\u6536\u8bb0\u5f55\u5931\u8d25");
        }
    }

    private UmcQryEnterpriseInfoDetailRspBo getUmcQryEnterpriseInfoDetailRspBo(FscLianDongCreateReceivableBusiReqBo busiReqBo) {
        UmcQryEnterpriseInfoDetailReqBo umcQryEnterpriseInfoDetailReqBo = new UmcQryEnterpriseInfoDetailReqBo();
        umcQryEnterpriseInfoDetailReqBo.setOrgId(busiReqBo.getPurchaserId());
        log.debug("\u67e5\u8be2\u4f1a\u5458\u7528\u6237\u7c7b\u578b\u5165\u53c2{}", (Object)umcQryEnterpriseInfoDetailReqBo);
        UmcQryEnterpriseInfoDetailRspBo umcQryEnterpriseInfoDetailRspBo = this.umcQryEnterpriseInfoDetailService.qryEnterpriseInfoDetail(umcQryEnterpriseInfoDetailReqBo);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u7528\u6237\u7c7b\u578b\u51fa\u53c2{}", (Object)umcQryEnterpriseInfoDetailRspBo);
        if (!"0000".equals(umcQryEnterpriseInfoDetailRspBo.getRespCode()) || StringUtils.isEmpty((Object)umcQryEnterpriseInfoDetailRspBo.getExtField2())) {
            throw new FscBusinessException(umcQryEnterpriseInfoDetailRspBo.getRespCode(), "\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u4fe1\u606f\u5931\u8d25\u6216\u6570\u636e\u4e3a\u7a7a");
        }
        return umcQryEnterpriseInfoDetailRspBo;
    }

    private void check(FscLianDongCreateReceivableBusiReqBo busiReqBo) {
        FscReceivableInfoPO fscReceivableInfoPo = new FscReceivableInfoPO();
        fscReceivableInfoPo.setExtends1(busiReqBo.getOrderShouldPayId().toString());
        fscReceivableInfoPo.setParentSaleOrderId(busiReqBo.getSaleOrderId());
        fscReceivableInfoPo.setPayOrderType(busiReqBo.getPayOrderType());
        fscReceivableInfoPo.setExtends4("1");
        FscReceivableInfoPO modelBy = this.fscReceivableInfoMapper.getModelBy(fscReceivableInfoPo);
        if (modelBy != null) {
            throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u5bf9\u5e94\u5e94\u4ed8\u5355\uff0c\u5e94\u4ed8\u5355ID\u4e3a\uff1a" + modelBy.getFscReceivableId());
        }
    }

    private CfcEncodedSerialGetServiceRspBO getCfcEncodedSerialGetServiceRspBo(FscLianDongCreateReceivableBusiReqBo busiReqBo) {
        log.debug("\u5f00\u59cb\u751f\u6210\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7{}", (Object)busiReqBo);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("RECEIVABLE_PAY_NO");
        log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u5165\u53c2{}", (Object)encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u51fa\u53c2{}", (Object)encodedSerialGetServicePayRspBO);
        if (CollectionUtils.isEmpty((Collection)encodedSerialGetServicePayRspBO.getSerialNoList())) {
            log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u5931\u8d25");
            throw new FscBusinessException("190000", "\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return encodedSerialGetServicePayRspBO;
    }
}

