/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.dyc.oc.service.order.UocQrySaleTemporaryContractService;
import com.tydic.dyc.oc.service.order.bo.QrySaleTemporaryContractBo;
import com.tydic.dyc.oc.service.order.bo.UocQrySaleTemporaryContractReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQrySaleTemporaryContractRspBo;
import com.tydic.fsc.bill.busi.api.FscLianDongDealNotCheckFscOrderBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealNotCheckFscOrderBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealNotCheckFscOrderBusiRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongDealNotCheckFscOrderBusiServiceImpl
implements FscLianDongDealNotCheckFscOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongDealNotCheckFscOrderBusiServiceImpl.class);
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private UocQrySaleTemporaryContractService uocQrySaleTemporaryContractService;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTORSERVICEDEALRELORDER = new ThreadPoolExecutor(CPU, 2 * CPU, 200L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("\u7f16\u8f91\u5bf9\u8d26\u5355\u79fb\u9664\u76f8\u5173\u9a8c\u6536\u5355\u5f00\u7968\u4fe1\u606f").build(), new ThreadPoolExecutor.AbortPolicy());
    @Value(value="${removeId:0000}")
    private Long removeId;

    @Override
    public FscLianDongDealNotCheckFscOrderBusiRspBo dealNotCheckFscOrder(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        FscOrderPO fscOrderModelPo = this.checkFscOrder(busiReqBo);
        this.updateInvoice(busiReqBo);
        if (!CollectionUtils.isEmpty(busiReqBo.getSaleOrderIdRemoveList())) {
            this.checkAfterFscOrder(busiReqBo);
            List<FscOrderRelationPO> fscOrderRelationPoList = this.checkFscOrderRelation(busiReqBo);
            List<Long> acceptOrderIdList = fscOrderRelationPoList.stream().map(FscOrderRelationPO::getAcceptOrderId).distinct().collect(Collectors.toList());
            List<FscOrderItemPO> fscOrderItemPoList = this.checkFscOrderItem(busiReqBo, acceptOrderIdList);
            this.delFscOrderRelation(fscOrderRelationPoList);
            this.delFscOrderItem(fscOrderItemPoList);
            this.setInfo(fscOrderModelPo, acceptOrderIdList, busiReqBo);
            this.dealRelUpdate(fscOrderRelationPoList);
        }
        this.sendMq(busiReqBo.getFscOrderId());
        FscLianDongDealNotCheckFscOrderBusiRspBo fscLianDongDealNotCheckFscOrderBusiRspBo = new FscLianDongDealNotCheckFscOrderBusiRspBo();
        fscLianDongDealNotCheckFscOrderBusiRspBo.setRespCode("0000");
        fscLianDongDealNotCheckFscOrderBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongDealNotCheckFscOrderBusiRspBo;
    }

    private void setInfo(FscOrderPO fscOrderModelPo, List<Long> acceptOrderIdList, FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        BigDecimal totalCharge = fscOrderModelPo.getTotalCharge();
        BigDecimal inspTotalBillMoney = fscOrderModelPo.getInspTotalBillMoney();
        BigDecimal inspTotalTransMoney = fscOrderModelPo.getInspTotalTransMoney();
        BigDecimal trueInvoicingSaleFee = fscOrderModelPo.getTrueInvoicingSaleFee();
        BigDecimal orderMoney = fscOrderModelPo.getOrderMoney();
        BigDecimal totalCombinedPaymentCredit = fscOrderModelPo.getTotalCombinedPaymentCredit();
        BigDecimal totalPaymentLimit = fscOrderModelPo.getTotalPaymentLimit();
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.getFscUocInspectionDetailsListPageQueryRspBo(acceptOrderIdList);
        this.setFirstOrFixed(totalCombinedPaymentCredit, totalPaymentLimit, inspectionDetailsList);
        this.setBill(totalCharge, inspTotalBillMoney, inspTotalTransMoney, trueInvoicingSaleFee, inspectionDetailsList);
        this.setOrder(orderMoney, inspectionDetailsList);
        FscOrderPO fscOrderPoSet = new FscOrderPO();
        fscOrderPoSet.setUpdateTime(new Date());
        fscOrderPoSet.setUpdateOperId(busiReqBo.getUserId() + "");
        fscOrderPoSet.setTotalCharge(totalCharge.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setInspTotalBillMoney(inspTotalBillMoney.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setInspTotalTransMoney(inspTotalTransMoney.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setTrueInvoicingSaleFee(trueInvoicingSaleFee.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setOrderMoney(orderMoney.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setTotalPaymentLimit(totalPaymentLimit.setScale(2, RoundingMode.HALF_UP));
        fscOrderPoSet.setTotalCombinedPaymentCredit(totalCombinedPaymentCredit.setScale(2, RoundingMode.HALF_UP));
        FscOrderPO fscOrderPoWhere = new FscOrderPO();
        fscOrderPoWhere.setFscOrderId(fscOrderModelPo.getFscOrderId());
        int update = this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5bf9\u8d26\u5355\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void setOrder(BigDecimal orderMoney, FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList) {
        Map<Long, List<FscUocInspectionDetailsListBO>> fscUocInspectionListBoMap = inspectionDetailsList.getRows().stream().collect(Collectors.groupingBy(FscUocInspectionDetailsListBO::getSaleOrderId));
        for (Long k : fscUocInspectionListBoMap.keySet()) {
            FscUocInspectionDetailsListBO fscUocInspectionDetailsListBo = fscUocInspectionListBoMap.get(k).get(0);
            orderMoney = orderMoney.subtract(fscUocInspectionDetailsListBo.getSaleOrderAmount());
        }
    }

    private void setBill(BigDecimal totalCharge, BigDecimal inspTotalBillMoney, BigDecimal inspTotalTransMoney, BigDecimal trueInvoicingSaleFee, FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList) {
        for (FscUocInspectionDetailsListBO row : inspectionDetailsList.getRows()) {
            if (row.getTrueInvoicingSaleFee() == null) {
                throw new FscBusinessException("190000", "\u6709\u9a8c\u6536\u5355\u9a8c\u6536\u91d1\u989d\u4e3a\u7a7a");
            }
            totalCharge = totalCharge.subtract(row.getTrueInvoicingSaleFee());
            trueInvoicingSaleFee = trueInvoicingSaleFee.subtract(row.getTrueInvoicingSaleFee());
            inspTotalBillMoney = inspTotalBillMoney.subtract(row.getTrueInvoicingSaleFee());
            if (row.getInspTotalSaleTransMoney() == null) continue;
            inspTotalBillMoney = inspTotalBillMoney.subtract(row.getInspTotalSaleTransMoney());
            inspTotalTransMoney = inspTotalTransMoney.subtract(row.getInspTotalSaleTransMoney());
        }
    }

    private void setFirstOrFixed(BigDecimal totalCombinedPaymentCredit, BigDecimal totalPaymentLimit, FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList) {
        List fscUocInspectionListFixed;
        List fscUocInspectionListFirst;
        List saleOrderIdList = inspectionDetailsList.getRows().stream().filter(fscUocInspectionDetailsListBO -> FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType()) || FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType())).map(FscUocInspectionDetailsListBO::getSaleOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(saleOrderIdList)) {
            UocQrySaleTemporaryContractReqBo uocQrySaleTemporaryContractReqBo = new UocQrySaleTemporaryContractReqBo();
            uocQrySaleTemporaryContractReqBo.setSaleOrderIds(saleOrderIdList);
            log.debug("\u5bf9\u8d26\u5355\u521b\u5efa\u8c03\u7528\u6388\u4fe1\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)uocQrySaleTemporaryContractReqBo);
            UocQrySaleTemporaryContractRspBo uocQrySaleTemporaryContractRspBo = this.uocQrySaleTemporaryContractService.qrySaleTemporaryContract(uocQrySaleTemporaryContractReqBo);
            log.debug("\u5bf9\u8d26\u5355\u521b\u5efa\u8c03\u7528\u6388\u4fe1\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)uocQrySaleTemporaryContractRspBo);
            if (!"0000".equals(uocQrySaleTemporaryContractRspBo.getRespCode())) {
                log.debug("\u67e5\u8be2\u5206\u644a\u6388\u4fe1\u989d\u5ea6\u5931\u8d25\u539f\u56e0{}", (Object)uocQrySaleTemporaryContractRspBo.getRespDesc());
                throw new FscBusinessException(uocQrySaleTemporaryContractRspBo.getRespCode(), "\u67e5\u8be2\u5206\u644a\u6388\u4fe1\u989d\u5ea6\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty((Collection)uocQrySaleTemporaryContractRspBo.getQrySaleTemporaryContractBoList()) || uocQrySaleTemporaryContractRspBo.getQrySaleTemporaryContractBoList().size() != saleOrderIdList.size()) {
                throw new FscBusinessException(uocQrySaleTemporaryContractRspBo.getRespCode(), "\u67e5\u8be2\u5206\u644a\u6388\u4fe1\u989d\u5ea6\u6570\u91cf\u4e3a\u7a7a\u6216\u4e0d\u4e00\u81f4");
            }
            for (QrySaleTemporaryContractBo qrySaleTemporaryContractBo : uocQrySaleTemporaryContractRspBo.getQrySaleTemporaryContractBoList()) {
                totalCombinedPaymentCredit = totalCombinedPaymentCredit.subtract(qrySaleTemporaryContractBo.getCombinedPaymentCredit());
                totalPaymentLimit = totalPaymentLimit.subtract(qrySaleTemporaryContractBo.getPaymentLimit());
            }
        }
        if (!CollectionUtils.isEmpty(fscUocInspectionListFirst = inspectionDetailsList.getRows().stream().filter(fscUocInspectionDetailsListBO -> FscConstants.PayOrderType.PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType())).collect(Collectors.toList()))) {
            for (FscUocInspectionDetailsListBO fscUocInspectionDetailsListBo : fscUocInspectionListFirst) {
                if (fscUocInspectionDetailsListBo.getTrueInvoicingSaleFee() == null) {
                    throw new FscBusinessException("190000", "\u6709\u9a8c\u6536\u5355\u9a8c\u6536\u91d1\u989d\u4e3a\u7a7a");
                }
                totalPaymentLimit = totalPaymentLimit.subtract(fscUocInspectionDetailsListBo.getTrueInvoicingSaleFee());
                if (fscUocInspectionDetailsListBo.getInspTotalSaleTransMoney() == null) continue;
                totalPaymentLimit = totalPaymentLimit.subtract(fscUocInspectionDetailsListBo.getInspTotalSaleTransMoney());
            }
        }
        if (!CollectionUtils.isEmpty(fscUocInspectionListFixed = inspectionDetailsList.getRows().stream().filter(fscUocInspectionDetailsListBO -> !FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType()) && !FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType()) && !FscConstants.PayOrderType.PAY_FIRST.equals(fscUocInspectionDetailsListBO.getPayType())).collect(Collectors.toList()))) {
            for (FscUocInspectionDetailsListBO fscUocInspectionDetailsListBo : fscUocInspectionListFixed) {
                if (fscUocInspectionDetailsListBo.getTrueInvoicingSaleFee() == null) {
                    throw new FscBusinessException("190000", "\u6709\u9a8c\u6536\u5355\u9a8c\u6536\u91d1\u989d\u4e3a\u7a7a");
                }
                totalCombinedPaymentCredit = totalCombinedPaymentCredit.subtract(fscUocInspectionDetailsListBo.getTrueInvoicingSaleFee());
                if (fscUocInspectionDetailsListBo.getInspTotalSaleTransMoney() == null) continue;
                totalCombinedPaymentCredit = totalCombinedPaymentCredit.subtract(fscUocInspectionDetailsListBo.getInspTotalSaleTransMoney());
            }
        }
    }

    private FscUocInspectionDetailsListPageQueryRspBO getFscUocInspectionDetailsListPageQueryRspBo(List<Long> acceptOrderIdList) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBo = new FscUocInspectionDetailsListPageQueryReqBO();
        fscUocInspectionDetailsListPageQueryReqBo.setInspOrderIdList(acceptOrderIdList);
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBo);
        if (!"0000".equals(inspectionDetailsList.getRespCode()) || CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows()) || inspectionDetailsList.getRows().size() != acceptOrderIdList.size()) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u5e94\u9a8c\u6536\u5355\u7684\u8fd0\u8d39\u4fe1\u606f\u53ca\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\u6216\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        return inspectionDetailsList;
    }

    private void delFscOrderItem(List<FscOrderItemPO> fscOrderItemPoList) {
        List collect = fscOrderItemPoList.stream().map(FscOrderItemPO::getId).distinct().collect(Collectors.toList());
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setIdList(collect);
        int delete = this.fscOrderItemMapper.deleteBy(fscOrderItemPo);
        if (delete != collect.size()) {
            throw new FscBusinessException("190000", "\u5220\u9664\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f");
        }
    }

    private void delFscOrderRelation(List<FscOrderRelationPO> fscOrderRelationPoList) {
        List collect = fscOrderRelationPoList.stream().map(FscOrderRelationPO::getId).distinct().collect(Collectors.toList());
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setIdList(collect);
        int delete = this.fscOrderRelationMapper.deleteBy(fscOrderRelationPo);
        if (delete != collect.size()) {
            throw new FscBusinessException("190000", "\u5220\u9664\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f");
        }
    }

    private List<FscOrderItemPO> checkFscOrderItem(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo, List<Long> acceptOrderIdList) {
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(busiReqBo.getFscOrderId());
        fscOrderItemPo.setAcceptOrderIds(acceptOrderIdList);
        List fscOrderItemMapperList = this.fscOrderItemMapper.getList(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u79fb\u9664\u5bf9\u8d26\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderItemMapperList;
    }

    private List<FscOrderRelationPO> checkFscOrderRelation(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(busiReqBo.getFscOrderId());
        fscOrderRelationPo.setSaleOrderIds(busiReqBo.getSaleOrderIdRemoveList());
        List fscOrderRelationMapperList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u79fb\u9664\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        List collect = fscOrderRelationMapperList.stream().map(FscOrderRelationPO::getSaleOrderId).distinct().collect(Collectors.toList());
        if (collect.size() != busiReqBo.getSaleOrderIdRemoveList().size()) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u79fb\u9664\u5173\u8054\u4fe1\u606f\u4e0e\u79fb\u9664\u4fe1\u606f\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        return fscOrderRelationMapperList;
    }

    private void checkAfterFscOrder(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setSaleOrderIdList(busiReqBo.getSaleOrderIdRemoveList());
        List fscOrderByNotCheck = this.fscOrderMapper.getFscOrderByNotCheck(fscOrderPo);
        if (!CollectionUtils.isEmpty((Collection)fscOrderByNotCheck)) {
            throw new FscBusinessException("190000", "\u79fb\u9664\u8ba2\u5355\u91cc\u9762\u6709\u8d85\u671f\u552e\u540e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664");
        }
    }

    private void updateInvoice(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        BeanUtils.copyProperties((Object)((Object)busiReqBo), (Object)fscOrderInvoicePo);
        this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePo);
        if (busiReqBo.getInvoiceCategory() != null) {
            Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
            if (FscConstants.FscInvoiceCategory.ELEC.equals(busiReqBo.getInvoiceCategory())) {
                elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
            }
            FscInvoiceRulePO fscInvoiceRulePo = new FscInvoiceRulePO();
            fscInvoiceRulePo.setFscOrderId(busiReqBo.getFscOrderId());
            fscInvoiceRulePo.setElecFlag(elecFlag);
            this.fscInvoiceRuleMapper.updateById(fscInvoiceRulePo);
        }
    }

    private FscOrderPO checkFscOrder(FscLianDongDealNotCheckFscOrderBusiReqBo busiReqBo) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(busiReqBo.getFscOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return fscOrderMapperModelBy;
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBo = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBo.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBo);
    }

    private void dealRelUpdate(List<FscOrderRelationPO> fscOrderRelationPoList) {
        EXECUTORSERVICEDEALRELORDER.execute(() -> fscOrderRelationPoList.forEach(fscOrderRelationPo -> {
            FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBo = new FscUocOrderRelUpdateReqBO();
            fscUocOrderRelUpdateReqBo.setRelId(this.removeId);
            fscUocOrderRelUpdateReqBo.setOperType(FscConstants.RelUpdateType.DEAL_FSC_ORDER);
            fscUocOrderRelUpdateReqBo.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            fscUocOrderRelUpdateReqBo.setRelType(FscConstants.FscRelType.INVOICE);
            fscUocOrderRelUpdateReqBo.setObjId(fscOrderRelationPo.getAcceptOrderId());
            fscUocOrderRelUpdateReqBo.setOrderId(fscOrderRelationPo.getOrderId());
            this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBo);
        }));
    }
}

