/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.service.ldOrganization.UmcQryLdOrgInfoDetailService;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcQryLdOrgInfoDetailRspBO;
import com.tydic.fsc.bill.busi.api.FscLianDongDealReceivableRefundBusiService;
import com.tydic.fsc.bill.busi.bo.ChargeCustomerDetailDTO;
import com.tydic.fsc.bill.busi.bo.ChargeDiscountDTO;
import com.tydic.fsc.bill.busi.bo.ForeignMatterApplyBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealReceivableRefundBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongDealReceivableRefundBusiRspBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongReceivableDownAddListBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongReceivableRefundBo;
import com.tydic.fsc.bill.busi.bo.LianDongFscPushReceivableSubtractReqBo;
import com.tydic.fsc.bill.busi.bo.LianDongFscReceiptQueryReqBo;
import com.tydic.fsc.bill.busi.bo.LianDongFscReceiptQueryRspBo;
import com.tydic.fsc.bill.busi.bo.ThirdQueryPaymentVo;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscReceivableInfoMapper;
import com.tydic.fsc.dao.FscReceivablePayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscReceivableInfoPO;
import com.tydic.fsc.po.FscReceivablePayPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscLianDongDealReceivableRefundBusiServiceImpl
implements FscLianDongDealReceivableRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongDealReceivableRefundBusiServiceImpl.class);
    @Autowired
    private FscReceivableInfoMapper fscReceivableInfoMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscReceivablePayMapper fscReceivablePayMapper;
    @Autowired
    private UmcQryLdOrgInfoDetailService umcQryLdOrgInfoDetailService;
    @Value(value="${PUSH_RECEIVABLE_REFUND:http://test1-lsugu.liando.cn}")
    private String PUSH_RECEIVABLE_REFUND;
    @Value(value="${PUSH_RECEIVABLE_DOWN:http://test1-lsugu.liando.cn}")
    private String PUSH_RECEIVABLE_DOWN;
    @Value(value="${PUSH_RECEIVABLE_DOWN:http://test1-lsugu.liando.cn}")
    private String PUSH_RECEIVABLE_FOREIGN_MATTER_APPLY;
    @Value(value="${RECEIPT_QUERY:http://test1-lsugu.liando.cn}")
    private String RECEIPT_QUERY;
    @Value(value="${PUSH_RECEIVABLE_DEL:http://test1-lsugu.liando.cn}")
    private String PUSH_RECEIVABLE_DEL;
    @Value(value="${PUSH_RECEIVABLE_SUBTRACT:http://test1-lsugu.liando.cn}")
    private String PUSH_RECEIVABLE_SUBTRACT;
    @Value(value="${receivableOrgIdWeb:1106732607002918912}")
    private Long receivableOrgIdWeb;

    @Override
    public FscLianDongDealReceivableRefundBusiRspBo dealReceivableRefund(FscLianDongDealReceivableRefundBusiReqBo busiReqBo) {
        log.debug("\u9006\u5411\u5e94\u6536API\u5b9e\u73b0\u7c7b\u5165\u53c2{}", (Object)busiReqBo);
        FscLianDongDealReceivableRefundBusiRspBo fscLianDongDealReceivableRefundBusiRspBo = new FscLianDongDealReceivableRefundBusiRspBo();
        fscLianDongDealReceivableRefundBusiRspBo.setRespCode("0000");
        fscLianDongDealReceivableRefundBusiRspBo.setRespDesc("\u6210\u529f");
        Date date = new Date();
        FscReceivableInfoPO fscReceivableInfoPoModel = new FscReceivableInfoPO();
        fscReceivableInfoPoModel = this.getFscReceivableInfoPo(busiReqBo, fscReceivableInfoPoModel);
        if (fscReceivableInfoPoModel == null) {
            return fscLianDongDealReceivableRefundBusiRspBo;
        }
        UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo = this.getUmcQryLdOrgInfoDetailRspBo();
        if (FscConstants.ReceivablePayState.PAYED.equals(fscReceivableInfoPoModel.getPayState())) {
            log.debug("\u5168\u90e8\u6536\u6b3e");
            this.dealPayed(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, date);
        } else if (FscConstants.ReceivablePayState.PART_PAY.equals(fscReceivableInfoPoModel.getPayState())) {
            log.debug("\u90e8\u5206\u6536\u6b3e");
            this.dealPartPay(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo);
        } else if (FscConstants.ReceivablePayState.WAIT_PAY.equals(fscReceivableInfoPoModel.getPayState())) {
            log.debug("\u5f85\u6536\u6b3e");
            this.dealNotPay(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo);
        } else {
            log.debug("\u5df2\u5220\u9664\u6216\u6570\u636e\u5f02\u5e38");
            return fscLianDongDealReceivableRefundBusiRspBo;
        }
        return fscLianDongDealReceivableRefundBusiRspBo;
    }

    private void dealNotPay(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, Date date, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo) {
        Map<Long, FscReceivablePayPO> fscReceivableNotPayPoMap = this.getLongFscReceivableNotPayPoMap(fscReceivableInfoPoModel);
        List<ThirdQueryPaymentVo> thirdQueryPaymentVoList = this.getReceipt(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo);
        if (fscReceivableNotPayPoMap.isEmpty()) {
            if (!CollectionUtils.isEmpty(thirdQueryPaymentVoList)) {
                log.debug("\u5b9e\u6536\u4fe1\u606f\u4e3a\u7a7a\u548c\u4e2d\u53f0\u8fd4\u56de\u5b9e\u6536\u4fe1\u606f\u4e0d\u4e3a\u7a7a");
                this.dealPayMapIsNull(thirdQueryPaymentVoList, fscReceivableInfoPoModel, date);
                this.check(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, thirdQueryPaymentVoList);
            }
        } else if (!CollectionUtils.isEmpty(thirdQueryPaymentVoList)) {
            log.debug("\u5b9e\u6536\u4fe1\u606f\u548c\u4e2d\u53f0\u8fd4\u56de\u5b9e\u6536\u4fe1\u606f\u90fd\u4e0d\u4e3a\u7a7a\u8d70\u90e8\u5206\u6536\u6b3e\u903b\u8f91");
            this.dealAllPartPay(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, fscReceivableNotPayPoMap, thirdQueryPaymentVoList);
        } else {
            throw new FscBusinessException("190000", "\u4e2d\u53f0\u5b9e\u6536\u4e3a\u7a7a\uff0cU\u8c37\u5b9e\u6536\u4e0d\u4e3a\u7a7a");
        }
    }

    private void dealAllPartPay(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, Date date, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, Map<Long, FscReceivablePayPO> fscReceivableNotPayPoMap, List<ThirdQueryPaymentVo> thirdQueryPaymentVoList) {
        this.dealPayNotNull(fscReceivableNotPayPoMap, thirdQueryPaymentVoList, fscReceivableInfoPoModel, date);
        this.check(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, thirdQueryPaymentVoList);
    }

    private void check(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, Date date, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, List<ThirdQueryPaymentVo> thirdQueryPaymentVoList) {
        BigDecimal totalChargePaid = thirdQueryPaymentVoList.stream().map(ThirdQueryPaymentVo::getChargePaid).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (totalChargePaid.compareTo(fscReceivableInfoPoModel.getReceivableMoney()) >= 0) {
            log.debug("\u5168\u90e8\u6536\u6b3e");
            this.updateReceviceInfo(date, fscReceivableInfoPoModel, totalChargePaid, fscReceivableInfoPoModel.getReceivableMoney(), FscConstants.ReceivablePayState.PAYED);
            this.dealPayed(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, date);
        } else if (totalChargePaid.compareTo(fscReceivableInfoPoModel.getReceivableMoney()) < 0) {
            log.debug("\u90e8\u5206\u6536\u6b3e");
            this.dealPartPayNew(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, totalChargePaid);
        }
    }

    private Map<Long, FscReceivablePayPO> getLongFscReceivableNotPayPoMap(FscReceivableInfoPO fscReceivableInfoPoModel) {
        FscReceivablePayPO fscReceivablePayPo = new FscReceivablePayPO();
        fscReceivablePayPo.setReceivableId(fscReceivableInfoPoModel.getFscReceivableId());
        log.debug("\u90e8\u5206\u6536\u6b3e\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u5165\u53c2{}", (Object)fscReceivablePayPo);
        List fscReceivablePayMapperList = this.fscReceivablePayMapper.getList(fscReceivablePayPo);
        log.debug("\u90e8\u5206\u6536\u6b3e\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u51fa\u53c2{}", (Object)fscReceivablePayMapperList);
        if (CollectionUtils.isEmpty((Collection)fscReceivablePayMapperList)) {
            return new HashMap<Long, FscReceivablePayPO>();
        }
        return fscReceivablePayMapperList.stream().collect(Collectors.toMap(FscReceivablePayPO::getPayId, o -> o));
    }

    private void dealPartPay(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, Date date, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo) {
        Map<Long, FscReceivablePayPO> fscReceivablePayPoMap = this.getLongFscReceivablePayPoMap(fscReceivableInfoPoModel);
        List<ThirdQueryPaymentVo> thirdQueryPaymentVoList = this.getReceipt(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo);
        this.dealAllPartPay(busiReqBo, date, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, fscReceivablePayPoMap, thirdQueryPaymentVoList);
    }

    private void dealPartPayNew(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, Date date, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, BigDecimal totalChargePaid) {
        this.updateReceviceInfo(date, fscReceivableInfoPoModel, totalChargePaid, fscReceivableInfoPoModel.getReceivableMoney(), FscConstants.ReceivablePayState.PART_PAY);
        if (busiReqBo.getReceivableMoney().negate().compareTo(fscReceivableInfoPoModel.getReceivableMoney().subtract(totalChargePaid)) == 0) {
            log.debug("\u9000\u6b3e\u91d1\u989d\u7b49\u4e8e\u5f85\u4ed8\u91d1\u989d");
            this.updateReceviceInfo(date, fscReceivableInfoPoModel, totalChargePaid, totalChargePaid, FscConstants.ReceivablePayState.PAYED);
            this.pushSubtract(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, busiReqBo.getReceivableMoney());
        } else if (busiReqBo.getReceivableMoney().negate().compareTo(fscReceivableInfoPoModel.getReceivableMoney().subtract(totalChargePaid)) < 0) {
            log.debug("\u9000\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5f85\u4ed8\u91d1\u989d");
            this.updateReceviceInfo(date, fscReceivableInfoPoModel, totalChargePaid, fscReceivableInfoPoModel.getReceivableMoney().add(busiReqBo.getReceivableMoney()), FscConstants.ReceivablePayState.PART_PAY);
            this.pushSubtract(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, busiReqBo.getReceivableMoney());
        } else {
            log.debug("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff08\u5fc5\u987b\u5728\u6700\u540e\u56e0\u4e3a\u6d89\u53ca\u5230\u6539\u53d8\u5165\u53c2\uff09");
            this.updateReceviceInfo(date, fscReceivableInfoPoModel, totalChargePaid, totalChargePaid, FscConstants.ReceivablePayState.PAYED);
            this.pushSubtract(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, fscReceivableInfoPoModel.getReceivableMoney().subtract(totalChargePaid));
            busiReqBo.setReceivableMoney(busiReqBo.getReceivableMoney().add(fscReceivableInfoPoModel.getReceivableMoney().subtract(totalChargePaid)));
            this.dealPayed(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, date);
        }
    }

    private void pushSubtract(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, BigDecimal discount) {
        LianDongFscPushReceivableSubtractReqBo lianDongFscPushReceivableSubtractReqBo = this.getLianDongFscPushReceivableSubtractReqBo(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, discount);
        this.doPostSubtract(busiReqBo, lianDongFscPushReceivableSubtractReqBo);
    }

    private void doPostSubtract(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, LianDongFscPushReceivableSubtractReqBo lianDongFscPushReceivableSubtractReqBo) {
        try {
            log.debug("\u63a8\u9001\u5e94\u6536\u51cf\u514dURL{}", (Object)this.PUSH_RECEIVABLE_SUBTRACT);
            log.debug("\u63a8\u9001\u5e94\u6536\u51cf\u514dBODY{}", (Object)lianDongFscPushReceivableSubtractReqBo);
            String result = HttpUtil.post((String)this.PUSH_RECEIVABLE_SUBTRACT, (String)JSONObject.toJSONString((Object)lianDongFscPushReceivableSubtractReqBo));
            log.debug("\u63a8\u9001\u5e94\u6536\u51cf\u514d\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObj.get((Object)"resultCode"))) {
                log.debug("\u63a8\u9001\u5e94\u6536\u51cf\u514d\u7cfb\u7edf\u5f02\u5e38");
                this.logUpdate(busiReqBo.getLogId(), result);
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u5e94\u6536\u51cf\u514d\u7cfb\u7edf\u5f02\u5e38");
            this.logUpdate(busiReqBo.getLogId(), e.getMessage());
            e.printStackTrace();
        }
    }

    private LianDongFscPushReceivableSubtractReqBo getLianDongFscPushReceivableSubtractReqBo(FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, BigDecimal discount) {
        LianDongFscPushReceivableSubtractReqBo lianDongFscPushReceivableSubtractReqBo = new LianDongFscPushReceivableSubtractReqBo();
        lianDongFscPushReceivableSubtractReqBo.setPrecinctId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        lianDongFscPushReceivableSubtractReqBo.setType("\u7279\u6b8a\u51cf\u514d");
        ChargeDiscountDTO chargeDiscountDto = new ChargeDiscountDTO();
        chargeDiscountDto.setId(fscReceivableInfoPoModel.getFscReceivableId().toString());
        chargeDiscountDto.setAccountFromType("\u8054\u4e1c\u94fe\u4e0aU\u8c37");
        chargeDiscountDto.setDiscount(discount);
        lianDongFscPushReceivableSubtractReqBo.setChargeDetailList(Collections.singletonList(chargeDiscountDto));
        return lianDongFscPushReceivableSubtractReqBo;
    }

    private void updateReceviceInfo(Date date, FscReceivableInfoPO fscReceivableInfoPoModel, BigDecimal totalChargePaid, BigDecimal receivableMoney, Integer payState) {
        FscReceivableInfoPO fscReceivableInfoPoSet = new FscReceivableInfoPO();
        fscReceivableInfoPoSet.setPayState(payState);
        fscReceivableInfoPoSet.setUpdateTime(date);
        fscReceivableInfoPoSet.setPayedMoney(totalChargePaid);
        fscReceivableInfoPoSet.setWaitPayMoney(receivableMoney.subtract(totalChargePaid));
        fscReceivableInfoPoSet.setReceivableMoney(receivableMoney);
        FscReceivableInfoPO fscReceivableInfoPoWhere = new FscReceivableInfoPO();
        fscReceivableInfoPoWhere.setFscReceivableId(fscReceivableInfoPoModel.getFscReceivableId());
        this.fscReceivableInfoMapper.updateBy(fscReceivableInfoPoSet, fscReceivableInfoPoWhere);
    }

    private void dealPayNotNull(Map<Long, FscReceivablePayPO> fscReceivablePayPoMap, List<ThirdQueryPaymentVo> thirdQueryPaymentVoList, FscReceivableInfoPO fscReceivableInfoPoModel, Date date) {
        ArrayList fscReceivablePayPoAddList = new ArrayList();
        thirdQueryPaymentVoList.forEach(thirdQueryPaymentVo -> {
            if (fscReceivablePayPoMap.get(thirdQueryPaymentVo.getId()) != null) {
                log.debug("\u4fee\u6539\u6536\u6b3e\u4fe1\u606f");
                this.updatePayInfo(fscReceivablePayPoMap, (ThirdQueryPaymentVo)thirdQueryPaymentVo);
            } else {
                log.debug("\u65b0\u589e\u6536\u6b3e\u4fe1\u606f");
                this.addList(fscReceivablePayPoAddList, fscReceivableInfoPoModel, (ThirdQueryPaymentVo)thirdQueryPaymentVo, date);
            }
        });
        if (!CollectionUtils.isEmpty(fscReceivablePayPoAddList)) {
            this.fscReceivablePayMapper.insertBatch(fscReceivablePayPoAddList);
        }
    }

    private void dealPayMapIsNull(List<ThirdQueryPaymentVo> thirdQueryPaymentVoList, FscReceivableInfoPO fscReceivableInfoPoModel, Date date) {
        ArrayList fscReceivablePayPoAddList = new ArrayList();
        thirdQueryPaymentVoList.forEach(thirdQueryPaymentVo -> {
            log.debug("\u65b0\u589e\u6536\u6b3e\u4fe1\u606f");
            this.addList(fscReceivablePayPoAddList, fscReceivableInfoPoModel, (ThirdQueryPaymentVo)thirdQueryPaymentVo, date);
        });
        if (!CollectionUtils.isEmpty(fscReceivablePayPoAddList)) {
            this.fscReceivablePayMapper.insertBatch(fscReceivablePayPoAddList);
        }
    }

    private void addList(ArrayList<FscReceivablePayPO> fscReceivablePayPoAddList, FscReceivableInfoPO finalFscReceivableInfoPoModel, ThirdQueryPaymentVo thirdQueryPaymentVo, Date date) {
        FscReceivablePayPO fscReceivablePayPo = new FscReceivablePayPO();
        fscReceivablePayPo.setPayId(thirdQueryPaymentVo.getId());
        fscReceivablePayPo.setReceivableId(finalFscReceivableInfoPoModel.getFscReceivableId());
        fscReceivablePayPo.setReceivablePayId(Long.valueOf(Sequence.getInstance().nextId()));
        fscReceivablePayPo.setThisPayMoney(thirdQueryPaymentVo.getChargePaid());
        fscReceivablePayPo.setPayTime(thirdQueryPaymentVo.getOperatorDate().toString());
        fscReceivablePayPo.setCreateTime(date);
        fscReceivablePayPoAddList.add(fscReceivablePayPo);
    }

    private void updatePayInfo(Map<Long, FscReceivablePayPO> fscReceivablePayPoMap, ThirdQueryPaymentVo thirdQueryPaymentVo) {
        FscReceivablePayPO fscReceivablePayPo = fscReceivablePayPoMap.get(thirdQueryPaymentVo.getId());
        fscReceivablePayPo.setPayTime(thirdQueryPaymentVo.getOperatorDate().toString());
        fscReceivablePayPo.setThisPayMoney(thirdQueryPaymentVo.getChargePaid());
        FscReceivablePayPO fscReceivablePayPoWhere = new FscReceivablePayPO();
        fscReceivablePayPoWhere.setPayId(thirdQueryPaymentVo.getId());
        this.fscReceivablePayMapper.updateBy(fscReceivablePayPo, fscReceivablePayPoWhere);
    }

    private Map<Long, FscReceivablePayPO> getLongFscReceivablePayPoMap(FscReceivableInfoPO fscReceivableInfoPoModel) {
        FscReceivablePayPO fscReceivablePayPo = new FscReceivablePayPO();
        fscReceivablePayPo.setReceivableId(fscReceivableInfoPoModel.getFscReceivableId());
        log.debug("\u90e8\u5206\u6536\u6b3e\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u5165\u53c2{}", (Object)fscReceivablePayPo);
        List fscReceivablePayMapperList = this.fscReceivablePayMapper.getList(fscReceivablePayPo);
        log.debug("\u90e8\u5206\u6536\u6b3e\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u51fa\u53c2{}", (Object)fscReceivablePayMapperList);
        if (CollectionUtils.isEmpty((Collection)fscReceivablePayMapperList)) {
            throw new FscBusinessException("190000", "\u90e8\u5206\u6536\u6b3e\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscReceivablePayMapperList.stream().collect(Collectors.toMap(FscReceivablePayPO::getPayId, o -> o));
    }

    private List<ThirdQueryPaymentVo> getReceipt(FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo) {
        LianDongFscReceiptQueryReqBo lianDongFscReceiptQueryReqBo = new LianDongFscReceiptQueryReqBo();
        lianDongFscReceiptQueryReqBo.setPrecinctId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        lianDongFscReceiptQueryReqBo.setChargeDetailIDs(Collections.singletonList(String.valueOf(fscReceivableInfoPoModel.getFscReceivableId())));
        try {
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606fURL{}", (Object)this.RECEIPT_QUERY);
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606fBODY{}", (Object)lianDongFscReceiptQueryReqBo);
            String result = HttpUtil.post((String)this.RECEIPT_QUERY, (String)JSONObject.toJSONString((Object)lianDongFscReceiptQueryReqBo));
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObj.get((Object)"resultCode"))) {
                log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u7cfb\u7edf\u5f02\u5e38");
                throw new FscBusinessException("190000", (String)resultObj.get((Object)"resultMsg"));
            }
            LianDongFscReceiptQueryRspBo lianDongFscReceiptQueryRspBo = (LianDongFscReceiptQueryRspBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), LianDongFscReceiptQueryRspBo.class);
            if (CollectionUtils.isEmpty(lianDongFscReceiptQueryRspBo.getResultData())) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5b9e\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
            }
            List<ThirdQueryPaymentVo> thirdQueryPaymentVoList = lianDongFscReceiptQueryRspBo.getResultData().stream().filter(thirdQueryOrderVo -> thirdQueryOrderVo.getIsDelete() == 0).flatMap(thirdQueryOrderVo -> thirdQueryOrderVo.getPaymentList().stream()).filter(paymentVo -> paymentVo.getIsDelete() == 0).filter(paymentVo -> !"998".equals(paymentVo.getSquareTypeID())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(thirdQueryPaymentVoList)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u5b9e\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
            }
            return thirdQueryPaymentVoList;
        }
        catch (Exception e) {
            log.debug("\u67e5\u8be2\u6536\u6b3e\u4fe1\u606f\u7cfb\u7edf\u5f02\u5e38");
            throw new FscBusinessException("190000", e.getMessage());
        }
    }

    private void dealPayed(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = dateFormat.format(date);
        SimpleDateFormat dateFormatOther = new SimpleDateFormat("yyyyMM");
        String formatOther = dateFormatOther.format(date);
        SimpleDateFormat dateFormatRefund = new SimpleDateFormat("yyyyMM-dd hh:mm:ss");
        String formatRefund = dateFormatRefund.format(date);
        FscReceivableInfoPO fscReceivableInfoPoRefund = this.insertInfo(busiReqBo, fscReceivableInfoPoModel, date);
        List<String> payIdList = this.getPayIdList(fscReceivableInfoPoModel);
        if (FscConstants.PayOrderTypeInfo.FIRST.equals(fscReceivableInfoPoModel.getPayOrderType()) && !StringUtils.isEmpty((Object)fscReceivableInfoPoModel.getExtends8()) && FscConstants.payOrderChannel.PAY_UP.toString().equals(fscReceivableInfoPoModel.getExtends8())) {
            log.debug("\u7ebf\u4e0a\u652f\u4ed8\u9884\u4ed8\u6b3e");
            this.dealFirstUpRefundByPayed(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, format, formatOther, formatRefund, fscReceivableInfoPoRefund, payIdList, date);
        } else {
            log.debug("\u7ebf\u4e0b\u652f\u4ed8\u9884\u4ed8\u6b3e\u6216\u5c3e\u6b3e");
            this.dealDownRefundByPayed(busiReqBo, fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, format, formatOther, formatRefund, fscReceivableInfoPoRefund, payIdList, date);
        }
    }

    private void dealDownRefundByPayed(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, String format, String formatOther, String formatRefund, FscReceivableInfoPO fscReceivableInfoPoRefund, List<String> payIdList, Date date) {
        ForeignMatterApplyBo foreignMatterApplyBo = this.getForeignMatterApplyBo(fscReceivableInfoPoRefund);
        String resultMessageForeignMatterApply = this.doPostForeignMatterApply(busiReqBo, foreignMatterApplyBo);
        FscLianDongReceivableDownAddListBo fscLianDongReceivableDownAddListBo = this.getFscLianDongReceivableDownAddListBo(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, format, formatOther, busiReqBo.getReceivableMoney(), busiReqBo.getRemark());
        String resultMessage = this.doPostDown(busiReqBo, fscLianDongReceivableDownAddListBo);
        FscLianDongReceivableRefundBo fscLianDongReceivableRefundBo = this.getFscLianDongReceivableRefundBo(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, formatRefund, fscReceivableInfoPoRefund, payIdList, FscConstants.ReceivableRefundType.YES, FscConstants.ReceivableRefundTransType.NO);
        this.doPostRefund(busiReqBo, fscReceivableInfoPoModel, fscLianDongReceivableRefundBo, resultMessage, resultMessageForeignMatterApply, date);
    }

    private String doPostForeignMatterApply(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, ForeignMatterApplyBo foreignMatterApplyBo) {
        String resultMessage = "";
        try {
            log.debug("\u63a8\u9001\u4e8b\u9879\u7533\u8bf7\u5355URL{}", (Object)this.PUSH_RECEIVABLE_FOREIGN_MATTER_APPLY);
            log.debug("\u63a8\u9001\u4e8b\u9879\u7533\u8bf7\u5355BODY{}", (Object)foreignMatterApplyBo);
            String result = HttpUtil.post((String)this.PUSH_RECEIVABLE_FOREIGN_MATTER_APPLY, (String)JSONObject.toJSONString((Object)foreignMatterApplyBo));
            log.debug("\u63a8\u9001\u4e8b\u9879\u7533\u8bf7\u5355\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"0".equals(resultObj.get((Object)"code"))) {
                log.debug("\u63a8\u9001\u4e8b\u9879\u7533\u8bf7\u5355\u7cfb\u7edf\u5f02\u5e38");
                this.logUpdate(busiReqBo.getLogId(), result);
                resultMessage = result;
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u4e8b\u9879\u7533\u8bf7\u5355\u7cfb\u7edf\u5f02\u5e38");
            this.logUpdate(busiReqBo.getLogId(), e.getMessage());
            resultMessage = e.getMessage();
            e.printStackTrace();
        }
        return resultMessage;
    }

    private ForeignMatterApplyBo getForeignMatterApplyBo(FscReceivableInfoPO fscReceivableInfoPoRefund) {
        ForeignMatterApplyBo foreignMatterApplyBo = new ForeignMatterApplyBo();
        foreignMatterApplyBo.setMatterId(fscReceivableInfoPoRefund.getFscReceivableId().toString());
        foreignMatterApplyBo.setApplyAmt(fscReceivableInfoPoRefund.getReceivableMoney());
        foreignMatterApplyBo.setRemark(fscReceivableInfoPoRefund.getRemark());
        foreignMatterApplyBo.setSourceSystem("UValley");
        foreignMatterApplyBo.setStatus("300");
        return foreignMatterApplyBo;
    }

    private void dealFirstUpRefundByPayed(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, String format, String formatOther, String formatRefund, FscReceivableInfoPO fscReceivableInfoPoRefund, List<String> payIdList, Date date) {
        FscLianDongReceivableDownAddListBo fscLianDongReceivableDownAddListBo = this.getFscLianDongReceivableDownAddListBo(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, format, formatOther, busiReqBo.getReceivableMoney(), busiReqBo.getRemark());
        String resultMessage = this.doPostDown(busiReqBo, fscLianDongReceivableDownAddListBo);
        FscLianDongReceivableRefundBo fscLianDongReceivableRefundBo = this.getFscLianDongReceivableRefundBo(fscReceivableInfoPoModel, umcQryLdOrgInfoDetailRspBo, formatRefund, fscReceivableInfoPoRefund, payIdList, FscConstants.ReceivableRefundType.NO, FscConstants.ReceivableRefundTransType.YES);
        this.doPostRefund(busiReqBo, fscReceivableInfoPoModel, fscLianDongReceivableRefundBo, resultMessage, "", date);
    }

    private FscLianDongReceivableRefundBo getFscLianDongReceivableRefundBo(FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, String formatRefund, FscReceivableInfoPO fscReceivableInfoPoRefund, List<String> payIdList, int directRefundFlag, int toPrePayment) {
        FscLianDongReceivableRefundBo fscLianDongReceivableRefundBo = new FscLianDongReceivableRefundBo();
        fscLianDongReceivableRefundBo.setPaymentIds(payIdList);
        fscLianDongReceivableRefundBo.setPrecinctId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        fscLianDongReceivableRefundBo.setHouseId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        fscLianDongReceivableRefundBo.setOwnerId(fscReceivableInfoPoModel.getExtends6());
        fscLianDongReceivableRefundBo.setRefundAmount(fscReceivableInfoPoRefund.getReceivableMoney());
        fscLianDongReceivableRefundBo.setRefundDate(formatRefund);
        fscLianDongReceivableRefundBo.setRemark(fscReceivableInfoPoRefund.getRemark());
        fscLianDongReceivableRefundBo.setSquareTypeId(fscReceivableInfoPoModel.getExtends8());
        fscLianDongReceivableRefundBo.setDirectRefundFlag(directRefundFlag);
        fscLianDongReceivableRefundBo.setToPrePayment(toPrePayment);
        return fscLianDongReceivableRefundBo;
    }

    private void doPostRefund(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, FscLianDongReceivableRefundBo fscLianDongReceivableRefundBo, String resultMessage, String resultMessageForeignMatterApply, Date date) {
        try {
            log.debug("\u63a8\u9001\u9000\u6b3eURL{}", (Object)this.PUSH_RECEIVABLE_REFUND);
            log.debug("\u63a8\u9001\u9000\u6b3eBODY{}", (Object)fscLianDongReceivableRefundBo);
            String result = HttpUtil.post((String)this.PUSH_RECEIVABLE_REFUND, (String)JSONObject.toJSONString((Object)fscLianDongReceivableRefundBo));
            log.debug("\u63a8\u9001\u9000\u6b3e\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObj.get((Object)"resultCode"))) {
                log.debug("\u63a8\u9001\u9000\u6b3e\u7cfb\u7edf\u5f02\u5e38");
                this.logUpdate(busiReqBo.getLogId(), "\u4e8b\u9879\u7533\u8bf7\u5355\uff1a" + resultMessageForeignMatterApply + "\u8d1f\u6570\u5e94\u6536\uff1a" + resultMessage + "\u63a8\u9001\u9000\u6b3e" + result);
            } else {
                this.updatePushState(fscReceivableInfoPoModel, date);
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u9000\u6b3e\u7cfb\u7edf\u5f02\u5e38");
            this.logUpdate(busiReqBo.getLogId(), "\u4e8b\u9879\u7533\u8bf7\u5355\uff1a" + resultMessageForeignMatterApply + "\u8d1f\u6570\u5e94\u6536\uff1a" + resultMessage + "\u63a8\u9001\u9000\u6b3e" + e.getMessage());
            e.printStackTrace();
        }
    }

    private List<String> getPayIdList(FscReceivableInfoPO fscReceivableInfoPoModel) {
        FscReceivablePayPO fscReceivablePayPo = new FscReceivablePayPO();
        fscReceivablePayPo.setReceivableId(fscReceivableInfoPoModel.getFscReceivableId());
        List fscReceivablePayPoList = this.fscReceivablePayMapper.getList(fscReceivablePayPo);
        if (CollectionUtils.isEmpty((Collection)fscReceivablePayPoList)) {
            throw new FscBusinessException("190000", "\u5168\u90e8\u6536\u6b3e\u67e5\u8be2\u5b9e\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscReceivablePayPoList.stream().map(FscReceivablePayPO::getPayId).map(Object::toString).collect(Collectors.toList());
    }

    private UmcQryLdOrgInfoDetailRspBO getUmcQryLdOrgInfoDetailRspBo() {
        UmcQryLdOrgInfoDetailReqBO umcQryLdOrgInfoDetailReqBo = new UmcQryLdOrgInfoDetailReqBO();
        umcQryLdOrgInfoDetailReqBo.setOrgIdWeb(this.receivableOrgIdWeb);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u5165\u53c2{}", (Object)umcQryLdOrgInfoDetailReqBo);
        UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo = this.umcQryLdOrgInfoDetailService.qryLdOrgInfoDetail(umcQryLdOrgInfoDetailReqBo);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u51fa\u53c2{}", (Object)umcQryLdOrgInfoDetailRspBo);
        if (!"0000".equals(umcQryLdOrgInfoDetailRspBo.getRespCode()) || umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO() == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbPkCorp()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbCorpName())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4f1a\u5458\u9879\u76eeID\u5931\u8d25\u6216\u6570\u636e\u4e3a\u7a7a");
        }
        return umcQryLdOrgInfoDetailRspBo;
    }

    private FscLianDongReceivableDownAddListBo getFscLianDongReceivableDownAddListBo(FscReceivableInfoPO fscReceivableInfoPoModel, UmcQryLdOrgInfoDetailRspBO umcQryLdOrgInfoDetailRspBo, String format, String formatOther, BigDecimal receivableMoney, String remark) {
        FscLianDongReceivableDownAddListBo fscLianDongReceivableDownAddListBo = new FscLianDongReceivableDownAddListBo();
        fscLianDongReceivableDownAddListBo.setThirdOrderNo(fscReceivableInfoPoModel.getFscReceivableId().toString());
        ChargeCustomerDetailDTO chargeCustomerDetailDto = new ChargeCustomerDetailDTO();
        chargeCustomerDetailDto.setId(fscReceivableInfoPoModel.getFscReceivableId().toString());
        chargeCustomerDetailDto.setPrecinctId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbNum());
        chargeCustomerDetailDto.setOwnerId(fscReceivableInfoPoModel.getExtends7());
        chargeCustomerDetailDto.setAccountFromType("\u8054\u4e1c\u94fe\u4e0aU\u8c37");
        chargeCustomerDetailDto.setCalcStartDate(format);
        chargeCustomerDetailDto.setCalcEndDate(format);
        chargeCustomerDetailDto.setShouldChargeDate(format);
        chargeCustomerDetailDto.setAccountBook(formatOther);
        chargeCustomerDetailDto.setChargeSum(receivableMoney);
        chargeCustomerDetailDto.setDiscount(BigDecimal.ZERO);
        chargeCustomerDetailDto.setReceivingBusinessId(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbPkCorp());
        chargeCustomerDetailDto.setReceivingBusiness(umcQryLdOrgInfoDetailRspBo.getUmcLdOrgInfoDetailBO().getPbCorpName());
        chargeCustomerDetailDto.setRemark(remark);
        chargeCustomerDetailDto.setChargeItemId("");
        fscLianDongReceivableDownAddListBo.setShouldPaidList(Collections.singletonList(chargeCustomerDetailDto));
        return fscLianDongReceivableDownAddListBo;
    }

    private void updatePushState(FscReceivableInfoPO fscReceivableInfoPoModel, Date date) {
        FscReceivableInfoPO fscReceivableInfoPoSet = new FscReceivableInfoPO();
        fscReceivableInfoPoSet.setReceivablePushState(FscConstants.ReceivablePushState.PUSHED);
        fscReceivableInfoPoSet.setPayState(FscConstants.ReceivablePayState.PAYED);
        fscReceivableInfoPoSet.setUpdateTime(date);
        FscReceivableInfoPO fscReceivableInfoPoWhere = new FscReceivableInfoPO();
        fscReceivableInfoPoWhere.setFscReceivableId(fscReceivableInfoPoModel.getFscReceivableId());
        this.fscReceivableInfoMapper.updateBy(fscReceivableInfoPoSet, fscReceivableInfoPoWhere);
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }

    private String doPostDown(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscLianDongReceivableDownAddListBo fscLianDongReceivableDownAddListBo) {
        String resultMessage = "";
        try {
            log.debug("\u8d1f\u6570\u63a8\u9001\u6279\u91cf\u5e94\u6536URL{}", (Object)this.PUSH_RECEIVABLE_DOWN);
            log.debug("\u8d1f\u6570\u63a8\u9001\u6279\u91cf\u5e94\u6536BODY{}", (Object)fscLianDongReceivableDownAddListBo);
            String result = HttpUtil.post((String)this.PUSH_RECEIVABLE_DOWN, (String)JSONObject.toJSONString((Object)fscLianDongReceivableDownAddListBo));
            log.debug("\u8d1f\u6570\u63a8\u9001\u6279\u91cf\u5e94\u6536\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObj.get((Object)"resultCode"))) {
                log.debug("\u8d1f\u6570\u63a8\u9001\u6279\u91cf\u5e94\u6536\u7cfb\u7edf\u5f02\u5e38");
                this.logUpdate(busiReqBo.getLogId(), result);
                resultMessage = result;
            }
        }
        catch (Exception e) {
            log.debug("\u8d1f\u6570\u63a8\u9001\u6279\u91cf\u5e94\u6536\u7cfb\u7edf\u5f02\u5e38");
            this.logUpdate(busiReqBo.getLogId(), e.getMessage());
            resultMessage = e.getMessage();
            e.printStackTrace();
        }
        return resultMessage;
    }

    private FscReceivableInfoPO insertInfo(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel, Date date) {
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBo = this.getCfcEncodedSerialGetServiceRspBo(busiReqBo);
        FscReceivableInfoPO fscReceivableInfoPoInsert = (FscReceivableInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscReceivableInfoPoModel), FscReceivableInfoPO.class);
        fscReceivableInfoPoInsert.setParentSaleOrderId(busiReqBo.getSaleOrderId());
        fscReceivableInfoPoInsert.setParentSaleOrderNo(busiReqBo.getSaleOrderNo());
        fscReceivableInfoPoInsert.setReceivableMoney(busiReqBo.getReceivableMoney());
        fscReceivableInfoPoInsert.setRemark(busiReqBo.getRemark());
        fscReceivableInfoPoInsert.setCreateTime(date);
        fscReceivableInfoPoInsert.setUpdateTime(null);
        fscReceivableInfoPoInsert.setUpdateOperId(null);
        fscReceivableInfoPoInsert.setFscReceivableId(Long.valueOf(Sequence.getInstance().nextId()));
        fscReceivableInfoPoInsert.setFscReceivableNo((String)encodedSerialGetServicePayRspBo.getSerialNoList().get(0));
        fscReceivableInfoPoInsert.setReceivablePushState(FscConstants.ReceivablePushState.NOT_PUSH);
        fscReceivableInfoPoInsert.setPayState(FscConstants.ReceivablePayState.WAIT_PAY);
        fscReceivableInfoPoInsert.setPayedMoney(BigDecimal.ZERO);
        fscReceivableInfoPoInsert.setWaitPayMoney(busiReqBo.getReceivableMoney());
        fscReceivableInfoPoInsert.setReceivablePushTime(null);
        fscReceivableInfoPoInsert.setExtends4("2");
        int insert = this.fscReceivableInfoMapper.insert(fscReceivableInfoPoInsert);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u9006\u5411\u5e94\u6536\u4fe1\u606f\u5931\u8d25");
        }
        return fscReceivableInfoPoInsert;
    }

    private CfcEncodedSerialGetServiceRspBO getCfcEncodedSerialGetServiceRspBo(FscLianDongDealReceivableRefundBusiReqBo busiReqBo) {
        log.debug("\u5f00\u59cb\u751f\u6210\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7{}", (Object)busiReqBo);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("RECEIVABLE_PAY_NO");
        log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u5165\u53c2{}", (Object)encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u51fa\u53c2{}", (Object)encodedSerialGetServicePayRspBO);
        if (CollectionUtils.isEmpty((Collection)encodedSerialGetServicePayRspBO.getSerialNoList())) {
            log.debug("\u67e5\u8be2\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u5931\u8d25");
            throw new FscBusinessException("190000", "\u5e94\u6536\u7533\u8bf7\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return encodedSerialGetServicePayRspBO;
    }

    private FscReceivableInfoPO getFscReceivableInfoPo(FscLianDongDealReceivableRefundBusiReqBo busiReqBo, FscReceivableInfoPO fscReceivableInfoPoModel) {
        FscReceivableInfoPO modelBy;
        FscReceivableInfoPO fscReceivableInfoPo;
        if (FscConstants.PayOrderTypeInfo.FIRST.equals(busiReqBo.getPayOrderType())) {
            log.debug("\u9884\u4ed8\u6b3e\u9006\u5411");
            fscReceivableInfoPo = new FscReceivableInfoPO();
            fscReceivableInfoPo.setExtends1(busiReqBo.getOrderShouldPayId().toString());
            fscReceivableInfoPo.setExtends4("1");
            modelBy = this.fscReceivableInfoMapper.getModelBy(fscReceivableInfoPo);
            fscReceivableInfoPoModel = modelBy == null ? null : modelBy;
        }
        if (FscConstants.PayOrderTypeInfo.BALANCE.equals(busiReqBo.getPayOrderType())) {
            log.debug("\u5c3e\u6b3e\u9006\u5411");
            fscReceivableInfoPo = new FscReceivableInfoPO();
            fscReceivableInfoPo.setExtends1(busiReqBo.getOrderShouldPayId().toString());
            fscReceivableInfoPo.setExtends4("1");
            fscReceivableInfoPo.setParentSaleOrderId(busiReqBo.getSaleOrderId());
            modelBy = this.fscReceivableInfoMapper.getModelBy(fscReceivableInfoPo);
            if (modelBy == null) {
                log.debug("\u5c3e\u6b3e\u5230\u8d27\u7c7b\u9006\u5411");
                FscReceivableInfoPO fscReceivableInfoPoAfter = new FscReceivableInfoPO();
                fscReceivableInfoPoAfter.setExtends1(busiReqBo.getOrderShouldPayId().toString());
                fscReceivableInfoPoAfter.setExtends4("1");
                FscReceivableInfoPO fscReceivableInfoPoAfterModel = this.fscReceivableInfoMapper.getModelBy(fscReceivableInfoPoAfter);
                fscReceivableInfoPoModel = fscReceivableInfoPoAfterModel == null ? null : fscReceivableInfoPoAfterModel;
            } else {
                fscReceivableInfoPoModel = modelBy;
            }
        }
        return fscReceivableInfoPoModel;
    }
}

