/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscLianDongDelFscNeedPayInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongDelFscNeedPayInvoiceBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongDelFscNeedPayInvoiceBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscNeedPayInvoiceMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscNeedPayInvoicePO;
import com.tydic.fsc.po.FscNeedPayPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscLianDongDelFscNeedPayInvoiceBusiServiceImpl
implements FscLianDongDelFscNeedPayInvoiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongDelFscNeedPayInvoiceBusiServiceImpl.class);
    @Autowired
    private FscNeedPayInvoiceMapper fscNeedPayInvoiceMapper;
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;

    @Override
    public FscLianDongDelFscNeedPayInvoiceBusiRspBo delFscNeedPayInvoice(FscLianDongDelFscNeedPayInvoiceBusiReqBo busiReqBo) {
        FscNeedPayInvoicePO qryFscNeedPayInvoicePo = new FscNeedPayInvoicePO();
        qryFscNeedPayInvoicePo.setNeedPayInvoiceIds(busiReqBo.getNeedPayInvoiceIds());
        qryFscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        List fscNeedPayInvoicePos = this.fscNeedPayInvoiceMapper.getList(qryFscNeedPayInvoicePo);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayInvoicePos)) {
            throw new FscBusinessException("190000", "\u5220\u9664\u7684\u53d1\u7968\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5");
        }
        if (fscNeedPayInvoicePos.size() != busiReqBo.getNeedPayInvoiceIds().size()) {
            throw new FscBusinessException("190000", "\u9700\u8981\u5220\u9664\u7684\u53d1\u7968\u4e2d\u6709\u4e0d\u5b58\u5728\u7684\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5");
        }
        for (Long needPayInvoiceId : busiReqBo.getNeedPayInvoiceIds()) {
            FscNeedPayInvoicePO setPo = new FscNeedPayInvoicePO();
            setPo.setIsDel(FscConstants.DELETE_TAG.DELETED);
            setPo.setUpdateTime(new Date());
            setPo.setUpdateOperId(busiReqBo.getUserId());
            FscNeedPayInvoicePO wherePo = new FscNeedPayInvoicePO();
            wherePo.setNeedPayInvoiceId(needPayInvoiceId);
            int update = this.fscNeedPayInvoiceMapper.updateBy(setPo, wherePo);
            if (update >= 1) continue;
            throw new FscBusinessException("190000", "\u5220\u9664\u53d1\u7968\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        this.updatePayNeedState(((FscNeedPayInvoicePO)fscNeedPayInvoicePos.get(0)).getNeedPayId());
        FscLianDongDelFscNeedPayInvoiceBusiRspBo busiRspBo = new FscLianDongDelFscNeedPayInvoiceBusiRspBo();
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u6210\u529f");
        return busiRspBo;
    }

    private void updatePayNeedState(Long needPayId) {
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setNeedPayId(needPayId);
        FscNeedPayPO modelBy = this.fscNeedPayMapper.getModelBy(fscNeedPayPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        FscNeedPayInvoicePO qryFscNeedPayInvoicePo = new FscNeedPayInvoicePO();
        qryFscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        qryFscNeedPayInvoicePo.setNeedPayId(needPayId);
        List fscNeedPayInvoicePoList = this.fscNeedPayInvoiceMapper.getList(qryFscNeedPayInvoicePo);
        FscNeedPayPO fscNeedPayPoSet = new FscNeedPayPO();
        FscNeedPayPO fscNeedPayPoQry = new FscNeedPayPO();
        fscNeedPayPoQry.setPurchaseOrderIds(Collections.singletonList(modelBy.getPurchaseOrderId()));
        fscNeedPayPoQry.setPayOrderType(modelBy.getPayOrderType());
        fscNeedPayPoQry.setExtend1(modelBy.getExtend1());
        List fscNeedPayMapperList = this.fscNeedPayMapper.getListNotBillAfter(fscNeedPayPo);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayMapperList)) {
            throw new FscBusinessException("190000", "\u5f00\u7968\u540e\u5224\u65ad\u72b6\u6001\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        BigDecimal needPayAmount = BigDecimal.ZERO;
        BigDecimal needPayWaitAmount = BigDecimal.ZERO;
        for (FscNeedPayPO fscNeedPayPoModelIn : fscNeedPayMapperList) {
            needPayAmount = needPayAmount.add(fscNeedPayPoModelIn.getNeedPayMoney());
            needPayWaitAmount = needPayWaitAmount.add(fscNeedPayPoModelIn.getWaitPayMoney());
        }
        if (CollectionUtils.isEmpty((Collection)fscNeedPayInvoicePoList)) {
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) < 0 || needPayWaitAmount.compareTo(needPayAmount) > 0) {
                throw new FscBusinessException("190000", "\u5e94\u4ed8\u5355\u6709\u8bef");
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) > 0 && needPayWaitAmount.compareTo(needPayAmount) < 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PART_NEED_PAY);
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) > 0 && needPayWaitAmount.compareTo(needPayAmount) == 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY);
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_NOT_INVOICE);
            }
        } else {
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) < 0 || needPayWaitAmount.compareTo(needPayAmount) > 0) {
                throw new FscBusinessException("190000", "\u5e94\u4ed8\u5355\u6709\u8bef");
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) > 0 && needPayWaitAmount.compareTo(needPayAmount) < 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PART_NEED_PAY_INVOICE);
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) > 0 && needPayWaitAmount.compareTo(needPayAmount) == 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY_INVOICE);
            }
            if (needPayWaitAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscNeedPayPoSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_INVOICE);
            }
        }
        FscNeedPayPO fscNeedPayPoWhere = new FscNeedPayPO();
        fscNeedPayPoWhere.setNeedPayId(needPayId);
        int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoSet, fscNeedPayPoWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u53d1\u7968\u72b6\u6001\u5931\u8d25");
        }
    }
}

