/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.service.weekdayConfig.UmcGetWorkingDayService;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataRspBo;
import com.tydic.fsc.bill.ability.bo.NeedPayBo;
import com.tydic.fsc.bill.busi.api.FscLianDongNeedPayCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayCreateBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayCreateBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractMapper;
import com.tydic.fsc.dao.FscContractPayMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractPO;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscNeedPayPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongNeedPayCreateBusiServiceImpl
implements FscLianDongNeedPayCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongNeedPayCreateBusiServiceImpl.class);
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscContractPayMapper fscContractPayMapper;
    @Autowired
    private FscContractMapper fscContractMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private UmcGetWorkingDayService umcGetWorkingDayService;
    @Value(value="${COST_A_NAME:\u5317\u4eac\u94fe\u4e0a\u4f18\u8c37\u79d1\u6280\u6709\u9650\u516c\u53f8}")
    private String COST_A_NAME;
    @Value(value="${COST_A_ID:305775845729763336}")
    private String COST_A_ID;

    @Override
    public FscLianDongNeedPayCreateBusiRspBo createNeedPay(FscLianDongNeedPayCreateBusiReqBo busiReqBo) {
        log.debug("\u5e94\u4ed8\u521b\u5efa\u5165\u53c2{}", (Object)busiReqBo);
        if (FscConstants.ForwardOrBackward.FORWARD.equals(busiReqBo.getNeedPayBoList().get(0).getForwardOrBackward())) {
            this.check(busiReqBo);
        }
        List<FscNeedPayPO> fscNeedPayPoList = this.getFscNeedPayPoList(busiReqBo);
        log.debug("\u65b0\u589e\u5e94\u4ed8\u4fe1\u606f{}", fscNeedPayPoList);
        this.fscNeedPayMapper.insertBatch(fscNeedPayPoList);
        FscLianDongNeedPayCreateBusiRspBo fscLianDongNeedPayCreateBusiRspBo = new FscLianDongNeedPayCreateBusiRspBo();
        fscLianDongNeedPayCreateBusiRspBo.setRespCode("0000");
        fscLianDongNeedPayCreateBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongNeedPayCreateBusiRspBo;
    }

    private List<FscNeedPayPO> getFscNeedPayPoList(FscLianDongNeedPayCreateBusiReqBo busiReqBo) {
        ArrayList<FscNeedPayPO> fscNeedPayPoList = new ArrayList<FscNeedPayPO>();
        busiReqBo.getNeedPayBoList().forEach(needPayBo -> {
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.getCfcEncodedSerialGetServiceRspBO(busiReqBo);
            FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
            fscNeedPayPo.setNeedPayDate("");
            if (needPayBo.getNeedPayTime() != null) {
                Date needPayTime = needPayBo.getNeedPayTime();
                if (needPayBo.getNeedPayDate() != null) {
                    UmcGetWorkingDayByDataReqBo umcGetWorkingDayByDataReqBo = new UmcGetWorkingDayByDataReqBo();
                    umcGetWorkingDayByDataReqBo.setIsContain(Boolean.valueOf(false));
                    umcGetWorkingDayByDataReqBo.setDate(needPayBo.getNeedPayTime());
                    umcGetWorkingDayByDataReqBo.setWorkingDayNum(needPayBo.getNeedPayDate().intValue());
                    UmcGetWorkingDayByDataRspBo workingDayByData = this.umcGetWorkingDayService.getWorkingDayByData(umcGetWorkingDayByDataReqBo);
                    if (!"0000".equals(workingDayByData.getRespCode())) {
                        throw new FscBusinessException("190000", "\u67e5\u8be2\u4f1a\u5458\u5de5\u4f5c\u65e5\u5931\u8d25");
                    }
                    needPayTime = workingDayByData.getDate();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String dateString = dateFormat.format(needPayTime);
                fscNeedPayPo.setNeedPayDate(dateString);
            }
            fscNeedPayPo.setNeedPayId(Long.valueOf(Sequence.getInstance().nextId()));
            fscNeedPayPo.setNeedPayCode((String)encodedSerialGetServicePayRspBO.getSerialNoList().get(0));
            fscNeedPayPo.setPurchaseOrderId(needPayBo.getSaleOrderId());
            fscNeedPayPo.setPurchaseOrderCode(needPayBo.getSaleOrderNo());
            fscNeedPayPo.setPurchaseId(Long.valueOf(this.COST_A_ID));
            fscNeedPayPo.setPurchaseName(this.COST_A_NAME);
            fscNeedPayPo.setSupplierId(needPayBo.getSupplierId());
            fscNeedPayPo.setSupplierName(needPayBo.getSupplierName());
            fscNeedPayPo.setNeedPayMoney(needPayBo.getNeedPayMoney());
            fscNeedPayPo.setPayedMoney(BigDecimal.ZERO);
            fscNeedPayPo.setWaitPayMoney(needPayBo.getNeedPayMoney());
            fscNeedPayPo.setNeedPayType(needPayBo.getNeedPayType());
            fscNeedPayPo.setPayOrderType(needPayBo.getPayOrderType());
            fscNeedPayPo.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY);
            fscNeedPayPo.setCreateOperId(needPayBo.getCreateOperId());
            fscNeedPayPo.setCreateTime(new Date());
            fscNeedPayPo.setExtend1(needPayBo.getNeedPayOrderType() + "");
            fscNeedPayPo.setExtend2(needPayBo.getForwardOrBackward() + "");
            fscNeedPayPo.setExtend3(needPayBo.getBackwardType() + "");
            fscNeedPayPo.setExtend4(FscConstants.ReceivablePushState.NOT_PUSH.toString());
            fscNeedPayPo.setExtend5(needPayBo.getAfterOrderId() + "");
            fscNeedPayPoList.add(fscNeedPayPo);
        });
        return fscNeedPayPoList;
    }

    private List<FscNeedPayPO> getFscNeedPayPoList(FscLianDongNeedPayCreateBusiReqBo busiReqBo, FscContractPO modelBy, Map<String, FscContractPayPO> fscContractPayPoMap) {
        ArrayList<FscNeedPayPO> fscNeedPayPoList = new ArrayList<FscNeedPayPO>();
        busiReqBo.getNeedPayBoList().forEach(needPayBo -> {
            FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
            fscNeedPayPo.setNeedPayDate("");
            if (needPayBo.getNeedPayTime() != null) {
                Date needPayTime = needPayBo.getNeedPayTime();
                if (needPayBo.getNeedPayDate() != null) {
                    UmcGetWorkingDayByDataReqBo umcGetWorkingDayByDataReqBo = new UmcGetWorkingDayByDataReqBo();
                    umcGetWorkingDayByDataReqBo.setIsContain(Boolean.valueOf(false));
                    umcGetWorkingDayByDataReqBo.setDate(needPayBo.getNeedPayTime());
                    umcGetWorkingDayByDataReqBo.setWorkingDayNum(needPayBo.getNeedPayDate().intValue());
                    UmcGetWorkingDayByDataRspBo workingDayByData = this.umcGetWorkingDayService.getWorkingDayByData(umcGetWorkingDayByDataReqBo);
                    if (!"0000".equals(workingDayByData.getRespCode())) {
                        throw new FscBusinessException("190000", "\u67e5\u8be2\u4f1a\u5458\u5de5\u4f5c\u65e5\u5931\u8d25");
                    }
                    needPayTime = workingDayByData.getDate();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String dateString = dateFormat.format(needPayTime);
                fscNeedPayPo.setNeedPayDate(dateString);
            }
            FscContractPayPO fscContractPayPoModel = (FscContractPayPO)fscContractPayPoMap.get(needPayBo.getSaleOrderId() + needPayBo.getPayOrderType().toString());
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.getCfcEncodedSerialGetServiceRspBO(busiReqBo);
            fscNeedPayPo.setNeedPayId(Long.valueOf(Sequence.getInstance().nextId()));
            fscNeedPayPo.setNeedPayCode((String)encodedSerialGetServicePayRspBO.getSerialNoList().get(0));
            fscNeedPayPo.setContractPayId(fscContractPayPoModel.getContractPayId());
            fscNeedPayPo.setCtrctId(null);
            fscNeedPayPo.setCtrctCode(modelBy.getCtrctCode());
            fscNeedPayPo.setCtrctName(modelBy.getCtrctName());
            fscNeedPayPo.setPurchaseOrderId(needPayBo.getSaleOrderId());
            fscNeedPayPo.setPurchaseOrderCode(needPayBo.getSaleOrderNo());
            fscNeedPayPo.setPurchaseId(Long.valueOf(modelBy.getCtrctFrgsId()));
            fscNeedPayPo.setPurchaseName(modelBy.getCtrctFrgsName());
            fscNeedPayPo.setSupplierId(Long.valueOf(modelBy.getCtrctKsdaId()));
            fscNeedPayPo.setSupplierName(modelBy.getCtrctKsdaName());
            fscNeedPayPo.setNeedPayMoney(fscContractPayPoModel.getContractPayPlanAmount());
            fscNeedPayPo.setPayedMoney(BigDecimal.ZERO);
            fscNeedPayPo.setWaitPayMoney(fscContractPayPoModel.getContractPayPlanAmount());
            fscNeedPayPo.setNeedPayType(needPayBo.getNeedPayType());
            fscNeedPayPo.setPayOrderType(needPayBo.getPayOrderType());
            fscNeedPayPo.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY);
            fscNeedPayPo.setCreateOperId(needPayBo.getCreateOperId());
            fscNeedPayPo.setCreateTime(new Date());
            fscNeedPayPo.setExtend1(needPayBo.getNeedPayOrderType() + "");
            fscNeedPayPo.setExtend2(needPayBo.getForwardOrBackward() + "");
            fscNeedPayPo.setExtend3(needPayBo.getBackwardType() + "");
            fscNeedPayPo.setExtend4(FscConstants.ReceivablePushState.NOT_PUSH.toString());
            fscNeedPayPoList.add(fscNeedPayPo);
        });
        return fscNeedPayPoList;
    }

    private Map<String, FscContractPayPO> getStringFscContractPayPOMap(FscLianDongNeedPayCreateBusiReqBo busiReqBo) {
        FscContractPayPO fscContractPayPo = new FscContractPayPO();
        fscContractPayPo.setPurchaseOrderId(busiReqBo.getNeedPayBoList().get(0).getSaleOrderId());
        fscContractPayPo.setIsDel(FscConstants.DicDelFlag.NO);
        List fscContractPayMapperList = this.fscContractPayMapper.getList(fscContractPayPo);
        if (CollectionUtils.isEmpty((Collection)fscContractPayMapperList)) {
            throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f");
        }
        log.debug("\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u5206\u7ec4\u524d\u7ed3\u679c{}", (Object)fscContractPayMapperList);
        Map<String, FscContractPayPO> fscContractPayPoMap = fscContractPayMapperList.stream().collect(Collectors.toMap(e -> e.getPurchaseOrderId() + e.getExtend2(), e -> e));
        log.debug("\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u5206\u7ec4\u540e\u7ed3\u679c{}", fscContractPayPoMap);
        busiReqBo.getNeedPayBoList().forEach(needPayBo -> {
            if (fscContractPayPoMap.get(needPayBo.getSaleOrderId() + needPayBo.getPayOrderType().toString()) == null) {
                throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f");
            }
        });
        return fscContractPayPoMap;
    }

    private FscContractPO getFscContractPo(FscLianDongNeedPayCreateBusiReqBo busiReqBo) {
        FscContractPO fscContractPo = new FscContractPO();
        fscContractPo.setPurchaseOrderId(busiReqBo.getNeedPayBoList().get(0).getSaleOrderId());
        fscContractPo.setIsDel(FscConstants.DicDelFlag.NO);
        FscContractPO modelBy = this.fscContractMapper.getModelBy(fscContractPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f");
        }
        return modelBy;
    }

    private void check(FscLianDongNeedPayCreateBusiReqBo busiReqBo) {
        List saleOrderIds = busiReqBo.getNeedPayBoList().stream().map(NeedPayBo::getSaleOrderId).collect(Collectors.toList());
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setPurchaseOrderIds(saleOrderIds);
        fscNeedPayPo.setExtend2(FscConstants.ForwardOrBackward.FORWARD.toString());
        log.debug("\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u521b\u5efa\u4e86\u6b63\u5411\u5e94\u4ed8\u5165\u53c2{}", (Object)fscNeedPayPo);
        List fscNeedPayMapperList = this.fscNeedPayMapper.getList(fscNeedPayPo);
        log.debug("\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u521b\u5efa\u4e86\u6b63\u5411\u5e94\u4ed8\u51fa\u53c2{}", (Object)fscNeedPayMapperList);
        if (!CollectionUtils.isEmpty((Collection)fscNeedPayMapperList)) {
            List collect = fscNeedPayMapperList.stream().map(e -> e.getPurchaseOrderId() + (long)e.getNeedPayType().intValue() + (long)e.getPayOrderType().intValue()).collect(Collectors.toList());
            busiReqBo.getNeedPayBoList().forEach(needPayBo -> {
                if (collect.contains(needPayBo.getSaleOrderId() + (long)needPayBo.getNeedPayType().intValue() + (long)needPayBo.getPayOrderType().intValue())) {
                    throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u5df2\u7ecf\u521b\u5efa\u4e86\u6b63\u5411\u5e94\u4ed8");
                }
            });
        }
    }

    private CfcEncodedSerialGetServiceRspBO getCfcEncodedSerialGetServiceRspBO(FscLianDongNeedPayCreateBusiReqBo busiReqBO) {
        log.debug("\u5f00\u59cb\u751f\u6210\u5e94\u4ed8\u7533\u8bf7\u5355\u7f16\u53f7{}", (Object)busiReqBO);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("NEED_PAY_NO");
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u7533\u8bf7\u5355\u7f16\u53f7\u5165\u53c2{}", (Object)encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServicePayRspBO = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u7533\u8bf7\u5355\u7f16\u53f7\u51fa\u53c2{}", (Object)encodedSerialGetServicePayRspBO);
        if (CollectionUtils.isEmpty((Collection)encodedSerialGetServicePayRspBO.getSerialNoList())) {
            log.debug("\u67e5\u8be2\u5e94\u4ed8\u7533\u8bf7\u5355\u7f16\u53f7\u5931\u8d25");
            throw new FscBusinessException("190000", "\u5e94\u4ed8\u7533\u8bf7\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return encodedSerialGetServicePayRspBO;
    }
}

