/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.NeedPayFscCallBackBo;
import com.tydic.fsc.bill.busi.api.FscLianDongNeedPayFscCallBackBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayFscCallBackBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayFscCallBackBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscNeedPayInvoiceMapper;
import com.tydic.fsc.dao.FscNeedPayItemMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscNeedPayInvoicePO;
import com.tydic.fsc.po.FscNeedPayItemPO;
import com.tydic.fsc.po.FscNeedPayPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongNeedPayFscCallBackBusiServiceImpl
implements FscLianDongNeedPayFscCallBackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongNeedPayFscCallBackBusiServiceImpl.class);
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscNeedPayItemMapper fscNeedPayItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscNeedPayInvoiceMapper fscNeedPayInvoiceMapper;

    @Override
    public FscLianDongNeedPayFscCallBackBusiRspBo dealNeedPayFscCallBack(FscLianDongNeedPayFscCallBackBusiReqBo busiReqBo) {
        log.debug("\u6210\u672c\u5e94\u4ed8\u7ed3\u679c\u56de\u4f20API(\u7ed3\u7b97)\u5f00\u59cb");
        List<String> fscOrderNoList = busiReqBo.getPayResultList().stream().map(NeedPayFscCallBackBo::getFscOrderNo).collect(Collectors.toList());
        List<FscOrderPO> fscOrderMapperListCallBack = this.getFscOrderPoList(busiReqBo, fscOrderNoList);
        List<FscOrderRelationPO> fscOrderRelationMapperList = this.getFscOrderRelationPoList(fscOrderMapperListCallBack);
        List<Long> saleOrderIds = fscOrderRelationMapperList.stream().map(FscOrderRelationPO::getSaleOrderId).distinct().collect(Collectors.toList());
        List<FscNeedPayPO> fscNeedPayMapperList = this.getFscNeedPayPoList(saleOrderIds);
        this.dealInfo(busiReqBo, fscNeedPayMapperList);
        FscLianDongNeedPayFscCallBackBusiRspBo fscLianDongNeedPayFscCallBackBusiRspBo = new FscLianDongNeedPayFscCallBackBusiRspBo();
        fscLianDongNeedPayFscCallBackBusiRspBo.setRespCode("0000");
        fscLianDongNeedPayFscCallBackBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongNeedPayFscCallBackBusiRspBo;
    }

    private void dealInfo(FscLianDongNeedPayFscCallBackBusiReqBo busiReqBo, List<FscNeedPayPO> fscNeedPayMapperList) {
        ArrayList<FscNeedPayItemPO> fscNeedPayItemPoList = new ArrayList<FscNeedPayItemPO>();
        Date date = new Date();
        BigDecimal payAmount = busiReqBo.getPayAmount();
        this.setInfo(busiReqBo, fscNeedPayMapperList, fscNeedPayItemPoList, date, payAmount);
        log.debug("\u4ed8\u6b3e\u660e\u7ec6\u503c\u96c6\u5408{}", fscNeedPayItemPoList);
        if (!CollectionUtils.isEmpty(fscNeedPayItemPoList)) {
            this.fscNeedPayItemMapper.insertBatch(fscNeedPayItemPoList);
        }
    }

    private void setInfo(FscLianDongNeedPayFscCallBackBusiReqBo busiReqBo, List<FscNeedPayPO> fscNeedPayMapperList, List<FscNeedPayItemPO> fscNeedPayItemPoList, Date date, BigDecimal payAmount) {
        Map<Long, List<FscNeedPayPO>> fscNeedPayPoBillRefundListMap = fscNeedPayMapperList.stream().filter(fscNeedPayPoBillRefund -> FscConstants.ForwardOrBackward.BACKWARD.toString().equals(fscNeedPayPoBillRefund.getExtend2())).collect(Collectors.groupingBy(FscNeedPayPO::getPurchaseOrderId));
        List fscNeedPayPoBillList = fscNeedPayMapperList.stream().filter(fscNeedPayPoBill -> FscConstants.ForwardOrBackward.FORWARD.toString().equals(fscNeedPayPoBill.getExtend2())).collect(Collectors.toList());
        Map<Long, List<FscNeedPayPO>> collect = fscNeedPayMapperList.stream().collect(Collectors.groupingBy(FscNeedPayPO::getPurchaseOrderId));
        for (FscNeedPayPO fscNeedPayPoModel : fscNeedPayPoBillList) {
            ArrayList<FscNeedPayPO> fscNeedPayPoList = new ArrayList();
            if (fscNeedPayPoBillRefundListMap != null && !CollectionUtils.isEmpty((Collection)fscNeedPayPoBillRefundListMap.get(fscNeedPayPoModel.getPurchaseOrderId()))) {
                fscNeedPayPoList = fscNeedPayPoBillRefundListMap.get(fscNeedPayPoModel.getPurchaseOrderId());
            }
            BigDecimal needPayAmountBalance = BigDecimal.ZERO;
            BigDecimal needPayWaitAmountBalance = BigDecimal.ZERO;
            for (FscNeedPayPO fscNeedPayPoModelFor : collect.get(fscNeedPayPoModel.getPurchaseOrderId())) {
                needPayAmountBalance = fscNeedPayPoModelFor.getNeedPayMoney().add(needPayAmountBalance);
                needPayWaitAmountBalance = fscNeedPayPoModelFor.getWaitPayMoney().add(needPayWaitAmountBalance);
            }
            if (payAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            if (needPayWaitAmountBalance.compareTo(BigDecimal.ZERO) < 0) {
                log.debug("\u6709\u8ba2\u5355\u5f85\u4ed8\u91d1\u989d\u5c0f\u4e8e0");
                throw new FscBusinessException("190000", "\u6709\u8ba2\u5355\u5f85\u4ed8\u91d1\u989d\u5c0f\u4e8e0");
            }
            if (needPayWaitAmountBalance.compareTo(BigDecimal.ZERO) == 0) {
                log.debug("\u6709\u8ba2\u5355\u5f85\u4ed8\u91d1\u989d\u7b49\u4e8e0");
                continue;
            }
            if (needPayWaitAmountBalance.compareTo(BigDecimal.ZERO) <= 0) continue;
            log.debug("\u6709\u8ba2\u5355\u5f85\u4ed8\u91d1\u989d\u7b49\u5927\u4e8e0");
            if (payAmount.compareTo(needPayWaitAmountBalance) < 0) {
                log.debug("\u5269\u4f59\u4ed8\u6b3e\u91d1\u989d\u4e0d\u591f\u586b\u5145\u6240\u6709\u5f85\u4ed8\u91d1\u989d");
                this.updatePayNeed(fscNeedPayPoModel, fscNeedPayPoModel.getPayedMoney().add(payAmount), fscNeedPayPoModel.getWaitPayMoney().subtract(payAmount), FscConstants.FscNeedPayState.PART_NEED_PAY, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoModel, fscNeedPayItemPoList, payAmount, date);
                break;
            }
            if (payAmount.compareTo(needPayWaitAmountBalance) == 0) {
                log.debug("\u5269\u4f59\u4ed8\u6b3e\u91d1\u989d\u521a\u597d\u591f\u586b\u5145\u6240\u6709\u5f85\u4ed8\u91d1\u989d");
                this.updatePayNeed(fscNeedPayPoModel, needPayAmountBalance, BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoModel, fscNeedPayItemPoList, payAmount, date);
                if (CollectionUtils.isEmpty(fscNeedPayPoList)) break;
                this.updatePayNeedRefund(fscNeedPayPoList, date);
                break;
            }
            if (payAmount.compareTo(needPayWaitAmountBalance) > 0) {
                log.debug("\u5269\u4f59\u4ed8\u6b3e\u91d1\u989d\u521a\u591f\u586b\u5145\u6240\u6709\u5f85\u4ed8\u91d1\u989d,\u5e76\u4e14\u8fd8\u6709\u5269\u4f59");
                int lastIndex = fscNeedPayPoBillList.size() - 1;
                FscNeedPayPO lastElement = (FscNeedPayPO)fscNeedPayPoBillList.get(lastIndex);
                if (lastElement.getPurchaseOrderId().equals(fscNeedPayPoModel.getPurchaseOrderId())) {
                    this.updatePayNeed(fscNeedPayPoModel, payAmount, BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                    this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoModel, fscNeedPayItemPoList, payAmount, date);
                    if (!CollectionUtils.isEmpty(fscNeedPayPoList)) {
                        this.updatePayNeedRefund(fscNeedPayPoList, date);
                    }
                    payAmount = BigDecimal.ZERO;
                } else {
                    this.updatePayNeed(fscNeedPayPoModel, needPayAmountBalance, BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                    this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoModel, fscNeedPayItemPoList, needPayWaitAmountBalance, date);
                    if (!CollectionUtils.isEmpty(fscNeedPayPoList)) {
                        this.updatePayNeedRefund(fscNeedPayPoList, date);
                    }
                    payAmount = payAmount.subtract(needPayWaitAmountBalance);
                }
            }
            log.debug("\u5faa\u73af\u540e\u4ed8\u6b3e\u5269\u4f59\u91d1\u989d{}", (Object)payAmount);
        }
    }

    private void updatePayNeedRefund(List<FscNeedPayPO> fscNeedPayPoList, Date date) {
        fscNeedPayPoList.forEach(fscNeedPayPo -> {
            FscNeedPayPO fscNeedPayPoOnSet = new FscNeedPayPO();
            fscNeedPayPoOnSet.setWaitPayMoney(BigDecimal.ZERO);
            fscNeedPayPoOnSet.setPayedMoney(fscNeedPayPo.getNeedPayMoney());
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_NOT_INVOICE);
            fscNeedPayPoOnSet.setUpdateTime(date);
            FscNeedPayPO fscNeedPayPoOnWhere = new FscNeedPayPO();
            fscNeedPayPoOnWhere.setNeedPayId(fscNeedPayPo.getNeedPayId());
            log.debug("\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f{}{}", (Object)fscNeedPayPoOnSet, (Object)fscNeedPayPoOnWhere);
            int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoOnSet, fscNeedPayPoOnWhere);
            if (update < 1) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
            }
        });
    }

    private List<FscNeedPayPO> getFscNeedPayPoList(List<Long> saleOrderIds) {
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setExtend1(FscConstants.NeedPayOrderType.BILL_PAY.toString());
        fscNeedPayPo.setPayOrderType(FscConstants.PayOrderTypeInfo.BALANCE);
        fscNeedPayPo.setPurchaseOrderIds(saleOrderIds);
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u96c6\u5408\u5165\u53c2{}", (Object)fscNeedPayPo);
        List fscNeedPayMapperList = this.fscNeedPayMapper.getListNotBillAfter(fscNeedPayPo);
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u96c6\u5408\u51fa\u53c2{}", (Object)fscNeedPayMapperList);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayMapperList) || fscNeedPayMapperList.size() != saleOrderIds.size()) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u5e94\u4ed8\u4fe1\u606f\u6570\u91cf\u4e0e\u91c7\u8d2d\u5355\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        return fscNeedPayMapperList;
    }

    private List<FscOrderRelationPO> getFscOrderRelationPoList(List<FscOrderPO> fscOrderMapperListCallBack) {
        List fscOrderIds = fscOrderMapperListCallBack.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(fscOrderIds);
        log.debug("\u67e5\u8be2\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u96c6\u5408\u5165\u53c2{}", (Object)fscOrderRelationPo);
        List fscOrderRelationMapperList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        log.debug("\u67e5\u8be2\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u96c6\u5408\u51fa\u53c2{}", (Object)fscOrderRelationMapperList);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderRelationMapperList;
    }

    private List<FscOrderPO> getFscOrderPoList(FscLianDongNeedPayFscCallBackBusiReqBo busiReqBo, List<String> fscOrderNoList) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setOrderNos(fscOrderNoList);
        log.debug("\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f\u96c6\u5408\u5165\u53c2{}", (Object)fscOrderPo);
        List fscOrderMapperListCallBack = this.fscOrderMapper.getList(fscOrderPo);
        log.debug("\u67e5\u8be2\u5bf9\u8d26\u5355\u4fe1\u606f\u96c6\u5408\u51fa\u53c2{}", (Object)fscOrderMapperListCallBack);
        if (CollectionUtils.isEmpty((Collection)fscOrderMapperListCallBack) || fscOrderMapperListCallBack.size() != busiReqBo.getPayResultList().size()) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4e3a\u7a7a\u6216\u8005\u5bf9\u8d26\u5355\u6570\u91cf\u4e0e\u4ed8\u6b3e\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        return fscOrderMapperListCallBack;
    }

    private void updatePayNeed(FscNeedPayPO fscNeedPayPo, BigDecimal payedAmount, BigDecimal waitPayAmount, Integer needPayState, Date date) {
        FscNeedPayPO fscNeedPayPoOnWhere = new FscNeedPayPO();
        fscNeedPayPoOnWhere.setNeedPayId(fscNeedPayPo.getNeedPayId());
        FscNeedPayPO fscNeedPayPoOnSet = new FscNeedPayPO();
        fscNeedPayPoOnSet.setWaitPayMoney(waitPayAmount);
        fscNeedPayPoOnSet.setPayedMoney(payedAmount);
        fscNeedPayPoOnSet.setNeedPayState(needPayState);
        fscNeedPayPoOnSet.setUpdateTime(date);
        this.setNeedPayState(fscNeedPayPo, needPayState, fscNeedPayPoOnSet);
        log.debug("\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f{}{}", (Object)fscNeedPayPoOnSet, (Object)fscNeedPayPoOnWhere);
        int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoOnSet, fscNeedPayPoOnWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void setNeedPayState(FscNeedPayPO fscNeedPayPo, Integer needPayState, FscNeedPayPO fscNeedPayPoOnSet) {
        FscNeedPayInvoicePO fscNeedPayInvoicePo = new FscNeedPayInvoicePO();
        fscNeedPayInvoicePo.setNeedPayId(fscNeedPayPo.getNeedPayId());
        fscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        List list = this.fscNeedPayInvoiceMapper.getList(fscNeedPayInvoicePo);
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.PAYED_NOT_INVOICE.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_INVOICE);
        }
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.PART_NEED_PAY.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PART_NEED_PAY_INVOICE);
        }
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.NEED_PAY.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY_INVOICE);
        }
    }

    private void AddNeedItem(Date payTime, FscNeedPayPO fscNeedPayPo, List<FscNeedPayItemPO> fscNeedPayItemPoList, BigDecimal amount, Date date) {
        FscNeedPayItemPO fscNeedPayItemPo = new FscNeedPayItemPO();
        fscNeedPayItemPo.setCtrctCode(fscNeedPayPo.getCtrctCode());
        fscNeedPayItemPo.setCtrctName(fscNeedPayPo.getCtrctName());
        fscNeedPayItemPo.setCreateTime(date);
        fscNeedPayItemPo.setCreateOperId(fscNeedPayPo.getCreateOperId());
        fscNeedPayItemPo.setNeedPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscNeedPayItemPo.setNeedPayItemType(fscNeedPayPo.getNeedPayType());
        fscNeedPayItemPo.setPayTime(payTime);
        fscNeedPayItemPo.setPayMoney(amount);
        fscNeedPayItemPo.setNeedPayId(fscNeedPayPo.getNeedPayId());
        fscNeedPayItemPoList.add(fscNeedPayItemPo);
    }
}

