/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.CallOrderBo;
import com.tydic.fsc.bill.busi.api.FscLianDongNeedPayOrderCallBackBusiService;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayOrderCallBackBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscLianDongNeedPayOrderCallBackBusiRspBo;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractPayMapper;
import com.tydic.fsc.dao.FscNeedPayInvoiceMapper;
import com.tydic.fsc.dao.FscNeedPayItemMapper;
import com.tydic.fsc.dao.FscNeedPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractPayPO;
import com.tydic.fsc.po.FscNeedPayInvoicePO;
import com.tydic.fsc.po.FscNeedPayItemPO;
import com.tydic.fsc.po.FscNeedPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscLianDongNeedPayOrderCallBackBusiServiceImpl
implements FscLianDongNeedPayOrderCallBackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscLianDongNeedPayOrderCallBackBusiServiceImpl.class);
    @Autowired
    private FscContractPayMapper fscContractPayMapper;
    @Autowired
    private FscNeedPayMapper fscNeedPayMapper;
    @Autowired
    private FscNeedPayItemMapper fscNeedPayItemMapper;
    @Autowired
    private FscCostLogAtomService fscCostLogAtomService;
    @Autowired
    private FscNeedPayInvoiceMapper fscNeedPayInvoiceMapper;
    @Value(value="${CALL_ORDER_URL:www.baidu.com}")
    private String callOrderUrl;
    @Value(value="${IS_CALL_ORDER:true}")
    private boolean isCallOrderFlag;

    @Override
    public FscLianDongNeedPayOrderCallBackBusiRspBo dealNeedPayOrderCallBack(FscLianDongNeedPayOrderCallBackBusiReqBo busiReqBo) {
        log.debug("\u6210\u672c\u5e94\u4ed8\u7ed3\u679c\u56de\u4f20API(\u8ba2\u5355)\u5f00\u59cb");
        List<FscNeedPayPO> fscNeedPayMapperList = this.getFscNeedPayPoList(busiReqBo);
        Map<Integer, FscNeedPayPO> fscNeedPayPoMap = this.getFscNeedPayPo(fscNeedPayMapperList);
        FscNeedPayPO fscNeedPayPoFirst = this.getFscNeedPayFirstPo(fscNeedPayPoMap);
        ArrayList<FscNeedPayItemPO> fscNeedPayItemPoList = new ArrayList<FscNeedPayItemPO>();
        this.dealInfo(busiReqBo, fscNeedPayPoFirst, fscNeedPayItemPoList, fscNeedPayPoMap);
        log.debug("\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u96c6\u5408{}", fscNeedPayItemPoList);
        this.fscNeedPayItemMapper.insertBatch(fscNeedPayItemPoList);
        FscLianDongNeedPayOrderCallBackBusiRspBo fscLianDongNeedPayOrderCallBackBusiRspBo = new FscLianDongNeedPayOrderCallBackBusiRspBo();
        fscLianDongNeedPayOrderCallBackBusiRspBo.setRespCode("0000");
        fscLianDongNeedPayOrderCallBackBusiRspBo.setRespDesc("\u6210\u529f");
        return fscLianDongNeedPayOrderCallBackBusiRspBo;
    }

    private void callOrder(FscLianDongNeedPayOrderCallBackBusiReqBo busiReqBo, Boolean isCallOrder) {
        if (isCallOrder.booleanValue()) {
            CallOrderBo callOrderBo = new CallOrderBo();
            callOrderBo.setSaleOrderId(Long.valueOf(busiReqBo.getPurchaseOrderId()));
            this.doPost(callOrderBo, busiReqBo.getLogId());
        }
    }

    private void doPost(CallOrderBo callOrderBo, Long logId) {
        try {
            log.debug("\u63a8\u9001\u5e94\u4ed8\u8ba2\u5355\u9884\u4ed8\u6b3e\u5df2\u4ed8body{}", (Object)callOrderBo);
            log.debug("\u63a8\u9001\u5e94\u4ed8\u8ba2\u5355\u9884\u4ed8\u6b3e\u5df2\u4ed8url{}", (Object)this.callOrderUrl);
            String result = HttpUtil.post((String)this.callOrderUrl, (String)JSONObject.toJSONString((Object)callOrderBo));
            log.debug("\u63a8\u9001\u5e94\u4ed8\u8ba2\u5355\u9884\u4ed8\u6b3e\u5df2\u4ed8\u51fa\u53c2-{}", (Object)result);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (Integer.parseInt((String)resultObj.get((Object)"code")) != 0) {
                log.debug("\u63a8\u9001\u5e94\u4ed8\u8ba2\u5355\u9884\u4ed8\u6b3e\u5df2\u4ed8\u8fd4\u56de\u5f02\u5e38");
                this.logUpdate(logId, result);
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u5e94\u4ed8\u8ba2\u5355\u9884\u4ed8\u6b3e\u5df2\u4ed8\u5f02\u5e38");
            this.logUpdate(logId, e.getMessage());
            e.printStackTrace();
        }
    }

    private void logUpdate(Long id, String rspStr) {
        this.fscCostLogAtomService.logUpdate(id, rspStr, FscConstants.CostIsError.NO);
    }

    private FscNeedPayPO getFscNeedPayFirstPo(Map<Integer, FscNeedPayPO> fscNeedPayPoMap) {
        FscNeedPayPO fscNeedPayPoFirst = fscNeedPayPoMap.get(FscConstants.PayOrderTypeInfo.FIRST);
        log.debug("\u9884\u4ed8\u6b3e\u5e94\u4ed8\u4fe1\u606f{}", (Object)fscNeedPayPoFirst);
        if (fscNeedPayPoFirst == null) {
            throw new FscBusinessException("190000", "\u83b7\u53d6\u9884\u4ed8\u6b3e\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscNeedPayPoFirst;
    }

    private List<FscNeedPayPO> getFscNeedPayPoList(FscLianDongNeedPayOrderCallBackBusiReqBo busiReqBo) {
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setPurchaseOrderId(Long.valueOf(busiReqBo.getPurchaseOrderId()));
        fscNeedPayPo.setExtend1(FscConstants.NeedPayOrderType.FIRST_PAY.toString());
        fscNeedPayPo.setExtend2(FscConstants.ForwardOrBackward.FORWARD.toString());
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u5165\u53c2{}", (Object)fscNeedPayPo);
        List fscNeedPayMapperList = this.fscNeedPayMapper.getList(fscNeedPayPo);
        log.debug("\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u51fa\u53c2{}", (Object)fscNeedPayMapperList);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayMapperList) || fscNeedPayMapperList.size() > 2) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a\u6216\u5e94\u4ed8\u6570\u636e\u5927\u4e8e2");
        }
        return fscNeedPayMapperList;
    }

    private Map<Integer, FscNeedPayPO> getFscNeedPayPo(List<FscNeedPayPO> fscNeedPayMapperList) {
        return fscNeedPayMapperList.stream().collect(Collectors.toMap(FscNeedPayPO::getPayOrderType, o -> o));
    }

    private void dealInfo(FscLianDongNeedPayOrderCallBackBusiReqBo busiReqBo, FscNeedPayPO fscNeedPayPoFirst, List<FscNeedPayItemPO> fscNeedPayItemPoList, Map<Integer, FscNeedPayPO> fscNeedPayPoMap) {
        Date date = new Date();
        BigDecimal payAmount = busiReqBo.getPayAmount();
        FscNeedPayPO fscNeedPayPo = new FscNeedPayPO();
        fscNeedPayPo.setPurchaseOrderIds(Collections.singletonList(Long.valueOf(busiReqBo.getPurchaseOrderId())));
        fscNeedPayPo.setPayOrderType(FscConstants.PayOrderTypeInfo.FIRST);
        fscNeedPayPo.setExtend1(FscConstants.NeedPayOrderType.FIRST_PAY.toString());
        List fscNeedPayMapperListFirst = this.fscNeedPayMapper.getListNotBillAfter(fscNeedPayPo);
        if (CollectionUtils.isEmpty((Collection)fscNeedPayMapperListFirst)) {
            throw new FscBusinessException("190000", "\u5f00\u7968\u540e\u5224\u65ad\u72b6\u6001\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        List<FscNeedPayPO> fscNeedPayPoFirstRefundList = fscNeedPayMapperListFirst.stream().filter(fscNeedPayPoFirstRefund -> FscConstants.ForwardOrBackward.BACKWARD.toString().equals(fscNeedPayPoFirstRefund.getExtend2())).collect(Collectors.toList());
        BigDecimal needPayAmountFirst = BigDecimal.ZERO;
        BigDecimal needPayWaitAmountFirst = BigDecimal.ZERO;
        for (FscNeedPayPO fscNeedPayPoModelIn : fscNeedPayMapperListFirst) {
            needPayAmountFirst = needPayAmountFirst.add(fscNeedPayPoModelIn.getNeedPayMoney());
            needPayWaitAmountFirst = needPayWaitAmountFirst.add(fscNeedPayPoModelIn.getWaitPayMoney());
        }
        List<FscNeedPayPO> fscNeedPayPoFirstBalanceList = null;
        BigDecimal needPayAmountBalance = BigDecimal.ZERO;
        BigDecimal needPayWaitAmountBalance = BigDecimal.ZERO;
        fscNeedPayPo.setPayOrderType(FscConstants.PayOrderTypeInfo.BALANCE);
        List fscNeedPayMapperListBalance = this.fscNeedPayMapper.getListNotBillAfter(fscNeedPayPo);
        if (!CollectionUtils.isEmpty((Collection)fscNeedPayMapperListBalance)) {
            fscNeedPayPoFirstBalanceList = fscNeedPayMapperListBalance.stream().filter(fscNeedPayPoFirstRefund -> FscConstants.ForwardOrBackward.BACKWARD.toString().equals(fscNeedPayPoFirstRefund.getExtend2())).collect(Collectors.toList());
            for (FscNeedPayPO fscNeedPayPoModelIn : fscNeedPayMapperListBalance) {
                needPayAmountBalance = needPayAmountBalance.add(fscNeedPayPoModelIn.getNeedPayMoney());
                needPayWaitAmountBalance = needPayWaitAmountBalance.add(fscNeedPayPoModelIn.getWaitPayMoney());
            }
        }
        if (needPayWaitAmountFirst.compareTo(BigDecimal.ZERO) > 0) {
            log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u5927\u4e8e0\uff0c\u9700\u8981\u5145\u586b\u9884\u4ed8\u6b3e{}", (Object)needPayWaitAmountFirst);
            if (payAmount.compareTo(needPayWaitAmountFirst) > 0) {
                log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d");
                BigDecimal needPayAmountFirstPayed = needPayAmountFirst;
                BigDecimal needPayItemAmountFirstPayed = needPayWaitAmountFirst;
                if (CollectionUtils.isEmpty((Collection)fscNeedPayMapperListBalance)) {
                    needPayAmountFirstPayed = fscNeedPayPoFirst.getPayedMoney().add(payAmount);
                    needPayItemAmountFirstPayed = payAmount;
                }
                this.updatePayNeed(fscNeedPayPoFirst, needPayAmountFirstPayed, BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoFirst, fscNeedPayItemPoList, needPayItemAmountFirstPayed, date);
                if (!CollectionUtils.isEmpty(fscNeedPayPoFirstRefundList)) {
                    this.updatePayNeedRefund(fscNeedPayPoFirstRefundList, date);
                }
                if (!CollectionUtils.isEmpty((Collection)fscNeedPayMapperListBalance)) {
                    FscNeedPayPO fscNeedPayPoAfter = this.getFscAfterNeedPayPo(fscNeedPayPoMap);
                    Integer needPayState = this.getNeedState(needPayItemAmountFirstPayed, payAmount, needPayAmountBalance, fscNeedPayPoAfter.getPayedMoney());
                    BigDecimal subtract = needPayAmountBalance.subtract(fscNeedPayPoAfter.getPayedMoney().add(payAmount.subtract(needPayItemAmountFirstPayed)));
                    if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                        subtract = BigDecimal.ZERO;
                    }
                    this.updatePayNeed(fscNeedPayPoAfter, fscNeedPayPoAfter.getPayedMoney().add(payAmount.subtract(needPayItemAmountFirstPayed)), subtract, needPayState, date);
                    this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoAfter, fscNeedPayItemPoList, payAmount.subtract(needPayItemAmountFirstPayed), date);
                    if (FscConstants.FscNeedPayState.PAYED_NOT_INVOICE.equals(needPayState) && !CollectionUtils.isEmpty(fscNeedPayPoFirstBalanceList)) {
                        this.updatePayNeedRefund(fscNeedPayPoFirstBalanceList, date);
                    }
                }
            } else if (payAmount.compareTo(needPayWaitAmountFirst) == 0) {
                log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u7b49\u4e8e\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d");
                this.updatePayNeed(fscNeedPayPoFirst, needPayAmountFirst, BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoFirst, fscNeedPayItemPoList, payAmount, date);
                if (!CollectionUtils.isEmpty(fscNeedPayPoFirstRefundList)) {
                    this.updatePayNeedRefund(fscNeedPayPoFirstRefundList, date);
                }
            } else if (payAmount.compareTo(needPayWaitAmountFirst) < 0) {
                log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u5927\u4e8e\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d");
                this.updatePayNeed(fscNeedPayPoFirst, fscNeedPayPoFirst.getPayedMoney().add(busiReqBo.getPayAmount()), needPayAmountFirst.subtract(fscNeedPayPoFirst.getPayedMoney().add(payAmount)), FscConstants.FscNeedPayState.PART_NEED_PAY, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoFirst, fscNeedPayItemPoList, payAmount, date);
            }
        }
        if (needPayWaitAmountFirst.compareTo(BigDecimal.ZERO) == 0) {
            if (CollectionUtils.isEmpty(fscNeedPayPoFirstBalanceList)) {
                log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u7b49\u4e8e0\uff0c\u4f46\u662f\u53c8\u6ca1\u6709\u5c3e\u6b3e\uff0c\u5168\u90e8\u653e\u5230\u9884\u4ed8\u6b3e\u4e0a");
                this.updatePayNeed(fscNeedPayPoFirst, fscNeedPayPoFirst.getPayedMoney().add(payAmount), BigDecimal.ZERO, FscConstants.FscNeedPayState.PAYED_NOT_INVOICE, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoFirst, fscNeedPayItemPoList, payAmount, date);
            }
            if (!CollectionUtils.isEmpty(fscNeedPayPoFirstBalanceList)) {
                log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u7b49\u4e8e0\uff0c\u6709\u5c3e\u6b3e\u5145\u586b\u5c3e\u6b3e{}", (Object)needPayWaitAmountFirst);
                FscNeedPayPO fscNeedPayPoAfter = this.getFscAfterNeedPayPo(fscNeedPayPoMap);
                Integer needPayState = this.getNeedStateAfter(payAmount, needPayWaitAmountBalance);
                BigDecimal subtract = needPayAmountBalance.subtract(fscNeedPayPoAfter.getPayedMoney().add(payAmount));
                if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    subtract = BigDecimal.ZERO;
                }
                this.updatePayNeed(fscNeedPayPoAfter, fscNeedPayPoAfter.getPayedMoney().add(payAmount), subtract, needPayState, date);
                this.AddNeedItem(busiReqBo.getPayTime(), fscNeedPayPoAfter, fscNeedPayItemPoList, payAmount, date);
                if (FscConstants.FscNeedPayState.PAYED_NOT_INVOICE.equals(needPayState)) {
                    this.updatePayNeedRefund(fscNeedPayPoFirstBalanceList, date);
                }
            }
        }
        if (needPayWaitAmountFirst.compareTo(BigDecimal.ZERO) < 0) {
            log.debug("\u9884\u4ed8\u6b3e\u5f85\u4ed8\u91d1\u989d\u5c0f\u4e8e0\uff0c\u62a5\u9519{}", (Object)needPayWaitAmountFirst);
            throw new FscBusinessException("190000", "\u67e5\u8be2\u9884\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e0");
        }
    }

    private Integer getContractPayStateAfter(BigDecimal payAmount, FscNeedPayPO fscNeedPayPoAfter) {
        Integer contractPayState = FscConstants.FscNeedPayState.PAYED_NOT_INVOICE;
        if (fscNeedPayPoAfter.getPayedMoney().add(payAmount).compareTo(fscNeedPayPoAfter.getNeedPayMoney()) > 0) {
            throw new FscBusinessException("190000", "\u8be5\u8ba2\u5355\u4ed8\u6b3e\u91d1\u989d\u603b\u8ba1\u8d85\u8fc7\u4e86\u5e94\u4ed8\u91d1\u989d");
        }
        if (fscNeedPayPoAfter.getPayedMoney().add(payAmount).compareTo(fscNeedPayPoAfter.getNeedPayMoney()) < 0) {
            contractPayState = FscConstants.ContractPayState.PART_PAY;
        }
        log.debug("\u521d\u59cb\u5316\u5408\u540c\u4ed8\u6b3e\u72b6\u6001\u51fa{}", (Object)contractPayState);
        return contractPayState;
    }

    private Integer getNeedStateAfter(BigDecimal payAmount, BigDecimal fscNeedPayPoAfterWaitAmount) {
        Integer needPayState = FscConstants.FscNeedPayState.PAYED_NOT_INVOICE;
        if (payAmount.compareTo(fscNeedPayPoAfterWaitAmount) < 0) {
            needPayState = FscConstants.FscNeedPayState.PART_NEED_PAY;
        }
        return needPayState;
    }

    private Integer getNeedState(BigDecimal needPayAmountFirstPayed, BigDecimal payAmount, BigDecimal needPayAmountBalanceNeedPay, BigDecimal fscNeedPayAfterPayedAmount) {
        Integer needPayState = FscConstants.FscNeedPayState.PAYED_NOT_INVOICE;
        if (fscNeedPayAfterPayedAmount.add(payAmount.subtract(needPayAmountFirstPayed)).compareTo(needPayAmountBalanceNeedPay) < 0) {
            needPayState = FscConstants.FscNeedPayState.PART_NEED_PAY;
        }
        return needPayState;
    }

    private FscNeedPayPO getFscAfterNeedPayPo(Map<Integer, FscNeedPayPO> fscNeedPayPoMap) {
        if (fscNeedPayPoMap.get(FscConstants.PayOrderTypeInfo.BALANCE) == null) {
            throw new FscBusinessException("190000", "\u6709\u5c3e\u6b3e\u65f6\u83b7\u53d6\u5c3e\u6b3e\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscNeedPayPO fscNeedPayPoAfter = fscNeedPayPoMap.get(FscConstants.PayOrderTypeInfo.BALANCE);
        log.debug("\u5c3e\u6b3e\u4fe1\u606f{}", (Object)fscNeedPayPoAfter);
        return fscNeedPayPoAfter;
    }

    private FscContractPayPO getFscContractPayPo(FscNeedPayPO fscNeedPayPo) {
        FscContractPayPO fscContractPayPo = new FscContractPayPO();
        fscContractPayPo.setContractPayId(fscNeedPayPo.getContractPayId());
        fscContractPayPo.setIsDel(FscConstants.DicDelFlag.NO);
        log.debug("\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f{}", (Object)fscContractPayPo);
        FscContractPayPO fscContractPayMapperModelBy = this.fscContractPayMapper.getModelBy(fscContractPayPo);
        log.debug("\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u51fa\u53c2{}", (Object)fscContractPayMapperModelBy);
        if (fscContractPayMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscContractPayMapperModelBy;
    }

    private void updateContractPayItem(Date payTime, FscNeedPayPO fscNeedPayPo, Date date, BigDecimal payedAmount, Integer contractPayState) {
        FscContractPayPO fscContractPayPoWhere = new FscContractPayPO();
        fscContractPayPoWhere.setContractPayId(fscNeedPayPo.getContractPayId());
        fscContractPayPoWhere.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        FscContractPayPO fscContractPayPoSet = new FscContractPayPO();
        fscContractPayPoSet.setContractPayAmount(payedAmount);
        fscContractPayPoSet.setUpdateTime(date);
        fscContractPayPoSet.setContractPayTime(payTime.toString());
        fscContractPayPoSet.setContractPayState(contractPayState.toString());
        log.debug("\u66f4\u65b0\u5408\u540c\u4ed8\u6b3e\u4fe1\u606fSet{}{}", (Object)fscContractPayPoSet, (Object)fscContractPayPoWhere);
        int update = this.fscContractPayMapper.updateBy(fscContractPayPoSet, fscContractPayPoWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5408\u540c\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updatePayNeed(FscNeedPayPO fscNeedPayPo, BigDecimal payedAmount, BigDecimal waitPayAmount, Integer needPayState, Date date) {
        FscNeedPayPO fscNeedPayPoOnSet = new FscNeedPayPO();
        fscNeedPayPoOnSet.setWaitPayMoney(waitPayAmount);
        fscNeedPayPoOnSet.setPayedMoney(payedAmount);
        fscNeedPayPoOnSet.setNeedPayState(needPayState);
        fscNeedPayPoOnSet.setUpdateTime(date);
        this.setPayNeedState(fscNeedPayPo, needPayState, fscNeedPayPoOnSet);
        FscNeedPayPO fscNeedPayPoOnWhere = new FscNeedPayPO();
        fscNeedPayPoOnWhere.setNeedPayId(fscNeedPayPo.getNeedPayId());
        log.debug("\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f{}{}", (Object)fscNeedPayPoOnSet, (Object)fscNeedPayPoOnWhere);
        int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoOnSet, fscNeedPayPoOnWhere);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updatePayNeedRefund(List<FscNeedPayPO> fscNeedPayPoList, Date date) {
        fscNeedPayPoList.forEach(fscNeedPayPo -> {
            FscNeedPayPO fscNeedPayPoOnSet = new FscNeedPayPO();
            fscNeedPayPoOnSet.setWaitPayMoney(BigDecimal.ZERO);
            fscNeedPayPoOnSet.setPayedMoney(fscNeedPayPo.getNeedPayMoney());
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_NOT_INVOICE);
            fscNeedPayPoOnSet.setUpdateTime(date);
            FscNeedPayPO fscNeedPayPoOnWhere = new FscNeedPayPO();
            fscNeedPayPoOnWhere.setNeedPayId(fscNeedPayPo.getNeedPayId());
            log.debug("\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f{}{}", (Object)fscNeedPayPoOnSet, (Object)fscNeedPayPoOnWhere);
            int update = this.fscNeedPayMapper.updateBy(fscNeedPayPoOnSet, fscNeedPayPoOnWhere);
            if (update < 1) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f\u5931\u8d25");
            }
        });
    }

    private void setPayNeedState(FscNeedPayPO fscNeedPayPo, Integer needPayState, FscNeedPayPO fscNeedPayPoOnSet) {
        FscNeedPayInvoicePO fscNeedPayInvoicePo = new FscNeedPayInvoicePO();
        fscNeedPayInvoicePo.setNeedPayId(fscNeedPayPo.getNeedPayId());
        fscNeedPayInvoicePo.setIsDel(FscConstants.DELETE_TAG.NO_DEL);
        List list = this.fscNeedPayInvoiceMapper.getList(fscNeedPayInvoicePo);
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.PAYED_NOT_INVOICE.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PAYED_INVOICE);
        }
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.PART_NEED_PAY.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.PART_NEED_PAY_INVOICE);
        }
        if (!CollectionUtils.isEmpty((Collection)list) && FscConstants.FscNeedPayState.NEED_PAY.equals(needPayState)) {
            fscNeedPayPoOnSet.setNeedPayState(FscConstants.FscNeedPayState.NEED_PAY_INVOICE);
        }
    }

    private void AddNeedItem(Date payTime, FscNeedPayPO fscNeedPayPo, List<FscNeedPayItemPO> fscNeedPayItemPoList, BigDecimal amount, Date date) {
        FscNeedPayItemPO fscNeedPayItemPo = new FscNeedPayItemPO();
        fscNeedPayItemPo.setCtrctCode(fscNeedPayPo.getCtrctCode());
        fscNeedPayItemPo.setCtrctName(fscNeedPayPo.getCtrctName());
        fscNeedPayItemPo.setCreateTime(date);
        fscNeedPayItemPo.setCreateOperId(fscNeedPayPo.getCreateOperId());
        fscNeedPayItemPo.setNeedPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscNeedPayItemPo.setNeedPayItemType(fscNeedPayPo.getNeedPayType());
        fscNeedPayItemPo.setPayTime(payTime);
        fscNeedPayItemPo.setPayMoney(amount);
        fscNeedPayItemPo.setNeedPayId(fscNeedPayPo.getNeedPayId());
        fscNeedPayItemPoList.add(fscNeedPayItemPo);
    }
}

