/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStopAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStopAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStopAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.ProcessStartBuilder;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscOrderStatusStopAtomServiceImpl
implements FscOrderStatusStopAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusStopAtomServiceImpl.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessStartBuilder processStartBuilder;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Value(value="${workflow.inst.type:WithInstance}")
    private String workflowInstEnable;
    @Value(value="${workflow.sys.code:CRC}")
    private String workflowSysCode;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;
    @Resource(name="fscTodoSyncProvider")
    private ProxyMessageProducer fscTodoSyncProvider;
    @Value(value="${FSC_TODO_SYNC_TOPIC:FSC_TODO_SYNC_TOPIC}")
    private String fscTodoSyncTopic;
    @Value(value="${FSC_TODO_SYNC_TAG:FSC_TODO_SYNC_TAG}")
    private String fscTodoSyncTag;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;

    @Override
    public FscOrderStatusStopAtomRspBO dealStatusStop(FscOrderStatusStopAtomReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrderPOResult = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPOResult) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b");
        }
        DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
        deleteProcInstSingleReqBO.setProcInstId(fscOrderPOResult.getProcInstId());
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleReqBO));
        }
        DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleRespBO));
        }
        if (!"0000".equals(deleteProcInstSingleRespBO.getRespCode())) {
            throw new FscBusinessException("194310", "\u6d41\u7a0b\u7ec8\u6b62\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + deleteProcInstSingleRespBO.getRespCode() + "\u3011," + deleteProcInstSingleRespBO.getRespDesc());
        }
        this.updateStatus(reqBO, FscBillStatus.MAIN_ORDER_CANCELLATION.getCode(), fscOrderPOResult.getTaskId());
        this.writeLog(reqBO, fscOrderPOResult, FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
        return new FscOrderStatusStopAtomRspBO();
    }

    private void val(FscOrderStatusStopAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("194310", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusStopAtomReqBO reqBO, Integer newStatus, String taskId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderState(newStatus);
        fscOrderPo.setCreateTimeStart(new Date());
        fscOrderPo.setTaskId(taskId);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusStopAtomReqBO reqBO, FscOrderPO fscOrderPO, Integer newStatus) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(reqBO.getBusiName());
        fscLogOrdBusiPo.setBusiType(fscOrderPO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
        FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPo.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrdStateChgLogPo.setOldState(fscOrderPO.getOrderState());
        fscOrdStateChgLogPo.setNewState(newStatus);
        fscOrdStateChgLogPo.setChgTime(new Date());
        if (null != reqBO.getUserId()) {
            fscOrdStateChgLogPo.setOperId(reqBO.getUserId().toString());
        }
        fscOrdStateChgLogPo.setChgDesc(reqBO.getBusiName());
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPo);
    }
}

