/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.tydic.fsc.busibase.atom.api.FscPayRecordTodoDealAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordInfoBO;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomRspBo;
import com.tydic.fsc.busibase.external.api.auth.FscAuthGetUserByRoleAndOrgExtService;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcTodoBo;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.busibase.external.api.umc.DycUmcSendHaveDoneAtomService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcSendTodoAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscTodoConfigMapper;
import com.tydic.fsc.po.FscTodoConfigPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayRecordTodoDealAtomServiceImpl
implements FscPayRecordTodoDealAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayRecordTodoDealAtomServiceImpl.class);
    @Autowired
    private FscTodoConfigMapper fscTodoConfigMapper;
    @Autowired
    private FscUmcSendTodoAtomService fscUmcSendTodoAtomService;
    @Autowired
    private DycUmcSendHaveDoneAtomService dycUmcSendHaveDoneAtomService;
    @Autowired
    private FscAuthGetUserByRoleAndOrgExtService fscAuthGetUserByRoleAndOrgExtService;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;
    public static final Integer HAVE_NOTICE = 1;
    @Value(value="#{'${send.notice.time.limit.code:1015,1017}'.split(',')}")
    public List<String> TIME_LIMIT_CODE;

    @Override
    public FscPayRecordTodoDealAtomRspBo sendPayRecordTodo(FscPayRecordTodoDealAtomReqBo reqBo) {
        FscTodoConfigPO payTodoConfig = this.getTodoConfig();
        List<FscPayRecordInfoBO> fscShouldPayInfo = reqBo.getFscShouldPayInfo();
        ArrayList<FscUmcTodoBo> todoList = new ArrayList<FscUmcTodoBo>();
        for (FscPayRecordInfoBO fscPayRecordInfoBO : fscShouldPayInfo) {
            FscAuthGetUserByRoleAndOrgReqBo fscAuthGetUserByRoleAndOrgReqBo = new FscAuthGetUserByRoleAndOrgReqBo();
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscPayRecordInfoBO.getPayerId());
            fscAuthGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList(payTodoConfig.getRole().split(";")));
            fscAuthGetUserByRoleAndOrgReqBo.setPageNo(1);
            fscAuthGetUserByRoleAndOrgReqBo.setPageSize(1000);
            fscAuthGetUserByRoleAndOrgReqBo.setLevelFlag(1);
            FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
            ArrayList<FscNoticeReceiverBO> receiverBOS = new ArrayList<FscNoticeReceiverBO>();
            if (!"0000".equals(userByRoleAndOrg.getRespCode())) continue;
            todoList.addAll(this.dealSendToto(payTodoConfig, userByRoleAndOrg, fscPayRecordInfoBO.getFscShouldPayId(), receiverBOS));
            if (userByRoleAndOrg.getTotal() <= 1) continue;
            for (int i = 0; i < userByRoleAndOrg.getTotal(); ++i) {
                fscAuthGetUserByRoleAndOrgReqBo.setPageNo(i + 2);
                FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
                todoList.addAll(this.dealSendToto(payTodoConfig, userByRoleAndOrgRspBo, fscPayRecordInfoBO.getFscShouldPayId(), receiverBOS));
            }
        }
        return new FscPayRecordTodoDealAtomRspBo();
    }

    @Override
    public FscPayRecordTodoDealAtomRspBo sendPayRecordTodoDone(FscPayRecordTodoDealAtomReqBo reqBo) {
        return new FscPayRecordTodoDealAtomRspBo();
    }

    private List<FscUmcTodoBo> dealSendToto(FscTodoConfigPO fscTodoConfigPO, FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg, Long shouldPayId, List<FscNoticeReceiverBO> receiverBOS) {
        if (CollectionUtils.isNotEmpty((Collection)userByRoleAndOrg.getRows())) {
            return userByRoleAndOrg.getRows().stream().map(fscAuthByRoleAndOrgQryUserInfoBo -> {
                FscUmcTodoBo fscUmcTodoBo = new FscUmcTodoBo();
                fscUmcTodoBo.setBusiId(Convert.toStr((Object)shouldPayId));
                fscUmcTodoBo.setTodoItemCode(fscTodoConfigPO.getTodoCode());
                if (fscTodoConfigPO.getItemUrl().contains("?")) {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"&shouldPayId={}", (Object[])new Object[]{shouldPayId}));
                } else {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"?shouldPayId={}", (Object[])new Object[]{shouldPayId}));
                }
                fscUmcTodoBo.setCreateOperId("1");
                fscUmcTodoBo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                fscUmcTodoBo.setCandidateOperId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscUmcTodoBo.setCandidateOperName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
                fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscNoticeReceiverBO.setReceiverName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                receiverBOS.add(fscNoticeReceiverBO);
                return fscUmcTodoBo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private FscTodoConfigPO getTodoConfig() {
        FscTodoConfigPO fscTodoConfigPO = new FscTodoConfigPO();
        fscTodoConfigPO.setTodoCode(FscConstants.MemWaitDoneType.PENDING_PAYMENT_RECORD.getCode());
        return this.fscTodoConfigMapper.getModelBy(fscTodoConfigPO);
    }
}

