/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscCostLogAtomService;
import com.tydic.fsc.dao.FscCostLogMapper;
import com.tydic.fsc.po.FscCostLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class FscCostLogAtomServiceImpl
implements FscCostLogAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscCostLogAtomServiceImpl.class);
    @Autowired
    private FscCostLogMapper fscCostLogMapper;

    @Override
    public Long logInsert(String objId, String reqStr, String rspStr, Integer isError, Integer objType, String method) {
        long id = Sequence.getInstance().nextId();
        try {
            FscCostLogPO po = new FscCostLogPO();
            po.setId(id);
            po.setCreateTime(new Date());
            po.setIsError(isError);
            po.setMethod(method);
            po.setObjId(objId);
            po.setObjType(objType);
            reqStr = !StringUtils.isEmpty((Object)reqStr) && reqStr.length() > 10000 ? reqStr.substring(0, 10000) : reqStr;
            po.setReq(reqStr);
            rspStr = !StringUtils.isEmpty((Object)rspStr) && rspStr.length() > 10000 ? rspStr.substring(0, 10000) : rspStr;
            po.setRsp(rspStr);
            this.fscCostLogMapper.insert(po);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("--\u6210\u672c\u7cfb\u7edf\u65e5\u5fd7\u65b0\u589e\u5931\u8d25--{}", (Object)e.getMessage());
            return null;
        }
        return id;
    }

    @Override
    public void logUpdate(Long id, String rspStr, Integer isError) {
        try {
            if (id != null) {
                FscCostLogPO set = new FscCostLogPO();
                FscCostLogPO where = new FscCostLogPO();
                where.setId(id);
                rspStr = !StringUtils.isEmpty((Object)rspStr) && rspStr.length() > 10000 ? rspStr.substring(0, 10000) : rspStr;
                set.setRsp(rspStr);
                set.setIsError(isError);
                this.fscCostLogMapper.updateBy(set, where);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("--\u6210\u672c\u7cfb\u7edf\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25--{}", (Object)e.getMessage());
        }
    }
}

