/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeeChannelPO;
import com.tydic.payment.pay.ability.PayProRelPayParaAbilityService;
import com.tydic.payment.pay.ability.bo.PayProMerchantPayInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaReqBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaRspBo;
import com.tydic.payment.pay.bo.PayCenterRspBo;
import com.tydic.payment.pay.dao.PaymentInsMapper;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.web.bo.req.InfoMechartPaymentInsReqBO;
import com.tydic.payment.pay.web.bo.req.MerchantInfoPaymentManagerReqBO;
import com.tydic.payment.pay.web.service.ConMerchantInfoMMerchantRelPaymentInsManageWebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantPayeeChannelAtomService")
public class FscMerchantPayeeChannelAtomServiceImpl
implements FscMerchantPayeeChannelAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeChannelAtomServiceImpl.class);
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeChannelAtomService fscMerchantPayeeChannelAtomService;
    @Autowired
    private PayProRelPayParaAbilityService payProRelPayParaAbilityService;
    @Autowired
    private ConMerchantInfoMMerchantRelPaymentInsManageWebService merchantInfoMMerchantRelPaymentInsManageWebService;
    @Autowired
    private PaymentInsMapper paymentInsMapper;

    @Override
    public FscMerchantPayeeChannelAtomRspBO queryPayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        FscMerchantPayeeChannelPO queryReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)queryReqPo);
        List<FscMerchantPayeeChannelPO> payChannelPos = this.fscMerchantPayeeChannelMapper.getList(queryReqPo);
        if (CollectionUtils.isEmpty(payChannelPos)) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a{}\uff0c\u67e5\u8be2\u652f\u4ed8\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a", (Object)JSON.toJSONString((Object)((Object)reqBo)));
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a");
            return retBo;
        }
        ArrayList<FscMerchantPayeeChannelDataBO> payChannels = new ArrayList<FscMerchantPayeeChannelDataBO>();
        for (FscMerchantPayeeChannelPO channelPo : payChannelPos) {
            FscMerchantPayeeChannelDataBO dataBo = new FscMerchantPayeeChannelDataBO();
            BeanUtils.copyProperties((Object)channelPo, (Object)dataBo);
            payChannels.add(dataBo);
        }
        retBo.setPayChannels(payChannels);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    @Override
    public FscMerchantPayeeChannelAtomRspBO addPayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("194306");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        FscMerchantPayeeChannelPO validateReqPo = new FscMerchantPayeeChannelPO();
        validateReqPo.setMerchantId(reqBo.getMerchantId());
        validateReqPo.setPayChannel(reqBo.getPayChannel());
        FscMerchantPayeeChannelPO validateRetPo = this.fscMerchantPayeeChannelMapper.getModelBy(validateReqPo);
        if (null != validateRetPo) {
            log.error("\u5546\u6237[{}]\uff0c\u5df2\u914d\u7f6e\u652f\u4ed8\u6e20\u9053[{}]\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e", (Object)reqBo.getMerchantId(), (Object)reqBo.getPayChannel());
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u5546\u6237\u5df2\u914d\u7f6e\u6b64\u652f\u4ed8\u6e20\u9053\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e");
            return retBo;
        }
        Long id = Sequence.getInstance().nextId();
        Date nowTime = this.fscMerchantMapper.getDBDate();
        FscMerchantPayeeChannelPO addPayChannelReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)addPayChannelReqPo);
        addPayChannelReqPo.setId(id);
        addPayChannelReqPo.setOperTime(nowTime);
        addPayChannelReqPo.setOperName(reqBo.getName());
        addPayChannelReqPo.setOperId(reqBo.getUserId());
        int result = this.fscMerchantPayeeChannelMapper.insert(addPayChannelReqPo);
        if (result < 1) {
            log.error("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5165\u8868\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5165\u8868\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setId(id);
        this.getFscMerchantPayeeChannelAtomRspBO(reqBo);
        return retBo;
    }

    private void getFscMerchantPayeeChannelAtomRspBO(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setMerchantId(reqBo.getMerchantId());
        FscMerchantPO modelBy = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (modelBy.getPayMerchantId() != null) {
            FscMerchantPayeeChannelAtomReqBO channelAtomReqBo = new FscMerchantPayeeChannelAtomReqBO();
            channelAtomReqBo.setMerchantId(reqBo.getMerchantId());
            FscMerchantPayeeChannelAtomRspBO channelAtomRetBo = this.fscMerchantPayeeChannelAtomService.queryPayChannel(channelAtomReqBo);
            if (!"0000".equals(channelAtomRetBo.getRespCode())) {
                throw new FscBusinessException(channelAtomRetBo.getRespCode(), channelAtomRetBo.getRespDesc());
            }
            this.updatePayMerchant(reqBo, channelAtomRetBo.getPayChannels(), modelBy.getPayMerchantId());
        }
    }

    @Override
    public FscMerchantPayeeChannelAtomRspBO updatePayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("194306");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        if (null == reqBo.getId()) {
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u66f4\u65b0\u652f\u4ed8\u673a\u6784\u914d\u7f6e\uff0c\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        Date nowTime = this.fscMerchantMapper.getDBDate();
        FscMerchantPayeeChannelPO updatePayChannelReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)updatePayChannelReqPo);
        updatePayChannelReqPo.setOperTime(nowTime);
        updatePayChannelReqPo.setOperName(reqBo.getName());
        updatePayChannelReqPo.setOperId(reqBo.getUserId());
        int result = this.fscMerchantPayeeChannelMapper.updateById(updatePayChannelReqPo);
        if (result < 1) {
            log.error("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        this.getFscMerchantPayeeChannelAtomRspBO(reqBo);
        retBo.setId(reqBo.getId());
        return retBo;
    }

    @Override
    public FscMerchantPayeeChannelAtomRspBO deletePayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("194306");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        if (null == reqBo.getId()) {
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u5220\u9664\u652f\u4ed8\u673a\u6784\u914d\u7f6e\uff0c\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        FscMerchantPayeeChannelPO deletePayChannelReqPo = new FscMerchantPayeeChannelPO();
        deletePayChannelReqPo.setId(reqBo.getId());
        int result = this.fscMerchantPayeeChannelMapper.deleteBy(deletePayChannelReqPo);
        if (result < 1) {
            log.error("\u5220\u9664\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("194306");
            retBo.setRespDesc("\u5220\u9664\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        this.getFscMerchantPayeeChannelAtomRspBO(reqBo);
        retBo.setId(reqBo.getId());
        return retBo;
    }

    @Override
    public FscMerchantPayeeChannelAtomRspBO queryPage(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        ArrayList<FscMerchantPayeeChannelDataBO> rows = new ArrayList<FscMerchantPayeeChannelDataBO>();
        Page<FscMerchantPayeeChannelPO> page = this.getPage(reqBo);
        FscMerchantPayeeChannelPO queryPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)queryPo);
        List<FscMerchantPayeeChannelPO> channelPos = this.fscMerchantPayeeChannelMapper.getListPage(queryPo, page);
        FscMerchantPO merchantPo = new FscMerchantPO();
        merchantPo.setMerchantId(reqBo.getMerchantId());
        merchantPo = this.fscMerchantMapper.getModelBy(merchantPo);
        if (!CollectionUtil.isEmpty(channelPos)) {
            for (FscMerchantPayeeChannelPO channelPo : channelPos) {
                FscMerchantPayeeChannelDataBO dataBo = new FscMerchantPayeeChannelDataBO();
                BeanUtils.copyProperties((Object)channelPo, (Object)dataBo);
                dataBo.setUpdateOperName(channelPo.getOperName());
                dataBo.setUpdateOperId(channelPo.getOperId().toString());
                dataBo.setUpdateTime(new DateTime((Object)channelPo.getOperTime()).toString("yyyy-MM-dd HH:mm:ss"));
                dataBo.setRemark(merchantPo.getRemark());
                rows.add(dataBo);
            }
        }
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)((Object)retBo));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRows(rows);
        retBo.setTotal(page.getTotalPages());
        retBo.setRecordsTotal(page.getTotalCount());
        return retBo;
    }

    private Page<FscMerchantPayeeChannelPO> getPage(FscMerchantPayeeChannelAtomReqBO reqBo) {
        if (reqBo.getPageNo() > 1) {
            return new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        }
        Page page = new Page();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)page);
        if (page.getPageNo() < 1) {
            page.setPageNo(1);
        }
        if (page.getPageSize() < 1) {
            page.setPageSize(10);
        }
        return page;
    }

    private String validateMerchant(Long merhcantId) {
        FscMerchantPO queryReqBo = new FscMerchantPO();
        queryReqBo.setMerchantId(merhcantId);
        FscMerchantPO merchantPo = this.fscMerchantMapper.getModelBy(queryReqBo);
        if (merchantPo == null || FscConstants.MerchantDeleteFlag.YES.equals(merchantPo.getDelFlag())) {
            log.info("\u5546\u6237\u4e0d\u5b58\u5728");
            return "\u5546\u6237\u4e0d\u5b58\u5728";
        }
        return null;
    }

    private void updatePayMerchant(FscMerchantPayeeChannelAtomReqBO reqBo, List<FscMerchantPayeeChannelDataBO> payChannels, String payMerchantId) {
        PayProRelPayParaReqBo payParaReqBo = new PayProRelPayParaReqBo();
        payParaReqBo.setMerchantId(payMerchantId);
        payParaReqBo.setUpdateOperId(reqBo.getUserId().toString());
        this.editPaymentInsInfo(payParaReqBo, payChannels, reqBo);
    }

    private void editPaymentInsInfo(PayProRelPayParaReqBo payParaReqBo, List<FscMerchantPayeeChannelDataBO> payChannels, FscMerchantPayeeChannelAtomReqBO reqBo) {
        this.delRelIns(payParaReqBo, reqBo);
        if (!CollectionUtils.isEmpty(payChannels)) {
            for (FscMerchantPayeeChannelDataBO channelDataBO : payChannels) {
                PayProRelPayParaRspBo payParaRetBo;
                PayProMerchantPayInsDataBo payInsDataBo = new PayProMerchantPayInsDataBo();
                payInsDataBo.setPaymentInsId(Long.valueOf(channelDataBO.getPayChannel()));
                List<String> payMethodStrList = Arrays.asList(channelDataBO.getPayMethod().split(","));
                List payMethodList = payMethodStrList.stream().map(value -> Long.valueOf(value.trim())).collect(Collectors.toList());
                payInsDataBo.setPayMethodList(payMethodList);
                List payParaList = JSONArray.parseArray((String)channelDataBO.getPayJson(), PayProPayInsParaDataBo.class);
                payInsDataBo.setPayParaList(payParaList);
                payParaReqBo.setPaymentIns(payInsDataBo);
                if (log.isDebugEnabled()) {
                    log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u914d\u7f6e\u53c2\u6570\u65b0\u589e\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payParaReqBo));
                }
                if ("0000".equals((payParaRetBo = this.payProRelPayParaAbilityService.addRelPayPara(payParaReqBo)).getRespCode())) continue;
                log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u53c2\u6570\u914d\u7f6e\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)payParaRetBo));
                throw new FscBusinessException("193123", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u53c2\u6570\u914d\u7f6e\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff1a" + payParaRetBo.getRespDesc());
            }
        }
    }

    private void delRelIns(PayProRelPayParaReqBo payParaReqBo, FscMerchantPayeeChannelAtomReqBO reqBo) {
        MerchantInfoPaymentManagerReqBO merchantInfoPaymentManagerReqBo = new MerchantInfoPaymentManagerReqBO();
        merchantInfoPaymentManagerReqBo.setMerchantId(payParaReqBo.getMerchantId());
        merchantInfoPaymentManagerReqBo.setOperId(reqBo.getUserId() + "");
        merchantInfoPaymentManagerReqBo.setRemark("\u64cd\u4f5c\u652f\u4ed8\u6e20\u9053");
        merchantInfoPaymentManagerReqBo.setOperTime(new Date());
        merchantInfoPaymentManagerReqBo.setOperType("2");
        ArrayList infoMechartPaymentInsReqList = new ArrayList();
        PaymentInsPo paymentInsPo = new PaymentInsPo();
        List paymentInsPos = this.paymentInsMapper.queryPaymentInf(paymentInsPo);
        paymentInsPos.forEach(paymentInsPoModel -> {
            InfoMechartPaymentInsReqBO infoMechartPaymentInsReqBo = new InfoMechartPaymentInsReqBO();
            infoMechartPaymentInsReqBo.setPaymentInsId(paymentInsPoModel.getPaymentInsId().toString());
            infoMechartPaymentInsReqList.add(infoMechartPaymentInsReqBo);
        });
        merchantInfoPaymentManagerReqBo.setInfoBusiList(infoMechartPaymentInsReqList);
        merchantInfoPaymentManagerReqBo.setInfoBusiListStr(JSONObject.toJSONString(infoMechartPaymentInsReqList));
        log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u914d\u7f6e\u53c2\u6570\u5220\u9664\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payParaReqBo));
        PayCenterRspBo boPayCenterRspBo = this.merchantInfoMMerchantRelPaymentInsManageWebService.merchantRelPaymentInsManage(merchantInfoPaymentManagerReqBo);
        if (!"0000".equals(boPayCenterRspBo.getRespCode())) {
            throw new FscBusinessException("190000", "\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

