/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscTodoSendAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscTodoSendAtomServiceReqBo;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService;
import com.tydic.osworkflow.ability.bo.StartWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceRespBO;
import com.tydic.osworkflow.ability.bo.TaskInfo;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.ProcessStartBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscOrderStatusStartAtomServiceImpl
implements FscOrderStatusStartAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusStartAtomServiceImpl.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessStartBuilder processStartBuilder;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Value(value="${workflow.inst.type:WithInstance}")
    private String workflowInstEnable;
    @Value(value="${workflow.sys.code:CRC}")
    private String workflowSysCode;
    @Autowired
    private OsworkflowStartProcAbilityService osworkflowStartProcAbilityService;
    @Resource(name="fscTodoSyncProvider")
    private ProxyMessageProducer fscTodoSyncProvider;
    @Value(value="${FSC_TODO_SYNC_TOPIC:FSC_TODO_SYNC_TOPIC}")
    private String fscTodoSyncTopic;
    @Value(value="${FSC_TODO_SYNC_TAG:FSC_TODO_SYNC_TAG}")
    private String fscTodoSyncTag;
    @Autowired
    private FscTodoSendAtomService fscTodoSendAtomService;

    @Override
    public FscOrderStatusStartAtomRspBO dealStatusStart(FscOrderStatusStartAtomReqBO reqBO) {
        HashMap<String, Long> variables;
        this.val(reqBO);
        if (null == FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString())) {
            throw new FscBusinessException("194310", "\u8bf7\u914d\u7f6e\u679a\u4e3e");
        }
        String procKey = FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString()).getDescr();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u542f\u52a8\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)), (Object)procKey);
        }
        StartWithInstanceReqBO startWithInstanceReqBO = new StartWithInstanceReqBO();
        startWithInstanceReqBO.setProcDefKey(procKey);
        startWithInstanceReqBO.setVariables(reqBO.getParamMap());
        startWithInstanceReqBO.setPartitonKey(Convert.toStr((Object)reqBO.getOrderId()));
        startWithInstanceReqBO.setSysCode(this.workflowSysCode);
        if (null == startWithInstanceReqBO.getVariables()) {
            variables = new HashMap<String, Long>();
            variables.put("objId", reqBO.getOrderId());
            variables.put("fscOrderId", reqBO.getOrderId());
            variables.put("orderId", reqBO.getOrderId());
            startWithInstanceReqBO.setVariables(variables);
        } else {
            variables = startWithInstanceReqBO.getVariables();
            variables.put("objId", reqBO.getOrderId());
            variables.put("fscOrderId", reqBO.getOrderId());
            variables.put("orderId", reqBO.getOrderId());
            startWithInstanceReqBO.setVariables(variables);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u6d41\u7a0b\u542f\u52a8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)startWithInstanceReqBO));
        }
        StartWithInstanceRespBO startWithInstanceRespBO = this.osworkflowStartProcAbilityService.startWithInstance(startWithInstanceReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u6d41\u7a0b\u542f\u52a8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)startWithInstanceRespBO));
        }
        if (!"0000".equals(startWithInstanceRespBO.getRespCode())) {
            throw new FscBusinessException("194310", "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + startWithInstanceRespBO.getRespCode() + "\u3011," + startWithInstanceRespBO.getRespDesc());
        }
        TaskInfo taskInfo = (TaskInfo)startWithInstanceRespBO.getTaskInfoWithInst().getTaskInfoList().get(0);
        Integer newStatus = this.string2Integer(taskInfo.getStepId());
        String taskId = taskInfo.getTaskId();
        String procInstId = taskInfo.getProcInstId();
        this.updateStatus(reqBO, newStatus, procKey, taskId, procInstId);
        this.writeLog(reqBO);
        FscOrderStatusStartAtomRspBO rspBO = new FscOrderStatusStartAtomRspBO();
        rspBO.setNewStatus(newStatus);
        this.sendTodo(newStatus, reqBO.getOrderId());
        return new FscOrderStatusStartAtomRspBO();
    }

    private void sendTodo(Integer newStatus, Long fscOrderId) {
        FscTodoSendAtomServiceReqBo fscTodoSendAtomServiceReqBo = new FscTodoSendAtomServiceReqBo();
        fscTodoSendAtomServiceReqBo.setNewStatus(newStatus);
        fscTodoSendAtomServiceReqBo.setFscOrderId(fscOrderId);
        this.fscTodoSendAtomService.sendTodo(fscTodoSendAtomServiceReqBo);
    }

    private void val(FscOrderStatusStartAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderFlow()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderFlow]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("194310", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusStartAtomReqBO reqBO, Integer newStatus, String procKey, String taskId, String procInstId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderFlowKey(procKey);
        fscOrderPo.setOrderState(newStatus);
        fscOrderPo.setCreateTimeStart(new Date());
        fscOrderPo.setTaskId(taskId);
        fscOrderPo.setProcInstId(procInstId);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusStartAtomReqBO reqBO) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)reqBO.getOrderFlow())).getDescr());
        fscLogOrdBusiPo.setBusiType(reqBO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
    }
}

