/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.bo.FscBillMailSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService"})
public class FscBillMailSyncAbilityServiceImpl
implements FscBillMailSyncAbilityService {
    @Resource(name="fscSyncBillMailListMqServiceProvider")
    private ProxyMessageProducer fscSyncBillMailListMqServiceProvider;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${es.FSC_BILL_MAIL_SYNC_TOPIC:}")
    private String topic;
    @Value(value="${es.FSC_BILL_MAIL_SYNC_TAG:}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    @PostMapping(value={"syncBillMail"})
    public void syncBillMail(@RequestBody FscBillMailListSyncAbilityReqBO reqBO) {
        FscBillMailSyncReqBO fscBillMailSyncReqBO = new FscBillMailSyncReqBO();
        fscBillMailSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        ProxySendResult proxySendResult = this.fscSyncBillMailListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscBillMailSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO.getFscOrderId());
        }
    }

    @PostMapping(value={"syncAllBillMail"})
    public void syncAllBillMail() {
        FscOrderPO fscOrderPO = new FscOrderPO();
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        for (FscOrderPO orderPO : fscOrderList) {
            FscBillMailSyncReqBO fscBillMailSyncReqBO = new FscBillMailSyncReqBO();
            fscBillMailSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
            ProxySendResult proxySendResult = this.fscSyncBillMailListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscBillMailSyncReqBO)));
            if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
            this.writeFailLog(orderPO.getFscOrderId());
        }
    }

    private void writeFailLog(Long fscOrderId) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_INVOICE_MAIL_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

