/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.bo.ErpOrderWriteOffBo;
import com.tydic.fsc.common.ability.bo.PaymentBo;
import com.tydic.fsc.common.busi.api.FscErpDaYaoPaymentSlipIssuedBusiService;
import com.tydic.fsc.common.busi.bo.FscErpDaYaoPaymentSlipIssuedBusiReqBo;
import com.tydic.fsc.common.busi.bo.FscErpDaYaoPaymentSlipIssuedBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscErpDaYaoPaymentSlipIssuedBusiServiceImpl
implements FscErpDaYaoPaymentSlipIssuedBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscErpDaYaoPaymentSlipIssuedBusiServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Value(value="${fscPayNotifyUrl}")
    private String notifyUrl;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.busi.id:10000001}")
    private String payBusiId;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    @Override
    public FscErpDaYaoPaymentSlipIssuedBusiRspBo dealPaymentSlipIssued(FscErpDaYaoPaymentSlipIssuedBusiReqBo busiReqBo) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FscErpDaYaoPaymentSlipIssuedBusiRspBo fscErpDaYaoPaymentSlipIssuedBusiRspBo = new FscErpDaYaoPaymentSlipIssuedBusiRspBo();
        Date date = new Date();
        if (busiReqBo.getOperType().equals(FscConstants.PayOperType.FSC)) {
            FscOrderPO orderPO = this.getFscOrderPO(busiReqBo.getFscOrderId());
            FscPayRelationPO fscPayRelationPoModelBy = this.getFscPayRelationPO(busiReqBo.getFscOrderId());
            FscPayOrderPO fscPayOrderPoModelBy = this.getFscPayOrderPO(fscPayRelationPoModelBy);
            List<FscOrderPayItemPO> fscOrderPayItemPOS = this.getFscOrderPayItemPOS(busiReqBo);
            HashSet shouldPayIdSet = new HashSet();
            fscOrderPayItemPOS.forEach(fscOrderPayItemPO -> shouldPayIdSet.add(fscOrderPayItemPO.getShouldPayId()));
            ArrayList<Long> shouldPayIdS = new ArrayList<Long>(shouldPayIdSet);
            List<FscShouldPayPO> fscShouldPayPOS = this.getFscShouldPayPOS(shouldPayIdS);
            ArrayList erpOrderWriteOffBos = new ArrayList();
            fscShouldPayPOS.forEach(fscShouldPayPOItem -> {
                ErpOrderWriteOffBo erpOrderWriteOffBo = new ErpOrderWriteOffBo();
                if (!StringUtils.isEmpty((Object)fscShouldPayPOItem.getObjectNo())) {
                    erpOrderWriteOffBo.setOrderNo(fscShouldPayPOItem.getObjectNo());
                }
                erpOrderWriteOffBo.setOrderMoney(fscShouldPayPOItem.getShouldPayAmount());
                erpOrderWriteOffBos.add(erpOrderWriteOffBo);
            });
            ArrayList shouldPayIds = new ArrayList(shouldPayIdSet);
            PaymentBo paymentBo = new PaymentBo();
            paymentBo.setType(fscPayOrderPoModelBy.getPayChannel());
            paymentBo.setValue(fscPayOrderPoModelBy.getPayMethod());
            this.invokeFscOrderStatusFlow(busiReqBo);
        } else if (busiReqBo.getOperType().equals(FscConstants.PayOperType.ORDER) || busiReqBo.getOperType().equals(FscConstants.PayOperType.QRY)) {
            List<FscOrderPayItemPO> fscOrderPayItemPoS = this.getFscOrderPayItemPOS(busiReqBo);
            FscOrderPayItemPO fscOrderPayItemPo = fscOrderPayItemPoS.get(0);
            FscPayRelationPO fscPayRelationPo = this.getFscPayRelationPO(fscOrderPayItemPo.getFscOrderId());
            FscPayOrderPO fscPayOrderPo = this.getFscPayOrderPO(fscPayRelationPo);
            HashSet shouldPayIdSet = new HashSet();
            fscOrderPayItemPoS.forEach(fscOrderPayItemPoModel -> shouldPayIdSet.add(fscOrderPayItemPoModel.getShouldPayId()));
            ArrayList<Long> shouldPayIdS = new ArrayList<Long>(shouldPayIdSet);
            List<FscShouldPayPO> fscShouldPayPoS = this.getFscShouldPayPOS(shouldPayIdS);
            this.sendPay(busiReqBo, fscPayOrderPo, fscShouldPayPoS);
        }
        return fscErpDaYaoPaymentSlipIssuedBusiRspBo;
    }

    private void sendPay(FscErpDaYaoPaymentSlipIssuedBusiReqBo busiReqBo, FscPayOrderPO fscPayOrderPo, List<FscShouldPayPO> fscShouldPayPoS) {
        HashMap<String, String> content = new HashMap<String, String>(9);
        content.put("busiId", this.payBusiId);
        content.put("busiCode", this.payBusiCode);
        content.put("notifyUrl", this.notifyUrl);
        content.put("createOperId", busiReqBo.getUserId().toString());
        content.put("creatOperName", busiReqBo.getUserName());
        content.put("TradeTime", new Date().toString());
        content.put("payNotifyTransId", fscPayOrderPo.getPayOrderId().toString());
        content.put("outOrderId", fscPayOrderPo.getPayOrderId().toString());
        content.put("paymentInsId", "51");
        content.put("PayMethod", fscShouldPayPoS.get(0).getPayChannel().toString());
        if (busiReqBo.getOperType().equals(FscConstants.PayOperType.ORDER)) {
            content.put("resultCode", "SUCCESS");
        } else if (busiReqBo.getOperType().equals(FscConstants.PayOperType.QRY)) {
            content.put("resultCode", "FAIL");
        }
        String contentSend = JSONObject.toJSONString(content);
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(this.payBusiId);
        dataEncryptionReqBo.setContent(contentSend);
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("busiId", this.payBusiId);
        postParams.put("busiCode", this.payBusiCode);
        postParams.put("content", dataEncryptionRspBo.getEncrypData());
        String resultData = null;
        try {
            log.debug("\u7ebf\u4e0b\u652f\u4ed8\u5f00\u59cb\u56de\u8c03\u4e86--------------------------------------------------" + postParams + "-----url" + this.notifyUrl);
            resultData = HttpUtil.sendPost((String)this.notifyUrl, postParams);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
    }

    private void invokeFscOrderStatusFlow(FscErpDaYaoPaymentSlipIssuedBusiReqBo busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private FscAttachmentPO getFscAttachmentPO(Long fscOrderId) {
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(fscOrderId);
        FscAttachmentPO fscAttachmentPoModelBy = this.fscAttachmentMapper.getModelBy(fscAttachmentPo);
        return fscAttachmentPoModelBy;
    }

    private FscOrderPO getFscOrderPO(Long fscOrderId) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(orderPO);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u6536\u6b3e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        return modelBy;
    }

    private List<FscShouldPayPO> getFscShouldPayPOS(List<Long> shouldPayIdS) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(shouldPayIdS);
        List fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscShouldPayPOS;
    }

    private List<FscOrderPayItemPO> getFscOrderPayItemPOS(FscErpDaYaoPaymentSlipIssuedBusiReqBo busiReqBo) {
        FscOrderPayItemPO fscOrderPayItemPoSelect = new FscOrderPayItemPO();
        fscOrderPayItemPoSelect.setFscOrderId(busiReqBo.getFscOrderId());
        List fscOrderPayItemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPoSelect);
        if (CollectionUtils.isEmpty((Collection)fscOrderPayItemPOS)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u660e\u7ec6\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderPayItemPOS;
    }

    private FscPayOrderPO getFscPayOrderPO(FscPayRelationPO fscPayRelationPoModelBy) {
        FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
        fscPayOrderPO.setPayOrderId(fscPayRelationPoModelBy.getPayOrderId());
        FscPayOrderPO fscPayOrderPoModelBy = this.fscPayOrderMapper.getModelBy(fscPayOrderPO);
        if (fscPayOrderPoModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscPayOrderPoModelBy;
    }

    private FscPayRelationPO getFscPayRelationPO(Long fscOrderId) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setFscOrderId(fscOrderId);
        FscPayRelationPO fscPayRelationPoModelBy = this.fscPayRelationMapper.getModelBy(fscPayRelationPO);
        if (fscPayRelationPoModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscPayRelationPoModelBy;
    }
}

