/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService"})
public class FscOrderItemDetailQueryAbilityServiceImpl
implements FscOrderItemDetailQueryAbilityService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryOrderItemDetail"})
    public FscOrderItemDetailQueryAbilityRspBO queryOrderItemDetail(@RequestBody FscOrderItemDetailQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        if (null != reqBO.getFscOrderId()) {
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdList())) {
            fscOrderItemPO.setFscOrderIdList(reqBO.getFscOrderIdList());
        }
        List fscOrderItemPOS = this.fscOrderItemMapper.getList(fscOrderItemPO);
        List fscOrderItemDetailBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderItemPOS), FscOrderItemDetailBO.class);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(reqBO.getFscOrderIdList());
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        for (FscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailBOS) {
            for (FscOrderPO orderPO : fscOrderList) {
                String specModel;
                String model;
                if (!orderPO.getFscOrderId().equals(fscOrderItemDetailBO.getFscOrderId())) continue;
                fscOrderItemDetailBO.setOrderNo(orderPO.getOrderNo());
                fscOrderItemDetailBO.setOrderDesc(orderPO.getOrderDesc());
                fscOrderItemDetailBO.setPurchaserName(orderPO.getPurchaserName());
                fscOrderItemDetailBO.setTaxCode(fscOrderItemDetailBO.getTaxCode());
                String productId = fscOrderItemDetailBO.getOrderItemId() + "-" + fscOrderItemDetailBO.getId();
                fscOrderItemDetailBO.setProductId(productId);
                String spec = fscOrderItemDetailBO.getSpec();
                if (StringUtils.isEmpty((Object)spec)) {
                    spec = "";
                }
                if (StringUtils.isEmpty((Object)(model = fscOrderItemDetailBO.getModel()))) {
                    model = "";
                }
                if ((specModel = spec + "," + model).trim().equals(",")) {
                    specModel = "";
                }
                fscOrderItemDetailBO.setSpecModel(specModel);
                BigDecimal untaxPrice = fscOrderItemDetailBO.getUntaxAmt().divide(fscOrderItemDetailBO.getNum(), 3, RoundingMode.HALF_UP);
                fscOrderItemDetailBO.setUntaxPrice(untaxPrice);
            }
        }
        FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = new FscOrderItemDetailQueryAbilityRspBO();
        fscOrderItemDetailQueryAbilityRspBO.setFscOrderItemDetailBOS(fscOrderItemDetailBOS);
        return fscOrderItemDetailQueryAbilityRspBO;
    }
}

