/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.common.busi.api.FscComInvoiceListSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscComOrderSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComInvoiceBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderListBusiService;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderSyncRspBO;
import com.tydic.fsc.common.config.ApplicationContextProvider;
import com.tydic.fsc.constants.FscConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscOrderSyncThreadsImpl {
    private static final Logger log = LoggerFactory.getLogger(FscOrderSyncThreadsImpl.class);
    private static Boolean isSyncStatistics;
    private static List<FscComOrderListQueryBusiReqBO> failureCombReqBO;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public synchronized Boolean handleList(List<FscComOrderListQueryBusiReqBO> data, int threadNum) throws InterruptedException {
        boolean isFailure = false;
        int length = data.size();
        int maxThreadNum = Runtime.getRuntime().availableProcessors();
        if (threadNum <= 0) {
            threadNum = maxThreadNum;
        } else if (threadNum > maxThreadNum) {
            threadNum = maxThreadNum;
        }
        if (length < threadNum) {
            threadNum = length;
        }
        log.info("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b\u6570{}--------------", (Object)threadNum);
        failureCombReqBO = new ArrayList<FscComOrderListQueryBusiReqBO>();
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        int baseNum = length / threadNum;
        int remainderNum = length % threadNum;
        int end = 0;
        for (int i = 0; i < threadNum; ++i) {
            int start = end;
            end = start + baseNum;
            if (i == threadNum - 1) {
                end = length;
            } else if (i < remainderNum) {
                ++end;
            }
            List<FscComOrderListQueryBusiReqBO> threadData = data.subList(start, end);
            HandleThread thread = new HandleThread(threadData, countDownLatch);
            thread.start();
        }
        countDownLatch.await();
        log.info("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u7ed3\u675f--------------");
        if (CollectionUtils.isNotEmpty(failureCombReqBO)) {
            log.info("---ES\u6279\u91cf\u591a\u7ebf\u7a0b\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a{}\uff0c\u5931\u8d25\u6570\u636e\uff1a{}", (Object)failureCombReqBO.size(), (Object)JSON.toJSONString(failureCombReqBO));
            if (!isFailure) {
                isFailure = true;
            }
        }
        failureCombReqBO = null;
        return isFailure;
    }

    static {
        failureCombReqBO = new ArrayList<FscComOrderListQueryBusiReqBO>();
    }

    static class HandleThread
    extends Thread {
        private final List<FscComOrderListQueryBusiReqBO> data;
        private final CountDownLatch countDownLatch;
        private FscComOrderSyncEsBusiService fscComOrderSyncEsBusiService;
        private FscEsSyncComOrderListBusiService fscEsSyncComOrderListBusiService;
        private FscComInvoiceListSyncEsBusiService fscComInvoiceListSyncEsBusiService;
        private FscEsSyncComInvoiceBusiService fscEsSyncComInvoiceBusiService;

        public HandleThread(List<FscComOrderListQueryBusiReqBO> data, CountDownLatch countDownLatch) {
            this.data = data;
            this.countDownLatch = countDownLatch;
            this.fscComOrderSyncEsBusiService = ApplicationContextProvider.getBean(FscComOrderSyncEsBusiService.class);
            this.fscEsSyncComOrderListBusiService = ApplicationContextProvider.getBean(FscEsSyncComOrderListBusiService.class);
            this.fscComInvoiceListSyncEsBusiService = ApplicationContextProvider.getBean(FscComInvoiceListSyncEsBusiService.class);
            this.fscEsSyncComInvoiceBusiService = ApplicationContextProvider.getBean(FscEsSyncComInvoiceBusiService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (!CollectionUtils.isNotEmpty(this.data)) return;
            Iterator<FscComOrderListQueryBusiReqBO> iterator = this.data.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.countDownLatch.countDown();
                    return;
                }
                FscComOrderListQueryBusiReqBO combReqBO = iterator.next();
                try {
                    Class<FscOrderSyncThreadsImpl> clazz;
                    if (FscConstants.FSC_OBJ_TYPE.ORDER.equals(combReqBO.getObjType())) {
                        Object fscComOrderListEsSyncRspBO;
                        FscComOrderSyncRspBO combRspBO = this.fscComOrderSyncEsBusiService.dealComOrderSyncEs(combReqBO);
                        if ("0000".equals(combRspBO.getRespCode())) {
                            fscComOrderListEsSyncRspBO = this.fscEsSyncComOrderListBusiService.esSyncComOrderList(combRspBO.getFscComOrderListEsSyncReqBO());
                            if ("0000".equals(fscComOrderListEsSyncRspBO.getRespCode())) continue;
                            clazz = FscOrderSyncThreadsImpl.class;
                            // MONITORENTER : com.tydic.fsc.common.ability.impl.FscOrderSyncThreadsImpl.class
                            failureCombReqBO.add(combReqBO);
                            // MONITOREXIT : clazz
                            log.error("ES\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u7ed3\u7b97\u5355ID\uff1a{}, \u539f\u56e0\uff1a{}", (Object)combReqBO.getFscOrderId(), (Object)fscComOrderListEsSyncRspBO.getRespDesc());
                            continue;
                        }
                        fscComOrderListEsSyncRspBO = FscOrderSyncThreadsImpl.class;
                        // MONITORENTER : com.tydic.fsc.common.ability.impl.FscOrderSyncThreadsImpl.class
                        failureCombReqBO.add(combReqBO);
                        // MONITOREXIT : fscComOrderListEsSyncRspBO
                        log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u7ed3\u7b97\u5355\u6570\u636e-\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                        continue;
                    }
                    if (!FscConstants.FSC_OBJ_TYPE.INVOICE.equals(combReqBO.getObjType())) continue;
                    FscComInvoiceListQueryBusiReqBO fscComInvoiceListQueryBusiReqBO = new FscComInvoiceListQueryBusiReqBO();
                    fscComInvoiceListQueryBusiReqBO.setFscOrderId(combReqBO.getFscOrderId());
                    FscComInvoiceListSyncRspBO fscComInvoiceListSyncRspBO = this.fscComInvoiceListSyncEsBusiService.dealBillInvoiceListSyncEs(fscComInvoiceListQueryBusiReqBO);
                    if ("0000".equals(fscComInvoiceListSyncRspBO.getRespCode())) {
                        FscComInvoiceListEsSyncRspBO fscComInvoiceListEsSyncRspBO = this.fscEsSyncComInvoiceBusiService.esSyncBillInvoiceList(fscComInvoiceListSyncRspBO.getFscOrderInvoiceEsSyncReqBOList());
                        if ("0000".equals(fscComInvoiceListEsSyncRspBO.getRespCode())) continue;
                        Class<FscOrderSyncThreadsImpl> clazz2 = FscOrderSyncThreadsImpl.class;
                        // MONITORENTER : com.tydic.fsc.common.ability.impl.FscOrderSyncThreadsImpl.class
                        failureCombReqBO.add(combReqBO);
                        // MONITOREXIT : clazz2
                        log.error("ES\u540c\u6b65\u53d1\u7968\u5931\u8d25\uff0c\u7ed3\u7b97\u5355ID\uff1a{}, \u539f\u56e0\uff1a{}", (Object)combReqBO.getFscOrderId(), (Object)fscComInvoiceListEsSyncRspBO.getRespDesc());
                        continue;
                    }
                    clazz = FscOrderSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.fsc.common.ability.impl.FscOrderSyncThreadsImpl.class
                    failureCombReqBO.add(combReqBO);
                    // MONITOREXIT : clazz
                    log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u53d1\u7968\u6570\u636e-\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                }
                catch (Exception e) {
                    Class<FscOrderSyncThreadsImpl> clazz = FscOrderSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.fsc.common.ability.impl.FscOrderSyncThreadsImpl.class
                    failureCombReqBO.add(combReqBO);
                    // MONITOREXIT : clazz
                    log.error("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u67e5\u8be2\u5f02\u5e38,\u7ed3\u7b97\u5355ID\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO.getFscOrderId()));
                    continue;
                }
                break;
            }
        }
    }
}

