/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService"})
public class FscComOrderCancelAbilityServiceImpl
implements FscComOrderCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"dealOrderCancel"})
    public FscComOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscComOrderCancelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191125", "\u67e5\u8be2\u5bf9\u8d26\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u5bf9\u8d26\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u5bf9\u8d26\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u7535\u5546\u4fa7\u5bf9\u8d26\u5355\u53d6\u6d88\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\uff0c\u540e\u7eed\u72b6\u6001\u5f85\u4e0e\u7535\u5546\u5bf9\u63a5\u53d6\u6d88\u53d1\u7968\u63a5\u53e3\u540e\u542f\u7528");
        }
        if (FscConstants.FscTransOrderType.TRANSFEE.equals(fscOrderPO.getFscTransOrderType())) {
            throw new FscBusinessException("191125", "\u8fd0\u8d39\u5bf9\u8d26\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (fscOrderPO.getTotalCharge().compareTo(BigDecimal.ZERO) <= 0) {
            throw new FscBusinessException("191125", "\u9000\u8d27\u5bf9\u8d26\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (fscOrderPO.getTotalCharge().compareTo(BigDecimal.ZERO) > 0) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
            List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new FscBusinessException("191125", "\u67e5\u8be2\u5bf9\u8d26\u5355\u660e\u7ec6\u4e3a\u7a7a\uff0c\u53d6\u6d88\u5931\u8d25");
            }
            List saleOrderIdList = list.stream().map(FscOrderRelationPO::getSaleOrderId).distinct().collect(Collectors.toList());
            FscOrderRelationPO fscOrderRelationPoCheck = new FscOrderRelationPO();
            fscOrderRelationPoCheck.setSaleOrderIds(saleOrderIdList);
            int listByNotCancelCount = this.fscOrderRelationMapper.getListByNotCancelCount(fscOrderRelationPoCheck);
            if (listByNotCancelCount > 0) {
                throw new FscBusinessException("191125", "\u8be5\u5bf9\u8d26\u5355\u4e2d\u6709\u8ba2\u5355\u5df2\u7ecf\u6709\u8d85\u671f\u552e\u540e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
        }
        reqBO.setOrderState(fscOrderPO.getOrderState());
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
        busiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
        FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
        if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscComOrderCancelAbilityRspBO();
    }

    private void sendMq(FscComOrderCancelAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

