/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.service.order.UocUpdateSaleTemporaryContractService;
import com.tydic.dyc.oc.service.order.bo.UocUpdateSaleTemporaryContractReqBo;
import com.tydic.dyc.oc.service.order.bo.UocUpdateSaleTemporaryContractRspBo;
import com.tydic.dyc.oc.service.order.bo.UpdateSaleTemporaryContractBo;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderCancelBusiServiceImpl
implements FscComOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocUpdateSaleTemporaryContractService uocUpdateSaleTemporaryContractService;

    @Override
    public FscComOrderCancelBusiRspBO dealOrderCancel(FscComOrderCancelBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)((Object)reqBO));
        FscOrderCancelAtomReqBO fscOrderCancelAtomReqBO = (FscOrderCancelAtomReqBO)JSON.parseObject((String)jsonString, FscOrderCancelAtomReqBO.class);
        FscOrderCancelAtomRspBO fscOrderCancelAtomRspBO = this.fscOrderCancelAtomService.dealCancelStatus(fscOrderCancelAtomReqBO);
        if (!"0000".equals(fscOrderCancelAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193124", fscOrderCancelAtomRspBO.getRespDesc());
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setCancelOperId(reqBO.getUserId().toString());
        fscOrderPo.setCancelTime(new Date());
        fscOrderPo.setCancelOperName(reqBO.getName());
        this.fscOrderMapper.updateById(fscOrderPo);
        this.syncOrderStatus(reqBO.getOrderId());
        FscOrderRelationPO fscOrderRelationPoWhere = new FscOrderRelationPO();
        fscOrderRelationPoWhere.setFscOrderId(reqBO.getOrderId());
        FscOrderRelationPO fscOrderRelationPoSet = new FscOrderRelationPO();
        fscOrderRelationPoSet.setIsDel(FscConstants.DELETE_TAG.DELETED);
        this.fscOrderRelationMapper.updateBy(fscOrderRelationPoSet, fscOrderRelationPoWhere);
        return new FscComOrderCancelBusiRspBO();
    }

    private FscOrderPO getFscOrderPO(Long fscOrderId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u8be6\u60c5\u4e3a\u7a7a");
        }
        return fscOrderMapperModelBy;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscOrderPO fscOrderPo = this.getFscOrderPO(fscOrderId);
        log.debug("\u540c\u6b65\u8ba2\u5355\u72b6\u6001po{}", (Object)fscOrderPo);
        if (FscConstants.FscTransOrderType.ORDER.equals(fscOrderPo.getFscTransOrderType()) || FscConstants.FscTransOrderType.NEGATIVE.equals(fscOrderPo.getFscTransOrderType())) {
            log.debug("\u8fdb\u5165\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u4e86{}", (Object)fscOrderPo.getFscTransOrderType());
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        }
    }

    private void updateTemporary(List<FscOrderRelationPO> fscOrderRelationPoList) {
        List<FscOrderRelationPO> subFscOrderRelationPoList = fscOrderRelationPoList.stream().filter(fscOrderRelationPo -> FscConstants.PayOrderType.FIXED_LIMIT_ADD_PAY_FIRST.equals(fscOrderRelationPo.getTruePayMod()) || FscConstants.PayOrderType.TEMPORARY_LIMIT_ADD_PAY_FIRST.equals(fscOrderRelationPo.getTruePayMod())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(subFscOrderRelationPoList)) {
            HashMap updateSaleTemporaryContractBoMap = new HashMap(subFscOrderRelationPoList.size());
            subFscOrderRelationPoList.forEach(subFscOrderRelationPo -> {
                if (updateSaleTemporaryContractBoMap.get(subFscOrderRelationPo.getSaleOrderId()) == null) {
                    UpdateSaleTemporaryContractBo updateSaleTemporaryContractBo = new UpdateSaleTemporaryContractBo();
                    updateSaleTemporaryContractBo.setSurplusCombinedPaymentCreditAdd(subFscOrderRelationPo.getCombinedPaymentCredit());
                    updateSaleTemporaryContractBo.setSurplusPaymentLimitAdd(subFscOrderRelationPo.getPaymentLimit());
                    updateSaleTemporaryContractBo.setSaleOrderId(subFscOrderRelationPo.getSaleOrderId());
                    updateSaleTemporaryContractBoMap.put(subFscOrderRelationPo.getSaleOrderId(), updateSaleTemporaryContractBo);
                } else {
                    UpdateSaleTemporaryContractBo updateSaleTemporaryContractBo = (UpdateSaleTemporaryContractBo)updateSaleTemporaryContractBoMap.get(subFscOrderRelationPo.getSaleOrderId());
                    updateSaleTemporaryContractBo.setSurplusPaymentLimitAdd(updateSaleTemporaryContractBo.getSurplusPaymentLimitAdd().add(subFscOrderRelationPo.getPaymentLimit()));
                    updateSaleTemporaryContractBo.setSurplusCombinedPaymentCreditAdd(updateSaleTemporaryContractBo.getSurplusCombinedPaymentCreditAdd().add(subFscOrderRelationPo.getCombinedPaymentCredit()));
                    updateSaleTemporaryContractBoMap.put(subFscOrderRelationPo.getSaleOrderId(), updateSaleTemporaryContractBo);
                }
            });
            UocUpdateSaleTemporaryContractReqBo uocUpdateSaleTemporaryContractReqBo = new UocUpdateSaleTemporaryContractReqBo();
            ArrayList updateSaleTemporaryContractBoList = new ArrayList(updateSaleTemporaryContractBoMap.values());
            uocUpdateSaleTemporaryContractReqBo.setUpdateSaleTemporaryContractBoList(updateSaleTemporaryContractBoList);
            log.debug("\u5bf9\u8d26\u5355\u53d6\u6d88\u8c03\u7528\u6388\u4fe1\u66f4\u65b0\u63a5\u53e3\u5165\u53c2{}", (Object)uocUpdateSaleTemporaryContractReqBo);
            UocUpdateSaleTemporaryContractRspBo uocUpdateSaleTemporaryContractRspBo = this.uocUpdateSaleTemporaryContractService.updateSaleTemporaryContract(uocUpdateSaleTemporaryContractReqBo);
            log.debug("\u5bf9\u8d26\u5355\u53d6\u6d88\u8c03\u7528\u6388\u4fe1\u66f4\u65b0\u63a5\u53e3\u51fa\u53c2{}", (Object)uocUpdateSaleTemporaryContractRspBo);
            if (!"0000".equals(uocUpdateSaleTemporaryContractRspBo.getRespCode())) {
                throw new FscBusinessException("190000", "\u6388\u4fe1\u66f4\u65b0\u63a5\u53e3\u5931\u8d25");
            }
        }
    }

    private List<FscOrderRelationPO> getFscOrderRelationPoList(FscComOrderCancelBusiReqBO reqBO) {
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        List fscOrderRelationMapperList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationMapperList)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5bf9\u8d26\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        return fscOrderRelationMapperList;
    }
}

