/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderConfirmBusiServiceImpl
implements FscComOrderConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderConfirmBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    public static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    public static final String BUSI_CODE = "1005";

    @Override
    public FscComOrderConfirmBusiRspBO dealOrderConfirm(FscComOrderConfirmBusiReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        set.setOrderConfirmId(reqBO.getUserName());
        set.setOrderConfirmName(reqBO.getName());
        set.setOrderConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getOrderId());
        this.fscOrderMapper.updateBy(set, where);
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.TO_BE_CONFIRM.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setUserId(reqBO.getUserId());
        flowAtomReqBO.setUserName(reqBO.getUserName());
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193110", flowAtomRspBO.getRespDesc());
        }
        this.nextFlow(reqBO, flowAtomReqBO);
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscOrderInvoicePo);
        fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePo);
        if (reqBO.getInvoiceCategory() != null) {
            Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
            if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
                elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
            }
            FscInvoiceRulePO fscInvoiceRulePo = new FscInvoiceRulePO();
            fscInvoiceRulePo.setFscOrderId(reqBO.getOrderId());
            fscInvoiceRulePo.setElecFlag(elecFlag);
            this.fscInvoiceRuleMapper.updateById(fscInvoiceRulePo);
        }
        return new FscComOrderConfirmBusiRspBO();
    }

    private void nextFlow(FscComOrderConfirmBusiReqBO reqBO, FscOrderStatusFlowAtomReqBO flowAtomReqBO) {
        log.debug("\u6b21\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u5df2\u7ecf\u5206\u8d26\u5219\u7ee7\u7eed\u6d41\u8f6c\u5230\u5df2\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u5f00\u59cb");
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrderMapperModelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u4e3b\u5355\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (fscOrderMapperModelBy.getIsDivideAccount() != null && FscConstants.IsDivideAccount.YES.equals(fscOrderMapperModelBy.getIsDivideAccount())) {
            flowAtomReqBO.setCurStatus(Integer.valueOf(1013));
            HashMap<String, Integer> param = new HashMap<String, Integer>(1);
            param.put("confirmFlag", 0);
            log.debug("\u6b21\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u5df2\u7ecf\u5206\u8d26\u5219\u7ee7\u7eed\u6d41\u8f6c\u5230\u5df2\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u5165\u53c2{}", (Object)flowAtomReqBO);
            FscOrderStatusFlowAtomRspBO flowAtomRspBoNext = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            log.debug("\u6b21\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u5df2\u7ecf\u5206\u8d26\u5219\u7ee7\u7eed\u6d41\u8f6c\u5230\u5df2\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u51fa\u53c2{}", (Object)flowAtomRspBoNext);
            if (!"0000".equals(flowAtomRspBoNext.getRespCode())) {
                throw new FscBusinessException("193110", flowAtomRspBoNext.getRespDesc());
            }
        }
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscComOrderConfirmBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193110", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }
}

