/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscPayCallbackContentBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayIntfLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayIntfLogPO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService"})
public class FscPayBillCallbackAbilityServiceImpl
implements FscPayBillCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackAbilityServiceImpl.class);
    @Value(value="${payPublicKey}")
    private String payPublicKey;
    @Autowired
    private FscPayBillCallbackBusiService fscPayBillCallbackBusiService;
    @Autowired
    private FscPayIntfLogMapper fscPayIntfLogMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Value(value="${payCallBackFail:}")
    private String payCallBackFailFlag;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"dealPayBillCallback"})
    public FscPayBillCallbackAbilityRspBO dealPayBillCallback(@RequestBody FscPayBillCallbackAbilityReqBO abilityReqBO) {
        FscPayCallbackContentBO fscPayCallbackContentBO;
        if (abilityReqBO.getOutOrderId() != null) {
            fscPayCallbackContentBO = new FscPayCallbackContentBO();
            fscPayCallbackContentBO.setOutOrderId(abilityReqBO.getOutOrderId().toString());
        } else {
            String content = PayCenterUtils.deCode((String)abilityReqBO.getContent(), (String)this.payPublicKey);
            fscPayCallbackContentBO = (FscPayCallbackContentBO)JSON.parseObject((String)content, FscPayCallbackContentBO.class);
            if ("payCallBackFailFlag".equals(this.payCallBackFailFlag)) {
                fscPayCallbackContentBO.setResultCode("FAIL");
                log.debug("\u6d4b\u8bd5\u5931\u8d25\u573a\u666f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayCallbackContentBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
        FscPayBillCallbackBusiReqBO fscPayBillCallbackBusiReqBO = new FscPayBillCallbackBusiReqBO();
        fscPayCallbackContentBO.setPayMethod(fscPayCallbackContentBO.getPaymentInsId().toString());
        fscPayBillCallbackBusiReqBO.setFscPayCallbackContentBO(fscPayCallbackContentBO);
        FscPayBillCallbackBusiRspBO busiRspBO = this.fscPayBillCallbackBusiService.dealPayBillCallback(fscPayBillCallbackBusiReqBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getResultFscOrderIds())) {
            FscOrderPO orderPoModel = new FscOrderPO();
            orderPoModel.setFscOrderIds(busiRspBO.getResultFscOrderIds());
            List fscOrderPoS = this.fscOrderMapper.getList(orderPoModel);
            if (CollectionUtils.isEmpty((Collection)fscOrderPoS)) {
                throw new FscBusinessException("190000", "\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            if ("0000".equals(busiRspBO.getRespCode())) {
                fscOrderPoS.forEach(fscOrderPO -> {
                    if (!fscOrderPO.getOrderFlow().equals(FscConstants.OrderFlow.PL_SERVICE_FEE) && !fscOrderPO.getOrderFlow().equals(FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE)) {
                        log.debug("\u6d4b\u8bd5\u4ed8\u6b3e\u7533\u8bf7\u5355\u540c\u6b65es\u5f00\u59cb\u4e86----------------------------------------------------------" + busiRspBO.getResultFscOrderIds().toString());
                        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                    }
                });
            }
        }
        FscPayBillCallbackAbilityRspBO abilityRspBO = (FscPayBillCallbackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillCallbackAbilityRspBO.class);
        FscPayIntfLogPO fscPayIntfLogPO = new FscPayIntfLogPO();
        fscPayIntfLogPO.setCreateTime(new Date());
        fscPayIntfLogPO.setReqJson(JSON.toJSONString((Object)abilityReqBO));
        fscPayIntfLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayIntfLogPO.setIntfResult(FscConstants.InfcProcessResult.SUCCESS);
        fscPayIntfLogPO.setSerialNo(fscPayCallbackContentBO.getOutOrderId());
        if ("0000".equals(busiRspBO.getRespCode())) {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.SUCCESS);
        } else {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.FAIL);
            fscPayIntfLogPO.setRspJson(JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        fscPayIntfLogPO.setServiceCode("FscPayBillCallbackAbilityService");
        this.fscPayIntfLogMapper.insert(fscPayIntfLogPO);
        return abilityRspBO;
    }
}

