/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComErpPayOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscComErpPayOffAbilityReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscRefundFailureRecordMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPaySuccessCallBackOrderBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.bill.util.DateUtil;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillCallbackBusiServiceImpl
implements FscPayBillCallbackBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackBusiServiceImpl.class);
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComErpPayOffAbilityService fscComErpPayOffAbilityService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private FscRefundFailureRecordMapper fscRefundFailureRecordMapper;

    @Override
    public FscPayBillCallbackBusiRspBO dealPayBillCallback(FscPayBillCallbackBusiReqBO busiReqBO) {
        FscPayRelationPO fscPayRelationPoModel = new FscPayRelationPO();
        fscPayRelationPoModel.setPayOrderId(Long.valueOf(busiReqBO.getFscPayCallbackContentBO().getOutOrderId()));
        FscPayRelationPO fscPayRelationMapperModelBySelect = this.fscPayRelationMapper.getModelBy(fscPayRelationPoModel);
        if (fscPayRelationMapperModelBySelect == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u5173\u7cfb\u4e3a\u7a7a");
        }
        FscOrderPayItemPO fscOrderPayItemPoModel = new FscOrderPayItemPO();
        fscOrderPayItemPoModel.setFscOrderId(fscPayRelationMapperModelBySelect.getFscOrderId());
        List fscOrderPayItemMapperModelBy = this.fscOrderPayItemMapper.getList(fscOrderPayItemPoModel);
        if (CollectionUtils.isEmpty((Collection)fscOrderPayItemMapperModelBy)) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u652f\u4ed8\u5173\u7cfb\u660e\u7ec6\u4e3a\u7a7a");
        }
        FscShouldPayPO fscShouldPayPoModel = new FscShouldPayPO();
        fscShouldPayPoModel.setShouldPayId(((FscOrderPayItemPO)fscOrderPayItemMapperModelBy.get(0)).getShouldPayId());
        FscShouldPayPO fscShouldPayMapperModel = this.fscShouldPayMapper.getModelBy(fscShouldPayPoModel);
        if (fscShouldPayMapperModel == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u5e94\u4ed8\u4fe1\u606f\u4e3a\u7a7a");
        }
        Long payOrderId = Long.parseLong(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
        this.updatePayOrder(payOrderId, busiReqBO);
        this.updateMainOrder(busiReqBO, payOrderId);
        List<Long> payFscOrderId = this.getFscOrderId(payOrderId);
        this.invokeFscOrderStatusFlow(payFscOrderId, busiReqBO);
        List<Long> temp = this.updateFscOrderOrOrder(payFscOrderId, busiReqBO);
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>(payFscOrderId);
        if (!CollectionUtils.isEmpty(temp)) {
            resultFscOrderIds.addAll(temp);
        }
        FscOrderPO set = new FscOrderPO();
        set.setPayOperId(busiReqBO.getFscPayCallbackContentBO().getCreateOperId());
        set.setPayOperName(busiReqBO.getFscPayCallbackContentBO().getCreatOperName());
        set.setPayTime(DateUtil.strToDateyyyyMMddHHmmss((String)busiReqBO.getFscPayCallbackContentBO().getTradeTime()));
        set.setTransactionId(busiReqBO.getFscPayCallbackContentBO().getPayNotifyTransId());
        set.setUpdateTime(new Date());
        set.setPayState(FscConstants.PayStatus.PAYED);
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(payFscOrderId);
        this.fscOrderMapper.updateBy(set, where);
        FscPayBillCallbackBusiRspBO busiRspBO = new FscPayBillCallbackBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBoS = new ArrayList<FscPaySuccessCallBackOrderBO>();
        FscPaySuccessCallBackOrderBO fscPaySuccessCallBackOrderBO = new FscPaySuccessCallBackOrderBO();
        fscPaySuccessCallBackOrderBO.setObjectId(fscShouldPayMapperModel.getObjectId());
        fscPaySuccessCallBackOrderBO.setOrderId(fscShouldPayMapperModel.getOrderId());
        fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(true));
        fscPaySuccessCallBackOrderBoS.add(fscPaySuccessCallBackOrderBO);
        busiRspBO.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBoS);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return busiRspBO;
    }

    private void updateMainOrder(FscPayBillCallbackBusiReqBO busiReqBO, Long payOrderId) {
        FscPayRelationPO fscPayRelationPo = new FscPayRelationPO();
        fscPayRelationPo.setPayOrderId(payOrderId);
        FscPayRelationPO fscPayRelationMapperModelBy = this.fscPayRelationMapper.getModelBy(fscPayRelationPo);
        if (fscPayRelationMapperModelBy != null) {
            FscOrderPO fscOrderPoWhere = new FscOrderPO();
            fscOrderPoWhere.setFscOrderId(fscPayRelationMapperModelBy.getFscOrderId());
            FscOrderPO fscOrderPoSet = new FscOrderPO();
            fscOrderPoSet.setPayChannel(busiReqBO.getFscPayCallbackContentBO().getPaymentInsId().toString());
            fscOrderPoSet.setPayMethod(busiReqBO.getFscPayCallbackContentBO().getPayMethod());
            this.fscOrderMapper.updateBy(fscOrderPoSet, fscOrderPoWhere);
        }
    }

    private void sendMq(Long fscOrderId, FscPayBillCallbackBusiReqBO reqBO) {
        FscComErpPayOffAbilityReqBo fscComErpPayOffAbilityReqBo = new FscComErpPayOffAbilityReqBo();
        fscComErpPayOffAbilityReqBo.setFscOrderId(fscOrderId);
        fscComErpPayOffAbilityReqBo.setUserId(Long.valueOf(reqBO.getFscPayCallbackContentBO().getCreateOperId()));
        fscComErpPayOffAbilityReqBo.setUserName(reqBO.getFscPayCallbackContentBO().getCreatOperName());
        this.fscComErpPayOffAbilityService.dealErpPayOff(fscComErpPayOffAbilityReqBo);
    }

    private List<Long> updateFscOrderOrOrder(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setFscPayCallbackContentBO(busiReqBO.getFscPayCallbackContentBO());
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(payFscOrderId);
        FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193201", atomRspBO.getRespDesc());
        }
        return atomRspBO.getResultFscOrderIds();
    }

    private void updatePayOrder(Long payOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAY_FAIL);
        } else {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAIED);
        }
        fscPayOrderPO.setPayMethod(busiReqBO.getFscPayCallbackContentBO().getPayMethod());
        fscPayOrderPO.setUpdateTime(new Date());
        fscPayOrderPO.setPayOrderId(payOrderId);
        int count = this.fscPayOrderMapper.updateById(fscPayOrderPO);
        if (count != 1) {
            throw new FscBusinessException("193201", "\u652f\u4ed8\u5355\u4e0d\u5b58\u5728\uff01");
        }
    }

    private List<Long> getFscOrderId(Long payOrderId) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setPayOrderId(payOrderId);
        List pos = this.fscPayRelationMapper.getList(fscPayRelationPO);
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        pos.forEach(fscPayRelationPO1 -> fscOrderIds.add(fscPayRelationPO1.getFscOrderId()));
        return fscOrderIds;
    }

    private void invokeFscOrderStatusFlow(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag3);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        payFscOrderId.forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193201", atomRspBO.getRespDesc());
            }
        });
    }
}

