/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillProcessBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayServiceBillProcessBusiServiceImpl
implements FscPayServiceBillProcessBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillProcessBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;

    @Override
    public FscPayServiceBillProcessBusiRspBO dealPayServiceBillProcess(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        this.updateOrder(busiReqBO, busiReqBO.getFscOrderPO());
        this.invokeUacNoTask(busiReqBO, busiReqBO.getFscOrderPO());
        return new FscPayServiceBillProcessBusiRspBO();
    }

    private void updateOrder(FscPayServiceBillProcessBusiReqBO busiReqBO, FscOrderPO fscOrderPO) {
        if (busiReqBO.getCreditAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("193208", "\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u8d39\u91d1\u989d\uff01");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("MONTH_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("YEAR_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PLATFORM_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        FscOrderPO set = new FscOrderPO();
        set.setCreditNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        set.setDiscountOperId(busiReqBO.getUserName());
        set.setDiscountOperName(busiReqBO.getName());
        set.setDiscountOperTime(new Date());
        set.setCreditAmount(busiReqBO.getCreditAmount());
        set.setActualAmount(fscOrderPO.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
    }

    private void invokeUacNoTask(FscPayServiceBillProcessBusiReqBO busiReqBO, FscOrderPO fscOrderPO) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String createEvaProcessKey = FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow()) ? "FSC_PL_FREE_AUDIT" : "FSC_SERVICE_FREE_AUDIT";
        if (busiReqBO.getCreditAmount().compareTo(fscOrderPO.getTotalCharge()) == -1) {
            paramMap.put("orderFinish", "1");
        } else if (this.noNeedAudit.equals(createEvaProcessKey)) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        } else {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscServiceOrderState.TO_PROCESS);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO1 = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO1.getRespCode())) {
            throw new FscBusinessException("193208", atomRspBO1.getRespDesc());
        }
        if (paramMap.get("auditFlag") != null && FscConstants.ProcessParam.auditFlag.equals(paramMap.get("auditFlag"))) {
            FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
            fscAuditOrderCreateAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
            fscAuditOrderCreateAtomReqBO.setObjId(busiReqBO.getFscOrderId());
            fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
            if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
            }
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
            fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
            FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
            EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), EacStartProjectAbilityReqBO.class);
            eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
            eacStartProjectAbilityReqBO.setProcDefKey(createEvaProcessKey);
            eacStartProjectAbilityReqBO.setPartitionKey(busiReqBO.getFscOrderId().toString());
            HashMap<String, Long> variables = new HashMap<String, Long>();
            variables.put("auditId", atomRspBO.getAuditOrderId());
            eacStartProjectAbilityReqBO.setVariables(variables);
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(busiReqBO.getFscOrderId().toString());
            eacStartProjectAbilityReqBO.setBusinessIdList(strings);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
            if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
            }
        }
    }
}

