/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscDealCashierDownPayItemAbilityService;
import com.tydic.fsc.pay.ability.bo.FscDealCashierDownPayItemAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscDealCashierDownPayItemAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscDealCashierDownPayItemBusiService;
import com.tydic.fsc.pay.busi.api.FscNoticeOderBusiService;
import com.tydic.fsc.pay.busi.bo.FscDealCashierDownPayItemBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDealCashierDownPayItemBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscNoticeOderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscNoticeOderBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscDealCashierDownPayItemAbilityService"})
public class FscDealCashierDownPayItemAbilityServiceImpl
implements FscDealCashierDownPayItemAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDealCashierDownPayItemAbilityServiceImpl.class);
    @Autowired
    private FscDealCashierDownPayItemBusiService fscDealCashierDownPayItemBusiService;
    @Autowired
    private FscNoticeOderBusiService fscNoticeOderBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTORSERVICE = new ThreadPoolExecutor(CPU, 2 * CPU, 200L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("\u4ed8\u6b3e\u5b8c\u6210\u540e\u5bf9\u5e94\u4fee\u6539\u72b6\u6001\u6c60").build(), new ThreadPoolExecutor.AbortPolicy());

    @PostMapping(value={"dealCashierDownPayItem"})
    public FscDealCashierDownPayItemAbilityRspBO dealCashierDownPayItem(@RequestBody FscDealCashierDownPayItemAbilityReqBO abilityReqBO) {
        log.debug("\u7ebf\u4e0b\u4ed8\u6b3eability\u5c42\u5165\u53c2{}", (Object)abilityReqBO);
        this.check(abilityReqBO);
        FscDealCashierDownPayItemBusiReqBO fscDealCashierDownPayItemBusiReqBo = (FscDealCashierDownPayItemBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscDealCashierDownPayItemBusiReqBO.class));
        log.debug("\u7ebf\u4e0b\u4ed8\u6b3ebusi\u5c42\u5165\u53c2{}", (Object)fscDealCashierDownPayItemBusiReqBo);
        FscDealCashierDownPayItemBusiRspBO fscDealCashierDownPayItemBusiRspBo = this.fscDealCashierDownPayItemBusiService.dealCashierDownPayItem(fscDealCashierDownPayItemBusiReqBo);
        log.debug("\u7ebf\u4e0b\u4ed8\u6b3ebusi\u5c42\u51fa\u53c2{}", (Object)fscDealCashierDownPayItemBusiReqBo);
        if (!"0000".equals(fscDealCashierDownPayItemBusiRspBo.getRespCode())) {
            log.debug("\u7ebf\u4e0b\u4ed8\u6b3ebusi\u5c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0{}", (Object)fscDealCashierDownPayItemBusiRspBo.getRespDesc());
            throw new FscBusinessException(fscDealCashierDownPayItemBusiRspBo.getRespCode(), fscDealCashierDownPayItemBusiRspBo.getRespDesc());
        }
        log.debug("\u7ebf\u4e0b\u4ed8\u6b3e\u76f4\u63a5\u901a\u77e5\u5404\u7c7b\u578b\u7684\u5355\u636e\u53d8\u4e3a\u5df2\u4ed8\u6b3e\u6216\u4ed8\u6b3e\u5f85\u786e\u8ba4\u5f00\u59cb{}", (Object)fscDealCashierDownPayItemBusiRspBo.getPayOrderId());
        this.updateDownPayOrder(fscDealCashierDownPayItemBusiRspBo.getPayOrderId(), abilityReqBO);
        return (FscDealCashierDownPayItemAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)fscDealCashierDownPayItemBusiRspBo)), FscDealCashierDownPayItemAbilityRspBO.class);
    }

    private void check(FscDealCashierDownPayItemAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getPayOrderId() == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355id\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscDealCashierDownPayItemList())) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        abilityReqBO.getFscDealCashierDownPayItemList().forEach(fscDealCashierDownPayItemBo -> {
            if (fscDealCashierDownPayItemBo.getPayOrderItemId() == null) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6id\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (StringUtils.isEmpty((CharSequence)fscDealCashierDownPayItemBo.getPayObjectNo())) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u5bf9\u8c61\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (CollectionUtils.isEmpty((Collection)fscDealCashierDownPayItemBo.getAttachmentList())) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u9644\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            fscDealCashierDownPayItemBo.getAttachmentList().forEach(attachmentBo -> {
                if (attachmentBo.getAttachmentType() == null) {
                    throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u9644\u4ef6\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (StringUtils.isEmpty((CharSequence)attachmentBo.getAttachmentUrl())) {
                    throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u9644\u4ef6\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (StringUtils.isEmpty((CharSequence)attachmentBo.getAttachmentName())) {
                    throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u9644\u4ef6\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            });
        });
    }

    private void updateDownPayOrder(Long payOrderId, FscDealCashierDownPayItemAbilityReqBO abilityReqBO) {
        EXECUTORSERVICE.execute(() -> {
            try {
                log.debug("\u4ed8\u6b3e\u521b\u5efa\u5b8c\u6210\u540e\u901a\u77e5\u4fee\u6539\u8ba2\u5355\u6216\u5bf9\u8d26\u5355\u72b6\u6001\u5f00\u59cb");
                FscNoticeOderBusiReqBO fscNoticeOderBusiReqBo = (FscNoticeOderBusiReqBO)((Object)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscNoticeOderBusiReqBO.class)));
                fscNoticeOderBusiReqBo.setPayOrderId(payOrderId);
                fscNoticeOderBusiReqBo.setPayConfirmFlag(abilityReqBO.getPayConfirmFlag());
                log.debug("\u4ed8\u6b3e\u521b\u5efa\u5b8c\u6210\u540e\u901a\u77e5\u4fee\u6539\u8ba2\u5355\u6216\u5bf9\u8d26\u5355\u72b6\u6001\u5165\u53c2{}", (Object)fscNoticeOderBusiReqBo);
                FscNoticeOderBusiRspBO fscNoticeOderBusiRspBO = this.fscNoticeOderBusiService.dealNoticeOder(fscNoticeOderBusiReqBo);
                log.debug("\u4ed8\u6b3e\u521b\u5efa\u5b8c\u6210\u540e\u901a\u77e5\u4fee\u6539\u8ba2\u5355\u6216\u5bf9\u8d26\u5355\u72b6\u6001\u51fa\u53c2{}", (Object)fscNoticeOderBusiRspBO);
                if ("0000".equals(fscNoticeOderBusiRspBO.getRespCode())) {
                    if (!CollectionUtils.isEmpty(fscNoticeOderBusiRspBO.getFscPayOrderInfoItemList())) {
                        log.debug("\u540c\u6b65\u5bf9\u8d26\u5355\u72b6\u6001es\u5f00\u59cb");
                        List<Long> collect = fscNoticeOderBusiRspBO.getFscPayOrderInfoItemList().stream().map(FscPayOrderInfoItemPO::getPayObjectId).collect(Collectors.toList());
                        this.updateFscOrderInfo(collect);
                        this.sendMq(collect);
                    }
                    if (!CollectionUtils.isEmpty(fscNoticeOderBusiRspBO.getServiceFeeFscOrderIdList())) {
                        this.updateFscOrderInfo(fscNoticeOderBusiRspBO.getServiceFeeFscOrderIdList());
                        this.sendMq(fscNoticeOderBusiRspBO.getServiceFeeFscOrderIdList());
                    }
                }
            }
            catch (Exception e) {
                log.debug("\u4ed8\u6b3e\u521b\u5efa\u5b8c\u6210\u540e\u901a\u77e5\u4fee\u6539\u8ba2\u5355\u6216\u5bf9\u8d26\u5355\u72b6\u6001\u5931\u8d25");
                e.printStackTrace();
            }
        });
    }

    private void updateFscOrderInfo(List<Long> fscOrderId) {
        log.debug("\u4fee\u6539\u7ed3\u7b97\u5355\u4fe1\u606f\u5f00\u59cb");
        FscOrderPO fscOrderWherePo = new FscOrderPO();
        fscOrderWherePo.setFscOrderIds(fscOrderId);
        log.debug("\u4fee\u6539\u7ed3\u7b97\u5355\u4fe1\u606f\u5165\u53c2where{}", (Object)fscOrderWherePo);
        FscOrderPO fscOrderPOSetPo = new FscOrderPO();
        fscOrderPOSetPo.setPayChannel("0");
        fscOrderPOSetPo.setPayType(Integer.valueOf(2));
        fscOrderPOSetPo.setPayTime(new Date());
        log.debug("\u4fee\u6539\u7ed3\u7b97\u5355\u4fe1\u606f\u5165\u53c2Set{}", (Object)fscOrderPOSetPo);
        int update = this.fscOrderMapper.updateBy(fscOrderPOSetPo, fscOrderWherePo);
        if (update < 1) {
            throw new FscBusinessException("190000", "\u4fee\u6539\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void invokeFscOrderStatusFlow(List<FscPayOrderInfoItemPO> fscPayOrderInfoItemList, Map<String, Object> paramMap) {
        log.debug("\u6d41\u8f6c\u72b6\u6001\u5f00\u59cb");
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBo = new FscOrderStatusFlowAtomReqBO();
        fscPayOrderInfoItemList.forEach(fscPayOrderInfoItemPo -> {
            fscOrderStatusFlowAtomReqBo.setOrderId(fscPayOrderInfoItemPo.getPayObjectId());
            fscOrderStatusFlowAtomReqBo.setParamMap(paramMap);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u5165\u53c2{}", (Object)fscOrderStatusFlowAtomReqBo);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBo);
            log.debug("\u6d41\u8f6c\u72b6\u6001\u51fa\u53c2{}", (Object)atomRspBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                log.debug("\u6d41\u8f6c\u72b6\u6001\u5931\u8d25");
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private void sendMq(List<Long> fscOrderIds) {
        for (Long fscOrderId : fscOrderIds) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }
}

