/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscQryCashierDownPayItemAbilityService;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscQryCashierDownPayItemBO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscQryCashierDownPayItemAbilityService"})
public class FscQryCashierDownPayItemAbilityServiceImpl
implements FscQryCashierDownPayItemAbilityService {
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;

    @PostMapping(value={"qryCashierDownPayItem"})
    public FscQryCashierDownPayItemAbilityRspBO qryCashierDownPayItem(@RequestBody FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        this.check(abilityReqBO);
        this.checkFscPayInfo(abilityReqBO);
        List<FscPayOrderInfoItemPO> list = this.checkFscPayOrderInfoItemPOS(abilityReqBO);
        List<FscMerchantPO> fscMerchantMapperList = this.checkFscMerchantPOS(list);
        List<FscMerchantPayeePO> fscMerchantPayeePoList = this.getFscMerchantPayeePOS(fscMerchantMapperList);
        Map<Long, FscMerchantPayeePO> fscMerchantPayeePoMap = fscMerchantPayeePoList.stream().collect(Collectors.toMap(FscMerchantPayeePO::getMerchantId, o -> o));
        Map<Long, Long> fscMerchantMap = fscMerchantMapperList.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, FscMerchantPO::getMerchantId));
        ArrayList fscQryCashierDownPayItemBoS = new ArrayList();
        list.forEach(fscPayOrderInfoItemPoModel -> {
            FscQryCashierDownPayItemBO fscQryCashierDownPayItemBo = new FscQryCashierDownPayItemBO();
            fscQryCashierDownPayItemBo.setPayOrderItemId(fscPayOrderInfoItemPoModel.getPayOrderItemId());
            fscQryCashierDownPayItemBo.setPayObjectNo(fscPayOrderInfoItemPoModel.getPayObjectNo());
            fscQryCashierDownPayItemBo.setPayOrderItemAmount(fscPayOrderInfoItemPoModel.getPayOrderItemAmount());
            fscQryCashierDownPayItemBo.setPayBankName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankName());
            fscQryCashierDownPayItemBo.setPayBankAccount(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeBankAccount());
            fscQryCashierDownPayItemBo.setPayeeAccountName(((FscMerchantPayeePO)fscMerchantPayeePoMap.get(fscMerchantMap.get(fscPayOrderInfoItemPoModel.getPayeeId()))).getPayeeAccountName());
            fscQryCashierDownPayItemBoS.add(fscQryCashierDownPayItemBo);
        });
        FscQryCashierDownPayItemAbilityRspBO lianDongFscQryCashierDownPayItemAbilityRspBo = new FscQryCashierDownPayItemAbilityRspBO();
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespCode("0000");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setRespDesc("\u6210\u529f");
        lianDongFscQryCashierDownPayItemAbilityRspBo.setFscQryCashierDownPayItemList(fscQryCashierDownPayItemBoS);
        return lianDongFscQryCashierDownPayItemAbilityRspBo;
    }

    private List<FscMerchantPayeePO> getFscMerchantPayeePOS(List<FscMerchantPO> fscMerchantMapperList) {
        List merchantIds = fscMerchantMapperList.stream().map(FscMerchantPO::getMerchantId).collect(Collectors.toList());
        FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
        fscMerchantPayeePo.setMerchantIds(merchantIds);
        List fscMerchantPayeePoList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePo);
        return fscMerchantPayeePoList;
    }

    private List<FscMerchantPO> checkFscMerchantPOS(List<FscPayOrderInfoItemPO> list) {
        List collect = list.stream().map(FscPayOrderInfoItemPO::getPayeeId).distinct().collect(Collectors.toList());
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgIds(collect);
        fscMerchantPo.setDelFlag(Integer.valueOf(0));
        fscMerchantPo.setExceptionFlag(Integer.valueOf(0));
        fscMerchantPo.setStatus(Integer.valueOf(3));
        List fscMerchantMapperList = this.fscMerchantMapper.getList(fscMerchantPo);
        if (CollectionUtils.isEmpty((Collection)fscMerchantMapperList) || fscMerchantMapperList.size() != collect.size()) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e2d\u6709\u5546\u6237\u672a\u914d\u7f6e\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscMerchantMapperList;
    }

    private List<FscPayOrderInfoItemPO> checkFscPayOrderInfoItemPOS(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(abilityReqBO.getPayOrderId());
        List list = this.fscPayOrderInfoItemMapper.getList(fscPayOrderInfoItemPo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return list;
    }

    private void checkFscPayInfo(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayOrderId(abilityReqBO.getPayOrderId());
        FscPayInfoPO modelBy = this.fscPayInfoMapper.getModelBy(fscPayInfoPo);
        if (modelBy == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private void check(FscQryCashierDownPayItemAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getPayOrderId() == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355id\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }
}

