/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLedgerInfoItemMapper;
import com.tydic.fsc.dao.FscLedgerInfoMapper;
import com.tydic.fsc.dao.FscPayInfoMapper;
import com.tydic.fsc.dao.FscPayOrderInfoItemMapper;
import com.tydic.fsc.dao.FscRefundInfoMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.RefundGoodsBO;
import com.tydic.fsc.pay.busi.api.FscCreateRefundBusiService;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscCreateRefundBusiRspBO;
import com.tydic.fsc.po.FscLedgerInfoItemPO;
import com.tydic.fsc.po.FscLedgerInfoPO;
import com.tydic.fsc.po.FscPayInfoPO;
import com.tydic.fsc.po.FscPayOrderInfoItemPO;
import com.tydic.fsc.po.FscRefundInfoPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreateRefundBusiServiceImpl
implements FscCreateRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreateRefundBusiServiceImpl.class);
    @Autowired
    private FscRefundInfoMapper fscRefundInfoMapper;
    @Autowired
    private CfcRedisSerialService encodedSerialGetService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPayInfoMapper fscPayInfoMapper;
    @Autowired
    private FscPayOrderInfoItemMapper fscPayOrderInfoItemMapper;
    @Autowired
    private FscLedgerInfoItemMapper fscLedgerInfoItemMapper;
    @Autowired
    private FscLedgerInfoMapper fscLedgerInfoMapper;

    @Override
    public FscCreateRefundBusiRspBO createRefund(FscCreateRefundBusiReqBO busiReqBO) {
        this.isCreateRefund(busiReqBO);
        Long refundId = Sequence.getInstance().nextId();
        FscRefundInfoPO fscRefundInfoPo = new FscRefundInfoPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)fscRefundInfoPo);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.getCfcEncodedSerialGetServiceRspBO();
        fscRefundInfoPo.setCreateTime(new Date());
        fscRefundInfoPo.setRefundNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscRefundInfoPo.setRefundState(FscConstants.RefundState.APPLYING);
        fscRefundInfoPo.setRefundId(refundId);
        int insert = this.fscRefundInfoMapper.insert(fscRefundInfoPo);
        if (insert < 1) {
            throw new FscBusinessException("190000", "\u65b0\u589e\u9000\u6b3e\u7533\u8bf7\u5355\u5931\u8d25");
        }
        Long payOrderId = this.oldPay(fscRefundInfoPo);
        log.debug("\u5224\u65ad\u662f\u5426\u662f\u8001\u4ed8\u6b3e\u51fa\u53c2{}", (Object)payOrderId);
        if (payOrderId == null) {
            this.dealNewPay(busiReqBO, refundId, fscRefundInfoPo);
        }
        FscCreateRefundBusiRspBO fscCreateRefundBusiRspBO = new FscCreateRefundBusiRspBO();
        fscCreateRefundBusiRspBO.setRefundNo(fscRefundInfoPo.getRefundNo());
        fscCreateRefundBusiRspBO.setRefundAmount(fscRefundInfoPo.getRefundAmount());
        fscCreateRefundBusiRspBO.setRefundId(refundId);
        fscCreateRefundBusiRspBO.setRespCode("0000");
        fscCreateRefundBusiRspBO.setRespDesc("\u6210\u529f");
        return fscCreateRefundBusiRspBO;
    }

    private void isCreateRefund(FscCreateRefundBusiReqBO busiReqBO) {
        if (FscConstants.RefundType.ORDER_REFUND.equals(busiReqBO.getCreateType())) {
            FscRefundInfoPO fscRefundInfoPoModel = new FscRefundInfoPO();
            fscRefundInfoPoModel.setAfterOrderNo(busiReqBO.getAfterOrderNo());
            List fscRefundInfoPoList = this.fscRefundInfoMapper.getList(fscRefundInfoPoModel);
            if (!CollectionUtils.isEmpty((Collection)fscRefundInfoPoList)) {
                throw new FscBusinessException("190000", "\u8be5\u552e\u540e\u5355\u5df2\u7ecf\u521b\u5efa\u4e86\u9000\u6b3e\u5355\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u8bd5");
            }
        }
    }

    private void dealNewPay(FscCreateRefundBusiReqBO busiReqBO, Long refundId, FscRefundInfoPO fscRefundInfoPo) {
        log.debug("\u8fdb\u5165\u65b0\u4ed8\u6b3e\u9000\u6b3e");
        FscPayInfoPO fscPayInfoPoModel = this.newPay(fscRefundInfoPo);
        if (FscConstants.IsLedger.YES.equals(fscPayInfoPoModel.getIsLedger())) {
            this.allRefund(busiReqBO, fscPayInfoPoModel);
            log.debug("\u8fdb\u5165\u5206\u8d26\u4e0a\u7ebf\u540e\u4ed8\u6b3e\u7684\u5355\u5b50{}", (Object)fscPayInfoPoModel);
            List<Long> skuIds = busiReqBO.getRefundGoodsBOList().stream().map(RefundGoodsBO::getSkuId).distinct().collect(Collectors.toList());
            log.debug("\u9700\u8981\u9000\u6b3e\u7684\u5546\u54c1id\u96c6\u5408{}", skuIds);
            FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.getFscPayOrderInfoItemPo(busiReqBO, fscPayInfoPoModel.getPayOrderId());
            List<FscLedgerInfoItemPO> list = this.checkFscLedgerInfoItemList(skuIds, fscPayOrderInfoItemMapperModelBy);
            Map<Long, FscLedgerInfoItemPO> fscLedgerInfoItemPoMap = list.stream().collect(Collectors.toMap(FscLedgerInfoItemPO::getSkuId, fscLedgerInfoItemPoModel -> fscLedgerInfoItemPoModel));
            log.debug("\u83b7\u53d6\u5206\u8d26\u660e\u7ec6map{}", fscLedgerInfoItemPoMap);
            ArrayList fscLedgerInfoList = new ArrayList();
            HashMap<Long, BigDecimal> refundFscTotalAmount = new HashMap<Long, BigDecimal>(1);
            refundFscTotalAmount.put(list.get(0).getPayeeMerchantId(), BigDecimal.ZERO);
            busiReqBO.getRefundGoodsBOList().forEach(refundGoodsBo -> this.forEachCommondity(refundId, fscPayInfoPoModel.getPayOrderId(), fscLedgerInfoItemPoMap, fscLedgerInfoList, refundFscTotalAmount, (RefundGoodsBO)refundGoodsBo));
            BigDecimal finishRefundAmount = (BigDecimal)refundFscTotalAmount.get(list.get(0).getPayeeMerchantId());
            log.debug("\u5546\u6237\u603b\u5171\u9700\u8981\u9000\u6b3e\u7684\u91d1\u989d\u7ed3\u7b97\u6d4b{}", (Object)finishRefundAmount);
            if (finishRefundAmount.compareTo(busiReqBO.getRefundAmount()) != 0) {
                throw new FscBusinessException("190000", "\u5546\u54c1\u9000\u6b3e\u603b\u91d1\u989d\u7ed3\u7b97\u8ba1\u7b97\u7ed3\u679c\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            this.fscLedgerInfoMapper.insertBatch(fscLedgerInfoList);
        }
    }

    private void allRefund(FscCreateRefundBusiReqBO busiReqBO, FscPayInfoPO fscPayInfoPoModel) {
        if (!FscConstants.RefundType.ORDER_REFUND.equals(busiReqBO.getCreateType())) {
            log.debug("\u8fdb\u5165\u6574\u5355\u9000\u6b3e\u5f00\u59cb{}", (Object)busiReqBO.getCreateType());
            ArrayList<RefundGoodsBO> refundGoodsList = new ArrayList<RefundGoodsBO>();
            FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.getFscPayOrderInfoItemList(busiReqBO, fscPayInfoPoModel);
            List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList = this.getFscLedgerInfoItemList(fscPayOrderInfoItemMapperModelBy);
            this.forEachLedgerItem(busiReqBO, refundGoodsList, fscLedgerInfoItemMapperList);
        }
    }

    private void forEachLedgerItem(FscCreateRefundBusiReqBO busiReqBO, List<RefundGoodsBO> refundGoodsList, List<FscLedgerInfoItemPO> fscLedgerInfoItemMapperList) {
        fscLedgerInfoItemMapperList.forEach(fscLedgerInfoItemPoModel -> {
            log.debug("\u5f00\u59cb\u8f6e\u8be2\u8ba2\u5355\u7684\u5546\u54c1\u5206\u8d26\u660e\u7ec6{}", fscLedgerInfoItemPoModel);
            RefundGoodsBO refundGoodsBo = new RefundGoodsBO();
            refundGoodsBo.setNum(fscLedgerInfoItemPoModel.getSkuNum());
            refundGoodsBo.setSkuId(fscLedgerInfoItemPoModel.getSkuId());
            refundGoodsBo.setSkuRefundAmount(fscLedgerInfoItemPoModel.getRelAmount());
            refundGoodsList.add(refundGoodsBo);
        });
        log.debug("\u9000\u6b3e\u5546\u54c1\u96c6\u5408{}", refundGoodsList);
        busiReqBO.setRefundGoodsBOList(refundGoodsList);
    }

    private List<FscLedgerInfoItemPO> getFscLedgerInfoItemList(FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy) {
        FscLedgerInfoItemPO fscLedgerInfoItemPo = new FscLedgerInfoItemPO();
        fscLedgerInfoItemPo.setPayOrderItemId(fscPayOrderInfoItemMapperModelBy.getPayOrderItemId());
        log.debug("\u67e5\u8be2\u8be5\u8ba2\u5355\u7684\u5546\u54c1\u5206\u8d26\u660e\u7ec6\u5165\u53c2{}", (Object)fscLedgerInfoItemPo);
        List fscLedgerInfoItemMapperList = this.fscLedgerInfoItemMapper.getList(fscLedgerInfoItemPo);
        log.debug("\u67e5\u8be2\u8be5\u8ba2\u5355\u7684\u5546\u54c1\u5206\u8d26\u660e\u7ec6\u51fa\u53c2{}", (Object)fscLedgerInfoItemMapperList);
        if (CollectionUtils.isEmpty((Collection)fscLedgerInfoItemMapperList)) {
            throw new FscBusinessException("190000", "\u521b\u5efa\u9000\u6b3e\u5355\u65f6\u67e5\u8be2\u4ed8\u6b3e\u5206\u8d26\u660e\u7ec6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscLedgerInfoItemMapperList;
    }

    private FscPayOrderInfoItemPO getFscPayOrderInfoItemList(FscCreateRefundBusiReqBO busiReqBO, FscPayInfoPO fscPayInfoPoModel) {
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(fscPayInfoPoModel.getPayOrderId());
        fscPayOrderInfoItemPo.setPayObjectId(busiReqBO.getSaleOrderId());
        log.debug("\u67e5\u8be2\u8be5\u8ba2\u5355\u7684\u5546\u54c1\u660e\u7ec6\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.fscPayOrderInfoItemMapper.getModelBy(fscPayOrderInfoItemPo);
        log.debug("\u67e5\u8be2\u8be5\u8ba2\u5355\u7684\u5546\u54c1\u660e\u7ec6\u51fa\u53c2{}", (Object)fscPayOrderInfoItemMapperModelBy);
        if (fscPayOrderInfoItemMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u521b\u5efa\u9000\u6b3e\u5355\u65f6\u67e5\u8be2\u4ed8\u6b3e\u660e\u7ec6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscPayOrderInfoItemMapperModelBy;
    }

    private void forEachCommondity(Long refundId, Long payOrderId, Map<Long, FscLedgerInfoItemPO> fscLedgerInfoItemPoMap, List<FscLedgerInfoPO> fscLedgerInfoList, HashMap<Long, BigDecimal> refundFscTotalAmount, RefundGoodsBO refundGoodsBo) {
        log.debug("\u8fdb\u5165\u9000\u6b3e\u5546\u54c1\u5faa\u73af\u521b\u5efa\u9000\u6b3e\u5206\u8d26\u4fe1\u606f{}", (Object)refundGoodsBo);
        FscLedgerInfoItemPO fscLedgerInfoItemPoModel = fscLedgerInfoItemPoMap.get(refundGoodsBo.getSkuId());
        log.debug("\u83b7\u53d6\u9000\u6b3e\u5546\u54c1\u5faa\u73af\u521b\u5efa\u9000\u6b3e\u5206\u8d26\u4fe1\u606f\u660e\u7ec6{}", (Object)fscLedgerInfoItemPoModel);
        FscLedgerInfoPO fscLedgerInfoPoRefund = this.setFscLedgerInfoPo(refundId, payOrderId, refundGoodsBo, fscLedgerInfoItemPoModel);
        if (fscLedgerInfoItemPoModel.getLedgerAmount().compareTo(fscLedgerInfoItemPoModel.getRelAmount()) == 0) {
            this.notServiceFee(refundFscTotalAmount, refundGoodsBo, fscLedgerInfoItemPoModel, fscLedgerInfoPoRefund);
        } else {
            this.haveServiceFee(refundFscTotalAmount, refundGoodsBo, fscLedgerInfoItemPoModel, fscLedgerInfoPoRefund);
        }
        fscLedgerInfoList.add(fscLedgerInfoPoRefund);
    }

    private void haveServiceFee(HashMap<Long, BigDecimal> refundFscTotalAmount, RefundGoodsBO refundGoodsBo, FscLedgerInfoItemPO fscLedgerInfoItemPoModel, FscLedgerInfoPO fscLedgerInfoPoRefund) {
        log.debug("\u8be5\u5546\u54c1\u6536\u53d6\u4e86\u6210\u4ea4\u670d\u52a1\uff0c\u4f7f\u7528\u8ba1\u7b97\u540e\u7684\u7ed3\u679c\u8fdb\u884c\u9000\u6b3e");
        this.checkAmount(refundGoodsBo, fscLedgerInfoItemPoModel);
        log.debug("\u5f00\u59cb\u8ba1\u7b97\u5546\u6237\u6240\u9700\u5f52\u8fd8\u91d1\u989d");
        BigDecimal skuLedgerPrice = fscLedgerInfoItemPoModel.getSkuPrice().multiply(fscLedgerInfoItemPoModel.getSkuRate()).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u9000\u6b3e\u5546\u54c1\u670d\u52a1\u8d39\u5355\u4ef7\u91d1\u989d{}", (Object)skuLedgerPrice);
        BigDecimal skuLedgerAmount = skuLedgerPrice.multiply(refundGoodsBo.getNum()).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u9000\u6b3e\u5546\u54c1\u670d\u52a1\u8d39\u603b\u91d1\u989d{}", (Object)skuLedgerAmount);
        BigDecimal skuRefundAmount = refundGoodsBo.getSkuRefundAmount().subtract(skuLedgerAmount).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u5546\u6237\u6240\u9700\u5f52\u8fd8\u91d1\u989d{}", (Object)skuRefundAmount);
        fscLedgerInfoPoRefund.setPayLedgerItemRefundAmount(skuRefundAmount);
        fscLedgerInfoPoRefund.setPayItemRefundAmount(refundGoodsBo.getSkuRefundAmount());
        BigDecimal beforeAmount = refundFscTotalAmount.get(fscLedgerInfoItemPoModel.getPayeeMerchantId());
        log.debug("\u7d2f\u52a0\u524d\u9000\u6b3e\u91d1\u989d{}", (Object)beforeAmount);
        BigDecimal afterAmount = beforeAmount.add(skuLedgerAmount).add(skuRefundAmount).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u7d2f\u52a0\u540e\u9000\u6b3e\u91d1\u989d{}", (Object)afterAmount);
        refundFscTotalAmount.replace(fscLedgerInfoItemPoModel.getPayeeMerchantId(), afterAmount);
        log.debug("\u66ff\u6362\u540e\u9000\u6b3e\u91d1\u989d{}", refundFscTotalAmount);
    }

    private void notServiceFee(HashMap<Long, BigDecimal> refundFscTotalAmount, RefundGoodsBO refundGoodsBo, FscLedgerInfoItemPO fscLedgerInfoItemPoModel, FscLedgerInfoPO fscLedgerInfoPoRefund) {
        log.debug("\u8be5\u5546\u54c1\u6ca1\u6709\u6536\u53d6\u6210\u4ea4\u670d\u52a1\uff0c\u76f4\u63a5\u4f7f\u7528\u5546\u54c1\u91d1\u989d,\u4f46\u662f\u9700\u8981\u6821\u9a8c\u662f\u5426\u91d1\u989d\u4e00\u81f4");
        this.checkAmount(refundGoodsBo, fscLedgerInfoItemPoModel);
        fscLedgerInfoPoRefund.setPayItemRefundAmount(refundGoodsBo.getSkuRefundAmount());
        fscLedgerInfoPoRefund.setPayLedgerItemRefundAmount(BigDecimal.ZERO);
        BigDecimal beforeAmount = refundFscTotalAmount.get(fscLedgerInfoItemPoModel.getPayeeMerchantId());
        log.debug("\u7d2f\u52a0\u524d\u9000\u6b3e\u91d1\u989d{}", (Object)beforeAmount);
        BigDecimal afterAmount = beforeAmount.add(refundGoodsBo.getSkuRefundAmount()).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u7d2f\u52a0\u540e\u9000\u6b3e\u91d1\u989d{}", (Object)afterAmount);
        refundFscTotalAmount.replace(fscLedgerInfoItemPoModel.getPayeeMerchantId(), afterAmount);
        log.debug("\u66ff\u6362\u540e\u9000\u6b3e\u91d1\u989d{}", refundFscTotalAmount);
    }

    private FscLedgerInfoPO setFscLedgerInfoPo(Long refundId, Long payOrderId, RefundGoodsBO refundGoodsBo, FscLedgerInfoItemPO fscLedgerInfoItemPoModel) {
        log.debug("\u8bb0\u5f55\u5206\u8d26\u9000\u6b3e\u7edf\u4e00\u4fe1\u606f\u5f00\u59cb");
        FscLedgerInfoPO fscLedgerInfoPoRefund = new FscLedgerInfoPO();
        fscLedgerInfoPoRefund.setPayLedgerId(Long.valueOf(Sequence.getInstance().nextId()));
        fscLedgerInfoPoRefund.setPayLedgerItemId(fscLedgerInfoItemPoModel.getPayOrderItemId());
        fscLedgerInfoPoRefund.setPayOrderId(payOrderId);
        fscLedgerInfoPoRefund.setMerchantId(fscLedgerInfoItemPoModel.getPayeeMerchantId());
        fscLedgerInfoPoRefund.setPayItemRefundAmount(refundGoodsBo.getSkuRefundAmount());
        fscLedgerInfoPoRefund.setPayOrRefund(FscConstants.PayOrRefund.REFUND);
        fscLedgerInfoPoRefund.setServiceOrPay(FscConstants.ServiceOrPay.PAY);
        fscLedgerInfoPoRefund.setCreateTime(new Date());
        fscLedgerInfoPoRefund.setRefundId(refundId);
        return fscLedgerInfoPoRefund;
    }

    private List<FscLedgerInfoItemPO> checkFscLedgerInfoItemList(List<Long> skuIds, FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy) {
        log.debug("\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\uff0c\u5e76\u6821\u9a8c\u6570\u91cf\u662f\u5426\u4e00\u81f4\u5f00\u59cb");
        FscLedgerInfoItemPO fscLedgerInfoItemPo = new FscLedgerInfoItemPO();
        fscLedgerInfoItemPo.setPayOrderItemId(fscPayOrderInfoItemMapperModelBy.getPayOrderItemId());
        fscLedgerInfoItemPo.setSkuIds(skuIds);
        log.debug("\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\uff0c\u5e76\u6821\u9a8c\u6570\u91cf\u662f\u5426\u4e00\u81f4\u5165\u53c2{}", (Object)fscLedgerInfoItemPo);
        List list = this.fscLedgerInfoItemMapper.getList(fscLedgerInfoItemPo);
        log.debug("\u67e5\u8be2\u5206\u8d26\u660e\u7ec6\u4fe1\u606f\uff0c\u5e76\u6821\u9a8c\u6570\u91cf\u662f\u5426\u4e00\u81f4\u51fa\u53c2{}", (Object)list);
        if (CollectionUtils.isEmpty((Collection)list) || list.size() != skuIds.size()) {
            throw new FscBusinessException("190000", "\u5176\u4e2d\u6709\u5546\u54c1\u4fe1\u606f\u6ca1\u6709\u5206\u8d26\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return list;
    }

    private FscPayOrderInfoItemPO getFscPayOrderInfoItemPo(FscCreateRefundBusiReqBO busiReqBO, Long payOrderId) {
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u5355\u660e\u7ec6\u5f00\u59cb");
        FscPayOrderInfoItemPO fscPayOrderInfoItemPo = new FscPayOrderInfoItemPO();
        fscPayOrderInfoItemPo.setPayOrderId(payOrderId);
        fscPayOrderInfoItemPo.setPayObjectId(busiReqBO.getSaleOrderId());
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u5355\u660e\u7ec6\u5165\u53c2{}", (Object)fscPayOrderInfoItemPo);
        FscPayOrderInfoItemPO fscPayOrderInfoItemMapperModelBy = this.fscPayOrderInfoItemMapper.getModelBy(fscPayOrderInfoItemPo);
        log.debug("\u67e5\u8be2\u4ed8\u6b3e\u5355\u660e\u7ec6\u51fa\u53c2{}", (Object)fscPayOrderInfoItemMapperModelBy);
        if (fscPayOrderInfoItemMapperModelBy == null) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4ed8\u6b3e\u5355\u660e\u7ec6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return fscPayOrderInfoItemMapperModelBy;
    }

    private void checkAmount(RefundGoodsBO refundGoodsBo, FscLedgerInfoItemPO fscLedgerInfoItemPoModel) {
        log.debug("\u5546\u54c1\u5355\u4ef7{}", (Object)fscLedgerInfoItemPoModel.getSkuPrice());
        log.debug("\u5546\u54c1\u9000\u6b3e\u6570\u91cf{}", (Object)refundGoodsBo.getNum());
        BigDecimal merchantRefundAmount = fscLedgerInfoItemPoModel.getSkuPrice().multiply(refundGoodsBo.getNum()).setScale(2, RoundingMode.HALF_UP);
        log.debug("\u7ed3\u7b97\u8ba1\u7b97\u51fa\u7684\u5546\u54c1\u9000\u6b3e\u91d1\u989d{}", (Object)merchantRefundAmount);
        BigDecimal skuRefundAmount = refundGoodsBo.getSkuRefundAmount();
        log.debug("\u8ba2\u5355\u4f20\u7684\u5546\u54c1\u9000\u6b3e\u91d1\u989d{}", (Object)skuRefundAmount);
        if (merchantRefundAmount.compareTo(skuRefundAmount) != 0) {
            throw new FscBusinessException("190000", "\u5546\u54c1\u9000\u6b3e\u91d1\u989d\u7ed3\u7b97\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private CfcEncodedSerialGetServiceRspBO getCfcEncodedSerialGetServiceRspBO() {
        CfcEncodedSerialGetServiceRspBO serial = null;
        try {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_RETRUN_NO");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            serial = this.encodedSerialGetService.getSerial(encodedSerialGetServiceReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serial;
    }

    private Long oldPay(FscRefundInfoPO modelBy) {
        log.debug("\u8001\u652f\u4ed8\u9000\u6b3e\u6821\u9a8c");
        FscShouldPayPO fscShouldPayPoOrder = new FscShouldPayPO();
        fscShouldPayPoOrder.setObjectId(modelBy.getSaleOrderId());
        Long payOrderId = this.fscShouldPayMapper.getFscPayOrderIdByShouldPayId(fscShouldPayPoOrder);
        return payOrderId;
    }

    private FscPayInfoPO newPay(FscRefundInfoPO modelBy) {
        FscPayInfoPO fscPayOrder = this.getFscPayOrderId(modelBy);
        if (fscPayOrder == null) {
            throw new FscBusinessException("190000", "\u5916\u90e8\u8ba2\u5355\u6d41\u6c34\u4e3a\u7a7a");
        }
        return fscPayOrder;
    }

    private FscPayInfoPO getFscPayOrderId(FscRefundInfoPO modelBy) {
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff08\u53ea\u4f1a\u6709\u4e00\u6761\u652f\u4ed8\u6210\u529f\u7684\uff0c\u6240\u4ee5\u4e0d\u7528\u62c5\u5fc3\uff09{}", (Object)modelBy);
        FscPayInfoPO fscPayInfoPo = new FscPayInfoPO();
        fscPayInfoPo.setPayObjectId(modelBy.getSaleOrderId());
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff0c\u5165\u53c2{}", (Object)fscPayInfoPo);
        FscPayInfoPO fscPayInfoPoModel = this.fscPayInfoMapper.getPayOrderIdByPayObjectId(fscPayInfoPo);
        log.debug("\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u7684\u4ed8\u6b3e\u5355\uff0c\u5e76\u9000\u6b3e\uff0c\u51fa\u53c2{}", (Object)fscPayInfoPoModel);
        return fscPayInfoPoModel;
    }
}

