/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCostLogMapper;
import com.tydic.fsc.pay.atom.api.FscCostOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscCostOrderAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscCostOrderReqBO;
import com.tydic.fsc.pay.busi.api.FscDelOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscDelOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscDelOrderBusiRspBO;
import com.tydic.fsc.po.FscCostLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscDelOrderBusiServiceImpl
implements FscDelOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDelOrderBusiServiceImpl.class);
    @Autowired
    private FscCostLogMapper fscCostLogMapper;
    @Autowired
    private FscCostOrderAtomService fscCostOrderAtomService;

    @Override
    public FscDelOrderBusiRspBO delOrder(FscDelOrderBusiReqBO reqBO) {
        FscCostLogPO fscCostLogPo = new FscCostLogPO();
        fscCostLogPo.setMethod(this.getClass().toString());
        fscCostLogPo.setObjId(reqBO.getContractNo());
        fscCostLogPo.setObjType(FscConstants.CostObjType.CONTRACT_NO);
        FscCostOrderReqBO fscCostOrderReqBO = (FscCostOrderReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscCostOrderReqBO.class));
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u4f20fscCostOrderAtomService\u5165\u53c2{}", (Object)fscCostOrderReqBO);
        FscCostOrderAtomRspBO atomRspBO = this.fscCostOrderAtomService.costOrder(fscCostOrderReqBO);
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u4f20fscCostOrderAtomService\u51fa\u53c2{}", (Object)atomRspBO);
        if ("0000".equals(atomRspBO.getRespCode())) {
            log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u4f20fscCostOrderAtomService\u5904\u7406\u6210\u529f{}", (Object)atomRspBO);
            fscCostLogPo.setIsError(FscConstants.CostIsError.NO);
        } else {
            log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u4f20fscCostOrderAtomService\u5904\u7406\u5931\u8d25{}", (Object)atomRspBO);
            fscCostLogPo.setIsError(FscConstants.CostIsError.YES);
        }
        FscDelOrderBusiRspBO rspBO = (FscDelOrderBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)atomRspBO)), FscDelOrderBusiRspBO.class));
        fscCostLogPo.setReq(JSONObject.toJSONString((Object)((Object)reqBO)));
        fscCostLogPo.setCreateTime(new Date());
        fscCostLogPo.setRsp(JSONObject.toJSONString((Object)((Object)rspBO)));
        log.debug("\u6210\u672c\u7cfb\u7edf\u56de\u4f20\u65e5\u5fd7\u8bb0\u5f55\u5165\u53c2{}", (Object)fscCostLogPo);
        this.fscCostLogMapper.insert(fscCostLogPo);
        return rspBO;
    }
}

